/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.kroxylicious.proxy.filter;

import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.RequestHeaderData;

/**
 * A stateless filter for AlterUserScramCredentialsRequests.
 * The same instance may be invoked on multiple channels.
 */
public interface AlterUserScramCredentialsRequestFilter extends KrpcFilter {

    /**
     * Determine if a request message of type AlterUserScramCredentialsRequest should be handled by
     * this filter implementation.
     * returns true then {@code onAlterUserScramCredentialsRequest} is eligible to be invoked with
     * deserialized data, if the message reaches this filter in the chain.
     * @param apiVersion the apiVersion of the message
     * @return true if it should be handled
     */
    default boolean shouldHandleAlterUserScramCredentialsRequest(short apiVersion) {
        return true;
    }

    /**
     * Handle the given {@code request},
     * returning the {@code AlterUserScramCredentialsRequestData} instance to be passed to the next filter.
     * The implementation may modify the given {@code data} in-place and return it,
     * or instantiate a new one.
     *
     * @param apiVersion the apiVersion of the request
     * @param header request header.
     * @param request The KRPC message to handle.
     * @param context The context.
     */
    void onAlterUserScramCredentialsRequest(short apiVersion, RequestHeaderData header, AlterUserScramCredentialsRequestData request, KrpcFilterContext context);

}