/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.kroxylicious.proxy.filter;

import org.apache.kafka.common.message.DescribeGroupsResponseData;

import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;

/**
 * An invoker for DescribeGroupsResponseFilter. The point is that this invoker knows the type of
 * DescribeGroupsResponseFilter to avoid using instanceof/cast, which has a performance issue in
 * the current LTS java (17).
 */
class DescribeGroupsResponseFilterInvoker implements FilterInvoker {

    private final DescribeGroupsResponseFilter filter;

    DescribeGroupsResponseFilterInvoker(DescribeGroupsResponseFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean shouldHandleResponse(ApiKeys apiKey, short apiVersion) {
        return filter.shouldHandleDescribeGroupsResponse(apiVersion);
    }

    @Override
    public void onResponse(ApiKeys apiKey, short apiVersion, ResponseHeaderData header, ApiMessage body, KrpcFilterContext filterContext) {
        filter.onDescribeGroupsResponse(apiVersion, header, (DescribeGroupsResponseData) body, filterContext);
    }
}