/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.clients;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public record CloseableConsumer<K, V>(Consumer<K, V> instance) implements Consumer<K, V>,
AutoCloseable
{
    public static <K, V> Consumer<K, V> wrap(Consumer<K, V> instance) {
        return new CloseableConsumer<K, V>(instance);
    }

    public static <K, V> Consumer<K, V> create(Properties properties) {
        return CloseableConsumer.wrap(new KafkaConsumer(properties));
    }

    public static <K, V> Consumer<K, V> create(Map<String, Object> configs) {
        return CloseableConsumer.wrap(new KafkaConsumer(configs));
    }

    public Set<TopicPartition> assignment() {
        return this.instance.assignment();
    }

    public Set<String> subscription() {
        return this.instance.subscription();
    }

    public void subscribe(Collection<String> topics) {
        this.instance.subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.instance.subscribe(topics, callback);
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.instance.assign(partitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.instance.subscribe(pattern, callback);
    }

    public void subscribe(Pattern pattern) {
        this.instance.subscribe(pattern);
    }

    public void unsubscribe() {
        this.instance.unsubscribe();
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        return this.instance.poll(timeout);
    }

    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.instance.poll(timeout);
    }

    public void commitSync() {
        this.instance.commitSync();
    }

    public void commitSync(Duration timeout) {
        this.instance.commitSync(timeout);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.instance.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.instance.commitSync(offsets, timeout);
    }

    public void commitAsync() {
        this.instance.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.instance.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.instance.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.instance.seek(partition, offset);
    }

    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.instance.seek(partition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.instance.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.instance.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.instance.position(partition);
    }

    public long position(TopicPartition partition, Duration timeout) {
        return this.instance.position(partition, timeout);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.instance.committed(partition);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.instance.committed(partition, timeout);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.instance.committed(partitions);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.instance.committed(partitions, timeout);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.instance.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.instance.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.instance.partitionsFor(topic, timeout);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.instance.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.instance.listTopics(timeout);
    }

    public Set<TopicPartition> paused() {
        return this.instance.paused();
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.instance.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.instance.resume(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.instance.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.instance.offsetsForTimes(timestampsToSearch, timeout);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.instance.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.instance.beginningOffsets(partitions, timeout);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.instance.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.instance.endOffsets(partitions, timeout);
    }

    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.instance.currentLag(topicPartition);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.instance.groupMetadata();
    }

    public void enforceRebalance() {
        this.instance.enforceRebalance();
    }

    public void enforceRebalance(String reason) {
        this.instance.enforceRebalance(reason);
    }

    @Override
    public void close() {
        this.instance.close(Duration.ofSeconds(5L));
    }

    public void close(Duration timeout) {
        this.instance.close(timeout);
    }

    public void wakeup() {
        this.instance.wakeup();
    }
}

