/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.clients;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;

public record CloseableProducer<K, V>(Producer<K, V> instance) implements Producer<K, V>,
AutoCloseable
{
    public static <K, V> Producer<K, V> wrap(Producer<K, V> instance) {
        return new CloseableProducer<K, V>(instance);
    }

    public static <K, V> Producer<K, V> create(Properties properties) {
        return CloseableProducer.wrap(new KafkaProducer(properties));
    }

    public static <K, V> Producer<K, V> create(Map<String, Object> configs) {
        return CloseableProducer.wrap(new KafkaProducer(configs));
    }

    @Override
    public void close() {
        this.instance.close(Duration.ofSeconds(5L));
    }

    public void initTransactions() {
        this.instance.initTransactions();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.instance.beginTransaction();
    }

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.instance.sendOffsetsToTransaction(offsets, consumerGroupId);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.instance.sendOffsetsToTransaction(offsets, groupMetadata);
    }

    public void commitTransaction() throws ProducerFencedException {
        this.instance.commitTransaction();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.instance.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.instance.send(record);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        return this.instance.send(record, callback);
    }

    public void flush() {
        this.instance.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.instance.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.instance.metrics();
    }

    public void close(Duration timeout) {
        this.instance.close(timeout);
    }
}

