/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import io.kroxylicious.testing.kafka.common.BrokerCluster;
import io.kroxylicious.testing.kafka.common.BrokerConfig;
import io.kroxylicious.testing.kafka.common.ClusterId;
import io.kroxylicious.testing.kafka.common.KRaftCluster;
import io.kroxylicious.testing.kafka.common.Version;
import io.kroxylicious.testing.kafka.common.ZooKeeperCluster;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConstraintUtils {
    private ConstraintUtils() {
    }

    public static BrokerCluster brokerCluster(int numBrokers) {
        return ConstraintUtils.mkAnnotation(BrokerCluster.class, Map.of("numBrokers", numBrokers));
    }

    public static Version version(String value) {
        return ConstraintUtils.mkAnnotation(Version.class, Map.of("value", value));
    }

    public static BrokerConfig brokerConfig(String name, String value) {
        return ConstraintUtils.mkAnnotation(BrokerConfig.class, Map.of("name", name, "value", value));
    }

    public static BrokerConfig.List brokerConfigs(Map<String, String> configs) {
        return ConstraintUtils.mkAnnotation(BrokerConfig.List.class, Map.of("value", configs.entrySet().stream().map(entry -> ConstraintUtils.mkAnnotation(BrokerConfig.class, Map.of("name", entry.getKey(), "value", entry.getValue()))).toArray(BrokerConfig[]::new)));
    }

    public static ClusterId clusterId(String clusterId) {
        return ConstraintUtils.mkAnnotation(ClusterId.class, Map.of("clusterId", clusterId));
    }

    public static KRaftCluster kraftCluster(int numControllers) {
        return ConstraintUtils.mkAnnotation(KRaftCluster.class, Map.of("numControllers", numControllers));
    }

    public static ZooKeeperCluster zooKeeperCluster() {
        return ConstraintUtils.mkAnnotation(ZooKeeperCluster.class, Map.of());
    }

    private static <A extends Annotation> A mkAnnotation(Class<A> annoType, Map<String, Object> members) {
        Objects.requireNonNull(members);
        for (String member : members.keySet()) {
            try {
                annoType.getDeclaredMethod(member, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        Objects.requireNonNull(members);
        return (A)((Annotation)Proxy.newProxyInstance(annoType.getClassLoader(), new Class[]{annoType}, new AnnotationProxyInvocationHandler<A>(annoType, members)));
    }

    private static class AnnotationProxyInvocationHandler<A extends Annotation>
    implements InvocationHandler {
        private final Class<A> annoType;
        private final Map<String, Object> members;

        public AnnotationProxyInvocationHandler(Class<A> annoType, Map<String, Object> members) {
            this.annoType = annoType;
            this.members = members;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "annotationType": {
                    return this.annoType;
                }
                case "toString": {
                    return this.annoType.getSimpleName() + this.members.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ", "(", ")"));
                }
                case "hashCode": {
                    return this.members.hashCode();
                }
                case "equals": {
                    InvocationHandler otherInvocation;
                    Object other = args[0];
                    if (Proxy.isProxyClass(other.getClass()) && (otherInvocation = Proxy.getInvocationHandler(other)) instanceof AnnotationProxyInvocationHandler) {
                        return this.members.equals(((AnnotationProxyInvocationHandler)otherInvocation).members);
                    }
                    return false;
                }
            }
            return this.members.get(method.getName());
        }
    }
}

