/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import io.kroxylicious.testing.kafka.common.BrokerCluster;
import io.kroxylicious.testing.kafka.common.BrokerConfig;
import io.kroxylicious.testing.kafka.common.ClusterId;
import io.kroxylicious.testing.kafka.common.KRaftCluster;
import io.kroxylicious.testing.kafka.common.KafkaClusterExecutionMode;
import io.kroxylicious.testing.kafka.common.KeytoolCertificateGenerator;
import io.kroxylicious.testing.kafka.common.SaslPlainAuth;
import io.kroxylicious.testing.kafka.common.Tls;
import io.kroxylicious.testing.kafka.common.Version;
import io.kroxylicious.testing.kafka.common.ZooKeeperCluster;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.TestInfo;

public class KafkaClusterConfig {
    private static final System.Logger LOGGER = System.getLogger(KafkaClusterConfig.class.getName());
    private static final String ONE_CONFIG = Integer.toString(1);
    public static final String BROKER_ROLE = "broker";
    public static final String CONTROLLER_ROLE = "controller";
    public static final String CONTROLLER_LISTENER_NAME = "CONTROLLER";
    public static final String EXTERNAL_LISTENER_NAME = "EXTERNAL";
    public static final String INTERNAL_LISTENER_NAME = "INTERNAL";
    public static final String ANON_LISTENER_NAME = "ANON";
    private TestInfo testInfo;
    private KeytoolCertificateGenerator brokerKeytoolCertificateGenerator;
    private KeytoolCertificateGenerator clientKeytoolCertificateGenerator;
    private final KafkaClusterExecutionMode execMode;
    private final Boolean kraftMode;
    private String kafkaVersion;
    private final String saslMechanism;
    private final String securityProtocol;
    private Integer brokersNum;
    private Integer kraftControllers;
    private String kafkaKraftClusterId;
    private final Map<String, String> users;
    private final Map<String, String> brokerConfigs;
    private static final Set<Class<? extends Annotation>> SUPPORTED_CONSTRAINTS = Set.of(ClusterId.class, BrokerCluster.class, BrokerConfig.class, BrokerConfig.List.class, KRaftCluster.class, Tls.class, SaslPlainAuth.class, SaslPlainAuth.List.class, ZooKeeperCluster.class, Version.class);

    public static boolean supportsConstraint(Class<? extends Annotation> annotation) {
        return SUPPORTED_CONSTRAINTS.contains(annotation);
    }

    public static KafkaClusterConfig fromConstraints(List<Annotation> annotations, TestInfo testInfo) {
        KafkaClusterConfigBuilder builder = KafkaClusterConfig.builder();
        builder.testInfo(testInfo);
        builder.brokersNum(1);
        boolean sasl = false;
        boolean tls = false;
        for (Annotation annotation : annotations) {
            if (annotation instanceof BrokerCluster) {
                BrokerCluster brokerCluster = (BrokerCluster)annotation;
                builder.brokersNum(brokerCluster.numBrokers());
            }
            if (annotation instanceof KRaftCluster) {
                KRaftCluster kRaftCluster = (KRaftCluster)annotation;
                builder.kraftMode(true);
                builder.kraftControllers(kRaftCluster.numControllers());
            }
            if (annotation instanceof ZooKeeperCluster) {
                builder.kraftMode(false);
            }
            if (annotation instanceof Tls) {
                tls = true;
                try {
                    builder.brokerKeytoolCertificateGenerator(new KeytoolCertificateGenerator());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (annotation instanceof SaslPlainAuth.List) {
                SaslPlainAuth.List saslPlainAuthList = (SaslPlainAuth.List)annotation;
                builder.saslMechanism("PLAIN");
                sasl = true;
                HashMap<String, String> users = new HashMap<String, String>();
                SaslPlainAuth[] saslPlainAuthArray = saslPlainAuthList.value();
                int n = saslPlainAuthArray.length;
                for (int i = 0; i < n; ++i) {
                    SaslPlainAuth user = saslPlainAuthArray[i];
                    users.put(user.user(), user.password());
                }
                builder.users(users);
            } else if (annotation instanceof SaslPlainAuth) {
                SaslPlainAuth saslPlainAuth = (SaslPlainAuth)annotation;
                builder.saslMechanism("PLAIN");
                sasl = true;
                builder.users(Map.of(saslPlainAuth.user(), saslPlainAuth.password()));
            }
            if (annotation instanceof ClusterId) {
                ClusterId clusterId = (ClusterId)annotation;
                builder.kafkaKraftClusterId(clusterId.value());
            }
            if (annotation instanceof Version) {
                Version version = (Version)annotation;
                builder.kafkaVersion(version.value());
            }
            if (annotation instanceof BrokerConfig.List) {
                BrokerConfig.List brokerConfigList = (BrokerConfig.List)annotation;
                for (BrokerConfig config : brokerConfigList.value()) {
                    builder.brokerConfig(config.name(), config.value());
                }
                continue;
            }
            if (!(annotation instanceof BrokerConfig)) continue;
            BrokerConfig brokerConfig = (BrokerConfig)annotation;
            builder.brokerConfig(brokerConfig.name(), brokerConfig.value());
        }
        builder.securityProtocol((sasl ? "SASL_" : "") + (tls ? "SSL" : "PLAINTEXT"));
        return builder.build();
    }

    public Stream<ConfigHolder> getBrokerConfigs(Supplier<KafkaEndpoints> endPointConfigSupplier) {
        ArrayList<ConfigHolder> properties = new ArrayList<ConfigHolder>();
        KafkaEndpoints kafkaEndpoints = endPointConfigSupplier.get();
        int nodeCount = Math.max(this.brokersNum, this.kraftControllers);
        for (int brokerNum = 0; brokerNum < nodeCount; ++brokerNum) {
            ConfigHolder brokerConfigHolder = this.generateConfigForSpecificNode(kafkaEndpoints, brokerNum);
            properties.add(brokerConfigHolder);
        }
        return properties.stream();
    }

    @NotNull
    public ConfigHolder generateConfigForSpecificNode(KafkaEndpoints kafkaEndpoints, int nodeId) {
        String role = this.determineRole(nodeId);
        Properties nodeConfiguration = new Properties();
        nodeConfiguration.putAll(this.brokerConfigs);
        KafkaClusterConfig.putConfig(nodeConfiguration, "broker.id", Integer.toString(nodeId));
        TreeMap<String, String> protocolMap = new TreeMap<String, String>();
        TreeMap<String, String> listeners = new TreeMap<String, String>();
        TreeMap<String, String> advertisedListeners = new TreeMap<String, String>();
        TreeSet<String> earlyStart = new TreeSet<String>();
        ConfigHolder configHolder = role.contains(BROKER_ROLE) ? this.configureBroker(kafkaEndpoints, nodeId, protocolMap, listeners, advertisedListeners, earlyStart, nodeConfiguration) : this.configureController(kafkaEndpoints, nodeId, nodeConfiguration);
        if (this.isKraftMode()) {
            this.configureKraftNode(kafkaEndpoints, nodeId, nodeConfiguration, protocolMap, listeners, earlyStart, role);
        } else {
            KafkaClusterConfig.configureLegacyNode(kafkaEndpoints, nodeConfiguration);
        }
        KafkaClusterConfig.putConfig(nodeConfiguration, "listener.security.protocol.map", protocolMap.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
        KafkaClusterConfig.putConfig(nodeConfiguration, "listeners", listeners.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
        KafkaClusterConfig.putConfig(nodeConfiguration, "early.start.listeners", earlyStart.stream().map(Object::toString).collect(Collectors.joining(",")));
        this.configureSasl(nodeConfiguration);
        KafkaClusterConfig.putConfig(nodeConfiguration, "offsets.topic.replication.factor", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "offsets.topic.num.partitions", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "transaction.state.log.replication.factor", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "transaction.state.log.min.isr", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "group.initial.rebalance.delay.ms", Integer.toString(0));
        KafkaClusterConfig.putConfig(nodeConfiguration, "metrics.jmx.exclude", ".*");
        return configHolder;
    }

    @NotNull
    private ConfigHolder configureController(KafkaEndpoints kafkaEndpoints, int nodeId, Properties nodeConfiguration) {
        return new ConfigHolder(nodeConfiguration, null, null, null, nodeId, this.kafkaKraftClusterId);
    }

    @NotNull
    private ConfigHolder configureBroker(KafkaEndpoints kafkaEndpoints, int nodeId, TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, TreeMap<String, String> advertisedListeners, TreeSet<String> earlyStart, Properties nodeConfiguration) {
        KafkaEndpoints.EndpointPair interBrokerEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.INTERNAL, nodeId);
        KafkaEndpoints.EndpointPair clientEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.EXTERNAL, nodeId);
        KafkaEndpoints.EndpointPair anonEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.ANON, nodeId);
        String externalListenerTransport = this.securityProtocol == null ? SecurityProtocol.PLAINTEXT.name() : this.securityProtocol;
        KafkaClusterConfig.configureExternalListener(protocolMap, externalListenerTransport, listeners, clientEndpoint, advertisedListeners);
        KafkaClusterConfig.configureInternalListener(protocolMap, listeners, interBrokerEndpoint, advertisedListeners, earlyStart, nodeConfiguration);
        KafkaClusterConfig.configureAnonListener(protocolMap, listeners, anonEndpoint, advertisedListeners);
        this.configureTls(clientEndpoint, nodeConfiguration);
        KafkaClusterConfig.putConfig(nodeConfiguration, "advertised.listeners", advertisedListeners.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
        ConfigHolder configHolder = new ConfigHolder(nodeConfiguration, clientEndpoint.getConnect().getPort(), anonEndpoint.getConnect().getPort(), clientEndpoint.connectAddress(), nodeId, this.kafkaKraftClusterId);
        return configHolder;
    }

    @NotNull
    private String determineRole(int nodeId) {
        ArrayList<String> roles = new ArrayList<String>();
        if (nodeId < this.brokersNum || this.isAdditionalNode(nodeId)) {
            roles.add(BROKER_ROLE);
        }
        if (nodeId < this.kraftControllers) {
            roles.add(CONTROLLER_ROLE);
        }
        return String.join((CharSequence)",", roles);
    }

    private boolean isAdditionalNode(int nodeId) {
        return nodeId >= Math.max(this.brokersNum, this.kraftControllers);
    }

    private void configureTls(KafkaEndpoints.EndpointPair clientEndpoint, Properties server) {
        if (this.securityProtocol != null && this.securityProtocol.contains("SSL")) {
            if (this.brokerKeytoolCertificateGenerator == null) {
                throw new RuntimeException("brokerKeytoolCertificateGenerator needs to be initialized when calling KafkaClusterConfig");
            }
            try {
                this.brokerKeytoolCertificateGenerator.generateSelfSignedCertificateEntry("test@kroxylicious.io", clientEndpoint.getConnect().getHost(), "Dev", "Kroxylicious.io", null, null, "US");
                if (this.clientKeytoolCertificateGenerator != null && Path.of(this.clientKeytoolCertificateGenerator.getCertFilePath(), new String[0]).toFile().exists()) {
                    if (this.securityProtocol.equals(SecurityProtocol.SASL_SSL.toString())) {
                        server.put("listener.name.EXTERNAL.ssl.client.auth", "required");
                    } else {
                        server.put("ssl.client.auth", "required");
                    }
                    this.brokerKeytoolCertificateGenerator.generateTrustStore(this.clientKeytoolCertificateGenerator.getCertFilePath(), clientEndpoint.getConnect().getHost());
                    server.put("ssl.truststore.location", this.brokerKeytoolCertificateGenerator.getTrustStoreLocation());
                    server.put("ssl.truststore.password", this.brokerKeytoolCertificateGenerator.getPassword());
                    server.put("ssl.truststore.type", this.brokerKeytoolCertificateGenerator.getTrustStoreType());
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            server.put("ssl.keystore.location", this.brokerKeytoolCertificateGenerator.getKeyStoreLocation());
            server.put("ssl.keystore.password", this.brokerKeytoolCertificateGenerator.getPassword());
            server.put("ssl.key.password", this.brokerKeytoolCertificateGenerator.getPassword());
            server.put("ssl.keystore.type", this.brokerKeytoolCertificateGenerator.getKeyStoreType());
        }
    }

    private void configureSasl(Properties server) {
        if (this.saslMechanism != null) {
            KafkaClusterConfig.putConfig(server, "sasl.enabled.mechanisms", this.saslMechanism);
            StringBuilder saslPairs = new StringBuilder();
            Optional.ofNullable(this.users).orElse(Map.of()).forEach((key, value) -> {
                saslPairs.append(String.format("user_%s", key));
                saslPairs.append("=");
                saslPairs.append((String)value);
                saslPairs.append(" ");
            });
            String plainModuleConfig = String.format("org.apache.kafka.common.security.plain.PlainLoginModule required %s;", saslPairs);
            KafkaClusterConfig.putConfig(server, String.format("listener.name.%s.plain.sasl.jaas.config", EXTERNAL_LISTENER_NAME.toLowerCase()), plainModuleConfig);
        }
    }

    private static void configureInternalListener(TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, KafkaEndpoints.EndpointPair interBrokerEndpoint, TreeMap<String, String> advertisedListeners, TreeSet<String> earlyStart, Properties server) {
        protocolMap.put(INTERNAL_LISTENER_NAME, SecurityProtocol.PLAINTEXT.name());
        listeners.put(INTERNAL_LISTENER_NAME, interBrokerEndpoint.listenAddress());
        advertisedListeners.put(INTERNAL_LISTENER_NAME, interBrokerEndpoint.advertisedAddress());
        earlyStart.add(INTERNAL_LISTENER_NAME);
        KafkaClusterConfig.putConfig(server, "inter.broker.listener.name", INTERNAL_LISTENER_NAME);
    }

    private static void configureAnonListener(TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, KafkaEndpoints.EndpointPair anonEndpoint, TreeMap<String, String> advertisedListeners) {
        protocolMap.put(ANON_LISTENER_NAME, SecurityProtocol.PLAINTEXT.name());
        listeners.put(ANON_LISTENER_NAME, anonEndpoint.listenAddress());
        advertisedListeners.put(ANON_LISTENER_NAME, anonEndpoint.advertisedAddress());
    }

    private static void configureExternalListener(TreeMap<String, String> protocolMap, String externalListenerTransport, TreeMap<String, String> listeners, KafkaEndpoints.EndpointPair clientEndpoint, TreeMap<String, String> advertisedListeners) {
        protocolMap.put(EXTERNAL_LISTENER_NAME, externalListenerTransport);
        listeners.put(EXTERNAL_LISTENER_NAME, clientEndpoint.listenAddress());
        advertisedListeners.put(EXTERNAL_LISTENER_NAME, clientEndpoint.advertisedAddress());
    }

    private static void configureLegacyNode(KafkaEndpoints kafkaEndpoints, Properties server) {
        KafkaClusterConfig.putConfig(server, "zookeeper.connect", kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.CONTROLLER, 0).connectAddress());
        KafkaClusterConfig.putConfig(server, "zookeeper.sasl.enabled", "false");
        KafkaClusterConfig.putConfig(server, "zookeeper.connection.timeout.ms", Long.toString(60000L));
        KafkaClusterConfig.putConfig(server, KafkaConfig.ZkSessionTimeoutMsProp(), Long.toString(6000L));
    }

    private void configureKraftNode(KafkaEndpoints kafkaEndpoints, int nodeId, Properties nodeConfiguration, TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, TreeSet<String> earlyStart, String role) {
        KafkaClusterConfig.putConfig(nodeConfiguration, "node.id", Integer.toString(nodeId));
        String quorumVoters = IntStream.range(0, this.kraftControllers).mapToObj(controllerId -> String.format("%d@//%s", controllerId, kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.CONTROLLER, controllerId).connectAddress())).collect(Collectors.joining(","));
        KafkaClusterConfig.putConfig(nodeConfiguration, "controller.quorum.voters", quorumVoters);
        KafkaClusterConfig.putConfig(nodeConfiguration, "controller.listener.names", CONTROLLER_LISTENER_NAME);
        protocolMap.put(CONTROLLER_LISTENER_NAME, SecurityProtocol.PLAINTEXT.name());
        KafkaClusterConfig.putConfig(nodeConfiguration, "process.roles", role);
        if (role.contains(CONTROLLER_ROLE)) {
            KafkaEndpoints.EndpointPair controllerEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.CONTROLLER, nodeId);
            String bindAddress = controllerEndpoint.getBind().toString();
            listeners.put(CONTROLLER_LISTENER_NAME, bindAddress);
            earlyStart.add(CONTROLLER_LISTENER_NAME);
        }
    }

    private static void putConfig(Properties server, String key, String value) {
        Object orig = server.put(key, value);
        if (orig != null) {
            throw new RuntimeException("Cannot override broker config '" + key + "=" + value + "' with new value " + orig);
        }
    }

    public Map<String, Object> getAnonConnectConfigForCluster(String bootstrapServers) {
        return this.getConnectConfigForCluster(bootstrapServers, null, null, null, null);
    }

    public Map<String, Object> getConnectConfigForCluster(String bootstrapServers) {
        if (this.saslMechanism != null) {
            Map<String, String> users = this.getUsers();
            if (!users.isEmpty()) {
                Map.Entry<String, String> first = users.entrySet().iterator().next();
                return this.getConnectConfigForCluster(bootstrapServers, first.getKey(), first.getValue(), this.getSecurityProtocol(), this.getSaslMechanism());
            }
            return this.getConnectConfigForCluster(bootstrapServers, null, null, this.getSecurityProtocol(), this.getSaslMechanism());
        }
        return this.getConnectConfigForCluster(bootstrapServers, null, null, this.getSecurityProtocol(), this.getSaslMechanism());
    }

    public Map<String, Object> getConnectConfigForCluster(String bootstrapServers, String user, String password) {
        return this.getConnectConfigForCluster(bootstrapServers, user, password, this.getSecurityProtocol(), this.getSaslMechanism());
    }

    public Map<String, Object> getConnectConfigForCluster(String bootstrapServers, String user, String password, String securityProtocol, String saslMechanism) {
        HashMap<String, Object> kafkaConfig = new HashMap<String, Object>();
        if (securityProtocol != null) {
            kafkaConfig.put("security.protocol", securityProtocol);
            if (securityProtocol.contains("SSL")) {
                String clientTrustStorePassword;
                String clientTrustStoreFilePath;
                if (this.clientKeytoolCertificateGenerator != null) {
                    if (Path.of(this.clientKeytoolCertificateGenerator.getKeyStoreLocation(), new String[0]).toFile().exists()) {
                        kafkaConfig.put("ssl.keystore.location", this.clientKeytoolCertificateGenerator.getKeyStoreLocation());
                        kafkaConfig.put("ssl.keystore.password", this.clientKeytoolCertificateGenerator.getPassword());
                        kafkaConfig.put("ssl.key.password", this.clientKeytoolCertificateGenerator.getPassword());
                    }
                    try {
                        this.clientKeytoolCertificateGenerator.generateTrustStore(this.brokerKeytoolCertificateGenerator.getCertFilePath(), "client");
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    clientTrustStoreFilePath = this.clientKeytoolCertificateGenerator.getTrustStoreLocation();
                    clientTrustStorePassword = this.clientKeytoolCertificateGenerator.getPassword();
                } else {
                    Path clientTrustStore;
                    try {
                        Path certsDirectory = Files.createTempDirectory("kafkaClient", new FileAttribute[0]);
                        clientTrustStore = Paths.get(certsDirectory.toAbsolutePath().toString(), "kafka.truststore.jks");
                        certsDirectory.toFile().deleteOnExit();
                        clientTrustStore.toFile().deleteOnExit();
                        this.brokerKeytoolCertificateGenerator.generateTrustStore(this.brokerKeytoolCertificateGenerator.getCertFilePath(), "client", clientTrustStore.toAbsolutePath().toString());
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    clientTrustStoreFilePath = clientTrustStore.toAbsolutePath().toString();
                    clientTrustStorePassword = this.brokerKeytoolCertificateGenerator.getPassword();
                }
                kafkaConfig.put("ssl.truststore.location", clientTrustStoreFilePath);
                kafkaConfig.put("ssl.truststore.password", clientTrustStorePassword);
            }
        }
        if (saslMechanism != null) {
            if (securityProtocol == null) {
                kafkaConfig.put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name());
            }
            kafkaConfig.put("sasl.mechanism", saslMechanism);
            if ("PLAIN".equals(saslMechanism)) {
                if (user != null && password != null) {
                    kafkaConfig.put("sasl.jaas.config", String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";", user, password));
                }
            } else {
                throw new IllegalStateException(String.format("unsupported SASL mechanism %s", saslMechanism));
            }
        }
        kafkaConfig.put("bootstrap.servers", bootstrapServers);
        return kafkaConfig;
    }

    public boolean isKraftMode() {
        return this.getKraftMode() == null || this.getKraftMode() != false;
    }

    public String clusterId() {
        return this.isKraftMode() ? this.kafkaKraftClusterId : null;
    }

    private static String $default$kafkaVersion() {
        return "latest";
    }

    private static Integer $default$brokersNum() {
        return 1;
    }

    private static Integer $default$kraftControllers() {
        return 1;
    }

    private static String $default$kafkaKraftClusterId() {
        return Uuid.randomUuid().toString();
    }

    KafkaClusterConfig(TestInfo testInfo, KeytoolCertificateGenerator brokerKeytoolCertificateGenerator, KeytoolCertificateGenerator clientKeytoolCertificateGenerator, KafkaClusterExecutionMode execMode, Boolean kraftMode, String kafkaVersion, String saslMechanism, String securityProtocol, Integer brokersNum, Integer kraftControllers, String kafkaKraftClusterId, Map<String, String> users, Map<String, String> brokerConfigs) {
        this.testInfo = testInfo;
        this.brokerKeytoolCertificateGenerator = brokerKeytoolCertificateGenerator;
        this.clientKeytoolCertificateGenerator = clientKeytoolCertificateGenerator;
        this.execMode = execMode;
        this.kraftMode = kraftMode;
        this.kafkaVersion = kafkaVersion;
        this.saslMechanism = saslMechanism;
        this.securityProtocol = securityProtocol;
        this.brokersNum = brokersNum;
        this.kraftControllers = kraftControllers;
        this.kafkaKraftClusterId = kafkaKraftClusterId;
        this.users = users;
        this.brokerConfigs = brokerConfigs;
    }

    public static KafkaClusterConfigBuilder builder() {
        return new KafkaClusterConfigBuilder();
    }

    public KafkaClusterConfigBuilder toBuilder() {
        KafkaClusterConfigBuilder builder = new KafkaClusterConfigBuilder().testInfo(this.testInfo).brokerKeytoolCertificateGenerator(this.brokerKeytoolCertificateGenerator).clientKeytoolCertificateGenerator(this.clientKeytoolCertificateGenerator).execMode(this.execMode).kraftMode(this.kraftMode).kafkaVersion(this.kafkaVersion).saslMechanism(this.saslMechanism).securityProtocol(this.securityProtocol).brokersNum(this.brokersNum).kraftControllers(this.kraftControllers).kafkaKraftClusterId(this.kafkaKraftClusterId);
        if (this.users != null) {
            builder.users(this.users);
        }
        if (this.brokerConfigs != null) {
            builder.brokerConfigs(this.brokerConfigs);
        }
        return builder;
    }

    public TestInfo getTestInfo() {
        return this.testInfo;
    }

    public KeytoolCertificateGenerator getBrokerKeytoolCertificateGenerator() {
        return this.brokerKeytoolCertificateGenerator;
    }

    public KeytoolCertificateGenerator getClientKeytoolCertificateGenerator() {
        return this.clientKeytoolCertificateGenerator;
    }

    public KafkaClusterExecutionMode getExecMode() {
        return this.execMode;
    }

    public Boolean getKraftMode() {
        return this.kraftMode;
    }

    public String getKafkaVersion() {
        return this.kafkaVersion;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public Integer getBrokersNum() {
        return this.brokersNum;
    }

    public Integer getKraftControllers() {
        return this.kraftControllers;
    }

    public String getKafkaKraftClusterId() {
        return this.kafkaKraftClusterId;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public Map<String, String> getBrokerConfigs() {
        return this.brokerConfigs;
    }

    public String toString() {
        return "KafkaClusterConfig(testInfo=" + this.getTestInfo() + ", brokerKeytoolCertificateGenerator=" + this.getBrokerKeytoolCertificateGenerator() + ", clientKeytoolCertificateGenerator=" + this.getClientKeytoolCertificateGenerator() + ", execMode=" + this.getExecMode() + ", kraftMode=" + this.getKraftMode() + ", kafkaVersion=" + this.getKafkaVersion() + ", saslMechanism=" + this.getSaslMechanism() + ", securityProtocol=" + this.getSecurityProtocol() + ", brokersNum=" + this.getBrokersNum() + ", kraftControllers=" + this.getKraftControllers() + ", kafkaKraftClusterId=" + this.getKafkaKraftClusterId() + ", users=" + this.getUsers() + ", brokerConfigs=" + this.getBrokerConfigs() + ")";
    }

    public static class KafkaClusterConfigBuilder {
        private TestInfo testInfo;
        private KeytoolCertificateGenerator brokerKeytoolCertificateGenerator;
        private KeytoolCertificateGenerator clientKeytoolCertificateGenerator;
        private KafkaClusterExecutionMode execMode;
        private Boolean kraftMode;
        private boolean kafkaVersion$set;
        private String kafkaVersion$value;
        private String saslMechanism;
        private String securityProtocol;
        private boolean brokersNum$set;
        private Integer brokersNum$value;
        private boolean kraftControllers$set;
        private Integer kraftControllers$value;
        private boolean kafkaKraftClusterId$set;
        private String kafkaKraftClusterId$value;
        private ArrayList<String> users$key;
        private ArrayList<String> users$value;
        private ArrayList<String> brokerConfigs$key;
        private ArrayList<String> brokerConfigs$value;

        KafkaClusterConfigBuilder() {
        }

        public KafkaClusterConfigBuilder testInfo(TestInfo testInfo) {
            this.testInfo = testInfo;
            return this;
        }

        public KafkaClusterConfigBuilder brokerKeytoolCertificateGenerator(KeytoolCertificateGenerator brokerKeytoolCertificateGenerator) {
            this.brokerKeytoolCertificateGenerator = brokerKeytoolCertificateGenerator;
            return this;
        }

        public KafkaClusterConfigBuilder clientKeytoolCertificateGenerator(KeytoolCertificateGenerator clientKeytoolCertificateGenerator) {
            this.clientKeytoolCertificateGenerator = clientKeytoolCertificateGenerator;
            return this;
        }

        public KafkaClusterConfigBuilder execMode(KafkaClusterExecutionMode execMode) {
            this.execMode = execMode;
            return this;
        }

        public KafkaClusterConfigBuilder kraftMode(Boolean kraftMode) {
            this.kraftMode = kraftMode;
            return this;
        }

        public KafkaClusterConfigBuilder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion$value = kafkaVersion;
            this.kafkaVersion$set = true;
            return this;
        }

        public KafkaClusterConfigBuilder saslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
            return this;
        }

        public KafkaClusterConfigBuilder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        public KafkaClusterConfigBuilder brokersNum(Integer brokersNum) {
            this.brokersNum$value = brokersNum;
            this.brokersNum$set = true;
            return this;
        }

        public KafkaClusterConfigBuilder kraftControllers(Integer kraftControllers) {
            this.kraftControllers$value = kraftControllers;
            this.kraftControllers$set = true;
            return this;
        }

        public KafkaClusterConfigBuilder kafkaKraftClusterId(String kafkaKraftClusterId) {
            this.kafkaKraftClusterId$value = kafkaKraftClusterId;
            this.kafkaKraftClusterId$set = true;
            return this;
        }

        public KafkaClusterConfigBuilder user(String userKey, String userValue) {
            if (this.users$key == null) {
                this.users$key = new ArrayList();
                this.users$value = new ArrayList();
            }
            this.users$key.add(userKey);
            this.users$value.add(userValue);
            return this;
        }

        public KafkaClusterConfigBuilder users(Map<? extends String, ? extends String> users) {
            if (users == null) {
                throw new NullPointerException("users cannot be null");
            }
            if (this.users$key == null) {
                this.users$key = new ArrayList();
                this.users$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : users.entrySet()) {
                this.users$key.add($lombokEntry.getKey());
                this.users$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public KafkaClusterConfigBuilder clearUsers() {
            if (this.users$key != null) {
                this.users$key.clear();
                this.users$value.clear();
            }
            return this;
        }

        public KafkaClusterConfigBuilder brokerConfig(String brokerConfigKey, String brokerConfigValue) {
            if (this.brokerConfigs$key == null) {
                this.brokerConfigs$key = new ArrayList();
                this.brokerConfigs$value = new ArrayList();
            }
            this.brokerConfigs$key.add(brokerConfigKey);
            this.brokerConfigs$value.add(brokerConfigValue);
            return this;
        }

        public KafkaClusterConfigBuilder brokerConfigs(Map<? extends String, ? extends String> brokerConfigs) {
            if (brokerConfigs == null) {
                throw new NullPointerException("brokerConfigs cannot be null");
            }
            if (this.brokerConfigs$key == null) {
                this.brokerConfigs$key = new ArrayList();
                this.brokerConfigs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : brokerConfigs.entrySet()) {
                this.brokerConfigs$key.add($lombokEntry.getKey());
                this.brokerConfigs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public KafkaClusterConfigBuilder clearBrokerConfigs() {
            if (this.brokerConfigs$key != null) {
                this.brokerConfigs$key.clear();
                this.brokerConfigs$value.clear();
            }
            return this;
        }

        public KafkaClusterConfig build() {
            Map<Object, Object> brokerConfigs;
            Map<Object, Object> users;
            switch (this.users$key == null ? 0 : this.users$key.size()) {
                case 0: {
                    users = Collections.emptyMap();
                    break;
                }
                case 1: {
                    users = Collections.singletonMap(this.users$key.get(0), this.users$value.get(0));
                    break;
                }
                default: {
                    users = new LinkedHashMap(this.users$key.size() < 0x40000000 ? 1 + this.users$key.size() + (this.users$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.users$key.size(); ++$i) {
                        users.put(this.users$key.get($i), this.users$value.get($i));
                    }
                    users = Collections.unmodifiableMap(users);
                }
            }
            switch (this.brokerConfigs$key == null ? 0 : this.brokerConfigs$key.size()) {
                case 0: {
                    brokerConfigs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    brokerConfigs = Collections.singletonMap(this.brokerConfigs$key.get(0), this.brokerConfigs$value.get(0));
                    break;
                }
                default: {
                    brokerConfigs = new LinkedHashMap(this.brokerConfigs$key.size() < 0x40000000 ? 1 + this.brokerConfigs$key.size() + (this.brokerConfigs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.brokerConfigs$key.size(); ++$i) {
                        brokerConfigs.put(this.brokerConfigs$key.get($i), this.brokerConfigs$value.get($i));
                    }
                    brokerConfigs = Collections.unmodifiableMap(brokerConfigs);
                }
            }
            String kafkaVersion$value = this.kafkaVersion$value;
            if (!this.kafkaVersion$set) {
                kafkaVersion$value = KafkaClusterConfig.$default$kafkaVersion();
            }
            Integer brokersNum$value = this.brokersNum$value;
            if (!this.brokersNum$set) {
                brokersNum$value = KafkaClusterConfig.$default$brokersNum();
            }
            Integer kraftControllers$value = this.kraftControllers$value;
            if (!this.kraftControllers$set) {
                kraftControllers$value = KafkaClusterConfig.$default$kraftControllers();
            }
            String kafkaKraftClusterId$value = this.kafkaKraftClusterId$value;
            if (!this.kafkaKraftClusterId$set) {
                kafkaKraftClusterId$value = KafkaClusterConfig.$default$kafkaKraftClusterId();
            }
            return new KafkaClusterConfig(this.testInfo, this.brokerKeytoolCertificateGenerator, this.clientKeytoolCertificateGenerator, this.execMode, this.kraftMode, kafkaVersion$value, this.saslMechanism, this.securityProtocol, brokersNum$value, kraftControllers$value, kafkaKraftClusterId$value, users, brokerConfigs);
        }

        public String toString() {
            return "KafkaClusterConfig.KafkaClusterConfigBuilder(testInfo=" + this.testInfo + ", brokerKeytoolCertificateGenerator=" + this.brokerKeytoolCertificateGenerator + ", clientKeytoolCertificateGenerator=" + this.clientKeytoolCertificateGenerator + ", execMode=" + this.execMode + ", kraftMode=" + this.kraftMode + ", kafkaVersion$value=" + this.kafkaVersion$value + ", saslMechanism=" + this.saslMechanism + ", securityProtocol=" + this.securityProtocol + ", brokersNum$value=" + this.brokersNum$value + ", kraftControllers$value=" + this.kraftControllers$value + ", kafkaKraftClusterId$value=" + this.kafkaKraftClusterId$value + ", users$key=" + this.users$key + ", users$value=" + this.users$value + ", brokerConfigs$key=" + this.brokerConfigs$key + ", brokerConfigs$value=" + this.brokerConfigs$value + ")";
        }
    }

    public static interface KafkaEndpoints {
        public EndpointPair getEndpointPair(Listener var1, int var2);

        public static class Endpoint {
            private final String host;
            private final int port;

            public Endpoint(String host, int port) {
                this.host = host;
                this.port = port;
            }

            public String toString() {
                return String.format("//%s:%d", this.host, this.port);
            }

            public static EndpointBuilder builder() {
                return new EndpointBuilder();
            }

            public String getHost() {
                return this.host;
            }

            public int getPort() {
                return this.port;
            }

            public static class EndpointBuilder {
                private String host;
                private int port;

                EndpointBuilder() {
                }

                public EndpointBuilder host(String host) {
                    this.host = host;
                    return this;
                }

                public EndpointBuilder port(int port) {
                    this.port = port;
                    return this;
                }

                public Endpoint build() {
                    return new Endpoint(this.host, this.port);
                }

                public String toString() {
                    return "KafkaClusterConfig.KafkaEndpoints.Endpoint.EndpointBuilder(host=" + this.host + ", port=" + this.port + ")";
                }
            }
        }

        public static class EndpointPair {
            private final Endpoint bind;
            private final Endpoint connect;

            public EndpointPair(Endpoint bind, Endpoint connect) {
                this.bind = bind;
                this.connect = connect;
            }

            public String connectAddress() {
                return String.format("%s:%d", this.connect.host, this.connect.port);
            }

            public String listenAddress() {
                return String.format("//%s:%d", this.bind.host, this.bind.port);
            }

            public String advertisedAddress() {
                return String.format("//%s:%d", this.connect.host, this.connect.port);
            }

            public static EndpointPairBuilder builder() {
                return new EndpointPairBuilder();
            }

            public Endpoint getBind() {
                return this.bind;
            }

            public Endpoint getConnect() {
                return this.connect;
            }

            public static class EndpointPairBuilder {
                private Endpoint bind;
                private Endpoint connect;

                EndpointPairBuilder() {
                }

                public EndpointPairBuilder bind(Endpoint bind) {
                    this.bind = bind;
                    return this;
                }

                public EndpointPairBuilder connect(Endpoint connect) {
                    this.connect = connect;
                    return this;
                }

                public EndpointPair build() {
                    return new EndpointPair(this.bind, this.connect);
                }

                public String toString() {
                    return "KafkaClusterConfig.KafkaEndpoints.EndpointPair.EndpointPairBuilder(bind=" + this.bind + ", connect=" + this.connect + ")";
                }
            }
        }

        public static enum Listener {
            EXTERNAL,
            ANON,
            INTERNAL,
            CONTROLLER;

        }
    }

    public static class ConfigHolder {
        private final Properties properties;
        private final Integer externalPort;
        private final Integer anonPort;
        private final String endpoint;
        private final int brokerNum;
        private final String kafkaKraftClusterId;
        private final String roles;

        public ConfigHolder(Properties properties, Integer externalPort, Integer anonPort, String endpoint, int brokerNum, String kafkaKraftClusterId) {
            this.properties = properties;
            this.externalPort = externalPort;
            this.anonPort = anonPort;
            this.endpoint = endpoint;
            this.brokerNum = brokerNum;
            this.kafkaKraftClusterId = kafkaKraftClusterId;
            this.roles = properties.getProperty("process.roles", KafkaClusterConfig.BROKER_ROLE);
        }

        public boolean isBroker() {
            return this.roles.contains(KafkaClusterConfig.BROKER_ROLE);
        }

        public boolean isController() {
            return this.roles.contains(KafkaClusterConfig.CONTROLLER_ROLE);
        }

        public static ConfigHolderBuilder builder() {
            return new ConfigHolderBuilder();
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Integer getExternalPort() {
            return this.externalPort;
        }

        public Integer getAnonPort() {
            return this.anonPort;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public int getBrokerNum() {
            return this.brokerNum;
        }

        public String getKafkaKraftClusterId() {
            return this.kafkaKraftClusterId;
        }

        public String getRoles() {
            return this.roles;
        }

        public static class ConfigHolderBuilder {
            private Properties properties;
            private Integer externalPort;
            private Integer anonPort;
            private String endpoint;
            private int brokerNum;
            private String kafkaKraftClusterId;

            ConfigHolderBuilder() {
            }

            public ConfigHolderBuilder properties(Properties properties) {
                this.properties = properties;
                return this;
            }

            public ConfigHolderBuilder externalPort(Integer externalPort) {
                this.externalPort = externalPort;
                return this;
            }

            public ConfigHolderBuilder anonPort(Integer anonPort) {
                this.anonPort = anonPort;
                return this;
            }

            public ConfigHolderBuilder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public ConfigHolderBuilder brokerNum(int brokerNum) {
                this.brokerNum = brokerNum;
                return this;
            }

            public ConfigHolderBuilder kafkaKraftClusterId(String kafkaKraftClusterId) {
                this.kafkaKraftClusterId = kafkaKraftClusterId;
                return this;
            }

            public ConfigHolder build() {
                return new ConfigHolder(this.properties, this.externalPort, this.anonPort, this.endpoint, this.brokerNum, this.kafkaKraftClusterId);
            }

            public String toString() {
                return "KafkaClusterConfig.ConfigHolder.ConfigHolderBuilder(properties=" + this.properties + ", externalPort=" + this.externalPort + ", anonPort=" + this.anonPort + ", endpoint=" + this.endpoint + ", brokerNum=" + this.brokerNum + ", kafkaKraftClusterId=" + this.kafkaKraftClusterId + ")";
            }
        }
    }
}

