/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import io.kroxylicious.testing.kafka.api.KafkaCluster;
import io.kroxylicious.testing.kafka.common.KafkaClusterConfig;
import io.kroxylicious.testing.kafka.common.KafkaClusterExecutionMode;
import io.kroxylicious.testing.kafka.invm.InVMKafkaCluster;
import io.kroxylicious.testing.kafka.testcontainers.TestcontainersKafkaCluster;
import org.testcontainers.utility.DockerImageName;

public class KafkaClusterFactory {
    private static final System.Logger LOGGER = System.getLogger(KafkaClusterFactory.class.getName());
    public static final String TEST_CLUSTER_EXECUTION_MODE = "TEST_CLUSTER_EXECUTION_MODE";
    public static final String KAFKA_VERSION = "KAFKA_VERSION";
    public static final String KAFKA_IMAGE_REPO = "KAFKA_IMAGE_REPO";
    public static final String ZOOKEEPER_IMAGE_REPO = "ZOOKEEPER_IMAGE_REPO";
    public static final String TEST_CLUSTER_KRAFT_MODE = "TEST_CLUSTER_KRAFT_MODE";

    public static KafkaCluster create(KafkaClusterConfig clusterConfig) {
        if (clusterConfig == null) {
            throw new NullPointerException();
        }
        KafkaClusterExecutionMode clusterMode = KafkaClusterFactory.getExecutionMode(clusterConfig);
        boolean kraftMode = KafkaClusterFactory.convertClusterKraftMode(System.getenv().get(TEST_CLUSTER_KRAFT_MODE), true);
        KafkaClusterConfig.KafkaClusterConfigBuilder builder = clusterConfig.toBuilder();
        if (clusterConfig.getExecMode() == null) {
            builder.execMode(clusterMode);
        }
        if (clusterConfig.getKraftMode() == null) {
            builder.kraftMode(kraftMode);
        }
        if (KafkaClusterExecutionMode.CONTAINER == clusterMode && kraftMode && clusterConfig.getBrokersNum() < clusterConfig.getKraftControllers()) {
            throw new IllegalStateException("Due to https://github.com/ozangunalp/kafka-native/issues/88 we can't support controller only nodes in " + KafkaClusterExecutionMode.CONTAINER + " mode so we need to fail fast. This cluster has " + clusterConfig.getBrokersNum() + " brokers and " + clusterConfig.getKraftControllers() + " controllers");
        }
        String kafkaVersion = System.getenv().getOrDefault(KAFKA_VERSION, "latest");
        builder.kafkaVersion(kafkaVersion);
        KafkaClusterConfig actual = builder.build();
        LOGGER.log(System.Logger.Level.DEBUG, "Test cluster : {0}", actual);
        if (actual.getExecMode() == KafkaClusterExecutionMode.IN_VM) {
            return new InVMKafkaCluster(actual);
        }
        String kafkaImageRepo = System.getenv().get(KAFKA_IMAGE_REPO);
        String zookeeperImageRepo = System.getenv().get(ZOOKEEPER_IMAGE_REPO);
        DockerImageName kafkaImage = kafkaImageRepo != null ? DockerImageName.parse((String)kafkaImageRepo) : null;
        DockerImageName zookeeperImage = zookeeperImageRepo != null ? DockerImageName.parse((String)zookeeperImageRepo) : null;
        return new TestcontainersKafkaCluster(kafkaImage, zookeeperImage, actual);
    }

    private static KafkaClusterExecutionMode getExecutionMode(KafkaClusterConfig clusterConfig) {
        return KafkaClusterExecutionMode.convertClusterExecutionMode(System.getenv().get(TEST_CLUSTER_EXECUTION_MODE), clusterConfig.getExecMode() == null ? KafkaClusterExecutionMode.IN_VM : clusterConfig.getExecMode());
    }

    private static boolean convertClusterKraftMode(String mode, boolean defaultMode) {
        if (mode == null) {
            return defaultMode;
        }
        return Boolean.parseBoolean(mode);
    }
}

