/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;

public class ListeningSocketPreallocator
implements AutoCloseable {
    private static final int PORT_RANGE_LOW = 10000;
    private static final int PORT_RANGE_HIGH = 30000;
    private final List<ServerSocket> all = new ArrayList<ServerSocket>();
    private final Random random = new Random();

    public List<ServerSocket> preAllocateListeningSockets(int num) {
        if (num < 1) {
            return List.of();
        }
        return this.random.ints(10000, 30000).mapToObj(number -> {
            try {
                ServerSocket serverSocket = new ServerSocket(number);
                serverSocket.setReuseAddress(true);
                if (serverSocket.isBound()) {
                    return serverSocket;
                }
            }
            catch (IOException e) {
                if (e instanceof BindException) {
                    return null;
                }
                throw new RuntimeException(e);
            }
            return null;
        }).filter(Objects::nonNull).peek(this.all::add).limit(num).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.all.forEach(serverSocket -> {
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                System.getLogger("portAllocator").log(System.Logger.Level.WARNING, "failed to release socket: ", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        });
    }
}

