/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.invm;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

final class LoggingPrintStream {
    static PrintStream loggingPrintStream(System.Logger logger, System.Logger.Level level) {
        return new PrintStream(new LoggingOutputStream(logger, level));
    }

    private LoggingPrintStream() {
    }

    private static class LoggingOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream(1000);
        private final System.Logger logger;
        private final System.Logger.Level level;

        public LoggingOutputStream(System.Logger logger, System.Logger.Level level) {
            this.logger = logger;
            this.level = level;
        }

        @Override
        public void write(int b) {
            if (b == 10 || b == 13) {
                this.logPending();
            } else {
                this.os.write(b);
            }
        }

        @Override
        public void close() {
            this.logPending();
        }

        private void logPending() {
            String log;
            if (this.logger.isLoggable(this.level) && !(log = this.os.toString(Charset.defaultCharset()).stripTrailing()).isEmpty()) {
                this.logger.log(this.level, "{0}", log);
            }
            this.os.reset();
        }
    }
}

