/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import io.kroxylicious.testing.kafka.common.BrokerCluster;
import io.kroxylicious.testing.kafka.common.BrokerConfig;
import io.kroxylicious.testing.kafka.common.ClusterId;
import io.kroxylicious.testing.kafka.common.KRaftCluster;
import io.kroxylicious.testing.kafka.common.SaslMechanism;
import io.kroxylicious.testing.kafka.common.SaslPlainAuth;
import io.kroxylicious.testing.kafka.common.Tls;
import io.kroxylicious.testing.kafka.common.Version;
import io.kroxylicious.testing.kafka.common.ZooKeeperCluster;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConstraintUtils {
    private static final String VALUE = "value";

    private ConstraintUtils() {
    }

    public static BrokerCluster brokerCluster(int numBrokers) {
        return ConstraintUtils.mkAnnotation(BrokerCluster.class, Map.of("numBrokers", numBrokers));
    }

    public static Version version(String value) {
        return ConstraintUtils.mkAnnotation(Version.class, Map.of(VALUE, value));
    }

    public static BrokerConfig brokerConfig(String name, String value) {
        return ConstraintUtils.mkAnnotation(BrokerConfig.class, Map.of("name", name, VALUE, value));
    }

    public static BrokerConfig.List brokerConfigs(Map<String, String> configs) {
        return ConstraintUtils.mkAnnotation(BrokerConfig.List.class, Map.of(VALUE, configs.entrySet().stream().map(entry -> ConstraintUtils.mkAnnotation(BrokerConfig.class, Map.of("name", entry.getKey(), VALUE, entry.getValue()))).toArray(BrokerConfig[]::new)));
    }

    public static ClusterId clusterId(String clusterId) {
        return ConstraintUtils.mkAnnotation(ClusterId.class, Map.of(VALUE, clusterId));
    }

    public static KRaftCluster kraftCluster(int numControllers) {
        return ConstraintUtils.mkAnnotation(KRaftCluster.class, Map.of("numControllers", numControllers));
    }

    public static ZooKeeperCluster zooKeeperCluster() {
        return ConstraintUtils.mkAnnotation(ZooKeeperCluster.class, Map.of());
    }

    public static SaslPlainAuth saslPlainAuth(String user, String password) {
        return ConstraintUtils.mkAnnotation(SaslPlainAuth.class, Map.of("user", user, "password", password));
    }

    public static SaslPlainAuth.List saslPlainAuth(Map<String, String> users) {
        return ConstraintUtils.mkAnnotation(SaslPlainAuth.List.class, Map.of(VALUE, users.entrySet().stream().map(e -> ConstraintUtils.saslPlainAuth((String)e.getKey(), (String)e.getValue())).toArray(SaslPlainAuth[]::new)));
    }

    public static SaslMechanism saslMechanism(String saslMechanism) {
        return ConstraintUtils.saslMechanism(saslMechanism, Map.of());
    }

    public static SaslMechanism saslMechanism(String saslMechanism, Map<String, String> userPasswordPairs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (saslMechanism != null) {
            params.put(VALUE, saslMechanism);
        }
        if (userPasswordPairs != null && !userPasswordPairs.isEmpty()) {
            SaslMechanism.Principal[] principals = (SaslMechanism.Principal[])userPasswordPairs.entrySet().stream().map(e -> ConstraintUtils.mkAnnotation(SaslMechanism.Principal.class, Map.of("user", e.getKey(), "password", e.getValue()))).toArray(SaslMechanism.Principal[]::new);
            params.put("principals", principals);
        }
        return ConstraintUtils.mkAnnotation(SaslMechanism.class, params);
    }

    public static Tls tls() {
        return ConstraintUtils.mkAnnotation(Tls.class, Map.of());
    }

    private static <A extends Annotation> A mkAnnotation(Class<A> annoType, Map<String, Object> members) {
        Objects.requireNonNull(members);
        for (String member : members.keySet()) {
            try {
                annoType.getDeclaredMethod(member, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Annotation %s does not have an element %s".formatted(annoType.getName(), member));
            }
        }
        Map<String, Object> defaults = Arrays.stream(annoType.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getDefaultValue())).collect(Collectors.toMap(Method::getName, Method::getDefaultValue));
        HashMap<String, Object> annotationValues = new HashMap<String, Object>(defaults);
        annotationValues.putAll(members);
        return (A)((Annotation)Proxy.newProxyInstance(annoType.getClassLoader(), new Class[]{annoType}, new AnnotationProxyInvocationHandler<A>(annoType, annotationValues)));
    }

    private static class AnnotationProxyInvocationHandler<A extends Annotation>
    implements InvocationHandler {
        private final Class<A> annoType;
        private final Map<String, Object> members;

        public AnnotationProxyInvocationHandler(Class<A> annoType, Map<String, Object> members) {
            this.annoType = annoType;
            this.members = members;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            switch (method.getName()) {
                case "annotationType": {
                    return this.annoType;
                }
                case "toString": {
                    return this.annoType.getSimpleName() + this.members.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ", "(", ")"));
                }
                case "hashCode": {
                    return this.members.hashCode();
                }
                case "equals": {
                    InvocationHandler otherInvocation;
                    Object other = args[0];
                    if (Proxy.isProxyClass(other.getClass()) && (otherInvocation = Proxy.getInvocationHandler(other)) instanceof AnnotationProxyInvocationHandler) {
                        return this.members.equals(((AnnotationProxyInvocationHandler)otherInvocation).members);
                    }
                    return false;
                }
            }
            return this.members.get(method.getName());
        }
    }
}

