/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.testing.kafka.common.BrokerCluster;
import io.kroxylicious.testing.kafka.common.BrokerConfig;
import io.kroxylicious.testing.kafka.common.ClusterId;
import io.kroxylicious.testing.kafka.common.KRaftCluster;
import io.kroxylicious.testing.kafka.common.KafkaClusterExecutionMode;
import io.kroxylicious.testing.kafka.common.KeytoolCertificateGenerator;
import io.kroxylicious.testing.kafka.common.SaslMechanism;
import io.kroxylicious.testing.kafka.common.SaslPlainAuth;
import io.kroxylicious.testing.kafka.common.Tls;
import io.kroxylicious.testing.kafka.common.Version;
import io.kroxylicious.testing.kafka.common.ZooKeeperCluster;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;
import org.apache.kafka.common.utils.AppInfoParser;
import org.junit.jupiter.api.TestInfo;

public class KafkaClusterConfig {
    private static final System.Logger LOGGER = System.getLogger(KafkaClusterConfig.class.getName());
    private static final String ONE_CONFIG = Integer.toString(1);
    private static final AtomicBoolean DEPRECATED_SASL_PLAIN_AUTH_USE_REPORTED = new AtomicBoolean();
    private static final String BROKER_ROLE = "broker";
    private static final String CONTROLLER_ROLE = "controller";
    private static final String CONTROLLER_LISTENER_NAME = "CONTROLLER";
    private static final String EXTERNAL_LISTENER_NAME = "EXTERNAL";
    private static final String INTERNAL_LISTENER_NAME = "INTERNAL";
    private static final String ANON_LISTENER_NAME = "ANON";
    private static final String SCRAM_SHA_SASL_MECHANISM_PREFIX = "SCRAM-SHA-";
    private static final String PLAIN_SASL_MECHANISM_NAME = "PLAIN";
    private static final String OAUTHBEARER_SASL_MECHANISM_NAME = "OAUTHBEARER";
    private static final String SCRAM_256_SASL_MECHANISM_NAME = "SCRAM-SHA-256";
    private static final String SCRAM_512_SASL_MECHANISM_NAME = "SCRAM-SHA-512";
    private TestInfo testInfo;
    private KeytoolCertificateGenerator brokerKeytoolCertificateGenerator;
    private KeytoolCertificateGenerator clientKeytoolCertificateGenerator;
    private final KafkaClusterExecutionMode execMode;
    private final Boolean kraftMode;
    @NonNull
    private String kafkaVersion;
    private final String saslMechanism;
    @Nullable
    private String loginModule;
    private final String securityProtocol;
    private Integer brokersNum;
    private Integer kraftControllers;
    private String kafkaKraftClusterId;
    private final Map<String, String> users;
    private final Map<String, String> jaasServerOptions;
    private final Map<String, String> jaasClientOptions;
    private final Map<String, String> brokerConfigs;
    private static final Set<Class<? extends Annotation>> SUPPORTED_CONSTRAINTS = Set.of(ClusterId.class, BrokerCluster.class, BrokerConfig.class, BrokerConfig.List.class, KRaftCluster.class, Tls.class, SaslMechanism.class, SaslPlainAuth.class, SaslPlainAuth.List.class, ZooKeeperCluster.class, Version.class);

    public static boolean supportsConstraint(Class<? extends Annotation> annotation) {
        return SUPPORTED_CONSTRAINTS.contains(annotation);
    }

    public static KafkaClusterConfig fromConstraints(List<Annotation> annotations, TestInfo testInfo) {
        KafkaClusterConfigBuilder builder = KafkaClusterConfig.builder();
        builder.testInfo(testInfo);
        builder.brokersNum(1);
        boolean tls = false;
        boolean useSasl = false;
        Optional<Map<Object, Object>> saslUsers = Optional.empty();
        Optional<Map<Object, Object>> deprecatedSaslUsers = Optional.empty();
        for (Annotation annotation : annotations) {
            block18: {
                block17: {
                    if (annotation instanceof BrokerCluster) {
                        BrokerCluster brokerCluster = (BrokerCluster)annotation;
                        builder.brokersNum(brokerCluster.numBrokers());
                        continue;
                    }
                    if (annotation instanceof KRaftCluster) {
                        KRaftCluster kRaftCluster = (KRaftCluster)annotation;
                        builder.kraftMode(true);
                        builder.kraftControllers(kRaftCluster.numControllers());
                        continue;
                    }
                    if (annotation instanceof ZooKeeperCluster) {
                        builder.kraftMode(false);
                        continue;
                    }
                    if (annotation instanceof Tls) {
                        tls = true;
                        KafkaClusterConfig.processTls(builder::brokerKeytoolCertificateGenerator);
                        continue;
                    }
                    if (annotation instanceof ClusterId) {
                        ClusterId clusterId = (ClusterId)annotation;
                        builder.kafkaKraftClusterId(clusterId.value());
                        continue;
                    }
                    if (annotation instanceof Version) {
                        Version version = (Version)annotation;
                        builder.kafkaVersion(version.value());
                        continue;
                    }
                    if (annotation instanceof SaslMechanism) {
                        SaslMechanism mechanism = (SaslMechanism)annotation;
                        useSasl = true;
                        builder.saslMechanism(mechanism.value());
                        SaslMechanism.Principal[] principals = Optional.ofNullable(mechanism.principals()).orElse(new SaslMechanism.Principal[0]);
                        saslUsers = Optional.of(Arrays.stream(principals).collect(Collectors.toMap(SaslMechanism.Principal::user, SaslMechanism.Principal::password)));
                        continue;
                    }
                    if (annotation instanceof SaslPlainAuth || annotation instanceof SaslPlainAuth.List) {
                        deprecatedSaslUsers = KafkaClusterConfig.processDeprecatedSaslUserAnnotations(annotation);
                        continue;
                    }
                    if (annotation instanceof BrokerConfig) break block17;
                    if (!(annotation instanceof BrokerConfig.List)) break block18;
                }
                KafkaClusterConfig.processBrokerConfigs(annotation, builder::brokerConfig);
                continue;
            }
            throw new IllegalArgumentException("unexpected constraint annotation " + annotation.getClass());
        }
        if (deprecatedSaslUsers.isPresent()) {
            if (!DEPRECATED_SASL_PLAIN_AUTH_USE_REPORTED.compareAndExchange(false, true)) {
                LOGGER.log(System.Logger.Level.WARNING, "Use of deprecated SaslPlainAuth annotation, use SaslUser instead.");
            }
            if (useSasl) {
                throw new IllegalArgumentException("Cannot use deprecated SaslPlainAuth with SaslMechanism.");
            }
            builder.saslMechanism(PLAIN_SASL_MECHANISM_NAME);
            deprecatedSaslUsers.ifPresent(builder::users);
            useSasl = true;
        } else if (saslUsers.isPresent()) {
            saslUsers.ifPresent(builder::users);
        }
        builder.securityProtocol(KafkaClusterConfig.determineSecurityProtocol(useSasl, tls));
        return builder.build();
    }

    private static void processTls(Consumer<KeytoolCertificateGenerator> consumer) {
        try {
            consumer.accept(new KeytoolCertificateGenerator());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create broker certificate", e);
        }
    }

    private static Optional<Map<String, String>> processDeprecatedSaslUserAnnotations(Annotation annotation) {
        if (annotation instanceof SaslPlainAuth.List) {
            SaslPlainAuth.List saslPlainAuthList = (SaslPlainAuth.List)annotation;
            return Optional.of(Arrays.stream(saslPlainAuthList.value()).collect(Collectors.toMap(SaslPlainAuth::user, SaslPlainAuth::password)));
        }
        if (annotation instanceof SaslPlainAuth) {
            SaslPlainAuth saslPlainAuth = (SaslPlainAuth)annotation;
            return Optional.of(Map.of(saslPlainAuth.user(), saslPlainAuth.password()));
        }
        return Optional.empty();
    }

    private static void processBrokerConfigs(Annotation annotation, BiConsumer<String, String> consumer) {
        if (annotation instanceof BrokerConfig.List) {
            BrokerConfig.List brokerConfigList = (BrokerConfig.List)annotation;
            for (BrokerConfig config : brokerConfigList.value()) {
                consumer.accept(config.name(), config.value());
            }
        } else if (annotation instanceof BrokerConfig) {
            BrokerConfig brokerConfig = (BrokerConfig)annotation;
            consumer.accept(brokerConfig.name(), brokerConfig.value());
        }
    }

    private static String determineSecurityProtocol(boolean useSasl, boolean tls) {
        return (useSasl ? "SASL_" : "") + (tls ? "SSL" : "PLAINTEXT");
    }

    public Stream<ConfigHolder> getBrokerConfigs(Supplier<KafkaEndpoints> endPointConfigSupplier) {
        ArrayList<ConfigHolder> properties = new ArrayList<ConfigHolder>();
        KafkaEndpoints kafkaEndpoints = endPointConfigSupplier.get();
        int nodeCount = Math.max(this.brokersNum, this.kraftControllers);
        for (int brokerNum = 0; brokerNum < nodeCount; ++brokerNum) {
            ConfigHolder brokerConfigHolder = this.generateConfigForSpecificNode(kafkaEndpoints, brokerNum);
            properties.add(brokerConfigHolder);
        }
        return properties.stream();
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    public ConfigHolder generateConfigForSpecificNode(KafkaEndpoints kafkaEndpoints, int nodeId) {
        String role = this.determineRole(nodeId);
        Properties nodeConfiguration = new Properties();
        nodeConfiguration.putAll(this.brokerConfigs);
        KafkaClusterConfig.putConfig(nodeConfiguration, "broker.id", Integer.toString(nodeId));
        TreeMap<String, String> protocolMap = new TreeMap<String, String>();
        TreeMap<String, String> listeners = new TreeMap<String, String>();
        TreeMap<String, String> advertisedListeners = new TreeMap<String, String>();
        TreeSet<String> earlyStart = new TreeSet<String>();
        ConfigHolder configHolder = role.contains(BROKER_ROLE) ? this.configureBroker(kafkaEndpoints, nodeId, protocolMap, listeners, advertisedListeners, earlyStart, nodeConfiguration) : this.configureController(kafkaEndpoints, nodeId, nodeConfiguration);
        if (this.isKraftMode()) {
            this.configureKraftNode(kafkaEndpoints, nodeId, nodeConfiguration, protocolMap, listeners, earlyStart, role);
        } else {
            KafkaClusterConfig.configureLegacyNode(kafkaEndpoints, nodeConfiguration);
        }
        KafkaClusterConfig.putConfig(nodeConfiguration, "listener.security.protocol.map", protocolMap.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
        KafkaClusterConfig.putConfig(nodeConfiguration, "listeners", listeners.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
        KafkaClusterConfig.putConfig(nodeConfiguration, "early.start.listeners", earlyStart.stream().map(Object::toString).collect(Collectors.joining(",")));
        this.configureSasl(nodeConfiguration);
        KafkaClusterConfig.putConfig(nodeConfiguration, "offsets.topic.replication.factor", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "offsets.topic.num.partitions", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "transaction.state.log.replication.factor", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "transaction.state.log.min.isr", ONE_CONFIG);
        KafkaClusterConfig.putConfig(nodeConfiguration, "group.initial.rebalance.delay.ms", Integer.toString(0));
        KafkaClusterConfig.putConfig(nodeConfiguration, "metrics.jmx.exclude", ".*");
        return configHolder;
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private ConfigHolder configureController(KafkaEndpoints kafkaEndpoints, int nodeId, Properties nodeConfiguration) {
        return new ConfigHolder(nodeConfiguration, null, null, null, nodeId, this.kafkaKraftClusterId);
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private ConfigHolder configureBroker(KafkaEndpoints kafkaEndpoints, int nodeId, TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, TreeMap<String, String> advertisedListeners, TreeSet<String> earlyStart, Properties nodeConfiguration) {
        KafkaEndpoints.EndpointPair interBrokerEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.INTERNAL, nodeId);
        KafkaEndpoints.EndpointPair clientEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.EXTERNAL, nodeId);
        KafkaEndpoints.EndpointPair anonEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.ANON, nodeId);
        String externalListenerTransport = this.securityProtocol == null ? SecurityProtocol.PLAINTEXT.name() : this.securityProtocol;
        KafkaClusterConfig.configureExternalListener(protocolMap, externalListenerTransport, listeners, clientEndpoint, advertisedListeners);
        KafkaClusterConfig.configureInternalListener(protocolMap, listeners, interBrokerEndpoint, advertisedListeners, earlyStart, nodeConfiguration);
        KafkaClusterConfig.configureAnonListener(protocolMap, listeners, anonEndpoint, advertisedListeners);
        this.configureTls(clientEndpoint, nodeConfiguration);
        KafkaClusterConfig.putConfig(nodeConfiguration, "advertised.listeners", advertisedListeners.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")));
        ConfigHolder configHolder = new ConfigHolder(nodeConfiguration, clientEndpoint.getConnect().getPort(), anonEndpoint.getConnect().getPort(), clientEndpoint.connectAddress(), nodeId, this.kafkaKraftClusterId);
        return configHolder;
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private String determineRole(int nodeId) {
        ArrayList<String> roles = new ArrayList<String>();
        if (nodeId < this.brokersNum || this.isAdditionalNode(nodeId)) {
            roles.add(BROKER_ROLE);
        }
        if (nodeId < this.kraftControllers) {
            roles.add(CONTROLLER_ROLE);
        }
        return String.join((CharSequence)",", roles);
    }

    private boolean isAdditionalNode(int nodeId) {
        return nodeId >= Math.max(this.brokersNum, this.kraftControllers);
    }

    private void configureTls(KafkaEndpoints.EndpointPair clientEndpoint, Properties server) {
        if (this.securityProtocol != null && this.securityProtocol.contains("SSL")) {
            if (this.brokerKeytoolCertificateGenerator == null) {
                throw new RuntimeException("brokerKeytoolCertificateGenerator needs to be initialized when calling KafkaClusterConfig");
            }
            try {
                this.brokerKeytoolCertificateGenerator.generateSelfSignedCertificateEntry("test@kroxylicious.io", clientEndpoint.getConnect().getHost(), "Dev", "Kroxylicious.io", null, null, "US");
                if (this.clientKeytoolCertificateGenerator != null && Path.of(this.clientKeytoolCertificateGenerator.getCertFilePath(), new String[0]).toFile().exists()) {
                    if (this.securityProtocol.equals(SecurityProtocol.SASL_SSL.toString())) {
                        server.put("listener.name.%s.%s".formatted(EXTERNAL_LISTENER_NAME.toLowerCase(Locale.ROOT), "ssl.client.auth"), "required");
                    } else {
                        server.put("ssl.client.auth", "required");
                    }
                    this.brokerKeytoolCertificateGenerator.generateTrustStore(this.clientKeytoolCertificateGenerator.getCertFilePath(), clientEndpoint.getConnect().getHost());
                    server.put("ssl.truststore.location", this.brokerKeytoolCertificateGenerator.getTrustStoreLocation());
                    server.put("ssl.truststore.password", this.brokerKeytoolCertificateGenerator.getPassword());
                    server.put("ssl.truststore.type", this.brokerKeytoolCertificateGenerator.getTrustStoreType());
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            server.put("ssl.keystore.location", this.brokerKeytoolCertificateGenerator.getKeyStoreLocation());
            server.put("ssl.keystore.password", this.brokerKeytoolCertificateGenerator.getPassword());
            server.put("ssl.key.password", this.brokerKeytoolCertificateGenerator.getPassword());
            server.put("ssl.keystore.type", this.brokerKeytoolCertificateGenerator.getKeyStoreType());
        }
    }

    private void configureSasl(Properties server) {
        if (this.saslMechanism != null) {
            KafkaClusterConfig.putConfig(server, "sasl.enabled.mechanisms", this.saslMechanism);
            String lm = Optional.ofNullable(this.loginModule).orElse(this.deriveLoginModuleFromSasl(this.saslMechanism));
            Stream serverOptions = Optional.ofNullable(this.jaasServerOptions).orElse(Map.of()).entrySet().stream();
            Stream<Object> userOptions = Stream.empty();
            if (this.isSaslPlain()) {
                userOptions = Optional.ofNullable(this.users).orElse(Map.of()).entrySet().stream().collect(Collectors.toMap(e -> String.format("user_%s", e.getKey()), Map.Entry::getValue)).entrySet().stream();
            }
            String moduleOptions = Stream.concat(serverOptions, userOptions).map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(" "));
            String moduleConfig = String.format("%s required %s;", lm, moduleOptions);
            String configKey = String.format("listener.name.%s.%s.sasl.jaas.config", EXTERNAL_LISTENER_NAME.toLowerCase(Locale.ROOT), this.saslMechanism.toLowerCase(Locale.ROOT));
            KafkaClusterConfig.putConfig(server, configKey, moduleConfig);
        }
    }

    private String deriveLoginModuleFromSasl(String saslMechanism) {
        switch (saslMechanism.toUpperCase(Locale.ROOT)) {
            case "PLAIN": {
                return PlainLoginModule.class.getName();
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-512": {
                return ScramLoginModule.class.getName();
            }
            case "OAUTHBEARER": {
                return OAuthBearerLoginModule.class.getName();
            }
        }
        throw new IllegalArgumentException("Cannot derive login module from saslMechanism %s".formatted(saslMechanism));
    }

    private static void configureInternalListener(TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, KafkaEndpoints.EndpointPair interBrokerEndpoint, TreeMap<String, String> advertisedListeners, TreeSet<String> earlyStart, Properties server) {
        protocolMap.put(INTERNAL_LISTENER_NAME, SecurityProtocol.PLAINTEXT.name());
        listeners.put(INTERNAL_LISTENER_NAME, interBrokerEndpoint.listenAddress());
        advertisedListeners.put(INTERNAL_LISTENER_NAME, interBrokerEndpoint.advertisedAddress());
        earlyStart.add(INTERNAL_LISTENER_NAME);
        KafkaClusterConfig.putConfig(server, "inter.broker.listener.name", INTERNAL_LISTENER_NAME);
    }

    private static void configureAnonListener(TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, KafkaEndpoints.EndpointPair anonEndpoint, TreeMap<String, String> advertisedListeners) {
        protocolMap.put(ANON_LISTENER_NAME, SecurityProtocol.PLAINTEXT.name());
        listeners.put(ANON_LISTENER_NAME, anonEndpoint.listenAddress());
        advertisedListeners.put(ANON_LISTENER_NAME, anonEndpoint.advertisedAddress());
    }

    private static void configureExternalListener(TreeMap<String, String> protocolMap, String externalListenerTransport, TreeMap<String, String> listeners, KafkaEndpoints.EndpointPair clientEndpoint, TreeMap<String, String> advertisedListeners) {
        protocolMap.put(EXTERNAL_LISTENER_NAME, externalListenerTransport);
        listeners.put(EXTERNAL_LISTENER_NAME, clientEndpoint.listenAddress());
        advertisedListeners.put(EXTERNAL_LISTENER_NAME, clientEndpoint.advertisedAddress());
    }

    private static void configureLegacyNode(KafkaEndpoints kafkaEndpoints, Properties server) {
        KafkaClusterConfig.putConfig(server, "zookeeper.connect", kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.CONTROLLER, 0).connectAddress());
        KafkaClusterConfig.putConfig(server, "zookeeper.sasl.enabled", "false");
        KafkaClusterConfig.putConfig(server, "zookeeper.connection.timeout.ms", Long.toString(60000L));
        KafkaClusterConfig.putConfig(server, "zookeeper.session.timeout.ms", Long.toString(6000L));
    }

    private void configureKraftNode(KafkaEndpoints kafkaEndpoints, int nodeId, Properties nodeConfiguration, TreeMap<String, String> protocolMap, TreeMap<String, String> listeners, TreeSet<String> earlyStart, String role) {
        KafkaClusterConfig.putConfig(nodeConfiguration, "node.id", Integer.toString(nodeId));
        String quorumVoters = IntStream.range(0, this.kraftControllers).mapToObj(controllerId -> String.format("%d@%s", controllerId, kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.CONTROLLER, controllerId).connectAddress())).collect(Collectors.joining(","));
        KafkaClusterConfig.putConfig(nodeConfiguration, "controller.quorum.voters", quorumVoters);
        KafkaClusterConfig.putConfig(nodeConfiguration, "controller.listener.names", CONTROLLER_LISTENER_NAME);
        protocolMap.put(CONTROLLER_LISTENER_NAME, SecurityProtocol.PLAINTEXT.name());
        KafkaClusterConfig.putConfig(nodeConfiguration, "process.roles", role);
        if (role.contains(CONTROLLER_ROLE)) {
            KafkaEndpoints.EndpointPair controllerEndpoint = kafkaEndpoints.getEndpointPair(KafkaEndpoints.Listener.CONTROLLER, nodeId);
            String bindAddress = controllerEndpoint.getBind().toString();
            listeners.put(CONTROLLER_LISTENER_NAME, bindAddress);
            earlyStart.add(CONTROLLER_LISTENER_NAME);
        }
    }

    private static void putConfig(Properties server, String key, String value) {
        Object orig = server.put(key, value);
        if (orig != null) {
            throw new RuntimeException("Cannot override broker config '" + key + "=" + value + "' with new value " + orig);
        }
    }

    public Map<String, Object> getAnonConnectConfigForCluster(String bootstrapServers) {
        return this.getConnectConfigForCluster(bootstrapServers, null, null, null, null);
    }

    public Map<String, Object> getConnectConfigForCluster(String bootstrapServers) {
        if (this.saslMechanism != null) {
            Map<String, String> externalUsers = this.getUsers();
            if (!externalUsers.isEmpty()) {
                Map.Entry<String, String> first = externalUsers.entrySet().iterator().next();
                return this.getConnectConfigForCluster(bootstrapServers, first.getKey(), first.getValue(), this.getSecurityProtocol(), this.getSaslMechanism());
            }
            return this.getConnectConfigForCluster(bootstrapServers, null, null, this.getSecurityProtocol(), this.getSaslMechanism());
        }
        return this.getConnectConfigForCluster(bootstrapServers, null, null, this.getSecurityProtocol(), this.getSaslMechanism());
    }

    public Map<String, Object> getConnectConfigForCluster(String bootstrapServers, String user, String password) {
        return this.getConnectConfigForCluster(bootstrapServers, user, password, this.getSecurityProtocol(), this.getSaslMechanism());
    }

    public Map<String, Object> getConnectConfigForCluster(String bootstrapServers, String user, String password, String securityProtocol, String saslMechanism) {
        HashMap<String, Object> kafkaConfig = new HashMap<String, Object>();
        if (securityProtocol != null) {
            kafkaConfig.put("security.protocol", securityProtocol);
            if (securityProtocol.contains("SSL")) {
                this.buildSecurityProtocolConfig(kafkaConfig);
            }
        }
        if (saslMechanism != null) {
            this.buildSaslConnectConfig(kafkaConfig, user, password, securityProtocol, saslMechanism);
        }
        kafkaConfig.put("bootstrap.servers", bootstrapServers);
        return kafkaConfig;
    }

    private void buildSecurityProtocolConfig(Map<String, Object> kafkaConfig) {
        String clientTrustStorePassword;
        String clientTrustStoreFilePath;
        if (this.clientKeytoolCertificateGenerator != null) {
            if (Path.of(this.clientKeytoolCertificateGenerator.getKeyStoreLocation(), new String[0]).toFile().exists()) {
                kafkaConfig.put("ssl.keystore.location", this.clientKeytoolCertificateGenerator.getKeyStoreLocation());
                kafkaConfig.put("ssl.keystore.password", this.clientKeytoolCertificateGenerator.getPassword());
                kafkaConfig.put("ssl.key.password", this.clientKeytoolCertificateGenerator.getPassword());
            }
            try {
                this.clientKeytoolCertificateGenerator.generateTrustStore(this.brokerKeytoolCertificateGenerator.getCertFilePath(), "client");
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            clientTrustStoreFilePath = this.clientKeytoolCertificateGenerator.getTrustStoreLocation();
            clientTrustStorePassword = this.clientKeytoolCertificateGenerator.getPassword();
        } else {
            Path clientTrustStore;
            try {
                Path certsDirectory = Files.createTempDirectory("kafkaClient", new FileAttribute[0]);
                clientTrustStore = Paths.get(certsDirectory.toAbsolutePath().toString(), "kafka.truststore.jks");
                certsDirectory.toFile().deleteOnExit();
                clientTrustStore.toFile().deleteOnExit();
                this.brokerKeytoolCertificateGenerator.generateTrustStore(this.brokerKeytoolCertificateGenerator.getCertFilePath(), "client", clientTrustStore.toAbsolutePath().toString());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            clientTrustStoreFilePath = clientTrustStore.toAbsolutePath().toString();
            clientTrustStorePassword = this.brokerKeytoolCertificateGenerator.getPassword();
        }
        kafkaConfig.put("ssl.truststore.location", clientTrustStoreFilePath);
        kafkaConfig.put("ssl.truststore.password", clientTrustStorePassword);
    }

    private void buildSaslConnectConfig(Map<String, Object> kafkaConfig, String user, String password, String securityProtocol, String saslMechanism) {
        kafkaConfig.put("sasl.mechanism", saslMechanism);
        String lm = Optional.ofNullable(this.loginModule).orElse(this.deriveLoginModuleFromSasl(saslMechanism));
        if (securityProtocol == null) {
            kafkaConfig.put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name());
        }
        HashMap<String, String> jaasOptions = new HashMap<String, String>(this.jaasClientOptions == null ? Map.of() : this.jaasClientOptions);
        if (this.isSaslPlain() || this.isSaslScram()) {
            this.applyCredential(jaasOptions, "username", user);
            this.applyCredential(jaasOptions, "password", password);
        }
        String moduleOptions = jaasOptions.entrySet().stream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(" "));
        kafkaConfig.put("sasl.jaas.config", String.format("%s required %s;", lm, moduleOptions));
    }

    private void applyCredential(HashMap<String, String> jaasOptions, String credentialKey, String credentialValue) {
        jaasOptions.computeIfAbsent(credentialKey, k -> credentialValue);
        if (!jaasOptions.containsKey(credentialKey)) {
            LOGGER.log(System.Logger.Level.WARNING, "No {} value specified for SASL authentication", credentialKey);
        }
    }

    private boolean isSaslPlain() {
        return this.saslMechanism != null && this.saslMechanism.toUpperCase(Locale.ROOT).equals(PLAIN_SASL_MECHANISM_NAME);
    }

    public boolean isSaslScram() {
        return this.saslMechanism != null && this.saslMechanism.toUpperCase(Locale.ROOT).startsWith(SCRAM_SHA_SASL_MECHANISM_PREFIX);
    }

    public boolean isKraftMode() {
        return this.getKraftMode() == null || this.getKraftMode() != false;
    }

    public String clusterId() {
        return this.isKraftMode() ? this.kafkaKraftClusterId : null;
    }

    private static String detectKafkaVersionFromClasspath() {
        String version = AppInfoParser.getVersion();
        String appInfoParserUnknown = "unknown";
        return version == null || version.equals(appInfoParserUnknown) ? "latest" : version;
    }

    @Generated
    private static String $default$kafkaVersion() {
        return KafkaClusterConfig.detectKafkaVersionFromClasspath();
    }

    @Generated
    private static Integer $default$brokersNum() {
        return 1;
    }

    @Generated
    private static Integer $default$kraftControllers() {
        return 1;
    }

    @Generated
    private static String $default$kafkaKraftClusterId() {
        return Uuid.randomUuid().toString();
    }

    @Generated
    KafkaClusterConfig(TestInfo testInfo, KeytoolCertificateGenerator brokerKeytoolCertificateGenerator, KeytoolCertificateGenerator clientKeytoolCertificateGenerator, KafkaClusterExecutionMode execMode, Boolean kraftMode, @NonNull String kafkaVersion, String saslMechanism, @Nullable String loginModule, String securityProtocol, Integer brokersNum, Integer kraftControllers, String kafkaKraftClusterId, Map<String, String> users, Map<String, String> jaasServerOptions, Map<String, String> jaasClientOptions, Map<String, String> brokerConfigs) {
        if (kafkaVersion == null) {
            throw new NullPointerException("kafkaVersion is marked non-null but is null");
        }
        this.testInfo = testInfo;
        this.brokerKeytoolCertificateGenerator = brokerKeytoolCertificateGenerator;
        this.clientKeytoolCertificateGenerator = clientKeytoolCertificateGenerator;
        this.execMode = execMode;
        this.kraftMode = kraftMode;
        this.kafkaVersion = kafkaVersion;
        this.saslMechanism = saslMechanism;
        this.loginModule = loginModule;
        this.securityProtocol = securityProtocol;
        this.brokersNum = brokersNum;
        this.kraftControllers = kraftControllers;
        this.kafkaKraftClusterId = kafkaKraftClusterId;
        this.users = users;
        this.jaasServerOptions = jaasServerOptions;
        this.jaasClientOptions = jaasClientOptions;
        this.brokerConfigs = brokerConfigs;
    }

    @Generated
    public static KafkaClusterConfigBuilder builder() {
        return new KafkaClusterConfigBuilder();
    }

    @Generated
    public KafkaClusterConfigBuilder toBuilder() {
        KafkaClusterConfigBuilder builder = new KafkaClusterConfigBuilder().testInfo(this.testInfo).brokerKeytoolCertificateGenerator(this.brokerKeytoolCertificateGenerator).clientKeytoolCertificateGenerator(this.clientKeytoolCertificateGenerator).execMode(this.execMode).kraftMode(this.kraftMode).kafkaVersion(this.kafkaVersion).saslMechanism(this.saslMechanism).loginModule(this.loginModule).securityProtocol(this.securityProtocol).brokersNum(this.brokersNum).kraftControllers(this.kraftControllers).kafkaKraftClusterId(this.kafkaKraftClusterId);
        if (this.users != null) {
            builder.users(this.users);
        }
        if (this.jaasServerOptions != null) {
            builder.jaasServerOptions(this.jaasServerOptions);
        }
        if (this.jaasClientOptions != null) {
            builder.jaasClientOptions(this.jaasClientOptions);
        }
        if (this.brokerConfigs != null) {
            builder.brokerConfigs(this.brokerConfigs);
        }
        return builder;
    }

    @Generated
    public TestInfo getTestInfo() {
        return this.testInfo;
    }

    @Generated
    public KeytoolCertificateGenerator getBrokerKeytoolCertificateGenerator() {
        return this.brokerKeytoolCertificateGenerator;
    }

    @Generated
    public KeytoolCertificateGenerator getClientKeytoolCertificateGenerator() {
        return this.clientKeytoolCertificateGenerator;
    }

    @Generated
    public KafkaClusterExecutionMode getExecMode() {
        return this.execMode;
    }

    @Generated
    public Boolean getKraftMode() {
        return this.kraftMode;
    }

    @NonNull
    @Generated
    public String getKafkaVersion() {
        return this.kafkaVersion;
    }

    @Generated
    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    @Nullable
    @Generated
    public String getLoginModule() {
        return this.loginModule;
    }

    @Generated
    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    @Generated
    public Integer getBrokersNum() {
        return this.brokersNum;
    }

    @Generated
    public Integer getKraftControllers() {
        return this.kraftControllers;
    }

    @Generated
    public String getKafkaKraftClusterId() {
        return this.kafkaKraftClusterId;
    }

    @Generated
    public Map<String, String> getUsers() {
        return this.users;
    }

    @Generated
    public Map<String, String> getJaasServerOptions() {
        return this.jaasServerOptions;
    }

    @Generated
    public Map<String, String> getJaasClientOptions() {
        return this.jaasClientOptions;
    }

    @Generated
    public Map<String, String> getBrokerConfigs() {
        return this.brokerConfigs;
    }

    @Generated
    public String toString() {
        return "KafkaClusterConfig(testInfo=" + this.getTestInfo() + ", brokerKeytoolCertificateGenerator=" + this.getBrokerKeytoolCertificateGenerator() + ", clientKeytoolCertificateGenerator=" + this.getClientKeytoolCertificateGenerator() + ", execMode=" + this.getExecMode() + ", kraftMode=" + this.getKraftMode() + ", kafkaVersion=" + this.getKafkaVersion() + ", saslMechanism=" + this.getSaslMechanism() + ", loginModule=" + this.getLoginModule() + ", securityProtocol=" + this.getSecurityProtocol() + ", brokersNum=" + this.getBrokersNum() + ", kraftControllers=" + this.getKraftControllers() + ", kafkaKraftClusterId=" + this.getKafkaKraftClusterId() + ", users=" + this.getUsers() + ", jaasServerOptions=" + this.getJaasServerOptions() + ", jaasClientOptions=" + this.getJaasClientOptions() + ", brokerConfigs=" + this.getBrokerConfigs() + ")";
    }

    @Generated
    public static class KafkaClusterConfigBuilder {
        @Generated
        private TestInfo testInfo;
        @Generated
        private KeytoolCertificateGenerator brokerKeytoolCertificateGenerator;
        @Generated
        private KeytoolCertificateGenerator clientKeytoolCertificateGenerator;
        @Generated
        private KafkaClusterExecutionMode execMode;
        @Generated
        private Boolean kraftMode;
        @Generated
        private boolean kafkaVersion$set;
        @Generated
        private String kafkaVersion$value;
        @Generated
        private String saslMechanism;
        @Generated
        private String loginModule;
        @Generated
        private String securityProtocol;
        @Generated
        private boolean brokersNum$set;
        @Generated
        private Integer brokersNum$value;
        @Generated
        private boolean kraftControllers$set;
        @Generated
        private Integer kraftControllers$value;
        @Generated
        private boolean kafkaKraftClusterId$set;
        @Generated
        private String kafkaKraftClusterId$value;
        @Generated
        private ArrayList<String> users$key;
        @Generated
        private ArrayList<String> users$value;
        @Generated
        private ArrayList<String> jaasServerOptions$key;
        @Generated
        private ArrayList<String> jaasServerOptions$value;
        @Generated
        private ArrayList<String> jaasClientOptions$key;
        @Generated
        private ArrayList<String> jaasClientOptions$value;
        @Generated
        private ArrayList<String> brokerConfigs$key;
        @Generated
        private ArrayList<String> brokerConfigs$value;

        @Generated
        KafkaClusterConfigBuilder() {
        }

        @Generated
        public KafkaClusterConfigBuilder testInfo(TestInfo testInfo) {
            this.testInfo = testInfo;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder brokerKeytoolCertificateGenerator(KeytoolCertificateGenerator brokerKeytoolCertificateGenerator) {
            this.brokerKeytoolCertificateGenerator = brokerKeytoolCertificateGenerator;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder clientKeytoolCertificateGenerator(KeytoolCertificateGenerator clientKeytoolCertificateGenerator) {
            this.clientKeytoolCertificateGenerator = clientKeytoolCertificateGenerator;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder execMode(KafkaClusterExecutionMode execMode) {
            this.execMode = execMode;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder kraftMode(Boolean kraftMode) {
            this.kraftMode = kraftMode;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder kafkaVersion(@NonNull String kafkaVersion) {
            if (kafkaVersion == null) {
                throw new NullPointerException("kafkaVersion is marked non-null but is null");
            }
            this.kafkaVersion$value = kafkaVersion;
            this.kafkaVersion$set = true;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder saslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder loginModule(@Nullable String loginModule) {
            this.loginModule = loginModule;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder brokersNum(Integer brokersNum) {
            this.brokersNum$value = brokersNum;
            this.brokersNum$set = true;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder kraftControllers(Integer kraftControllers) {
            this.kraftControllers$value = kraftControllers;
            this.kraftControllers$set = true;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder kafkaKraftClusterId(String kafkaKraftClusterId) {
            this.kafkaKraftClusterId$value = kafkaKraftClusterId;
            this.kafkaKraftClusterId$set = true;
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder user(String userKey, String userValue) {
            if (this.users$key == null) {
                this.users$key = new ArrayList();
                this.users$value = new ArrayList();
            }
            this.users$key.add(userKey);
            this.users$value.add(userValue);
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder users(Map<? extends String, ? extends String> users) {
            if (users == null) {
                throw new NullPointerException("users cannot be null");
            }
            if (this.users$key == null) {
                this.users$key = new ArrayList();
                this.users$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : users.entrySet()) {
                this.users$key.add($lombokEntry.getKey());
                this.users$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder clearUsers() {
            if (this.users$key != null) {
                this.users$key.clear();
                this.users$value.clear();
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder jaasServerOption(String jaasServerOptionKey, String jaasServerOptionValue) {
            if (this.jaasServerOptions$key == null) {
                this.jaasServerOptions$key = new ArrayList();
                this.jaasServerOptions$value = new ArrayList();
            }
            this.jaasServerOptions$key.add(jaasServerOptionKey);
            this.jaasServerOptions$value.add(jaasServerOptionValue);
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder jaasServerOptions(Map<? extends String, ? extends String> jaasServerOptions) {
            if (jaasServerOptions == null) {
                throw new NullPointerException("jaasServerOptions cannot be null");
            }
            if (this.jaasServerOptions$key == null) {
                this.jaasServerOptions$key = new ArrayList();
                this.jaasServerOptions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : jaasServerOptions.entrySet()) {
                this.jaasServerOptions$key.add($lombokEntry.getKey());
                this.jaasServerOptions$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder clearJaasServerOptions() {
            if (this.jaasServerOptions$key != null) {
                this.jaasServerOptions$key.clear();
                this.jaasServerOptions$value.clear();
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder jaasClientOption(String jaasClientOptionKey, String jaasClientOptionValue) {
            if (this.jaasClientOptions$key == null) {
                this.jaasClientOptions$key = new ArrayList();
                this.jaasClientOptions$value = new ArrayList();
            }
            this.jaasClientOptions$key.add(jaasClientOptionKey);
            this.jaasClientOptions$value.add(jaasClientOptionValue);
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder jaasClientOptions(Map<? extends String, ? extends String> jaasClientOptions) {
            if (jaasClientOptions == null) {
                throw new NullPointerException("jaasClientOptions cannot be null");
            }
            if (this.jaasClientOptions$key == null) {
                this.jaasClientOptions$key = new ArrayList();
                this.jaasClientOptions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : jaasClientOptions.entrySet()) {
                this.jaasClientOptions$key.add($lombokEntry.getKey());
                this.jaasClientOptions$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder clearJaasClientOptions() {
            if (this.jaasClientOptions$key != null) {
                this.jaasClientOptions$key.clear();
                this.jaasClientOptions$value.clear();
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder brokerConfig(String brokerConfigKey, String brokerConfigValue) {
            if (this.brokerConfigs$key == null) {
                this.brokerConfigs$key = new ArrayList();
                this.brokerConfigs$value = new ArrayList();
            }
            this.brokerConfigs$key.add(brokerConfigKey);
            this.brokerConfigs$value.add(brokerConfigValue);
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder brokerConfigs(Map<? extends String, ? extends String> brokerConfigs) {
            if (brokerConfigs == null) {
                throw new NullPointerException("brokerConfigs cannot be null");
            }
            if (this.brokerConfigs$key == null) {
                this.brokerConfigs$key = new ArrayList();
                this.brokerConfigs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : brokerConfigs.entrySet()) {
                this.brokerConfigs$key.add($lombokEntry.getKey());
                this.brokerConfigs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public KafkaClusterConfigBuilder clearBrokerConfigs() {
            if (this.brokerConfigs$key != null) {
                this.brokerConfigs$key.clear();
                this.brokerConfigs$value.clear();
            }
            return this;
        }

        @Generated
        public KafkaClusterConfig build() {
            Map<Object, Object> brokerConfigs;
            Map<Object, Object> jaasClientOptions;
            Map<Object, Object> jaasServerOptions;
            Map<Object, Object> users;
            switch (this.users$key == null ? 0 : this.users$key.size()) {
                case 0: {
                    users = Collections.emptyMap();
                    break;
                }
                case 1: {
                    users = Collections.singletonMap(this.users$key.get(0), this.users$value.get(0));
                    break;
                }
                default: {
                    users = new LinkedHashMap(this.users$key.size() < 0x40000000 ? 1 + this.users$key.size() + (this.users$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.users$key.size(); ++$i) {
                        users.put(this.users$key.get($i), this.users$value.get($i));
                    }
                    users = Collections.unmodifiableMap(users);
                }
            }
            switch (this.jaasServerOptions$key == null ? 0 : this.jaasServerOptions$key.size()) {
                case 0: {
                    jaasServerOptions = Collections.emptyMap();
                    break;
                }
                case 1: {
                    jaasServerOptions = Collections.singletonMap(this.jaasServerOptions$key.get(0), this.jaasServerOptions$value.get(0));
                    break;
                }
                default: {
                    jaasServerOptions = new LinkedHashMap(this.jaasServerOptions$key.size() < 0x40000000 ? 1 + this.jaasServerOptions$key.size() + (this.jaasServerOptions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.jaasServerOptions$key.size(); ++$i) {
                        jaasServerOptions.put(this.jaasServerOptions$key.get($i), this.jaasServerOptions$value.get($i));
                    }
                    jaasServerOptions = Collections.unmodifiableMap(jaasServerOptions);
                }
            }
            switch (this.jaasClientOptions$key == null ? 0 : this.jaasClientOptions$key.size()) {
                case 0: {
                    jaasClientOptions = Collections.emptyMap();
                    break;
                }
                case 1: {
                    jaasClientOptions = Collections.singletonMap(this.jaasClientOptions$key.get(0), this.jaasClientOptions$value.get(0));
                    break;
                }
                default: {
                    jaasClientOptions = new LinkedHashMap(this.jaasClientOptions$key.size() < 0x40000000 ? 1 + this.jaasClientOptions$key.size() + (this.jaasClientOptions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.jaasClientOptions$key.size(); ++$i) {
                        jaasClientOptions.put(this.jaasClientOptions$key.get($i), this.jaasClientOptions$value.get($i));
                    }
                    jaasClientOptions = Collections.unmodifiableMap(jaasClientOptions);
                }
            }
            switch (this.brokerConfigs$key == null ? 0 : this.brokerConfigs$key.size()) {
                case 0: {
                    brokerConfigs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    brokerConfigs = Collections.singletonMap(this.brokerConfigs$key.get(0), this.brokerConfigs$value.get(0));
                    break;
                }
                default: {
                    brokerConfigs = new LinkedHashMap(this.brokerConfigs$key.size() < 0x40000000 ? 1 + this.brokerConfigs$key.size() + (this.brokerConfigs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.brokerConfigs$key.size(); ++$i) {
                        brokerConfigs.put(this.brokerConfigs$key.get($i), this.brokerConfigs$value.get($i));
                    }
                    brokerConfigs = Collections.unmodifiableMap(brokerConfigs);
                }
            }
            String kafkaVersion$value = this.kafkaVersion$value;
            if (!this.kafkaVersion$set) {
                kafkaVersion$value = KafkaClusterConfig.$default$kafkaVersion();
            }
            Integer brokersNum$value = this.brokersNum$value;
            if (!this.brokersNum$set) {
                brokersNum$value = KafkaClusterConfig.$default$brokersNum();
            }
            Integer kraftControllers$value = this.kraftControllers$value;
            if (!this.kraftControllers$set) {
                kraftControllers$value = KafkaClusterConfig.$default$kraftControllers();
            }
            String kafkaKraftClusterId$value = this.kafkaKraftClusterId$value;
            if (!this.kafkaKraftClusterId$set) {
                kafkaKraftClusterId$value = KafkaClusterConfig.$default$kafkaKraftClusterId();
            }
            return new KafkaClusterConfig(this.testInfo, this.brokerKeytoolCertificateGenerator, this.clientKeytoolCertificateGenerator, this.execMode, this.kraftMode, kafkaVersion$value, this.saslMechanism, this.loginModule, this.securityProtocol, brokersNum$value, kraftControllers$value, kafkaKraftClusterId$value, users, jaasServerOptions, jaasClientOptions, brokerConfigs);
        }

        @Generated
        public String toString() {
            return "KafkaClusterConfig.KafkaClusterConfigBuilder(testInfo=" + this.testInfo + ", brokerKeytoolCertificateGenerator=" + this.brokerKeytoolCertificateGenerator + ", clientKeytoolCertificateGenerator=" + this.clientKeytoolCertificateGenerator + ", execMode=" + this.execMode + ", kraftMode=" + this.kraftMode + ", kafkaVersion$value=" + this.kafkaVersion$value + ", saslMechanism=" + this.saslMechanism + ", loginModule=" + this.loginModule + ", securityProtocol=" + this.securityProtocol + ", brokersNum$value=" + this.brokersNum$value + ", kraftControllers$value=" + this.kraftControllers$value + ", kafkaKraftClusterId$value=" + this.kafkaKraftClusterId$value + ", users$key=" + this.users$key + ", users$value=" + this.users$value + ", jaasServerOptions$key=" + this.jaasServerOptions$key + ", jaasServerOptions$value=" + this.jaasServerOptions$value + ", jaasClientOptions$key=" + this.jaasClientOptions$key + ", jaasClientOptions$value=" + this.jaasClientOptions$value + ", brokerConfigs$key=" + this.brokerConfigs$key + ", brokerConfigs$value=" + this.brokerConfigs$value + ")";
        }
    }

    public static interface KafkaEndpoints {
        public EndpointPair getEndpointPair(Listener var1, int var2);

        public static class Endpoint {
            private final String host;
            private final int port;

            public Endpoint(String host, int port) {
                this.host = host;
                this.port = port;
            }

            public String toString() {
                return String.format("//%s:%d", this.host, this.port);
            }

            @Generated
            public static EndpointBuilder builder() {
                return new EndpointBuilder();
            }

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public static class EndpointBuilder {
                @Generated
                private String host;
                @Generated
                private int port;

                @Generated
                EndpointBuilder() {
                }

                @Generated
                public EndpointBuilder host(String host) {
                    this.host = host;
                    return this;
                }

                @Generated
                public EndpointBuilder port(int port) {
                    this.port = port;
                    return this;
                }

                @Generated
                public Endpoint build() {
                    return new Endpoint(this.host, this.port);
                }

                @Generated
                public String toString() {
                    return "KafkaClusterConfig.KafkaEndpoints.Endpoint.EndpointBuilder(host=" + this.host + ", port=" + this.port + ")";
                }
            }
        }

        public static class EndpointPair {
            private final Endpoint bind;
            private final Endpoint connect;

            public EndpointPair(Endpoint bind, Endpoint connect) {
                this.bind = bind;
                this.connect = connect;
            }

            public String connectAddress() {
                return String.format("%s:%d", this.connect.host, this.connect.port);
            }

            public String listenAddress() {
                return String.format("//%s:%d", this.bind.host, this.bind.port);
            }

            public String advertisedAddress() {
                return String.format("//%s:%d", this.connect.host, this.connect.port);
            }

            @Generated
            public static EndpointPairBuilder builder() {
                return new EndpointPairBuilder();
            }

            @Generated
            public Endpoint getBind() {
                return this.bind;
            }

            @Generated
            public Endpoint getConnect() {
                return this.connect;
            }

            @Generated
            public static class EndpointPairBuilder {
                @Generated
                private Endpoint bind;
                @Generated
                private Endpoint connect;

                @Generated
                EndpointPairBuilder() {
                }

                @Generated
                public EndpointPairBuilder bind(Endpoint bind) {
                    this.bind = bind;
                    return this;
                }

                @Generated
                public EndpointPairBuilder connect(Endpoint connect) {
                    this.connect = connect;
                    return this;
                }

                @Generated
                public EndpointPair build() {
                    return new EndpointPair(this.bind, this.connect);
                }

                @Generated
                public String toString() {
                    return "KafkaClusterConfig.KafkaEndpoints.EndpointPair.EndpointPairBuilder(bind=" + this.bind + ", connect=" + this.connect + ")";
                }
            }
        }

        public static enum Listener {
            EXTERNAL,
            ANON,
            INTERNAL,
            CONTROLLER;

        }
    }

    public static class ConfigHolder {
        private final Properties properties;
        private final Integer externalPort;
        private final Integer anonPort;
        private final String endpoint;
        private final int brokerNum;
        private final String kafkaKraftClusterId;

        public ConfigHolder(Properties properties, Integer externalPort, Integer anonPort, String endpoint, int brokerNum, String kafkaKraftClusterId) {
            this.properties = properties;
            this.externalPort = externalPort;
            this.anonPort = anonPort;
            this.endpoint = endpoint;
            this.brokerNum = brokerNum;
            this.kafkaKraftClusterId = kafkaKraftClusterId;
        }

        private String getRoles() {
            return this.properties.getProperty("process.roles", KafkaClusterConfig.BROKER_ROLE);
        }

        public boolean isBroker() {
            return this.getRoles().contains(KafkaClusterConfig.BROKER_ROLE);
        }

        public boolean isController() {
            return this.getRoles().contains(KafkaClusterConfig.CONTROLLER_ROLE);
        }

        @Generated
        public static ConfigHolderBuilder builder() {
            return new ConfigHolderBuilder();
        }

        @Generated
        public Properties getProperties() {
            return this.properties;
        }

        @Generated
        public Integer getExternalPort() {
            return this.externalPort;
        }

        @Generated
        public Integer getAnonPort() {
            return this.anonPort;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public int getBrokerNum() {
            return this.brokerNum;
        }

        @Generated
        public String getKafkaKraftClusterId() {
            return this.kafkaKraftClusterId;
        }

        @Generated
        public static class ConfigHolderBuilder {
            @Generated
            private Properties properties;
            @Generated
            private Integer externalPort;
            @Generated
            private Integer anonPort;
            @Generated
            private String endpoint;
            @Generated
            private int brokerNum;
            @Generated
            private String kafkaKraftClusterId;

            @Generated
            ConfigHolderBuilder() {
            }

            @Generated
            public ConfigHolderBuilder properties(Properties properties) {
                this.properties = properties;
                return this;
            }

            @Generated
            public ConfigHolderBuilder externalPort(Integer externalPort) {
                this.externalPort = externalPort;
                return this;
            }

            @Generated
            public ConfigHolderBuilder anonPort(Integer anonPort) {
                this.anonPort = anonPort;
                return this;
            }

            @Generated
            public ConfigHolderBuilder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            @Generated
            public ConfigHolderBuilder brokerNum(int brokerNum) {
                this.brokerNum = brokerNum;
                return this;
            }

            @Generated
            public ConfigHolderBuilder kafkaKraftClusterId(String kafkaKraftClusterId) {
                this.kafkaKraftClusterId = kafkaKraftClusterId;
                return this;
            }

            @Generated
            public ConfigHolder build() {
                return new ConfigHolder(this.properties, this.externalPort, this.anonPort, this.endpoint, this.brokerNum, this.kafkaKraftClusterId);
            }

            @Generated
            public String toString() {
                return "KafkaClusterConfig.ConfigHolder.ConfigHolderBuilder(properties=" + this.properties + ", externalPort=" + this.externalPort + ", anonPort=" + this.anonPort + ", endpoint=" + this.endpoint + ", brokerNum=" + this.brokerNum + ", kafkaKraftClusterId=" + this.kafkaKraftClusterId + ")";
            }
        }
    }
}

