/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Requires ability to write test key material to file-system.")
public class KeytoolCertificateGenerator {
    private static final String PKCS12_KEYSTORE_TYPE = "PKCS12";
    private String password;
    private final Path certFilePath;
    private final Path keyStoreFilePath;
    private final Path trustStoreFilePath;
    private final System.Logger log = System.getLogger(KeytoolCertificateGenerator.class.getName());

    public KeytoolCertificateGenerator() throws IOException {
        this(null, null);
    }

    public KeytoolCertificateGenerator(String certFilePath, String trustStorePath) throws IOException {
        Path certsDirectory = Files.createTempDirectory("kproxy", new FileAttribute[0]);
        this.certFilePath = Path.of(certsDirectory.toAbsolutePath() + "/cert-file", new String[0]);
        this.keyStoreFilePath = certFilePath != null ? Path.of(certFilePath, new String[0]) : Paths.get(certsDirectory.toAbsolutePath().toString(), "kafka.keystore.jks");
        this.trustStoreFilePath = trustStorePath != null ? Path.of(trustStorePath, new String[0]) : Paths.get(certsDirectory.toAbsolutePath().toString(), "kafka.truststore.jks");
        certsDirectory.toFile().deleteOnExit();
        if (certFilePath == null) {
            this.keyStoreFilePath.toFile().deleteOnExit();
        }
        if (trustStorePath == null) {
            this.trustStoreFilePath.toFile().deleteOnExit();
        }
        this.certFilePath.toFile().deleteOnExit();
    }

    public String getCertFilePath() {
        return this.certFilePath.toAbsolutePath().toString();
    }

    public String getKeyStoreLocation() {
        return this.keyStoreFilePath.toAbsolutePath().toString();
    }

    public String getTrustStoreLocation() {
        return this.trustStoreFilePath.toAbsolutePath().toString();
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = UUID.randomUUID().toString().replace("-", "");
        }
        return this.password;
    }

    public boolean canGenerateWildcardSAN() {
        return Runtime.version().feature() >= 17;
    }

    public void generateTrustStore(String certFilePath, String alias) throws GeneralSecurityException, IOException {
        this.generateTrustStore(certFilePath, alias, this.getTrustStoreLocation());
    }

    public void generateTrustStore(String certFilePath, String alias, String trustStoreFilePath) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        if (Path.of(trustStoreFilePath, new String[0]).toFile().exists() && (keyStore = KeyStore.getInstance(new File(trustStoreFilePath), this.getPassword().toCharArray())).containsAlias(alias)) {
            keyStore.deleteEntry(alias);
            keyStore.store(new FileOutputStream(trustStoreFilePath), this.getPassword().toCharArray());
        }
        ArrayList<String> commandParameters = new ArrayList<String>(List.of("keytool", "-import", "-trustcacerts"));
        commandParameters.addAll(List.of("-keystore", trustStoreFilePath));
        commandParameters.addAll(List.of("-storepass", this.getPassword()));
        commandParameters.add("-noprompt");
        commandParameters.addAll(List.of("-alias", alias));
        commandParameters.addAll(List.of("-file", certFilePath));
        this.runCommand(commandParameters);
    }

    public void generateSelfSignedCertificateEntry(String email, String domain, String organizationUnit, String organization, String city, String state, String country) throws GeneralSecurityException, IOException {
        if (this.keyStoreFilePath.toFile().exists()) {
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreFilePath.toFile(), this.getPassword().toCharArray());
            keyStore.load(new FileInputStream(this.keyStoreFilePath.toFile()), this.getPassword().toCharArray());
            if (keyStore.containsAlias(domain)) {
                keyStore.deleteEntry(domain);
                keyStore.store(new FileOutputStream(this.keyStoreFilePath.toFile()), this.getPassword().toCharArray());
            }
        }
        ArrayList<String> commandParameters = new ArrayList<String>(List.of("keytool", "-genkey"));
        commandParameters.addAll(List.of("-alias", domain));
        commandParameters.addAll(List.of("-keyalg", "RSA"));
        commandParameters.addAll(List.of("-keysize", "2048"));
        commandParameters.addAll(List.of("-sigalg", "SHA256withRSA"));
        commandParameters.addAll(List.of("-storetype", PKCS12_KEYSTORE_TYPE));
        commandParameters.addAll(List.of("-keystore", this.getKeyStoreLocation()));
        commandParameters.addAll(List.of("-storepass", this.getPassword()));
        commandParameters.addAll(List.of("-keypass", this.getPassword()));
        commandParameters.addAll(List.of("-dname", this.getDomainName(email, domain, organizationUnit, organization, city, state, country)));
        commandParameters.addAll(List.of("-validity", "365"));
        if (this.canGenerateWildcardSAN() && !this.isWildcardDomain(domain)) {
            commandParameters.addAll(this.getSAN(domain));
        }
        this.runCommand(commandParameters);
        this.createCrtFileToImport(domain);
    }

    private void createCrtFileToImport(String alias) throws IOException {
        ArrayList<String> commandParameters = new ArrayList<String>(List.of("keytool", "-export", "-rfc"));
        commandParameters.addAll(List.of("-keystore", this.getKeyStoreLocation()));
        commandParameters.addAll(List.of("-storepass", this.getPassword()));
        commandParameters.addAll(List.of("-storetype", this.getKeyStoreType()));
        commandParameters.addAll(List.of("-alias", alias));
        commandParameters.addAll(List.of("-file", this.certFilePath.toAbsolutePath().toString()));
        this.runCommand(commandParameters);
    }

    private void runCommand(List<String> commandParameters) throws IOException {
        ProcessBuilder keytool = new ProcessBuilder(new String[0]).command(commandParameters);
        Process process = keytool.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Keytool execution error");
        }
        this.log.log(System.Logger.Level.DEBUG, "Generating certificate using `keytool` using command: {0}, parameters: {1}", process.info(), commandParameters);
        if (process.exitValue() > 0) {
            String processError = new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().collect(Collectors.joining(" \\ "));
            String processOutput = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining(" \\ "));
            this.log.log(System.Logger.Level.WARNING, "Error generating certificate, error output: {0}, normal output: {1}, commandline parameters: {2}", processError, processOutput, commandParameters);
            throw new IOException("Keytool execution error: '" + processError + "', output: '" + processOutput + "', commandline parameters: " + commandParameters);
        }
    }

    private boolean isWildcardDomain(String domain) {
        return domain.startsWith("*.");
    }

    private String getDomainName(String email, String domain, String organizationUnit, String organization, String city, String state, String country) {
        return "CN=" + domain + ", OU=" + organizationUnit + ", O=" + organization + ", L=" + city + ", ST=" + state + ", C=" + country + ", EMAILADDRESS=" + email;
    }

    private List<String> getSAN(String domain) {
        return List.of("-ext", "SAN=dns:" + domain);
    }

    public String getTrustStoreType() {
        return PKCS12_KEYSTORE_TYPE;
    }

    public String getKeyStoreType() {
        return PKCS12_KEYSTORE_TYPE;
    }
}

