/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.common;

import io.kroxylicious.testing.kafka.common.KafkaClusterConfig;
import io.kroxylicious.testing.kafka.common.ListeningSocketPreallocator;
import java.io.Closeable;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PortAllocator {
    private final Map<KafkaClusterConfig.KafkaEndpoints.Listener, Map<Integer, ServerSocket>> ports = new HashMap<KafkaClusterConfig.KafkaEndpoints.Listener, Map<Integer, ServerSocket>>();

    public synchronized int getPort(KafkaClusterConfig.KafkaEndpoints.Listener listener, int nodeId) {
        if (!this.hasRegisteredPort(listener, nodeId)) {
            throw new IllegalArgumentException("listener " + listener + " does not have a port for node " + nodeId + ".");
        }
        return this.ports.get((Object)listener).get(nodeId).getLocalPort();
    }

    public synchronized boolean hasRegisteredPort(KafkaClusterConfig.KafkaEndpoints.Listener listener, int nodeId) {
        Map<Integer, ServerSocket> portsMap = this.ports.get((Object)listener);
        return portsMap != null && portsMap.containsKey(nodeId);
    }

    public PortAllocationSession allocationSession() {
        return new PortAllocationSession();
    }

    public synchronized void deallocate(int nodeId) {
        for (Map<Integer, ServerSocket> value : this.ports.values()) {
            value.remove(nodeId);
        }
    }

    private synchronized void allocate(Set<KafkaClusterConfig.KafkaEndpoints.Listener> listeners, int firstBrokerIdInclusive, int lastBrokerIdExclusive, ListeningSocketPreallocator preallocator) {
        if (lastBrokerIdExclusive <= firstBrokerIdInclusive) {
            throw new IllegalArgumentException("attempted to allocate ports to an invalid range of broker ids: [" + firstBrokerIdInclusive + "," + lastBrokerIdExclusive + ")");
        }
        int toAllocate = lastBrokerIdExclusive - firstBrokerIdInclusive;
        for (KafkaClusterConfig.KafkaEndpoints.Listener listener : listeners) {
            List<ServerSocket> sockets = preallocator.preAllocateListeningSockets(toAllocate);
            Map listenerPorts = this.ports.computeIfAbsent(listener, listener1 -> new HashMap());
            for (int i = 0; i < toAllocate; ++i) {
                listenerPorts.put(firstBrokerIdInclusive + i, sockets.get(i));
            }
        }
    }

    public class PortAllocationSession
    implements Closeable {
        ListeningSocketPreallocator preallocator = new ListeningSocketPreallocator();

        private PortAllocationSession() {
        }

        public void allocate(Set<KafkaClusterConfig.KafkaEndpoints.Listener> listeners, int firstNodeIdInclusive, int lastNodeIdExclusive) {
            PortAllocator.this.allocate(listeners, firstNodeIdInclusive, lastNodeIdExclusive, this.preallocator);
        }

        public void allocate(Set<KafkaClusterConfig.KafkaEndpoints.Listener> listeners, int nodeId) {
            PortAllocator.this.allocate(listeners, nodeId, nodeId + 1, this.preallocator);
        }

        @Override
        public void close() {
            this.preallocator.close();
        }
    }
}

