/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.invm;

import io.kroxylicious.testing.kafka.invm.InVMKafkaCluster;
import io.kroxylicious.testing.kafka.invm.LoggingPrintStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.collection.immutable.Seq;

final class KraftLogDirUtil {
    private static final PrintStream LOGGING_PRINT_STREAM = LoggingPrintStream.loggingPrintStream(InVMKafkaCluster.LOGGER, System.Logger.Level.DEBUG);
    private static final String FORMAT_METHOD_NAME = "formatCommand";
    private static final boolean IGNORE_FORMATTED = true;

    private KraftLogDirUtil() {
        throw new IllegalStateException();
    }

    static void prepareLogDirsForKraft(String clusterId, KafkaConfig config, List<UserScramCredentialRecord> scramCredentialRecords) {
        Seq directories = StorageTool.configToLogDirectories((KafkaConfig)config);
        try {
            MetadataVersion metadataVersion = MetadataVersion.fromVersionString((String)(config.interBrokerProtocolVersionString() == null ? MetadataVersion.LATEST_PRODUCTION.version() : config.interBrokerProtocolVersionString()));
            Object metaProperties = KraftLogDirUtil.buildMetadataPropertiesReflectively(clusterId, config);
            BootstrapMetadata bootstrapMetadata = KraftLogDirUtil.buildBootstrapMetadata(scramCredentialRecords, metadataVersion);
            KraftLogDirUtil.formatReflectively(metaProperties, (Seq<String>)directories, bootstrapMetadata, metadataVersion);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to prepare log dirs for KRaft", e);
        }
    }

    private static void formatReflectively(Object metaProperties, Seq<String> directories, BootstrapMetadata bootstrapMetadata, MetadataVersion metadataVersion) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method formatMethod = StorageTool.class.getDeclaredMethod(FORMAT_METHOD_NAME, PrintStream.class, Seq.class, metaProperties.getClass(), BootstrapMetadata.class, MetadataVersion.class, Boolean.TYPE);
            formatMethod.invoke(null, LOGGING_PRINT_STREAM, directories, metaProperties, bootstrapMetadata, metadataVersion, true);
        }
        catch (NoSuchMethodException e) {
            Method formatMethod = StorageTool.class.getDeclaredMethod(FORMAT_METHOD_NAME, PrintStream.class, Seq.class, metaProperties.getClass(), MetadataVersion.class, Boolean.TYPE);
            formatMethod.invoke(null, LOGGING_PRINT_STREAM, directories, metaProperties, metadataVersion, true);
        }
    }

    private static BootstrapMetadata buildBootstrapMetadata(List<UserScramCredentialRecord> scramCredentialRecords, MetadataVersion metadataVersion) {
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(KraftLogDirUtil.metadataVersionMessage(metadataVersion));
        for (UserScramCredentialRecord credentialRecord : scramCredentialRecords) {
            metadataRecords.add(KraftLogDirUtil.scramMessage(credentialRecord));
        }
        return BootstrapMetadata.fromRecords(metadataRecords, (String)"invm-kafka");
    }

    private static Object buildMetadataPropertiesReflectively(String clusterId, KafkaConfig config) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method buildMetadataProperties = StorageTool.class.getDeclaredMethod("buildMetadataProperties", String.class, KafkaConfig.class);
        return buildMetadataProperties.invoke(null, clusterId, config);
    }

    private static ApiMessageAndVersion withVersion(ApiMessage message) {
        return new ApiMessageAndVersion(message, 0);
    }

    private static ApiMessageAndVersion metadataVersionMessage(MetadataVersion metadataVersion) {
        return KraftLogDirUtil.withVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()));
    }

    private static ApiMessageAndVersion scramMessage(UserScramCredentialRecord scramRecord) {
        return KraftLogDirUtil.withVersion((ApiMessage)scramRecord);
    }
}

