/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.testing.kafka.invm;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import kafka.tools.StorageTool;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import scala.collection.mutable.Buffer;
import scala.jdk.javaapi.CollectionConverters;

final class ScramUtils {
    private ScramUtils() {
        throw new IllegalStateException();
    }

    static ScramCredential asScramCredential(UserScramCredentialRecord uscr) {
        return new ScramCredential(uscr.salt(), uscr.storedKey(), uscr.serverKey(), uscr.iterations());
    }

    @NonNull
    static List<UserScramCredentialRecord> getScramCredentialRecords(String saslMechanism, Map<String, String> users) {
        ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)saslMechanism);
        if (scramMechanism == null) {
            throw new IllegalArgumentException("unexpected scram mechanism " + saslMechanism);
        }
        List<String> addScram = users.entrySet().stream().map(e -> scramMechanism.mechanismName() + "=" + ScramUtils.toKafkaScramCredentialsFormat((String)e.getKey(), (String)e.getValue())).toList();
        Namespace n = new Namespace(Map.of("add_scram", addScram));
        return CollectionConverters.asJava((Buffer)((Buffer)StorageTool.getUserScramCredentialRecords((Namespace)n).get()));
    }

    @NonNull
    private static String toKafkaScramCredentialsFormat(String username, String password) {
        return "[name=%s,password=%s]".formatted(username, password);
    }
}

