(function(root, factory) {
  if (typeof define === 'function' && define.amd) 
    define(['exports', 'kotlin', 'ktor-ktor-client-core-jsLegacy', 'ktor-ktor-utils-jsLegacy', 'ktor-ktor-http-jsLegacy', 'ktor-ktor-io-jsLegacy'], factory);
  else if (typeof exports === 'object') 
    factory(module.exports, require('kotlin'), require('ktor-ktor-client-core-jsLegacy'), require('ktor-ktor-utils-jsLegacy'), require('ktor-ktor-http-jsLegacy'), require('ktor-ktor-io-jsLegacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-auth-jsLegacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'ktor-ktor-client-auth-jsLegacy'.");
    }
    if (typeof this['ktor-ktor-client-core-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-auth-jsLegacy'. Its dependency 'ktor-ktor-client-core-jsLegacy' was not found. Please, check whether 'ktor-ktor-client-core-jsLegacy' is loaded prior to 'ktor-ktor-client-auth-jsLegacy'.");
    }
    if (typeof this['ktor-ktor-utils-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-auth-jsLegacy'. Its dependency 'ktor-ktor-utils-jsLegacy' was not found. Please, check whether 'ktor-ktor-utils-jsLegacy' is loaded prior to 'ktor-ktor-client-auth-jsLegacy'.");
    }
    if (typeof this['ktor-ktor-http-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-auth-jsLegacy'. Its dependency 'ktor-ktor-http-jsLegacy' was not found. Please, check whether 'ktor-ktor-http-jsLegacy' is loaded prior to 'ktor-ktor-client-auth-jsLegacy'.");
    }
    if (typeof this['ktor-ktor-io-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-auth-jsLegacy'. Its dependency 'ktor-ktor-io-jsLegacy' was not found. Please, check whether 'ktor-ktor-io-jsLegacy' is loaded prior to 'ktor-ktor-client-auth-jsLegacy'.");
    }
    if (false) {

    }
    root['ktor-ktor-client-auth-jsLegacy'] = factory(typeof this['ktor-ktor-client-auth-jsLegacy'] === 'undefined' ? {} : this['ktor-ktor-client-auth-jsLegacy'], kotlin, this['ktor-ktor-client-core-jsLegacy'], this['ktor-ktor-utils-jsLegacy'], this['ktor-ktor-http-jsLegacy'], this['ktor-ktor-io-jsLegacy']);
  }
}(this, function(_, Kotlin, $module$ktor_ktor_client_core_jsLegacy, $module$ktor_ktor_utils_jsLegacy, $module$ktor_ktor_http_jsLegacy, $module$ktor_ktor_io_jsLegacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var HttpRequestPipeline = $module$ktor_ktor_client_core_jsLegacy.io.ktor.client.request.HttpRequestPipeline;
  var Unit = Kotlin.kotlin.Unit;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var AttributeKey = $module$ktor_ktor_utils_jsLegacy.io.ktor.util.AttributeKey;
  var HttpSend = $module$ktor_ktor_client_core_jsLegacy.io.ktor.client.features.HttpSend;
  var feature = $module$ktor_ktor_client_core_jsLegacy.io.ktor.client.features.feature_ccg70z$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var HttpStatusCode = $module$ktor_ktor_http_jsLegacy.io.ktor.http.HttpStatusCode;
  var HashSet_init = Kotlin.kotlin.collections.HashSet_init_mqih57$;
  var http = $module$ktor_ktor_http_jsLegacy.io.ktor.http;
  var parseAuthorizationHeader = $module$ktor_ktor_http_jsLegacy.io.ktor.http.auth.parseAuthorizationHeader_61zpoe$;
  var HttpRequestBuilder = $module$ktor_ktor_client_core_jsLegacy.io.ktor.client.request.HttpRequestBuilder;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var HttpClientFeature = $module$ktor_ktor_client_core_jsLegacy.io.ktor.client.features.HttpClientFeature;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var throwUPAE = Kotlin.throwUPAE;
  var auth = $module$ktor_ktor_http_jsLegacy.io.ktor.http.auth;
  var equals = Kotlin.equals;
  var HttpAuthHeader$Parameterized = $module$ktor_ktor_http_jsLegacy.io.ktor.http.auth.HttpAuthHeader.Parameterized;
  var encodeBase64 = $module$ktor_ktor_utils_jsLegacy.io.ktor.util.encodeBase64_964n91$;
  var charsets = $module$ktor_ktor_io_jsLegacy.io.ktor.utils.io.charsets;
  var encodeToByteArray = $module$ktor_ktor_io_jsLegacy.io.ktor.utils.io.charsets.encodeToByteArray_fj4osb$;
  var URLBuilder = $module$ktor_ktor_http_jsLegacy.io.ktor.http.URLBuilder;
  var takeFrom = $module$ktor_ktor_http_jsLegacy.io.ktor.http.takeFrom_rs9g2p$;
  var toString = Kotlin.toString;
  var hex = $module$ktor_ktor_utils_jsLegacy.io.ktor.util.hex_fqrh44$;
  var get_fullPath = $module$ktor_ktor_http_jsLegacy.io.ktor.http.get_fullPath_5y8s0c$;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var HttpAuthHeader$HttpAuthHeader$Parameterized_init = $module$ktor_ktor_http_jsLegacy.io.ktor.http.auth.HttpAuthHeader.Parameterized_init_9j85vu$;
  var headers = $module$ktor_ktor_client_core_jsLegacy.io.ktor.client.request.headers_nc42ot$;
  var Digest = $module$ktor_ktor_utils_jsLegacy.io.ktor.util.Digest_61zpoe$;
  var build = $module$ktor_ktor_utils_jsLegacy.io.ktor.util.build_1mpr19$;

  var generateNonce = $module$ktor_ktor_utils_jsLegacy.io.ktor.util.generateNonce;

  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  function Auth(providers) {
    Auth$Feature_getInstance();
    if (providers === void 0) {
      providers = ArrayList_init();
    }
    this.providers = providers;
    this.alwaysSend_lz59ob$_0 = lazy(Auth$alwaysSend$lambda(this));
  }
  Object.defineProperty(Auth.prototype, 'alwaysSend_0', {
  configurable: true, 
  get: function() {
  return this.alwaysSend_lz59ob$_0.value;
}});
  function Auth$Feature() {
    Auth$Feature_instance = this;
    this.key_6bts5$_0 = new AttributeKey('DigestAuth');
  }
  Object.defineProperty(Auth$Feature.prototype, 'key', {
  configurable: true, 
  get: function() {
  return this.key_6bts5$_0;
}});
  Auth$Feature.prototype.prepare_oh3mgy$$default = function(block) {
  var $receiver = new Auth();
  block($receiver);
  return $receiver;
};
  function Coroutine$Auth$Feature$install$lambda(closure$feature_0, $receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$feature = closure$feature_0;
    this.local$tmp$ = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$Auth$Feature$install$lambda.$metadata$ = {
  kind: Kotlin.Kind.CLASS, 
  simpleName: null, 
  interfaces: [CoroutineImpl]};
  Coroutine$Auth$Feature$install$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Auth$Feature$install$lambda.prototype.constructor = Coroutine$Auth$Feature$install$lambda;
  Coroutine$Auth$Feature$install$lambda.prototype.doResume = function() {
  do try {
    switch (this.state_0) {
      case 0:
        this.local$tmp$ = this.local$closure$feature.alwaysSend_0.iterator();
        this.state_0 = 2;
        continue;
      case 1:
        throw this.exception_0;
      case 2:
        if (!this.local$tmp$.hasNext()) {
          this.state_0 = 4;
          continue;
        }
        var provider = this.local$tmp$.next();
        this.state_0 = 3;
        this.result_0 = provider.addRequestHeaders_s9rlw$(this.local$$receiver.context, this);
        if (this.result_0 === COROUTINE_SUSPENDED) 
          return COROUTINE_SUSPENDED;
        continue;
      case 3:
        this.state_0 = 2;
        continue;
      case 4:
        return Unit;
      default:
        this.state_0 = 1;
        throw new Error('State Machine Unreachable execution');
    }
  }  catch (e) {
  if (this.state_0 === 1) {
    this.exceptionState_0 = this.state_0;
    throw e;
  } else {
    this.state_0 = this.exceptionState_0;
    this.exception_0 = e;
  }
} while (true);
};
  function Auth$Feature$install$lambda(closure$feature_0) {
    return function($receiver_0, it_0, continuation_0, suspended) {
  var instance = new Coroutine$Auth$Feature$install$lambda(closure$feature_0, $receiver_0, it_0, this, continuation_0);
  if (suspended) 
    return instance;
  else 
    return instance.doResume(null);
};
  }
  function Coroutine$Auth$Feature$install$lambda_0(closure$circuitBreaker_0, closure$feature_0, $receiver_0, origin_0, context_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$circuitBreaker = closure$circuitBreaker_0;
    this.local$closure$feature = closure$feature_0;
    this.local$tmp$_1 = void 0;
    this.local$tmp$_2 = void 0;
    this.local$tmp$_3 = void 0;
    this.local$call = void 0;
    this.local$candidateProviders = void 0;
    this.local$request = void 0;
    this.local$$receiver = $receiver_0;
    this.local$origin = origin_0;
    this.local$context = context_0;
  }
  Coroutine$Auth$Feature$install$lambda_0.$metadata$ = {
  kind: Kotlin.Kind.CLASS, 
  simpleName: null, 
  interfaces: [CoroutineImpl]};
  Coroutine$Auth$Feature$install$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Auth$Feature$install$lambda_0.prototype.constructor = Coroutine$Auth$Feature$install$lambda_0;
  Coroutine$Auth$Feature$install$lambda_0.prototype.doResume = function() {
  do try {
    switch (this.state_0) {
      case 0:
        var tmp$, tmp$_0;
        if (!((tmp$ = this.local$origin.response.status) != null ? tmp$.equals(HttpStatusCode.Companion.Unauthorized) : null)) {
          return this.local$origin;
        } else {
          this.state_0 = 2;
          continue;
        }
      case 1:
        throw this.exception_0;
      case 2:
        if (this.local$origin.request.attributes.contains_w48dwb$(this.local$closure$circuitBreaker)) {
          return this.local$origin;
        } else {
          this.state_0 = 3;
          continue;
        }
      case 3:
        this.local$call = this.local$origin;
        var $receiver = HashSet_init(this.local$closure$feature.providers);
        $receiver.removeAll_brywnq$(this.local$closure$feature.alwaysSend_0);
        this.local$candidateProviders = $receiver;
        this.state_0 = 4;
        continue;
      case 4:
        if (!((tmp$_0 = this.local$call.response.status) != null ? tmp$_0.equals(HttpStatusCode.Companion.Unauthorized) : null)) {
          this.state_0 = 10;
          continue;
        }
        this.local$tmp$_1 = this.local$call.response.headers.get_61zpoe$(http.HttpHeaders.WWWAuthenticate);
        if (this.local$tmp$_1 == null) {
          return this.local$call;
        } else {
          this.state_0 = 5;
          continue;
        }
      case 5:
        var headerValue = this.local$tmp$_1;
        this.local$tmp$_2 = parseAuthorizationHeader(headerValue);
        if (this.local$tmp$_2 == null) {
          return this.local$call;
        } else {
          this.state_0 = 6;
          continue;
        }
      case 6:
        var authHeader = this.local$tmp$_2;
        var firstOrNull$result;
        firstOrNull$break:
          do {
            var tmp$_1;
            tmp$_1 = this.local$candidateProviders.iterator();
            while (tmp$_1.hasNext()) {
              var element = tmp$_1.next();
              if (element.isApplicable_902e1j$(authHeader)) {
                firstOrNull$result = element;
                break firstOrNull$break;
              }
            }
            firstOrNull$result = null;
          } while (false);
        this.local$tmp$_3 = firstOrNull$result;
        if (this.local$tmp$_3 == null) {
          return this.local$call;
        } else {
          this.state_0 = 7;
          continue;
        }
      case 7:
        var provider = this.local$tmp$_3;
        this.local$candidateProviders.remove_11rb$(provider);
        this.local$request = new HttpRequestBuilder();
        this.local$request.takeFromWithExecutionContext_s9rlw$(this.local$context);
        this.state_0 = 8;
        this.result_0 = provider.addRequestHeaders_s9rlw$(this.local$request, this);
        if (this.result_0 === COROUTINE_SUSPENDED) 
          return COROUTINE_SUSPENDED;
        continue;
      case 8:
        this.local$request.attributes.put_uuntuo$(this.local$closure$circuitBreaker, Unit);
        this.state_0 = 9;
        this.result_0 = this.local$$receiver.execute_s9rlw$(this.local$request, this);
        if (this.result_0 === COROUTINE_SUSPENDED) 
          return COROUTINE_SUSPENDED;
        continue;
      case 9:
        this.local$call = this.result_0;
        this.state_0 = 4;
        continue;
      case 10:
        return this.local$call;
      default:
        this.state_0 = 1;
        throw new Error('State Machine Unreachable execution');
    }
  }  catch (e) {
  if (this.state_0 === 1) {
    this.exceptionState_0 = this.state_0;
    throw e;
  } else {
    this.state_0 = this.exceptionState_0;
    this.exception_0 = e;
  }
} while (true);
};
  function Auth$Feature$install$lambda_0(closure$circuitBreaker_0, closure$feature_0) {
    return function($receiver_0, origin_0, context_0, continuation_0, suspended) {
  var instance = new Coroutine$Auth$Feature$install$lambda_0(closure$circuitBreaker_0, closure$feature_0, $receiver_0, origin_0, context_0, this, continuation_0);
  if (suspended) 
    return instance;
  else 
    return instance.doResume(null);
};
  }
  Auth$Feature.prototype.install_wojrb5$ = function(feature_0, scope) {
  scope.requestPipeline.intercept_h71y74$(HttpRequestPipeline.Phases.State, Auth$Feature$install$lambda(feature_0));
  var circuitBreaker = new AttributeKey('auth-request');
  ensureNotNull(feature(scope, HttpSend.Feature)).intercept_vsqnz3$(Auth$Feature$install$lambda_0(circuitBreaker, feature_0));
};
  Auth$Feature.$metadata$ = {
  kind: Kind_OBJECT, 
  simpleName: 'Feature', 
  interfaces: [HttpClientFeature]};
  var Auth$Feature_instance = null;
  function Auth$Feature_getInstance() {
    if (Auth$Feature_instance === null) {
      new Auth$Feature();
    }
    return Auth$Feature_instance;
  }
  function Auth$alwaysSend$lambda(this$Auth) {
    return function() {
  var $receiver = this$Auth.providers;
  var destination = ArrayList_init();
  var tmp$;
  tmp$ = $receiver.iterator();
  while (tmp$.hasNext()) {
    var element = tmp$.next();
    if (element.sendWithoutRequest) 
      destination.add_11rb$(element);
  }
  return destination;
};
  }
  Auth.$metadata$ = {
  kind: Kind_CLASS, 
  simpleName: 'Auth', 
  interfaces: []};
  function Auth_0($receiver, block) {
    $receiver.install_xlxg29$(Auth$Feature_getInstance(), block);
  }
  function AuthProvider() {
  }
  AuthProvider.$metadata$ = {
  kind: Kind_INTERFACE, 
  simpleName: 'AuthProvider', 
  interfaces: []};
  function basic($receiver, block) {
    var $receiver_0 = new BasicAuthConfig();
    block($receiver_0);
    $receiver.providers.add_11rb$(new BasicAuthProvider($receiver_0.username, $receiver_0.password, $receiver_0.realm, $receiver_0.sendWithoutRequest));
  }
  function BasicAuthConfig() {
    this.username_dzdau4$_0 = this.username_dzdau4$_0;
    this.password_z60toh$_0 = this.password_z60toh$_0;
    this.realm = null;
    this.sendWithoutRequest = false;
  }
  Object.defineProperty(BasicAuthConfig.prototype, 'username', {
  configurable: true, 
  get: function() {
  if (this.username_dzdau4$_0 == null) 
    return throwUPAE('username');
  return this.username_dzdau4$_0;
}, 
  set: function(username) {
  this.username_dzdau4$_0 = username;
}});
  Object.defineProperty(BasicAuthConfig.prototype, 'password', {
  configurable: true, 
  get: function() {
  if (this.password_z60toh$_0 == null) 
    return throwUPAE('password');
  return this.password_z60toh$_0;
}, 
  set: function(password) {
  this.password_z60toh$_0 = password;
}});
  BasicAuthConfig.$metadata$ = {
  kind: Kind_CLASS, 
  simpleName: 'BasicAuthConfig', 
  interfaces: []};
  function BasicAuthProvider(username, password, realm, sendWithoutRequest) {
    if (realm === void 0) 
      realm = null;
    if (sendWithoutRequest === void 0) 
      sendWithoutRequest = false;
    this.username_0 = username;
    this.password_0 = password;
    this.realm_0 = realm;
    this.sendWithoutRequest_362v96$_0 = sendWithoutRequest;
    this.defaultCharset_0 = charsets.Charsets.UTF_8;
  }
  Object.defineProperty(BasicAuthProvider.prototype, 'sendWithoutRequest', {
  get: function() {
  return this.sendWithoutRequest_362v96$_0;
}});
  BasicAuthProvider.prototype.isApplicable_902e1j$ = function(auth_0) {
  if (!equals(auth_0.authScheme, auth.AuthScheme.Basic)) 
    return false;
  if (this.realm_0 != null) {
    if (!Kotlin.isType(auth_0, HttpAuthHeader$Parameterized)) 
      return false;
    return equals(auth_0.parameter_61zpoe$('realm'), this.realm_0);
  }
  return true;
};
  BasicAuthProvider.prototype.addRequestHeaders_s9rlw$ = function(request, continuation) {
  request.headers.set_puj7f4$(http.HttpHeaders.Authorization, this.constructBasicAuthValue_8be2vx$());
};
  BasicAuthProvider.prototype.constructBasicAuthValue_8be2vx$ = function() {
  var authString = this.username_0 + ':' + this.password_0;
  var authBuf = encodeBase64(encodeToByteArray(this.defaultCharset_0.newEncoder(), authString, 0, authString.length));
  return 'Basic ' + authBuf;
};
  BasicAuthProvider.$metadata$ = {
  kind: Kind_CLASS, 
  simpleName: 'BasicAuthProvider', 
  interfaces: [AuthProvider]};
  function digest($receiver, block) {
    var $receiver_0 = new DigestAuthConfig();
    block($receiver_0);
    var config = $receiver_0;
    var $receiver_1 = $receiver.providers;
    var element = new DigestAuthProvider(config.username, config.password, config.realm, config.algorithmName);
    $receiver_1.add_11rb$(element);
  }
  function DigestAuthConfig() {
    this.username = '';
    this.password = '';
    this.realm = null;
    this.algorithmName = 'MD5';
  }
  DigestAuthConfig.$metadata$ = {
  kind: Kind_CLASS, 
  simpleName: 'DigestAuthConfig', 
  interfaces: []};
  function DigestAuthProvider(username, password, realm, algorithmName) {
    if (algorithmName === void 0) 
      algorithmName = 'MD5';
    this.username = username;
    this.password = password;
    this.realm = realm;
    this.algorithmName = algorithmName;
    this.sendWithoutRequest_dahw9o$_0 = false;
    this.serverNonce_0 = null;
    this.qop_0 = null;
    this.opaque_0 = null;
    this.clientNonce_0 = generateNonce();
    this.requestCounter_0 = 0;
  }
  Object.defineProperty(DigestAuthProvider.prototype, 'sendWithoutRequest', {
  configurable: true, 
  get: function() {
  return this.sendWithoutRequest_dahw9o$_0;
}});
  DigestAuthProvider.prototype.isApplicable_902e1j$ = function(auth_0) {
  var tmp$;
  if (!Kotlin.isType(auth_0, HttpAuthHeader$Parameterized) || !equals(auth_0.parameter_61zpoe$('realm'), this.realm) || !equals(auth_0.authScheme, auth.AuthScheme.Digest)) 
    return false;
  tmp$ = auth_0.parameter_61zpoe$('nonce');
  if (tmp$ == null) {
    return false;
  }
  var newNonce = tmp$;
  var newQop = auth_0.parameter_61zpoe$('qop');
  var newOpaque = auth_0.parameter_61zpoe$('opaque');
  this.serverNonce_0 = newNonce;
  this.qop_0 = newQop;
  this.opaque_0 = newOpaque;
  return true;
};
  function DigestAuthProvider$addRequestHeaders$lambda(closure$auth) {
    return function($receiver) {
  $receiver.append_puj7f4$(http.HttpHeaders.Authorization, closure$auth.render());
  return Unit;
};
  }
  function Coroutine$addRequestHeaders_s9rlw$($this, request_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$nonceCount = void 0;
    this.local$methodName = void 0;
    this.local$url = void 0;
    this.local$nonce = void 0;
    this.local$serverOpaque = void 0;
    this.local$actualQop = void 0;
    this.local$start = void 0;
    this.local$request = request_0;
  }
  Coroutine$addRequestHeaders_s9rlw$.$metadata$ = {
  kind: Kotlin.Kind.CLASS, 
  simpleName: null, 
  interfaces: [CoroutineImpl]};
  Coroutine$addRequestHeaders_s9rlw$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$addRequestHeaders_s9rlw$.prototype.constructor = Coroutine$addRequestHeaders_s9rlw$;
  Coroutine$addRequestHeaders_s9rlw$.prototype.doResume = function() {
  do try {
    switch (this.state_0) {
      case 0:
        this.local$nonceCount = (function(scope) {
  return ++scope.$this.requestCounter_0;
})(this);
        this.local$methodName = this.local$request.method.value.toUpperCase();
        this.local$url = takeFrom(new URLBuilder(), this.local$request.url).build();
        this.local$nonce = ensureNotNull(this.$this.serverNonce_0);
        this.local$serverOpaque = this.$this.opaque_0;
        this.local$actualQop = this.$this.qop_0;
        this.state_0 = 2;
        this.result_0 = this.$this.makeDigest_0(this.$this.username + ':' + toString(this.$this.realm) + ':' + this.$this.password, this);
        if (this.result_0 === COROUTINE_SUSPENDED) 
          return COROUTINE_SUSPENDED;
        continue;
      case 1:
        throw this.exception_0;
      case 2:
        var credential = this.result_0;
        this.local$start = hex(credential);
        this.state_0 = 3;
        this.result_0 = this.$this.makeDigest_0(this.local$methodName + ':' + get_fullPath(this.local$url), this);
        if (this.result_0 === COROUTINE_SUSPENDED) 
          return COROUTINE_SUSPENDED;
        continue;
      case 3:
        var end = hex(this.result_0);
        var tokenSequence = this.local$actualQop == null ? listOf([this.local$start, this.local$nonce, end]) : listOf([this.local$start, this.local$nonce, this.local$nonceCount, this.$this.clientNonce_0, this.local$actualQop, end]);
        this.state_0 = 4;
        this.result_0 = this.$this.makeDigest_0(joinToString(tokenSequence, ':'), this);
        if (this.result_0 === COROUTINE_SUSPENDED) 
          return COROUTINE_SUSPENDED;
        continue;
      case 4:
        var token = this.result_0;
        var tmp$ = auth.AuthScheme.Digest;
        var $receiver = LinkedHashMap_init();
        var tmp$_0;
        if ((tmp$_0 = this.$this.realm) != null) {
          $receiver.put_xwzc9p$('realm', tmp$_0);
        }
        if (this.local$serverOpaque != null) {
          $receiver.put_xwzc9p$('opaque', this.local$serverOpaque);
        }
        var key = 'username';
        var value = this.$this.username;
        $receiver.put_xwzc9p$(key, value);
        $receiver.put_xwzc9p$('nonce', this.local$nonce);
        var value_0 = this.$this.clientNonce_0;
        $receiver.put_xwzc9p$('cnonce', value_0);
        var key_0 = 'response';
        var value_1 = hex(token);
        $receiver.put_xwzc9p$(key_0, value_1);
        var value_2 = get_fullPath(this.local$url);
        $receiver.put_xwzc9p$('uri', value_2);
        if (this.local$actualQop != null) {
          $receiver.put_xwzc9p$('qop', this.local$actualQop);
        }
        var value_3 = this.local$nonceCount.toString();
        $receiver.put_xwzc9p$('nc', value_3);
        var auth_0 = HttpAuthHeader$HttpAuthHeader$Parameterized_init(tmp$, $receiver);
        headers(this.local$request, DigestAuthProvider$addRequestHeaders$lambda(auth_0));
        return;
      default:
        this.state_0 = 1;
        throw new Error('State Machine Unreachable execution');
    }
  }  catch (e) {
  if (this.state_0 === 1) {
    this.exceptionState_0 = this.state_0;
    throw e;
  } else {
    this.state_0 = this.exceptionState_0;
    this.exception_0 = e;
  }
} while (true);
};
  DigestAuthProvider.prototype.addRequestHeaders_s9rlw$ = function(request_0, continuation_0, suspended) {
  var instance = new Coroutine$addRequestHeaders_s9rlw$(this, request_0, continuation_0);
  if (suspended) 
    return instance;
  else 
    return instance.doResume(null);
};
  DigestAuthProvider.prototype.makeDigest_0 = function(data, continuation) {
  var digest = Digest(this.algorithmName);
  return build(digest, encodeToByteArray(charsets.Charsets.UTF_8.newEncoder(), data, 0, data.length), continuation);
};
  DigestAuthProvider.$metadata$ = {
  kind: Kind_CLASS, 
  simpleName: 'DigestAuthProvider', 
  interfaces: [AuthProvider]};
  Object.defineProperty(Auth, 'Feature', {
  get: Auth$Feature_getInstance});
  var package$io = _.io || (_.io = {});
  var package$ktor = package$io.ktor || (package$io.ktor = {});
  var package$client = package$ktor.client || (package$ktor.client = {});
  var package$features = package$client.features || (package$client.features = {});
  var package$auth = package$features.auth || (package$features.auth = {});
  package$auth.Auth = Auth;
  package$auth.Auth_5fpl88$ = Auth_0;
  package$auth.AuthProvider = AuthProvider;
  var package$providers = package$auth.providers || (package$auth.providers = {});
  package$providers.basic_c7fts0$ = basic;
  package$providers.BasicAuthConfig = BasicAuthConfig;
  $$importsForInline$$['ktor-ktor-io-jsLegacy'] = $module$ktor_ktor_io_jsLegacy;
  package$providers.BasicAuthProvider = BasicAuthProvider;
  package$providers.digest_lqu332$ = digest;
  package$providers.DigestAuthConfig = DigestAuthConfig;
  package$providers.DigestAuthProvider = DigestAuthProvider;
  Auth$Feature.prototype.prepare_oh3mgy$ = HttpClientFeature.prototype.prepare_oh3mgy$;
  Kotlin.defineModule('ktor-ktor-client-auth-jsLegacy', _);
  return _;
}));
