(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'ktor-ktor-client-core-js-legacy', 'ktor-ktor-io-js-legacy', 'ktor-ktor-test-dispatcher-js-legacy', 'kotlinx-coroutines-core', 'ktor-ktor-utils-js-legacy', 'ktor-ktor-http-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('ktor-ktor-client-core-js-legacy'), require('ktor-ktor-io-js-legacy'), require('ktor-ktor-test-dispatcher-js-legacy'), require('kotlinx-coroutines-core'), require('ktor-ktor-utils-js-legacy'), require('ktor-ktor-http-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    if (typeof this['ktor-ktor-client-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'ktor-ktor-client-core-js-legacy' was not found. Please, check whether 'ktor-ktor-client-core-js-legacy' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    if (typeof this['ktor-ktor-io-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'ktor-ktor-io-js-legacy' was not found. Please, check whether 'ktor-ktor-io-js-legacy' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    if (typeof this['ktor-ktor-test-dispatcher-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'ktor-ktor-test-dispatcher-js-legacy' was not found. Please, check whether 'ktor-ktor-test-dispatcher-js-legacy' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    if (typeof this['ktor-ktor-utils-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'ktor-ktor-utils-js-legacy' was not found. Please, check whether 'ktor-ktor-utils-js-legacy' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    if (typeof this['ktor-ktor-http-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'ktor-ktor-client-tests-js-legacy'. Its dependency 'ktor-ktor-http-js-legacy' was not found. Please, check whether 'ktor-ktor-http-js-legacy' is loaded prior to 'ktor-ktor-client-tests-js-legacy'.");
    }
    root['ktor-ktor-client-tests-js-legacy'] = factory(typeof this['ktor-ktor-client-tests-js-legacy'] === 'undefined' ? {} : this['ktor-ktor-client-tests-js-legacy'], kotlin, this['ktor-ktor-client-core-js-legacy'], this['ktor-ktor-io-js-legacy'], this['ktor-ktor-test-dispatcher-js-legacy'], this['kotlinx-coroutines-core'], this['ktor-ktor-utils-js-legacy'], this['ktor-ktor-http-js-legacy']);
  }
}(this, function (_, Kotlin, $module$ktor_ktor_client_core_js_legacy, $module$ktor_ktor_io_js_legacy, $module$ktor_ktor_test_dispatcher_js_legacy, $module$kotlinx_coroutines_core, $module$ktor_ktor_utils_js_legacy, $module$ktor_ktor_http_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var L60000 = Kotlin.Long.fromInt(60000);
  var HttpClient = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.HttpClient;
  var Unit = Kotlin.kotlin.Unit;
  var HttpClientConfig = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.HttpClientConfig;
  var throwCCE = Kotlin.throwCCE;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var testSuspend = $module$ktor_ktor_test_dispatcher_js_legacy.io.ktor.test.dispatcher.testSuspend_rngysb$;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var HttpClient_0 = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.HttpClient_744i18$;
  var Job = $module$kotlinx_coroutines_core.kotlinx.coroutines.Job;
  var ensureNotNull = Kotlin.ensureNotNull;
  var yield_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.yield;
  var cancel = $module$kotlinx_coroutines_core.kotlinx.coroutines.cancel_n4wjt3$;
  var Throwable = Error;
  var async = $module$kotlinx_coroutines_core.kotlinx.coroutines.async_pda6u4$;
  var awaitAll = $module$kotlinx_coroutines_core.kotlinx.coroutines.awaitAll_60afti$;
  var coroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.coroutineScope_awg8ri$;
  var L_1 = Kotlin.Long.NEG_ONE;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var addSuppressedInternal = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.addSuppressedInternal_oh0dqn$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var toByte = Kotlin.toByte;
  var toChar = Kotlin.toChar;
  var toBoxedChar = Kotlin.toBoxedChar;
  var concatToString = Kotlin.kotlin.text.concatToString_355ntz$;
  var encodeBase64 = $module$ktor_ktor_utils_js_legacy.io.ktor.util.encodeBase64_pdl1vz$;
  var take = Kotlin.kotlin.text.take_6ic1pp$;
  var PartData$FileItem = $module$ktor_ktor_http_js_legacy.io.ktor.http.content.PartData.FileItem;
  var PartData$FormItem = $module$ktor_ktor_http_js_legacy.io.ktor.http.content.PartData.FormItem;
  var PartData$BinaryItem = $module$ktor_ktor_http_js_legacy.io.ktor.http.content.PartData.BinaryItem;
  var PartData$BinaryChannelItem = $module$ktor_ktor_http_js_legacy.io.ktor.http.content.PartData.BinaryChannelItem;
  var http = $module$ktor_ktor_http_js_legacy.io.ktor.http;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var ContentDisposition = $module$ktor_ktor_http_js_legacy.io.ktor.http.ContentDisposition;
  var ContentType = $module$ktor_ktor_http_js_legacy.io.ktor.http.ContentType;
  var charsets = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.charsets;
  var readText = $module$ktor_ktor_io_js_legacy.io.ktor.utils.io.core.readText_1lnizf$;
  var charArray = Kotlin.charArray;
  var unboxChar = Kotlin.unboxChar;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var equals = Kotlin.equals;
  var asPromise = $module$kotlinx_coroutines_core.kotlinx.coroutines.asPromise_ge6odz$;
  var js = $module$ktor_ktor_client_core_js_legacy.io.ktor.client.engine.js;
  var withTimeout = $module$kotlinx_coroutines_core.kotlinx.coroutines.withTimeout_ms3uf5$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var TEST_SERVER;
  var TEST_WEBSOCKET_SERVER;
  var TCP_SERVER;
  function testWithEngine(engine, timeoutMillis, block) {
    if (timeoutMillis === void 0)
      timeoutMillis = L60000;
    return testWithClient(new HttpClient(engine), timeoutMillis, block);
  }
  function testWithClient$lambda$lambda$lambda$lambda(closure$builder) {
    return function ($receiver) {
      var tmp$;
      closure$builder.config(Kotlin.isType(tmp$ = $receiver, HttpClientConfig) ? tmp$ : throwCCE());
      return Unit;
    };
  }
  function Coroutine$testWithClient$lambda$lambda(closure$builder_0, closure$client_0, threadId_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 7;
    this.local$closure$builder = closure$builder_0;
    this.local$closure$client = closure$client_0;
    this.local$times = void 0;
    this.local$index = void 0;
    this.local$$receiver = void 0;
    this.local$closed = void 0;
    this.local$threadId = threadId_0;
  }
  Coroutine$testWithClient$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$testWithClient$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$testWithClient$lambda$lambda.prototype.constructor = Coroutine$testWithClient$lambda$lambda;
  Coroutine$testWithClient$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$times = this.local$closure$builder.repeatCount;
            this.local$index = 0;
            this.state_0 = 1;
            continue;
          case 1:
            if (this.local$index >= this.local$times) {
              this.state_0 = 8;
              continue;
            }

            var closure$client = this.local$closure$client;
            var closure$builder = this.local$closure$builder;
            this.local$$receiver = closure$client.config_f0veat$(testWithClient$lambda$lambda$lambda$lambda(closure$builder));
            var tmp$;
            this.local$closed = false;
            this.exceptionState_0 = 3;
            this.state_0 = 2;
            this.result_0 = closure$builder.test(new TestInfo(this.local$threadId, this.local$index), this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            tmp$ = Unit;
            this.exceptionState_0 = 7;
            this.finallyPath_0 = [5];
            this.state_0 = 4;
            continue;
          case 3:
            this.finallyPath_0 = [7];
            this.exceptionState_0 = 4;
            var first = this.exception_0;
            if (Kotlin.isType(first, Throwable)) {
              try {
                this.local$closed = true;
                this.local$$receiver.close();
              } catch (second) {
                if (Kotlin.isType(second, Throwable)) {
                  addSuppressedInternal(first, second);
                } else
                  throw second;
              }
              throw first;
            } else
              throw first;
          case 4:
            this.exceptionState_0 = 7;
            if (!this.local$closed) {
              this.local$$receiver.close();
            }

            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 5:
            this.state_0 = 6;
            continue;
          case 6:
            this.local$index++;
            this.state_0 = 1;
            continue;
          case 7:
            throw this.exception_0;
          case 8:
            return Unit;
          default:
            this.state_0 = 7;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 7) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function testWithClient$lambda$lambda(closure$builder_0, closure$client_0) {
    return function (threadId_0, continuation_0, suspended) {
      var instance = new Coroutine$testWithClient$lambda$lambda(closure$builder_0, closure$client_0, threadId_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$testWithClient$lambda(closure$block_0, closure$client_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$block = closure$block_0;
    this.local$closure$client = closure$client_0;
    this.local$$receiver = void 0;
  }
  Coroutine$testWithClient$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$testWithClient$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$testWithClient$lambda.prototype.constructor = Coroutine$testWithClient$lambda;
  Coroutine$testWithClient$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$$receiver = new TestClientBuilder();
            this.state_0 = 2;
            this.result_0 = this.local$closure$block(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var builder = this.local$$receiver;
            this.state_0 = 3;
            this.result_0 = concurrency(builder.concurrency, testWithClient$lambda$lambda(builder, this.local$closure$client), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.local$closure$client.engine.close(), Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function testWithClient$lambda(closure$block_0, closure$client_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$testWithClient$lambda(closure$block_0, closure$client_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function testWithClient(client, timeout, block) {
    return testSuspend(void 0, timeout, testWithClient$lambda(block, client));
  }
  function Coroutine$testWithEngine$lambda$lambda(closure$builder_0, closure$loader_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$builder = closure$builder_0;
    this.local$closure$loader = closure$loader_0;
  }
  Coroutine$testWithEngine$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$testWithEngine$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$testWithEngine$lambda$lambda.prototype.constructor = Coroutine$testWithEngine$lambda$lambda;
  Coroutine$testWithEngine$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = delay(this.local$closure$builder.dumpAfterDelay, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$closure$loader.dumpCoroutines(), Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function testWithEngine$lambda$lambda(closure$builder_0, closure$loader_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$testWithEngine$lambda$lambda(closure$builder_0, closure$loader_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$testWithEngine$lambda$lambda_0(closure$builder_0, closure$factory_0, threadId_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 14;
    this.local$closure$builder = closure$builder_0;
    this.local$closure$factory = closure$factory_0;
    this.local$times = void 0;
    this.local$index = void 0;
    this.local$closure$builder_0 = void 0;
    this.local$client = void 0;
    this.local$closed = void 0;
    this.local$job = void 0;
    this.local$threadId = threadId_0;
  }
  Coroutine$testWithEngine$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$testWithEngine$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$testWithEngine$lambda$lambda_0.prototype.constructor = Coroutine$testWithEngine$lambda$lambda_0;
  Coroutine$testWithEngine$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$times = this.local$closure$builder.repeatCount;
            this.local$index = 0;
            this.state_0 = 1;
            continue;
          case 1:
            if (this.local$index >= this.local$times) {
              this.state_0 = 15;
              continue;
            }

            var closure$factory = this.local$closure$factory;
            this.local$closure$builder_0 = this.local$closure$builder;
            this.local$client = HttpClient_0(closure$factory, this.local$closure$builder_0.config);
            var tmp$;
            this.local$closed = false;
            this.exceptionState_0 = 3;
            this.state_0 = 2;
            this.result_0 = this.local$closure$builder_0.test(new TestInfo(this.local$threadId, this.local$index), this.local$client, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            tmp$ = Unit;
            this.exceptionState_0 = 14;
            this.finallyPath_0 = [5];
            this.state_0 = 4;
            continue;
          case 3:
            this.finallyPath_0 = [14];
            this.exceptionState_0 = 4;
            var first = this.exception_0;
            if (Kotlin.isType(first, Throwable)) {
              try {
                this.local$closed = true;
                this.local$client.close();
              } catch (second) {
                if (Kotlin.isType(second, Throwable)) {
                  addSuppressedInternal(first, second);
                } else
                  throw second;
              }
              throw first;
            } else
              throw first;
          case 4:
            this.exceptionState_0 = 14;
            if (!this.local$closed) {
              this.local$client.close();
            }

            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 5:
            this.exceptionState_0 = 9;
            this.local$job = ensureNotNull(this.local$client.coroutineContext.get_j3r2sn$(Job.Key));
            this.state_0 = 6;
            continue;
          case 6:
            if (!this.local$job.isActive) {
              this.state_0 = 8;
              continue;
            }

            this.state_0 = 7;
            this.result_0 = yield_0(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 7:
            this.state_0 = 6;
            continue;
          case 8:
            this.exceptionState_0 = 14;
            this.finallyPath_0 = [12];
            this.state_0 = 10;
            continue;
          case 9:
            this.finallyPath_0 = [14];
            this.exceptionState_0 = 10;
            var cause = this.exception_0;
            if (Kotlin.isType(cause, Throwable)) {
              cancel(this.local$client, 'Test failed', cause);
              throw cause;
            } else
              throw cause;
          case 10:
            this.exceptionState_0 = 14;
            this.state_0 = 11;
            this.result_0 = this.local$closure$builder_0.after(this.local$client, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 11:
            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 12:
            this.state_0 = 13;
            continue;
          case 13:
            this.local$index++;
            this.state_0 = 1;
            continue;
          case 14:
            throw this.exception_0;
          case 15:
            return Unit;
          default:
            this.state_0 = 14;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 14) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function testWithEngine$lambda$lambda_0(closure$builder_0, closure$factory_0) {
    return function (threadId_0, continuation_0, suspended) {
      var instance = new Coroutine$testWithEngine$lambda$lambda_0(closure$builder_0, closure$factory_0, threadId_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$testWithEngine$lambda(closure$block_0, closure$loader_0, closure$factory_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$block = closure$block_0;
    this.local$closure$loader = closure$loader_0;
    this.local$closure$factory = closure$factory_0;
    this.local$$receiver = void 0;
  }
  Coroutine$testWithEngine$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$testWithEngine$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$testWithEngine$lambda.prototype.constructor = Coroutine$testWithEngine$lambda;
  Coroutine$testWithEngine$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$$receiver = new TestClientBuilder();
            this.state_0 = 2;
            this.result_0 = this.local$closure$block(this.local$$receiver, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var builder = this.local$$receiver;
            if (builder.dumpAfterDelay.toNumber() > 0 && this.local$closure$loader != null) {
              launch(coroutines.GlobalScope, void 0, void 0, testWithEngine$lambda$lambda(builder, this.local$closure$loader));
            }

            this.state_0 = 3;
            this.result_0 = concurrency(builder.concurrency, testWithEngine$lambda$lambda_0(builder, this.local$closure$factory), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function testWithEngine$lambda(closure$block_0, closure$loader_0, closure$factory_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$testWithEngine$lambda(closure$block_0, closure$loader_0, closure$factory_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function testWithEngine_0(factory, loader, timeoutMillis, block) {
    if (loader === void 0)
      loader = null;
    if (timeoutMillis === void 0)
      timeoutMillis = L60000;
    return testSuspend(void 0, timeoutMillis, testWithEngine$lambda(block, loader, factory));
  }
  function Coroutine$concurrency$lambda$lambda$lambda(closure$block_0, closure$it_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$block = closure$block_0;
    this.local$closure$it = closure$it_0;
  }
  Coroutine$concurrency$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$concurrency$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$concurrency$lambda$lambda$lambda.prototype.constructor = Coroutine$concurrency$lambda$lambda$lambda;
  Coroutine$concurrency$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$block(this.local$closure$it, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function concurrency$lambda$lambda$lambda(closure$block_0, closure$it_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$concurrency$lambda$lambda$lambda(closure$block_0, closure$it_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$concurrency$lambda(closure$level_0, closure$block_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$level = closure$level_0;
    this.local$closure$block = closure$block_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$concurrency$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$concurrency$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$concurrency$lambda.prototype.constructor = Coroutine$concurrency$lambda;
  Coroutine$concurrency$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var size = this.local$closure$level;
            var list = ArrayList_init(size);
            for (var index = 0; index < size; index++) {
              list.add_11rb$(async(this.local$$receiver, void 0, void 0, concurrency$lambda$lambda$lambda(this.local$closure$block, index)));
            }

            this.state_0 = 2;
            this.result_0 = awaitAll(list, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function concurrency$lambda(closure$level_0, closure$block_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$concurrency$lambda(closure$level_0, closure$block_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$concurrency(level_0, block_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$level = level_0;
    this.local$block = block_0;
  }
  Coroutine$concurrency.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$concurrency.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$concurrency.prototype.constructor = Coroutine$concurrency;
  Coroutine$concurrency.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = coroutineScope(concurrency$lambda(this.local$level, this.local$block), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function concurrency(level_0, block_0, continuation_0, suspended) {
    var instance = new Coroutine$concurrency(level_0, block_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function TestClientBuilder(config, test, after, repeatCount, dumpAfterDelay, concurrency) {
    if (config === void 0)
      config = TestClientBuilder_init$lambda;
    if (test === void 0)
      test = TestClientBuilder_init$lambda_0;
    if (after === void 0)
      after = TestClientBuilder_init$lambda_1;
    if (repeatCount === void 0)
      repeatCount = 1;
    if (dumpAfterDelay === void 0)
      dumpAfterDelay = L_1;
    if (concurrency === void 0)
      concurrency = 1;
    this.config = config;
    this.test = test;
    this.after = after;
    this.repeatCount = repeatCount;
    this.dumpAfterDelay = dumpAfterDelay;
    this.concurrency = concurrency;
  }
  function TestClientBuilder_init$lambda($receiver) {
    return Unit;
  }
  function Coroutine$TestClientBuilder_init$lambda($receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
  }
  Coroutine$TestClientBuilder_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TestClientBuilder_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TestClientBuilder_init$lambda.prototype.constructor = Coroutine$TestClientBuilder_init$lambda;
  Coroutine$TestClientBuilder_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TestClientBuilder_init$lambda_0($receiver_0, it_0, continuation_0, suspended) {
    var instance = new Coroutine$TestClientBuilder_init$lambda($receiver_0, it_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$TestClientBuilder_init$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$TestClientBuilder_init$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$TestClientBuilder_init$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$TestClientBuilder_init$lambda_0.prototype.constructor = Coroutine$TestClientBuilder_init$lambda_0;
  Coroutine$TestClientBuilder_init$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function TestClientBuilder_init$lambda_1(it_0, continuation_0, suspended) {
    var instance = new Coroutine$TestClientBuilder_init$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  TestClientBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TestClientBuilder',
    interfaces: []
  };
  function config($receiver, block) {
    $receiver.config = block;
  }
  function test($receiver, block) {
    $receiver.test = block;
  }
  function after($receiver, block) {
    $receiver.after = block;
  }
  function makeArray(size) {
    var array = new Int8Array(size);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = toByte(i);
    }
    return array;
  }
  function makeString(size) {
    var tmp$;
    var array = charArray(size, null);
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      var value = unboxChar(toBoxedChar(toChar(i)));
      array[i] = value;
    }
    return take(encodeBase64(concatToString(array)), size);
  }
  function makeString_0($receiver) {
    var $receiver_0 = StringBuilder_init();
    var list = $receiver;
    var tmp$;
    tmp$ = list.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      $receiver_0.append_pdl1vj$(ensureNotNull(element.name) + '\n');
      if (Kotlin.isType(element, PartData$FileItem))
        tmp$_0 = filenameContentTypeAndContentString(element.provider, element.headers);
      else if (Kotlin.isType(element, PartData$FormItem))
        tmp$_0 = element.value;
      else if (Kotlin.isType(element, PartData$BinaryItem))
        tmp$_0 = filenameContentTypeAndContentString(element.provider, element.headers);
      else if (Kotlin.isType(element, PartData$BinaryChannelItem)) {
        throw IllegalStateException_init('Not implemented'.toString());
      } else
        tmp$_0 = Kotlin.noWhenBranchMatched();
      var content = tmp$_0;
      $receiver_0.append_pdl1vj$(content);
    }
    return $receiver_0.toString();
  }
  function filenameContentTypeAndContentString(provider, headers) {
    var tmp$, tmp$_0, tmp$_1;
    var dispositionHeader = joinToString(ensureNotNull(headers.getAll_61zpoe$(http.HttpHeaders.ContentDisposition)), ';');
    var disposition = ContentDisposition.Companion.parse_61zpoe$(dispositionHeader);
    var filename = (tmp$ = disposition.parameter_61zpoe$('filename')) != null ? tmp$ : '';
    var contentType = (tmp$_1 = (tmp$_0 = headers.get_61zpoe$(http.HttpHeaders.ContentType)) != null ? ContentType.Companion.parse_61zpoe$(tmp$_0) : null) != null ? tmp$_1 : '';
    var content = readText(provider(), charsets.Charsets.ISO_8859_1);
    return filename + contentType.toString() + content;
  }
  function TestInfo(threadId, attempt) {
    this.threadId = threadId;
    this.attempt = attempt;
  }
  TestInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TestInfo',
    interfaces: []
  };
  var assertFailsAndContainsCause = defineInlineFunction('ktor-ktor-client-tests-js-legacy.io.ktor.client.tests.utils.assertFailsAndContainsCause_73903m$', wrapFunction(function () {
    var getKClass = Kotlin.getKClass;
    var ensureNotNull = Kotlin.ensureNotNull;
    var contains = Kotlin.kotlin.text.contains_li3zpu$;
    var Throwable = Error;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function (T_0, isT, block) {
      var tmp$;
      try {
        block();
        throw IllegalStateException_init(('Expected ' + getKClass(T_0) + " exception, but it wasn't thrown").toString());
      } catch (cause) {
        if (Kotlin.isType(cause, Throwable)) {
          if (!isT(cause) && ((tmp$ = cause.message) != null ? contains(tmp$, ensureNotNull(getKClass(T_0).simpleName)) : null) === true) {
            throw IllegalStateException_init(('Expected ' + getKClass(T_0) + ' exception, but ' + cause + ' was thrown instead').toString());
          }
        } else
          throw cause;
      }
    };
  }));
  var assertFailsWith = defineInlineFunction('ktor-ktor-client-tests-js-legacy.io.ktor.client.tests.utils.assertFailsWith_73903m$', wrapFunction(function () {
    var getKClass = Kotlin.getKClass;
    var ensureNotNull = Kotlin.ensureNotNull;
    var contains = Kotlin.kotlin.text.contains_li3zpu$;
    var Throwable = Error;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function (T_0, isT, block) {
      var tmp$;
      try {
        block();
        throw IllegalStateException_init(('Expected ' + getKClass(T_0) + " exception, but it wasn't thrown").toString());
      } catch (cause) {
        if (Kotlin.isType(cause, Throwable)) {
          if (!isT(cause) && ((tmp$ = cause.message) != null ? contains(tmp$, ensureNotNull(getKClass(T_0).simpleName)) : null) === true) {
            throw IllegalStateException_init(('Expected ' + getKClass(T_0) + ' exception, but ' + cause + ' was thrown instead').toString());
          }
        } else
          throw cause;
      }
    };
  }));
  function ClientLoader(timeoutSeconds) {
    if (timeoutSeconds === void 0)
      timeoutSeconds = 60;
    this.timeoutSeconds_57qbpb$_0 = timeoutSeconds;
  }
  function Coroutine$ClientLoader$clientTests$lambda($receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
  }
  Coroutine$ClientLoader$clientTests$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ClientLoader$clientTests$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ClientLoader$clientTests$lambda.prototype.constructor = Coroutine$ClientLoader$clientTests$lambda;
  Coroutine$ClientLoader$clientTests$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ClientLoader$clientTests$lambda($receiver_0, continuation_0, suspended) {
    var instance = new Coroutine$ClientLoader$clientTests$lambda($receiver_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$ClientLoader$clientTests$lambda$lambda(closure$block_0, this$_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$block = closure$block_0;
    this.local$this$ = this$_0;
  }
  Coroutine$ClientLoader$clientTests$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ClientLoader$clientTests$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ClientLoader$clientTests$lambda$lambda.prototype.constructor = Coroutine$ClientLoader$clientTests$lambda$lambda;
  Coroutine$ClientLoader$clientTests$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$block(this.local$this$, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ClientLoader$clientTests$lambda$lambda(closure$block_0, this$_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ClientLoader$clientTests$lambda$lambda(closure$block_0, this$_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$ClientLoader$clientTests$lambda_0(this$ClientLoader_0, closure$block_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$ClientLoader = this$ClientLoader_0;
    this.local$closure$block = closure$block_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$ClientLoader$clientTests$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ClientLoader$clientTests$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ClientLoader$clientTests$lambda_0.prototype.constructor = Coroutine$ClientLoader$clientTests$lambda_0;
  Coroutine$ClientLoader$clientTests$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = withTimeout(Kotlin.Long.fromInt(this.local$this$ClientLoader.timeoutSeconds_57qbpb$_0).multiply(Kotlin.Long.fromInt(1000)), ClientLoader$clientTests$lambda$lambda(this.local$closure$block, this.local$$receiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ClientLoader$clientTests$lambda_0(this$ClientLoader_0, closure$block_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ClientLoader$clientTests$lambda_0(this$ClientLoader_0, closure$block_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ClientLoader.prototype.clientTests_dyfi6w$ = function (skipEngines, onlyWithEngine, block) {
    if (skipEngines === void 0)
      skipEngines = emptyList();
    if (onlyWithEngine === void 0)
      onlyWithEngine = null;
    var tmp$;
    var destination = ArrayList_init(collectionSizeOrDefault(skipEngines, 10));
    var tmp$_0;
    tmp$_0 = skipEngines.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination.add_11rb$(item.toLowerCase());
    }
    var skipEnginesLowerCase = destination;
    if (onlyWithEngine != null && !equals(onlyWithEngine, 'js') || skipEnginesLowerCase.contains_11rb$('js')) {
      tmp$ = asPromise(async(coroutines.GlobalScope, void 0, void 0, ClientLoader$clientTests$lambda));
    } else {
      tmp$ = testWithEngine_0(js.Js, void 0, void 0, ClientLoader$clientTests$lambda_0(this, block));
    }
    return tmp$;
  };
  ClientLoader.prototype.dumpCoroutines = function () {
    throw IllegalStateException_init('Debug probes unsupported[js]'.toString());
  };
  ClientLoader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClientLoader',
    interfaces: []
  };
  var package$io = _.io || (_.io = {});
  var package$ktor = package$io.ktor || (package$io.ktor = {});
  var package$client = package$ktor.client || (package$ktor.client = {});
  var package$tests = package$client.tests || (package$client.tests = {});
  var package$utils = package$tests.utils || (package$tests.utils = {});
  Object.defineProperty(package$utils, 'TEST_SERVER', {
    get: function () {
      return TEST_SERVER;
    }
  });
  Object.defineProperty(package$utils, 'TEST_WEBSOCKET_SERVER', {
    get: function () {
      return TEST_WEBSOCKET_SERVER;
    }
  });
  Object.defineProperty(package$utils, 'TCP_SERVER', {
    get: function () {
      return TCP_SERVER;
    }
  });
  package$utils.testWithEngine_wc0r4j$ = testWithEngine;
  $$importsForInline$$['ktor-ktor-io-js-legacy'] = $module$ktor_ktor_io_js_legacy;
  package$utils.testWithEngine_s4iy9i$ = testWithEngine_0;
  package$utils.TestClientBuilder = TestClientBuilder;
  package$utils.config_8vvptz$ = config;
  package$utils.test_kxyeo6$ = test;
  package$utils.after_1ab453$ = after;
  package$utils.makeArray_za3lpa$ = makeArray;
  package$utils.makeString_za3lpa$ = makeString;
  package$utils.makeString_kzqrdw$ = makeString_0;
  package$utils.TestInfo = TestInfo;
  $$importsForInline$$['ktor-ktor-client-tests-js-legacy'] = _;
  package$utils.ClientLoader = ClientLoader;
  TEST_SERVER = 'http://127.0.0.1:8080';
  TEST_WEBSOCKET_SERVER = 'ws://127.0.0.1:8080';
  TCP_SERVER = 'http://127.0.0.1:8082';
  Kotlin.defineModule('ktor-ktor-client-tests-js-legacy', _);
  return _;
}));

//# sourceMappingURL=ktor-ktor-client-tests-js-legacy.js.map
