/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.tests.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import java.io.Closeable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlinx.coroutines.debug.junit4.CoroutinesTimeout;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0014H\u0007R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00108WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lio/ktor/client/tests/utils/TestWithKtor;", "", "()V", "server", "Lio/ktor/server/engine/ApplicationEngine;", "getServer", "()Lio/ktor/server/engine/ApplicationEngine;", "serverPort", "", "getServerPort", "()I", "testUrl", "", "getTestUrl", "()Ljava/lang/String;", "timeout", "Lkotlinx/coroutines/debug/junit4/CoroutinesTimeout;", "getTimeout", "()Lkotlinx/coroutines/debug/junit4/CoroutinesTimeout;", "ensureServerRunning", "", "startServer", "stopServer", "ktor-client-tests"})
public abstract class TestWithKtor {
    private final int serverPort;
    @NotNull
    private final String testUrl;
    @NotNull
    private final CoroutinesTimeout timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestWithKtor() {
        int n;
        int n2;
        Closeable closeable = new ServerSocket(0);
        TestWithKtor testWithKtor = this;
        Throwable throwable = null;
        try {
            ServerSocket it = (ServerSocket)closeable;
            boolean bl = false;
            n2 = it.getLocalPort();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        testWithKtor.serverPort = n = n2;
        this.testUrl = "http://localhost:" + this.serverPort;
        this.timeout = CoroutinesTimeout.Companion.seconds$default((CoroutinesTimeout.Companion)CoroutinesTimeout.Companion, (int)300, (boolean)false, (boolean)false, (int)6, null);
        throwable = LoggerFactory.getLogger((String)"ROOT");
        Logger logger = throwable instanceof Logger ? (Logger)throwable : null;
        if (logger != null) {
            logger.setLevel(Level.ERROR);
        }
    }

    protected final int getServerPort() {
        return this.serverPort;
    }

    @NotNull
    protected final String getTestUrl() {
        return this.testUrl;
    }

    @Rule
    @NotNull
    public CoroutinesTimeout getTimeout() {
        return this.timeout;
    }

    @NotNull
    public abstract ApplicationEngine getServer();

    @Before
    public final void startServer() {
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                ApplicationEngine.DefaultImpls.start$default((ApplicationEngine)this.getServer(), (boolean)false, (int)1, null);
            }
            catch (Throwable cause) {
                if (attempt >= 10) {
                    throw cause;
                }
                Thread.sleep(250L * (long)attempt);
                continue;
            }
            break;
        }
        this.ensureServerRunning();
    }

    @After
    public final void stopServer() {
        ApplicationEngineJvmKt.stop((ApplicationEngine)this.getServer(), (long)0L, (long)0L, (TimeUnit)TimeUnit.SECONDS);
    }

    private final void ensureServerRunning() {
        while (true) {
            try {
                new Socket("localhost", this.serverPort).close();
            }
            catch (Throwable _) {
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }
}

