/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.tests.utils;

import io.ktor.http.ContentDisposition;
import io.ktor.http.ContentType;
import io.ktor.http.Headers;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.PartData;
import io.ktor.util.Base64Kt;
import io.ktor.utils.io.core.Input;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"filenameContentTypeAndContentString", "", "provider", "Lkotlin/Function0;", "Lio/ktor/utils/io/core/Input;", "headers", "Lio/ktor/http/Headers;", "makeArray", "", "size", "", "makeString", "", "Lio/ktor/http/content/PartData;", "ktor-client-tests"})
@SourceDebugExtension(value={"SMAP\nGenerators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Generators.kt\nio/ktor/client/tests/utils/GeneratorsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1855#2,2:42\n1#3:44\n*S KotlinDebug\n*F\n+ 1 Generators.kt\nio/ktor/client/tests/utils/GeneratorsKt\n*L\n19#1:42,2\n*E\n"})
public final class GeneratorsKt {
    @NotNull
    public static final byte[] makeArray(int size) {
        int n = 0;
        byte[] byArray = new byte[size];
        while (n < size) {
            int n2 = n++;
            byArray[n2] = (byte)n2;
        }
        return byArray;
    }

    @NotNull
    public static final String makeString(int size) {
        int n = 0;
        char[] cArray = new char[size];
        while (n < size) {
            int n2 = n++;
            cArray[n2] = (char)n2;
        }
        return StringsKt.take((String)Base64Kt.encodeBase64((String)StringsKt.concatToString((char[])cArray)), (int)size);
    }

    @NotNull
    public static final String makeString(@NotNull List<? extends PartData> $this$makeString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$makeString, (String)"<this>");
        StringBuilder $this$makeString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List<? extends PartData> list = $this$makeString;
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            PartData it = (PartData)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = it.getName();
            Intrinsics.checkNotNull((Object)string2);
            $this$makeString_u24lambda_u241.append(stringBuilder2.append(string2).append('\n').toString());
            PartData partData = it;
            if (partData instanceof PartData.FileItem) {
                string = GeneratorsKt.filenameContentTypeAndContentString((Function0<? extends Input>)((PartData.FileItem)it).getProvider(), it.getHeaders());
            } else if (partData instanceof PartData.FormItem) {
                string = ((PartData.FormItem)it).getValue();
            } else if (partData instanceof PartData.BinaryItem) {
                string = GeneratorsKt.filenameContentTypeAndContentString((Function0<? extends Input>)((PartData.BinaryItem)it).getProvider(), it.getHeaders());
            } else {
                if (partData instanceof PartData.BinaryChannelItem) {
                    throw new IllegalStateException("Not implemented".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            String content = string;
            $this$makeString_u24lambda_u241.append(content);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String filenameContentTypeAndContentString(Function0<? extends Input> provider, Headers headers) {
        String string;
        String filename;
        block5: {
            block4: {
                List list = headers.getAll(HttpHeaders.INSTANCE.getContentDisposition());
                Intrinsics.checkNotNull((Object)list);
                String dispositionHeader = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
                ContentDisposition disposition = ContentDisposition.Companion.parse(dispositionHeader);
                String string2 = disposition.parameter("filename");
                if (string2 == null) {
                    string2 = filename = "";
                }
                if ((string = headers.get(HttpHeaders.INSTANCE.getContentType())) == null) break block4;
                String it = string;
                boolean bl = false;
                ContentType contentType = ContentType.Companion.parse(it);
                string = contentType;
                if (contentType != null) break block5;
            }
            string = "";
        }
        String contentType = string;
        String content = io.ktor.utils.io.core.StringsKt.readText$default((Input)((Input)provider.invoke()), (Charset)Charsets.ISO_8859_1, (int)0, (int)2, null);
        return filename + contentType + content;
    }
}

