/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.internal.LockFreeLinkedListHead;
import io.ktor.util.internal.LockFreeLinkedListNode;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.ChildHandle;
import kotlinx.coroutines.ChildJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.selects.SelectClause0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorExperimentalAPI
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0004\u001d\u001e\u001f B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J@\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162'\u0010\u0017\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00a2\u0006\u0002\b\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue;", "", "timeoutMillis", "", "clock", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)V", "cancelled", "", "head", "Lio/ktor/util/internal/LockFreeLinkedListHead;", "getTimeoutMillis", "()J", "cancel", "", "process", "now", "register", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "job", "Lkotlinx/coroutines/Job;", "withTimeout", "T", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Cancellable", "JobTask", "Registration", "WeakTimeoutCoroutine", "ktor-http-cio"})
public final class WeakTimeoutQueue {
    private final LockFreeLinkedListHead head;
    private volatile boolean cancelled;
    private final long timeoutMillis;
    private final Function0<Long> clock;

    @NotNull
    public final Registration register(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        long now = ((Number)this.clock.invoke()).longValue();
        LockFreeLinkedListHead head = this.head;
        if (this.cancelled) {
            throw (Throwable)new CancellationException();
        }
        JobTask cancellable = new JobTask(now + this.timeoutMillis, job);
        head.addLast((LockFreeLinkedListNode)cancellable);
        this.process(now, head, this.cancelled);
        if (this.cancelled) {
            cancellable.cancel();
            throw (Throwable)new CancellationException();
        }
        return cancellable;
    }

    public final void cancel() {
        this.cancelled = true;
        this.process();
    }

    public final void process() {
        this.process(((Number)this.clock.invoke()).longValue(), this.head, this.cancelled);
    }

    @Nullable
    public final <T> Object withTimeout(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        Object object;
        Object object2;
        Continuation<? super T> rawContinuation = $completion;
        boolean bl = false;
        Continuation continuation = IntrinsicsKt.intercepted(rawContinuation);
        WeakTimeoutCoroutine wrapped = new WeakTimeoutCoroutine(continuation.getContext(), continuation, null, 4, null);
        Registration handle = this.register(wrapped);
        wrapped.invokeOnCompletion((Function1<Throwable, Unit>)((Function1)handle));
        try {
            Object object3;
            if (wrapped.isCancelled()) {
                object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            } else {
                object2 = block;
                boolean bl2 = false;
                Object object4 = object2;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type (R, kotlin.coroutines.Continuation<T>) -> kotlin.Any?");
                }
                object3 = ((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(object4, (int)2)).invoke(wrapped, (Object)wrapped);
            }
            object2 = object3;
        }
        catch (Throwable t) {
            if (wrapped.tryComplete()) {
                handle.dispose();
                throw t;
            }
            object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        Object result2 = object2;
        if (result2 != IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            if (wrapped.tryComplete()) {
                handle.dispose();
                object = result2;
            } else {
                object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            }
        } else {
            object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void process(long now, LockFreeLinkedListHead head, boolean cancelled) {
        while (true) {
            Cancellable p;
            Object object;
            if (!((object = head.getNext()) instanceof Cancellable)) {
                object = null;
            }
            if ((Cancellable)object == null) {
                break;
            }
            if (!cancelled && p.getDeadline() > now) break;
            if (!p.isActive() || !p.remove()) continue;
            p.cancel();
        }
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public WeakTimeoutQueue(long timeoutMillis, @NotNull Function0<Long> clock) {
        Intrinsics.checkParameterIsNotNull(clock, (String)"clock");
        this.timeoutMillis = timeoutMillis;
        this.clock = clock;
        this.head = new LockFreeLinkedListHead();
    }

    public /* synthetic */ WeakTimeoutQueue(long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(l, (Function0<Long>)function0);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002#\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00072\u00020\bJ\u0013\u0010\t\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a8\u0006\n"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "cause", "", "Lkotlinx/coroutines/CompletionHandler;", "Lkotlinx/coroutines/DisposableHandle;", "invoke", "ktor-http-cio"})
    public static interface Registration
    extends Function1<Throwable, Unit>,
    DisposableHandle {
        public void invoke(@Nullable Throwable var1);

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void invoke(Registration $this, @Nullable Throwable cause) {
                $this.dispose();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "Lio/ktor/util/internal/LockFreeLinkedListNode;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "deadline", "", "(J)V", "getDeadline", "()J", "isActive", "", "()Z", "cancel", "", "dispose", "ktor-http-cio"})
    private static abstract class Cancellable
    extends LockFreeLinkedListNode
    implements Registration {
        private final long deadline;

        public boolean isActive() {
            return !this.isRemoved();
        }

        public abstract void cancel();

        public void dispose() {
            this.remove();
        }

        public final long getDeadline() {
            return this.deadline;
        }

        public Cancellable(long deadline) {
            this.deadline = deadline;
        }

        @Override
        public void invoke(@Nullable Throwable cause) {
            Registration.DefaultImpls.invoke(this, cause);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$JobTask;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "deadline", "", "job", "Lkotlinx/coroutines/Job;", "(JLkotlinx/coroutines/Job;)V", "isActive", "", "()Z", "cancel", "", "ktor-http-cio"})
    private static final class JobTask
    extends Cancellable {
        private final Job job;

        @Override
        public boolean isActive() {
            return super.isActive() && this.job.isActive();
        }

        @Override
        public void cancel() {
            Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
        }

        public JobTask(long deadline, @NotNull Job job) {
            Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
            super(deadline);
            this.job = job;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u00032\u00020\u0004B'\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0097\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u0097\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001c\u0010\u0011\u001a\u00020\u00152\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0097\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0016J\"\u0010\u0011\u001a\u00020\u00102\u0010\b\u0002\u0010\u0014\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018H\u0096\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0019J8\u0010\u001f\u001a\u00028\u0001\"\u0004\b\u0001\u0010\u001a2\u0006\u0010\u001b\u001a\u00028\u00012\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00028\u00010\u001cH\u0096\u0001\u00a2\u0006\u0004\b\u001f\u0010 J*\u0010$\u001a\u0004\u0018\u00018\u0001\"\b\b\u0001\u0010!*\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0096\u0003\u00a2\u0006\u0004\b$\u0010%J\u0014\u0010&\u001a\u00060\u0017j\u0002`\u0018H\u0097\u0001\u00a2\u0006\u0004\b&\u0010'JM\u00100\u001a\u00020/2\b\b\u0002\u0010(\u001a\u00020\u00152\b\b\u0002\u0010)\u001a\u00020\u00152'\u0010.\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00100*j\u0002`-H\u0097\u0001\u00a2\u0006\u0004\b0\u00101J9\u00100\u001a\u00020/2'\u0010.\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00100*j\u0002`-H\u0096\u0001\u00a2\u0006\u0004\b0\u00102J\u0013\u00103\u001a\u00020\u0010H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00104J\u001c\u00105\u001a\u00020\u00052\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\"H\u0096\u0001\u00a2\u0006\u0004\b5\u00106J\u0018\u00107\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0096\u0003\u00a2\u0006\u0004\b7\u00108J\u0018\u00107\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0097\u0003\u00a2\u0006\u0004\b7\u0010:J \u0010=\u001a\u00020\u00102\f\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000;H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>J\u0010\u0010?\u001a\u00020\u0015H\u0096\u0001\u00a2\u0006\u0004\b?\u0010@J\r\u0010A\u001a\u00020\u0015\u00a2\u0006\u0004\bA\u0010@R\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030B8\u0016@\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001c\u0010\u0006\u001a\u00020\u00058\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010F\u001a\u0004\bG\u0010HR\u0016\u0010J\u001a\u00020\u00058V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010HR\u0016\u0010K\u001a\u00020\u00158\u0016@\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u0010@R\u0016\u0010L\u001a\u00020\u00158\u0016@\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bL\u0010@R\u0016\u0010M\u001a\u00020\u00158\u0016@\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u0010@R\u0019\u0010\b\u001a\u00020\u00038\u0006@\u0006\u00a2\u0006\f\n\u0004\b\b\u0010N\u001a\u0004\bO\u0010PR\u001a\u0010#\u001a\u0006\u0012\u0002\b\u00030\"8\u0016@\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0016\u0010V\u001a\u00020S8\u0016@\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006W"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$WeakTimeoutCoroutine;", "T", "Lkotlin/coroutines/Continuation;", "Lkotlinx/coroutines/Job;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/CoroutineContext;", "context", "delegate", "job", "<init>", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;Lkotlinx/coroutines/Job;)V", "Lkotlinx/coroutines/ChildJob;", "child", "Lkotlinx/coroutines/ChildHandle;", "attachChild", "(Lkotlinx/coroutines/ChildJob;)Lkotlinx/coroutines/ChildHandle;", "", "cancel", "()V", "", "cause", "", "(Ljava/lang/Throwable;)Z", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "(Ljava/util/concurrent/CancellationException;)V", "R", "initial", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext$Element;", "operation", "fold", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "E", "Lkotlin/coroutines/CoroutineContext$Key;", "key", "get", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;", "getCancellationException", "()Ljava/util/concurrent/CancellationException;", "onCancelling", "invokeImmediately", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lkotlinx/coroutines/CompletionHandler;", "handler", "Lkotlinx/coroutines/DisposableHandle;", "invokeOnCompletion", "(ZZLkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/DisposableHandle;", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/DisposableHandle;", "join", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "minusKey", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext;", "plus", "(Lkotlin/coroutines/CoroutineContext;)Lkotlin/coroutines/CoroutineContext;", "other", "(Lkotlinx/coroutines/Job;)Lkotlinx/coroutines/Job;", "Lkotlin/Result;", "result", "resumeWith", "(Ljava/lang/Object;)V", "start", "()Z", "tryComplete", "Lkotlin/sequences/Sequence;", "getChildren", "()Lkotlin/sequences/Sequence;", "children", "Lkotlin/coroutines/CoroutineContext;", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "coroutineContext", "isActive", "isCancelled", "isCompleted", "Lkotlinx/coroutines/Job;", "getJob", "()Lkotlinx/coroutines/Job;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "Lkotlinx/coroutines/selects/SelectClause0;", "getOnJoin", "()Lkotlinx/coroutines/selects/SelectClause0;", "onJoin", "ktor-http-cio"})
    private static final class WeakTimeoutCoroutine<T>
    implements Continuation<T>,
    Job,
    CoroutineScope {
        @NotNull
        private final CoroutineContext context;
        private volatile Object state;
        private static final AtomicReferenceFieldUpdater state$FU = AtomicReferenceFieldUpdater.newUpdater(WeakTimeoutCoroutine.class, Object.class, "state");
        @NotNull
        private final Job job;

        @NotNull
        public CoroutineContext getContext() {
            return this.context;
        }

        @NotNull
        public CoroutineContext getCoroutineContext() {
            return this.getContext();
        }

        public void resumeWith(@NotNull Object result2) {
            block1: {
                Continuation it;
                Object upd$iv;
                Object cur$iv;
                WeakTimeoutCoroutine $this$getAndUpdate$iv = this;
                boolean $i$f$getAndUpdate = false;
                do {
                    cur$iv = $this$getAndUpdate$iv.state;
                    it = (Continuation)cur$iv;
                    boolean bl = false;
                    if (it != null) continue;
                    return;
                } while (!state$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = null));
                Continuation continuation = (Continuation)cur$iv;
                if (continuation == null) break block1;
                Continuation continuation2 = continuation;
                boolean bl = false;
                boolean bl2 = false;
                it = continuation2;
                boolean bl3 = false;
                it.resumeWith(result2);
                Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
            }
        }

        public final boolean tryComplete() {
            Object upd$iv;
            Object cur$iv;
            WeakTimeoutCoroutine $this$update$iv = this;
            boolean $i$f$update = false;
            do {
                cur$iv = $this$update$iv.state;
                Continuation it = (Continuation)cur$iv;
                boolean bl = false;
                if (it instanceof Continuation) continue;
                return false;
            } while (!state$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = null));
            Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
            return true;
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        public WeakTimeoutCoroutine(@NotNull CoroutineContext context, @NotNull Continuation<? super T> delegate, @NotNull Job job) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
            this.job = job;
            this.context = context.plus((CoroutineContext)this.job);
            this.state = delegate;
            Job job2 = (Job)context.get((CoroutineContext.Key)Job.Key);
            if (job2 != null) {
                Job job3 = job2;
                boolean bl = false;
                boolean bl2 = false;
                Job parent = job3;
                boolean bl3 = false;
                Job.DefaultImpls.invokeOnCompletion$default((Job)parent, (boolean)true, (boolean)false, (Function1)((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ WeakTimeoutCoroutine this$0;
                    {
                        this.this$0 = weakTimeoutCoroutine;
                        super(1);
                    }

                    public final void invoke(@Nullable Throwable it) {
                        if (it != null) {
                            WeakTimeoutCoroutine weakTimeoutCoroutine = this.this$0;
                            boolean bl = false;
                            Result.Companion companion = Result.Companion;
                            WeakTimeoutCoroutine weakTimeoutCoroutine2 = weakTimeoutCoroutine;
                            boolean bl2 = false;
                            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
                            weakTimeoutCoroutine2.resumeWith(object);
                            Job.DefaultImpls.cancel$default((Job)this.this$0.getJob(), null, (int)1, null);
                        }
                    }
                }), (int)2, null);
            }
            this.job.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(){

                public final void invoke(@Nullable Throwable it) {
                    WeakTimeoutCoroutine weakTimeoutCoroutine = this;
                    Throwable throwable = it;
                    if (throwable == null) {
                        throwable = new CancellationException();
                    }
                    Throwable throwable2 = throwable;
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    WeakTimeoutCoroutine weakTimeoutCoroutine2 = weakTimeoutCoroutine;
                    boolean bl2 = false;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    weakTimeoutCoroutine2.resumeWith(object);
                }
            });
        }

        public /* synthetic */ WeakTimeoutCoroutine(CoroutineContext coroutineContext, Continuation continuation, Job job, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                job = (Job)JobKt.Job((Job)((Job)coroutineContext.get((CoroutineContext.Key)Job.Key)));
            }
            this(coroutineContext, continuation, job);
        }

        @NotNull
        public Sequence<Job> getChildren() {
            return this.job.getChildren();
        }

        public boolean isActive() {
            return this.job.isActive();
        }

        public boolean isCancelled() {
            return this.job.isCancelled();
        }

        public boolean isCompleted() {
            return this.job.isCompleted();
        }

        @NotNull
        public CoroutineContext.Key<?> getKey() {
            return this.job.getKey();
        }

        @NotNull
        public SelectClause0 getOnJoin() {
            return this.job.getOnJoin();
        }

        @InternalCoroutinesApi
        @NotNull
        public ChildHandle attachChild(@NotNull ChildJob child) {
            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
            return this.job.attachChild(child);
        }

        @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
        public /* synthetic */ void cancel() {
            this.job.cancel();
        }

        @Deprecated(message="Since 1.2.0, binary compatibility with versions <= 1.1.x", level=DeprecationLevel.HIDDEN)
        public /* synthetic */ boolean cancel(@Nullable Throwable cause) {
            return this.job.cancel(cause);
        }

        public void cancel(@Nullable CancellationException cause) {
            this.job.cancel(cause);
        }

        public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            return (R)this.job.fold(initial, operation);
        }

        @Nullable
        public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return (E)this.job.get(key);
        }

        @InternalCoroutinesApi
        @NotNull
        public CancellationException getCancellationException() {
            return this.job.getCancellationException();
        }

        @InternalCoroutinesApi
        @NotNull
        public DisposableHandle invokeOnCompletion(boolean onCancelling, boolean invokeImmediately, @NotNull Function1<? super Throwable, Unit> handler) {
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            return this.job.invokeOnCompletion(onCancelling, invokeImmediately, handler);
        }

        @NotNull
        public DisposableHandle invokeOnCompletion(@NotNull Function1<? super Throwable, Unit> handler) {
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            return this.job.invokeOnCompletion(handler);
        }

        @Nullable
        public Object join(@NotNull Continuation<? super Unit> continuation) {
            return this.job.join(continuation);
        }

        @NotNull
        public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return this.job.minusKey(key);
        }

        @NotNull
        public CoroutineContext plus(@NotNull CoroutineContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return this.job.plus(context);
        }

        @Deprecated(message="Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.", level=DeprecationLevel.ERROR)
        @NotNull
        public Job plus(@NotNull Job other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return this.job.plus(other);
        }

        public boolean start() {
            return this.job.start();
        }
    }
}

