/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth.ldap;

import io.ktor.server.auth.Credential;
import io.ktor.server.auth.UserIdPrincipal;
import io.ktor.server.auth.UserPasswordCredential;
import io.ktor.server.auth.ldap.LdapKt;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\u001av\u0010\u0002\u001a\u0004\u0018\u0001H\u0003\"\b\b\u0000\u0010\u0004*\u00020\u0005\"\b\b\u0001\u0010\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00042\u0006\u0010\b\u001a\u00020\t2\"\b\u0002\u0010\n\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\f\u0012\u0004\u0012\u00020\r0\u000b2\u001f\u0010\u000e\u001a\u001b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u0004\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u000f\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\u0010\u0012\u001a \u0010\u0002\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t\u001aA\u0010\u0002\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u001f\u0010\u0016\u001a\u001b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000f\u00a2\u0006\u0002\b\u0011\u001a\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a2\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\t2 \u0010\n\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"ESCAPE_CHARACTERS", "", "ldapAuthenticate", "P", "K", "Lio/ktor/server/auth/Credential;", "", "credential", "ldapServerURL", "", "ldapEnvironmentBuilder", "Lkotlin/Function1;", "", "", "doVerify", "Lkotlin/Function2;", "Ljavax/naming/directory/InitialDirContext;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/auth/Credential;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Lio/ktor/server/auth/UserIdPrincipal;", "Lio/ktor/server/auth/UserPasswordCredential;", "userDNFormat", "validate", "ldapEscape", "string", "ldapEscapeImpl", "firstIndex", "", "ldapLogin", "ldapURL", "shouldEscape", "", "", "ktor-server-auth-ldap"})
public final class LdapKt {
    @NotNull
    private static final char[] ESCAPE_CHARACTERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <K extends Credential, P> P ldapAuthenticate(@NotNull K credential, @NotNull String ldapServerURL, @NotNull Function1<? super Map<String, Object>, Unit> ldapEnvironmentBuilder, @NotNull Function2<? super InitialDirContext, ? super K, ? extends P> doVerify) {
        Object object;
        Intrinsics.checkNotNullParameter(credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)ldapServerURL, (String)"ldapServerURL");
        Intrinsics.checkNotNullParameter(ldapEnvironmentBuilder, (String)"ldapEnvironmentBuilder");
        Intrinsics.checkNotNullParameter(doVerify, (String)"doVerify");
        try {
            Object object2;
            try (InitialDirContext root = LdapKt.ldapLogin(ldapServerURL, ldapEnvironmentBuilder);){
                object2 = doVerify.invoke((Object)root, credential);
            }
            object = object2;
        }
        catch (NamingException ne) {
            object = null;
        }
        return (P)object;
    }

    public static /* synthetic */ Object ldapAuthenticate$default(Credential credential, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = ldapAuthenticate.1.INSTANCE;
        }
        return LdapKt.ldapAuthenticate(credential, string, (Function1<? super Map<String, Object>, Unit>)function1, function2);
    }

    @Nullable
    public static final UserIdPrincipal ldapAuthenticate(@NotNull UserPasswordCredential credential, @NotNull String ldapServerURL, @NotNull String userDNFormat, @NotNull Function2<? super InitialDirContext, ? super UserPasswordCredential, UserIdPrincipal> validate) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)ldapServerURL, (String)"ldapServerURL");
        Intrinsics.checkNotNullParameter((Object)userDNFormat, (String)"userDNFormat");
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        Function1 configurator2 = (Function1)new Function1<Map<String, Object>, Unit>(userDNFormat, credential){
            final /* synthetic */ String $userDNFormat;
            final /* synthetic */ UserPasswordCredential $credential;
            {
                this.$userDNFormat = $userDNFormat;
                this.$credential = $credential;
                super(1);
            }

            public final void invoke(@NotNull Map<String, Object> env) {
                Intrinsics.checkNotNullParameter(env, (String)"env");
                env.put("java.naming.security.authentication", "simple");
                Map<String, Object> map = env;
                String string = "java.naming.security.principal";
                String string2 = this.$userDNFormat;
                Object[] objectArray = new Object[]{LdapKt.ldapEscape(this.$credential.getName())};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                string2 = string3;
                map.put(string, string2);
                env.put("java.naming.security.credentials", this.$credential.getPassword());
            }
        };
        return LdapKt.ldapAuthenticate((Credential)credential, ldapServerURL, (Function1<? super Map<String, Object>, Unit>)configurator2, validate);
    }

    @Nullable
    public static final UserIdPrincipal ldapAuthenticate(@NotNull UserPasswordCredential credential, @NotNull String ldapServerURL, @NotNull String userDNFormat) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)ldapServerURL, (String)"ldapServerURL");
        Intrinsics.checkNotNullParameter((Object)userDNFormat, (String)"userDNFormat");
        return LdapKt.ldapAuthenticate(credential, ldapServerURL, userDNFormat, (Function2<? super InitialDirContext, ? super UserPasswordCredential, UserIdPrincipal>)((Function2)ldapAuthenticate.2.INSTANCE));
    }

    private static final InitialDirContext ldapLogin(String ldapURL, Function1<? super Map<String, Object>, Unit> ldapEnvironmentBuilder) {
        Hashtable env = new Hashtable();
        ((Map)env).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ((Map)env).put("java.naming.provider.url", ldapURL);
        ldapEnvironmentBuilder.invoke(env);
        return new InitialDirContext(env);
    }

    @NotNull
    public static final String ldapEscape(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int index = 0;
        int n = StringsKt.getLastIndex((CharSequence)string);
        if (index <= n) {
            while (true) {
                char character;
                if (LdapKt.shouldEscape(character = string.charAt(index))) {
                    return LdapKt.ldapEscapeImpl(string, index);
                }
                if (index == n) break;
                ++index;
            }
        }
        return string;
    }

    private static final String ldapEscapeImpl(String string, int firstIndex) {
        StringBuilder stringBuilder;
        StringBuilder $this$ldapEscapeImpl_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int lastIndex = 0;
        int index = firstIndex;
        int n = StringsKt.getLastIndex((CharSequence)string);
        if (index <= n) {
            while (true) {
                char character;
                if (LdapKt.shouldEscape(character = string.charAt(index))) {
                    $this$ldapEscapeImpl_u24lambda_u241.append(string, lastIndex, index);
                    if (ArraysKt.contains((char[])ESCAPE_CHARACTERS, (char)character)) {
                        $this$ldapEscapeImpl_u24lambda_u241.append('\\');
                        $this$ldapEscapeImpl_u24lambda_u241.append(character);
                    } else {
                        byte[] encoded;
                        Intrinsics.checkNotNullExpressionValue((Object)String.valueOf(character).getBytes(Charsets.UTF_8), (String)"this as java.lang.String).getBytes(charset)");
                        boolean bl2 = false;
                        int n2 = encoded.length;
                        for (int byteIndex = 0; byteIndex < n2; ++byteIndex) {
                            int unsignedValue = encoded[byteIndex] & 0xFF;
                            $this$ldapEscapeImpl_u24lambda_u241.append('\\');
                            String string2 = Integer.toString(unsignedValue, CharsKt.checkRadix((int)16));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                            $this$ldapEscapeImpl_u24lambda_u241.append(StringsKt.padStart((String)string2, (int)2, (char)'0'));
                        }
                    }
                    lastIndex = index + 1;
                }
                if (index == n) break;
                ++index;
            }
        }
        $this$ldapEscapeImpl_u24lambda_u241.append(string, lastIndex, string.length());
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    private static final boolean shouldEscape(char $this$shouldEscape) {
        boolean bl;
        block1: {
            char c;
            block0: {
                char codepoint = $this$shouldEscape;
                boolean bl2 = false;
                c = codepoint;
                boolean bl3 = '?' <= c ? c < '\u007f' : false;
                if (!bl3) break block0;
                bl = codepoint == '\\';
                break block1;
            }
            bl = ('-' <= c ? c < ';' : false) ? false : (('$' <= c ? c < '+' : false) ? false : c != '!');
        }
        return bl;
    }

    static {
        char[] cArray = new char[]{' ', '\"', '#', '+', ',', ';', '<', '=', '>', '\\'};
        ESCAPE_CHARACTERS = cArray;
    }
}

