/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.testing.suites;

import io.ktor.server.application.Application;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.EmbeddedServerKt;
import io.ktor.server.testing.suites.ConfigTestSuite;
import io.ktor.server.testing.suites.ConfigTestSuiteKt;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/ktor/server/testing/suites/ConfigTestSuite;", "", "engine", "Lio/ktor/server/engine/ApplicationEngineFactory;", "(Lio/ktor/server/engine/ApplicationEngineFactory;)V", "getEngine", "()Lio/ktor/server/engine/ApplicationEngineFactory;", "testStartOnceWhenException", "", "testStartsOnceWithCapture", "ktor-server-test-suites"})
public abstract class ConfigTestSuite {
    @NotNull
    private final ApplicationEngineFactory<?, ?> engine;

    public ConfigTestSuite(@NotNull ApplicationEngineFactory<?, ?> engine) {
        Intrinsics.checkNotNullParameter(engine, (String)"engine");
        this.engine = engine;
    }

    @NotNull
    public final ApplicationEngineFactory<?, ?> getEngine() {
        return this.engine;
    }

    @Test
    public final void testStartOnceWhenException() {
        ApplicationEngine server2 = EmbeddedServerKt.embeddedServer$default(this.engine, (int)0, null, null, null, (Function1)testStartOnceWhenException.server.1.INSTANCE, (int)30, null);
        boolean $i$f$assertFailsWith = false;
        boolean failed$iv = false;
        try {
            boolean bl = false;
            ApplicationEngine.DefaultImpls.start$default((ApplicationEngine)server2, (boolean)false, (int)1, null);
        }
        catch (Throwable cause$iv) {
            failed$iv = true;
            Assert.assertTrue((boolean)(cause$iv instanceof IllegalStateException));
        }
        Assert.assertTrue((boolean)failed$iv);
        Assert.assertEquals((Object)1, (Object)ConfigTestSuiteKt.getCount());
        ApplicationEngineJvmKt.stop((ApplicationEngine)server2, (long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public final void testStartsOnceWithCapture() {
        Ref.IntRef counter = new Ref.IntRef();
        ApplicationEngine server2 = EmbeddedServerKt.embeddedServer$default(this.engine, (int)0, null, null, null, (Function1)((Function1)new Function1<Application, Unit>(counter){
            final /* synthetic */ Ref.IntRef $counter;
            {
                this.$counter = $counter;
                super(1);
            }

            public final void invoke(@NotNull Application $this$embeddedServer) {
                Intrinsics.checkNotNullParameter((Object)$this$embeddedServer, (String)"$this$embeddedServer");
                int n = this.$counter.element;
                this.$counter.element = n + 1;
                throw new IllegalStateException("Foo".toString());
            }
        }), (int)30, null);
        boolean $i$f$assertFailsWith = false;
        boolean failed$iv = false;
        try {
            boolean bl = false;
            ApplicationEngine.DefaultImpls.start$default((ApplicationEngine)server2, (boolean)false, (int)1, null);
        }
        catch (Throwable cause$iv) {
            failed$iv = true;
            Assert.assertTrue((boolean)(cause$iv instanceof IllegalStateException));
        }
        Assert.assertTrue((boolean)failed$iv);
        Assert.assertEquals((Object)1, (Object)counter.element);
        ApplicationEngineJvmKt.stop((ApplicationEngine)server2, (long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }
}

