/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.tomcat.jakarta;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.http.HttpHeaders;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineConnectorConfigJvmKt;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.servlet.jakarta.DefaultServletUpgrade;
import io.ktor.server.servlet.jakarta.KtorServlet;
import io.ktor.server.servlet.jakarta.ServletUpgrade;
import io.ktor.server.tomcat.jakarta.TomcatApplicationEngine;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import org.apache.catalina.Context;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.apache.tomcat.util.net.openssl.OpenSSLImplementation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001&\u0018\u0000 ,2\u00020\u0001:\u0002-,B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001bR#\u0010\"\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0018\u0010$\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/events/Events;", "monitor", "", "developmentMode", "Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Configuration;", "configuration", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;Lio/ktor/events/Events;ZLio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Configuration;Lkotlin/jvm/functions/Function0;)V", "wait", "start", "(Z)Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine;", "", "gracePeriodMillis", "timeoutMillis", "", "stop", "(JJ)V", "Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Configuration;", "getConfiguration", "()Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Configuration;", "Lkotlin/jvm/functions/Function0;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "tempDirectory$delegate", "Lkotlin/Lazy;", "getTempDirectory", "()Ljava/nio/file/Path;", "tempDirectory", "Lkotlinx/coroutines/CompletableJob;", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "io/ktor/server/tomcat/jakarta/TomcatApplicationEngine$ktorServlet$1", "ktorServlet", "Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$ktorServlet$1;", "Lorg/apache/catalina/startup/Tomcat;", "server", "Lorg/apache/catalina/startup/Tomcat;", "Companion", "Configuration", "ktor-server-tomcat-jakarta"})
@SourceDebugExtension(value={"SMAP\nTomcatApplicationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomcatApplicationEngine.kt\nio/ktor/server/tomcat/jakarta/TomcatApplicationEngine\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n13409#2,2:224\n1863#3:226\n1864#3:229\n1557#3:231\n1628#3,3:232\n37#4,2:227\n1#5:230\n*S KotlinDebug\n*F\n+ 1 TomcatApplicationEngine.kt\nio/ktor/server/tomcat/jakarta/TomcatApplicationEngine\n*L\n69#1:224,2\n73#1:226\n73#1:229\n162#1:231\n162#1:232,3\n120#1:227,2\n*E\n"})
public final class TomcatApplicationEngine
extends BaseApplicationEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Function0<Application> applicationProvider;
    @NotNull
    private final Lazy tempDirectory$delegate;
    @Nullable
    private CompletableJob cancellationDeferred;
    @NotNull
    private final ktorServlet.1 ktorServlet;
    @NotNull
    private final Tomcat server;
    @NotNull
    private volatile /* synthetic */ int stopped;
    private static final /* synthetic */ AtomicIntegerFieldUpdater stopped$FU;
    @NotNull
    private static final List<String> nativeNames = CollectionsKt.listOf((Object)"netty-tcnative-windows-x86_64");

    /*
     * WARNING - void declaration
     */
    public TomcatApplicationEngine(@NotNull ApplicationEnvironment environment, @NotNull Events monitor, boolean developmentMode, @NotNull Configuration configuration, @NotNull Function0<Application> applicationProvider) {
        Wrapper wrapper;
        Service service;
        void $this$server_u24lambda_u2410;
        Tomcat tomcat;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        super(environment, monitor, developmentMode, null, 8, null);
        this.configuration = configuration;
        this.applicationProvider = applicationProvider;
        this.tempDirectory$delegate = LazyKt.lazy(TomcatApplicationEngine::tempDirectory_delegate$lambda$0);
        this.ktorServlet = new KtorServlet(this){
            final /* synthetic */ TomcatApplicationEngine this$0;
            {
                this.this$0 = $receiver;
            }

            protected Set<String> getManagedByEngineHeaders() {
                return SetsKt.setOf((Object)HttpHeaders.INSTANCE.getTransferEncoding());
            }

            protected EnginePipeline getEnginePipeline() {
                return this.this$0.getPipeline();
            }

            protected Application getApplication() {
                return (Application)TomcatApplicationEngine.access$getApplicationProvider$p(this.this$0).invoke();
            }

            protected ServletUpgrade getUpgrade() {
                return (ServletUpgrade)DefaultServletUpgrade.INSTANCE;
            }

            protected Logger getLogger() {
                return this.this$0.getEnvironment().getLog();
            }

            public CoroutineContext getCoroutineContext() {
                return super.getCoroutineContext().plus(this.getApplication().getParentCoroutineContext());
            }
        };
        Tomcat tomcat2 = tomcat = new Tomcat();
        TomcatApplicationEngine tomcatApplicationEngine = this;
        boolean bl = false;
        this.configuration.getConfigureTomcat().invoke((Object)$this$server_u24lambda_u2410);
        Service $this$server_u24lambda_u2410_u24lambda_u247 = service = $this$server_u24lambda_u2410.getService();
        boolean bl22 = false;
        Connector[] connectorArray = $this$server_u24lambda_u2410_u24lambda_u247.findConnectors();
        Intrinsics.checkNotNullExpressionValue((Object)connectorArray, (String)"findConnectors(...)");
        Object $this$forEach$iv = connectorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Connector existing = (Connector)element$iv;
            boolean bl3 = false;
            $this$server_u24lambda_u2410_u24lambda_u247.removeConnector(existing);
        }
        $this$forEach$iv = this.configuration.getConnectors();
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245;
            Connector connector;
            Object element$iv = iterator.next();
            EngineConnectorConfig ktorConnector = (EngineConnectorConfig)element$iv;
            boolean bl4 = false;
            Connector connector2 = connector = new Connector();
            Service service2 = $this$server_u24lambda_u2410_u24lambda_u247;
            boolean bl5 = false;
            $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setPort(ktorConnector.getPort());
            if (ktorConnector instanceof EngineSSLConnectorConfig) {
                void $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u242;
                SSLHostConfigCertificate sSLHostConfigCertificate;
                void $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244;
                SSLHostConfig sSLHostConfig;
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setSecure(true);
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setScheme("https");
                if (((EngineSSLConnectorConfig)ktorConnector).getKeyStorePath() == null) {
                    throw new IllegalArgumentException("Tomcat requires keyStorePath. Make sure you're setting the property in the EngineSSLConnectorConfig class.");
                }
                if (((EngineSSLConnectorConfig)ktorConnector).getTrustStore() != null && ((EngineSSLConnectorConfig)ktorConnector).getTrustStorePath() == null) {
                    throw new IllegalArgumentException("Tomcat requires trustStorePath for client certificate authentication.Make sure you're setting the property in the EngineSSLConnectorConfig class.");
                }
                SSLHostConfig sSLHostConfig2 = sSLHostConfig = new SSLHostConfig();
                void var24_32 = $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                boolean bl6 = false;
                if (((EngineSSLConnectorConfig)ktorConnector).getTrustStorePath() != null) {
                    $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setProperty("clientAuth", "true");
                    File file = ((EngineSSLConnectorConfig)ktorConnector).getTrustStorePath();
                    Intrinsics.checkNotNull((Object)file);
                    $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setTruststoreFile(file.getAbsolutePath());
                } else {
                    $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setProperty("clientAuth", "false");
                }
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setSslProtocol("TLS");
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setProperty("SSLEnabled", "true");
                SSLHostConfigCertificate sSLHostConfigCertificate2 = sSLHostConfigCertificate = new SSLHostConfigCertificate((SSLHostConfig)$this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244, SSLHostConfigCertificate.Type.UNDEFINED);
                void var28_36 = $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244;
                boolean bl7 = false;
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u242.setCertificateKeyAlias(((EngineSSLConnectorConfig)ktorConnector).getKeyAlias());
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u242.setCertificateKeystorePassword(new String((char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke()));
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u242.setCertificateKeyPassword(new String((char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke()));
                File file = ((EngineSSLConnectorConfig)ktorConnector).getKeyStorePath();
                Intrinsics.checkNotNull((Object)file);
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u242.setCertificateKeystoreFile(file.getAbsolutePath());
                var28_36.addCertificate(sSLHostConfigCertificate);
                if (((EngineSSLConnectorConfig)ktorConnector).getEnabledProtocols() != null) {
                    List it;
                    boolean bl8 = false;
                    Collection $this$toTypedArray$iv = it;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setEnabledProtocols(thisCollection$iv.toArray(new String[0]));
                }
                var24_32.addSslHostConfig(sSLHostConfig);
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setProperty("SSLEnabled", "true");
                Class sslImpl = TomcatApplicationEngine.Companion.chooseSSLImplementation();
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setProperty("sslImplementationName", sslImpl.getName());
                if (Intrinsics.areEqual((Object)sslImpl.getSimpleName(), (Object)"OpenSSLImplementation")) {
                    $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
                }
            } else {
                $this$server_u24lambda_u2410_u24lambda_u247_u24lambda_u246_u24lambda_u245.setScheme("http");
            }
            service2.addConnector(connector);
        }
        if ($this$server_u24lambda_u2410.getConnector() == null) {
            void v3 = $this$server_u24lambda_u2410;
            Connector[] connectorArray2 = $this$server_u24lambda_u2410.getService().findConnectors();
            if (connectorArray2 == null || (connectorArray2 = (Connector[])ArraysKt.firstOrNull((Object[])connectorArray2)) == null) {
                void $this$server_u24lambda_u2410_u24lambda_u248;
                Connector bl22 = new Connector();
                $this$forEach$iv = bl22;
                void var34_43 = v3;
                boolean bl9 = false;
                $this$server_u24lambda_u2410_u24lambda_u248.setPort(80);
                v3 = var34_43;
                connectorArray2 = bl22;
            }
            v3.setConnector((Connector)connectorArray2);
        }
        $this$server_u24lambda_u2410.setBaseDir(((Object)this.getTempDirectory()).toString());
        Context ctx = $this$server_u24lambda_u2410.addContext("", ((Object)this.getTempDirectory()).toString());
        Wrapper $this$server_u24lambda_u2410_u24lambda_u249 = wrapper = Tomcat.addServlet((Context)ctx, (String)"ktor-servlet", (Servlet)((Servlet)this.ktorServlet));
        boolean bl10 = false;
        $this$server_u24lambda_u2410_u24lambda_u249.addMapping("/*");
        $this$server_u24lambda_u2410_u24lambda_u249.setAsyncSupported(true);
        $this$server_u24lambda_u2410_u24lambda_u249.setMultipartConfigElement(new MultipartConfigElement(""));
        tomcatApplicationEngine.server = tomcat;
        this.stopped = 0;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    private final Path getTempDirectory() {
        Lazy lazy = this.tempDirectory$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TomcatApplicationEngine start(boolean wait) {
        void $this$mapTo$iv$iv;
        this.server.start();
        Connector[] connectorArray = this.server.getService().findConnectors();
        Intrinsics.checkNotNullExpressionValue((Object)connectorArray, (String)"findConnectors(...)");
        Iterable $this$map$iv = ArraysKt.zip((Object[])connectorArray, (Iterable)this.configuration.getConnectors());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EngineConnectorConfigJvmKt.withPort((EngineConnectorConfig)((EngineConnectorConfig)it.getSecond()), (int)((Connector)it.getFirst()).getLocalPort()));
        }
        List connectors = (List)destination$iv$iv;
        this.getResolvedConnectorsDeferred().complete((Object)connectors);
        EventsKt.raiseCatching((Events)this.getMonitor(), (EventDefinition)DefaultApplicationEventsKt.getServerReady(), (Object)this.getEnvironment(), (Logger)this.getEnvironment().getLog());
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)((ApplicationEngine)this), (Application)((Application)this.applicationProvider.invoke()), (long)this.configuration.getShutdownGracePeriod(), (long)this.configuration.getShutdownTimeout());
        if (wait) {
            this.server.getServer().await();
            this.stop(this.configuration.getShutdownGracePeriod(), this.configuration.getShutdownTimeout());
        }
        return this;
    }

    public void stop(long gracePeriodMillis, long timeoutMillis) {
        if (!stopped$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        this.server.stop();
        this.server.destroy();
        File file = this.getTempDirectory().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.deleteRecursively((File)file);
    }

    private static final Path tempDirectory_delegate$lambda$0() {
        return Files.createTempDirectory("ktor-server-tomcat-jakarta-", new FileAttribute[0]);
    }

    public static final /* synthetic */ Function0 access$getApplicationProvider$p(TomcatApplicationEngine $this) {
        return $this.applicationProvider;
    }

    static {
        stopped$FU = AtomicIntegerFieldUpdater.newUpdater(TomcatApplicationEngine.class, "stopped");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Companion;", "", "<init>", "()V", "Ljava/lang/Class;", "Lorg/apache/tomcat/util/net/SSLImplementation;", "chooseSSLImplementation", "()Ljava/lang/Class;", "", "libraryName", "", "tryLoadLibrary", "(Ljava/lang/String;)Z", "", "nativeNames", "Ljava/util/List;", "ktor-server-tomcat-jakarta"})
    @SourceDebugExtension(value={"SMAP\nTomcatApplicationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomcatApplicationEngine.kt\nio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n295#2,2:224\n*S KotlinDebug\n*F\n+ 1 TomcatApplicationEngine.kt\nio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Companion\n*L\n201#1:224,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Class<? extends SSLImplementation> chooseSSLImplementation() {
            Class<JSSEImplementation> clazz;
            try {
                Class<JSSEImplementation> clazz2;
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = nativeNames;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!Companion.tryLoadLibrary(it)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                String nativeName = v0;
                if (nativeName != null) {
                    Library.initialize((String)nativeName);
                    SSL.initialize(null);
                    SSL.freeSSL((long)SSL.newSSL((long)SSL.SSL_PROTOCOL_ALL, (boolean)true));
                    clazz2 = OpenSSLImplementation.class;
                } else {
                    clazz2 = JSSEImplementation.class;
                }
                clazz = clazz2;
            }
            catch (Throwable t) {
                clazz = JSSEImplementation.class;
            }
            return clazz;
        }

        private final boolean tryLoadLibrary(String libraryName) {
            boolean bl;
            try {
                System.loadLibrary(libraryName);
                bl = true;
            }
            catch (Throwable t) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R3\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/tomcat/jakarta/TomcatApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "<init>", "()V", "Lkotlin/Function1;", "Lorg/apache/catalina/startup/Tomcat;", "", "Lkotlin/ExtensionFunctionType;", "configureTomcat", "Lkotlin/jvm/functions/Function1;", "getConfigureTomcat", "()Lkotlin/jvm/functions/Function1;", "setConfigureTomcat", "(Lkotlin/jvm/functions/Function1;)V", "ktor-server-tomcat-jakarta"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Tomcat, Unit> configureTomcat = Configuration::configureTomcat$lambda$0;

        @NotNull
        public final Function1<Tomcat, Unit> getConfigureTomcat() {
            return this.configureTomcat;
        }

        public final void setConfigureTomcat(@NotNull Function1<? super Tomcat, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureTomcat = function1;
        }

        private static final Unit configureTomcat$lambda$0(Tomcat tomcat) {
            Intrinsics.checkNotNullParameter((Object)tomcat, (String)"<this>");
            return Unit.INSTANCE;
        }
    }
}

