/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.IDecoder;
import zmq.Msg;

public abstract class DecoderBase
implements IDecoder {
    private byte[] readBuf;
    private int readPos;
    protected int toRead = 0;
    private int bufsize;
    private ByteBuffer buf;
    private int state = -1;
    boolean zeroCopy;

    public DecoderBase(int bufsize) {
        this.bufsize = bufsize;
        if (bufsize > 0) {
            this.buf = ByteBuffer.allocateDirect(bufsize);
        }
        this.readBuf = null;
        this.zeroCopy = false;
    }

    @Override
    public ByteBuffer getBuffer() {
        ByteBuffer b;
        if (this.toRead >= this.bufsize) {
            this.zeroCopy = true;
            b = ByteBuffer.wrap(this.readBuf);
            b.position(this.readPos);
        } else {
            this.zeroCopy = false;
            b = this.buf;
            b.clear();
        }
        return b;
    }

    @Override
    public int processBuffer(ByteBuffer buf, int size) {
        if (this.state() < 0) {
            return -1;
        }
        if (this.zeroCopy) {
            this.readPos += size;
            this.toRead -= size;
            while (this.toRead == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return size;
            }
            return size;
        }
        int pos = 0;
        while (true) {
            if (this.toRead == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return pos;
            }
            if (pos == size) {
                return pos;
            }
            int toCopy = Math.min(this.toRead, size - pos);
            buf.get(this.readBuf, this.readPos, toCopy);
            this.readPos += toCopy;
            pos += toCopy;
            this.toRead -= toCopy;
        }
    }

    protected void nextStep(Msg msg, int state) {
        this.nextStep(msg.data(), msg.size(), state);
    }

    protected void nextStep(byte[] buf, int toRead, int state) {
        this.readBuf = buf;
        this.readPos = 0;
        this.toRead = toRead;
        this.state = state;
    }

    protected int state() {
        return this.state;
    }

    protected void state(int state) {
        this.state = state;
    }

    protected void decodingError() {
        this.state(-1);
    }

    @Override
    public boolean stalled() {
        if (!this.next()) {
            return false;
        }
        while (this.toRead == 0) {
            if (this.next()) continue;
            return this.next();
        }
        return false;
    }

    protected abstract boolean next();
}

