/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.component.Component;
import io.kusanagi.katana.api.component.utils.Logger;
import io.kusanagi.katana.sdk.Callable;
import io.kusanagi.katana.sdk.ServiceSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Api {
    protected Component component;
    protected String path;
    protected String name;
    protected String version;
    protected String platformVersion;
    protected Map<String, String> variables;
    protected boolean isDebug;
    protected Mapping mapping;

    public Api() {
        this.variables = new HashMap<String, String>();
        this.isDebug = false;
    }

    public Api(Component component, String path, String name, String version, String platformVersion, Map<String, String> variables, boolean isDebug) {
        this.component = component;
        this.path = path;
        this.name = name;
        this.version = version;
        this.platformVersion = platformVersion;
        this.variables = variables;
        this.isDebug = isDebug;
    }

    public Api(Component component, String path, String name, String version, String platformVersion, Map<String, String> variables, boolean isDebug, Mapping mapping) {
        this.component = component;
        this.path = path;
        this.name = name;
        this.version = version;
        this.platformVersion = platformVersion;
        this.variables = variables;
        this.isDebug = isDebug;
        this.mapping = mapping;
    }

    public Api(Api other) {
        this.path = other.path;
        this.name = other.name;
        this.version = other.version;
        this.platformVersion = other.platformVersion;
        this.variables = other.variables;
        this.isDebug = other.isDebug;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    @JsonIgnore
    public boolean isDebug() {
        return this.isDebug;
    }

    @JsonIgnore
    public String getFrameworkVersion() {
        return this.platformVersion;
    }

    @JsonIgnore
    public String getPath() {
        return this.path;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Map<String, String> getVariables() {
        return this.variables;
    }

    public boolean hasVariable(String name) {
        return this.variables.containsKey(name);
    }

    @JsonIgnore
    public String getVariable(String name) {
        return this.variables.get(name);
    }

    public boolean hasResource(String name) {
        return this.component.hasResource(name);
    }

    public Callable getResource(String name) {
        return this.component.getResource(name);
    }

    public List<Map<String, String>> getServices() {
        ArrayList<Map<String, String>> services = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, ServiceSchema>> service : this.mapping.getServiceSchema().entrySet()) {
            Map<String, ServiceSchema> versions = this.mapping.getServiceSchema().get(service.getKey());
            for (Map.Entry<String, ServiceSchema> version : versions.entrySet()) {
                HashMap<String, String> serviceMap = new HashMap<String, String>();
                serviceMap.put("service", service.getKey());
                serviceMap.put("version", version.getKey());
                services.add(serviceMap);
            }
        }
        return services;
    }

    @JsonIgnore
    public ServiceSchema getServiceSchema(String name, String version) {
        if (this.mapping != null && this.mapping.getServiceSchema().containsKey(name) && this.mapping.getServiceSchema().get(name).containsKey(version)) {
            return this.mapping.getServiceSchema().get(name).get(version);
        }
        throw new IllegalArgumentException(String.format("Cannot resolve schema for service: %s (%s)", name, version));
    }

    public boolean log(String value) {
        Logger.log(4, value);
        return true;
    }

    public boolean done() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Api api = (Api)o;
        if (this.isDebug != api.isDebug) {
            return false;
        }
        if (this.component != null ? !this.component.equals(api.component) : api.component != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(api.path) : api.path != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(api.name) : api.name != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(api.version) : api.version != null) {
            return false;
        }
        if (this.platformVersion != null ? !this.platformVersion.equals(api.platformVersion) : api.platformVersion != null) {
            return false;
        }
        if (this.variables != null ? !this.variables.equals(api.variables) : api.variables != null) {
            return false;
        }
        return this.mapping != null ? this.mapping.equals(api.mapping) : api.mapping == null;
    }

    public int hashCode() {
        int result = this.component != null ? this.component.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        result = 31 * result + (this.isDebug ? 1 : 0);
        result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Api{component=" + this.component + ", path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", platformVersion='" + this.platformVersion + '\'' + ", variables=" + this.variables + ", isDebug=" + this.isDebug + ", mapping=" + this.mapping + '}';
    }

    public static abstract class Builder<T> {
        private Component component;
        private String path;
        private String name;
        private String version;
        private String platformVersion;
        private Map<String, String> variables;
        private boolean isDebug;
        private Mapping mapping;

        public Builder<T> setComponent(Component component) {
            this.component = component;
            return this;
        }

        public Builder<T> setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder<T> setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public Builder<T> setVariables(Map<String, String> variables) {
            this.variables = variables;
            return this;
        }

        public Builder<T> setDebug(boolean debug) {
            this.isDebug = debug;
            return this;
        }

        public Builder<T> setMapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public Component getComponent() {
            return this.component;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatformVersion() {
            return this.platformVersion;
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        public boolean isDebug() {
            return this.isDebug;
        }

        public Mapping getMapping() {
            return this.mapping;
        }

        public abstract T build();
    }
}

