/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.api.component;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kusanagi.katana.api.Api;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.component.ComponentWorker;
import io.kusanagi.katana.api.component.EventCallable;
import io.kusanagi.katana.api.component.Serializer;
import io.kusanagi.katana.api.component.utils.Factory;
import io.kusanagi.katana.api.component.utils.Logger;
import io.kusanagi.katana.api.component.utils.Option;
import io.kusanagi.katana.api.component.utils.OptionManager;
import io.kusanagi.katana.api.replies.ErrorPayload;
import io.kusanagi.katana.api.replies.common.CommandReplyResult;
import io.kusanagi.katana.sdk.ActionParamSchema;
import io.kusanagi.katana.sdk.ActionSchema;
import io.kusanagi.katana.sdk.Callable;
import io.kusanagi.katana.sdk.Error;
import io.kusanagi.katana.sdk.ServiceSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import org.zeromq.ZMQ;

public abstract class Component<T extends Api, S extends CommandReplyResult, R extends Component>
implements ComponentWorker.WorkerListener {
    protected static final Option[] APP_OPTIONS = new Option[]{new Option(new String[]{"-f", "--framework-version"}, true, true, true), new Option(new String[]{"-c", "--component"}, true, true, true), new Option(new String[]{"-n", "--name"}, true, true, true), new Option(new String[]{"-v", "--version"}, true, true, true), new Option(new String[]{"-s", "--socket"}, true, false, true), new Option(new String[]{"-t", "--tcp"}, true, false, true), new Option(new String[]{"-V", "--var"}, false, false, true), new Option(new String[]{"-d", "--disable-compact-names"}, true, false, false), new Option(new String[]{"-D", "--debug"}, true, false, false), new Option(new String[]{"-A", "--action"}, true, false, true), new Option(new String[]{"-q", "--quiet"}, true, false, false)};
    private final String workerEndpoint;
    private String componentName;
    private boolean disableCompactName;
    private String name;
    private String version;
    private String frameworkVersion;
    private String socket;
    private String tcp;
    private boolean debug;
    private Map<String, String> var = new HashMap<String, String>();
    private String action;
    private boolean quiet;
    private Map<String, Callable<T>> resources = new HashMap<String, Callable<T>>();
    private ZMQ.Socket router;
    private ZMQ.Context context;
    private ZMQ.Socket dealer;
    private OptionManager optionManager;
    private boolean stopped;
    private Mapping mapping;
    protected EventCallable<R> startupCallable;
    protected EventCallable<R> shutdownCallable;
    protected EventCallable<R> errorCallable;
    protected List<ComponentWorker> workers;
    protected Serializer serializer = Factory.getSerializer();

    public Component(String[] args) {
        this.optionManager = Factory.getOptionManager();
        this.optionManager.setOptions(Arrays.asList(APP_OPTIONS));
        this.workers = new ArrayList<ComponentWorker>();
        this.setArgs(args);
        if (this.tcp == null && this.socket == null) {
            this.generateDefaultSocket();
        }
        if (this.isDebug() && !this.quiet) {
            Logger.activate();
        } else {
            Logger.deactivate();
        }
        this.workerEndpoint = String.format("%s_%s", "ipc://workers", UUID.randomUUID().toString());
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    public String getComponent() {
        return this.componentName;
    }

    public boolean isDisableCompactName() {
        return this.disableCompactName;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public String getSocket() {
        return this.socket;
    }

    public String getTcp() {
        return this.tcp;
    }

    public Map<String, String> getVar() {
        return this.var;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean setResource(String name, Callable<T> resource) {
        this.resources.put(name, resource);
        return true;
    }

    public boolean hasResource(String name) {
        return this.resources.containsKey(name);
    }

    public Callable<T> getResource(String name) {
        return this.resources.get(name);
    }

    public Component<T, S, R> startup(EventCallable<R> callback) {
        this.startupCallable = callback;
        return this;
    }

    public Component<T, S, R> shutdown(EventCallable<R> callback) {
        this.shutdownCallable = callback;
        return this;
    }

    public Component<T, S, R> error(EventCallable<R> callback) {
        this.errorCallable = callback;
        return this;
    }

    public void run() {
        if (this.action != null) {
            Scanner in = new Scanner(System.in);
            String payload = in.next();
            try {
                S commandReply = this.processRequest(this.action, this.getSdkCommand(this.action, null, payload));
                System.out.print(this.serializer.serializeInJson(commandReply));
            }
            catch (Exception e) {
                Logger.log(e);
                this.runErrorCallback();
                try {
                    System.out.print(this.serializer.serializeInJson(Component.getErrorPayload(e)));
                }
                catch (JsonProcessingException e1) {
                    Logger.log(e1);
                    System.out.print("");
                }
            }
        } else {
            this.startSocket();
            this.setWorkers();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    if (Component.this.shutdownCallable != null) {
                        Component.this.runShutdown();
                    }
                    if (!Component.this.stopped) {
                        Component.this.stopSocket();
                    }
                }
            }));
            ZMQ.proxy(this.router, this.dealer, null);
        }
    }

    public boolean log(String value) {
        Logger.log(4, value);
        return this.debug;
    }

    protected abstract void runShutdown();

    private void setWorkers() {
        int workerCount = 1;
        if (this.var.containsKey("workers")) {
            workerCount = Integer.valueOf(this.var.get("workers"));
            workerCount = workerCount < 1 ? 1 : workerCount;
        }
        for (int i = 0; i < workerCount; ++i) {
            ComponentWorker componentWorker = new ComponentWorker(this.workerEndpoint);
            this.workers.add(componentWorker);
            componentWorker.setWorkerListener(this);
            componentWorker.start();
        }
    }

    private void startSocket() {
        this.context = ZMQ.context(1);
        this.router = this.context.socket(6);
        this.dealer = this.context.socket(5);
        this.bindSocket();
    }

    private void bindSocket() {
        if (this.tcp != null) {
            this.router.bind(String.format("%s://%s:%s", "tcp", "127.0.0.1", this.tcp));
        } else {
            this.router.bind(String.format("%s://%s", "ipc", this.socket));
        }
        this.dealer.bind(this.workerEndpoint);
    }

    public void stopSocket() {
        for (ComponentWorker worker : this.workers) {
            worker.stopSocket();
        }
        this.dealer.close();
        this.router.close();
        this.stopped = true;
    }

    private void generateDefaultSocket() {
        this.socket = String.format("@katana-%s-%s-%s", this.componentName, this.name, this.version);
    }

    @Override
    public byte[][] onRequestReceived(String componentType, byte[] mappings, byte[] commandBytes) {
        try {
            Mapping mapping = this.deserializeMappings(mappings);
            S commandReply = this.processRequest(componentType, this.getSdkCommand(componentType, mapping, commandBytes));
            return new byte[][]{this.getReplyMetadata(commandReply), this.serializer.serializeInBytes(commandReply)};
        }
        catch (Exception e) {
            Logger.log(e);
            this.runErrorCallback();
            try {
                byte[] bytes = this.serializer.serializeInBytes(Component.getErrorPayload(e));
                return new byte[][]{{0}, bytes};
            }
            catch (JsonProcessingException e1) {
                Logger.log(e1);
                return new byte[][]{{0}, new byte[0]};
            }
        }
    }

    protected abstract T getSdkCommand(String var1, Mapping var2, byte[] var3) throws IOException;

    protected abstract T getSdkCommand(String var1, Mapping var2, String var3) throws IOException;

    protected abstract void runErrorCallback();

    private static ErrorPayload getErrorPayload(Exception e) {
        Error error = new Error();
        error.setMessage(e.getMessage());
        error.setCode(1);
        error.setStatus("500 Internal Server Error");
        ErrorPayload errorPayload = new ErrorPayload();
        errorPayload.setError(error);
        return errorPayload;
    }

    private Mapping deserializeMappings(byte[] mappings) throws IOException {
        if (mappings == null) {
            return null;
        }
        Mapping mapping = new Mapping();
        mapping.setServiceSchema(new HashMap<String, Map<String, ServiceSchema>>());
        Map schemas = this.serializer.deserialize(mappings, Map.class);
        for (Map.Entry serviceKey : schemas.entrySet()) {
            Map versionMap = (Map)schemas.get((String)serviceKey.getKey());
            for (Map.Entry versionKey : versionMap.entrySet()) {
                Map serviceSchemaMap = (Map)versionMap.get((String)versionKey.getKey());
                String jsonServiceSchema = this.serializer.serializeInJson(serviceSchemaMap);
                ServiceSchema serviceSchema = this.serializer.deserialize(jsonServiceSchema, ServiceSchema.class);
                serviceSchema.setName((String)serviceKey.getKey());
                serviceSchema.setVersion((String)versionKey.getKey());
                for (String action : serviceSchema.getActions()) {
                    ActionSchema actionSchema = serviceSchema.getActionSchema(action);
                    actionSchema.setName(action);
                    for (Map.Entry<String, ActionParamSchema> param : actionSchema.getParams().entrySet()) {
                        actionSchema.getParamSchema(param.getKey()).setName(param.getKey());
                    }
                }
                HashMap<String, ServiceSchema> newVersionMap = new HashMap<String, ServiceSchema>();
                newVersionMap.put((String)versionKey.getKey(), serviceSchema);
                mapping.getServiceSchema().put((String)serviceKey.getKey(), newVersionMap);
            }
        }
        return mapping;
    }

    protected abstract S getCommandReplyPayload(String var1, T var2);

    protected abstract CommandReplyResult getReply(String var1, T var2);

    private S processRequest(String componentType, T command) {
        Callable<T> callable = this.getCallable(componentType);
        callable.run(command);
        return this.getCommandReplyPayload(componentType, command);
    }

    protected abstract byte[] getReplyMetadata(S var1);

    protected abstract Callable<T> getCallable(String var1);

    private void setArgs(String[] args) throws IllegalArgumentException {
        List<Option> currentOptions = this.optionManager.extractOptions(args);
        this.setMembers(currentOptions);
    }

    private void setMembers(List<Option> options) {
        block26: for (Option option : options) {
            switch (option.getNames()[0]) {
                case "-f": {
                    this.frameworkVersion = option.getValue();
                    if (this.frameworkVersion.matches("[a-zA-Z0-9*.,_\\-]+")) continue block26;
                    throw new IllegalArgumentException(String.format("Invalid framework version %s", this.frameworkVersion));
                }
                case "-c": {
                    this.componentName = option.getValue();
                    if (this.componentName.equals("service") || this.componentName.equals("middleware")) continue block26;
                    throw new IllegalArgumentException(String.format("Invalid componentName %s", this.componentName));
                }
                case "-n": {
                    this.name = option.getValue();
                    continue block26;
                }
                case "-v": {
                    this.version = option.getValue();
                    if (this.version.matches("[a-zA-Z0-9*.,_\\-]+")) continue block26;
                    throw new IllegalArgumentException(String.format("Invalid version %s", this.version));
                }
                case "-s": {
                    this.socket = option.getValue();
                    continue block26;
                }
                case "-t": {
                    this.tcp = option.getValue();
                    continue block26;
                }
                case "-V": {
                    String[] varObject = option.getValue().split("=");
                    if (varObject.length < 2) {
                        throw new IllegalArgumentException(String.format("Invalid variable %s", option.getValue()));
                    }
                    String varName = varObject[0];
                    String varValue = varObject[1];
                    this.var.put(varName, varValue);
                    continue block26;
                }
                case "-d": {
                    this.disableCompactName = true;
                    continue block26;
                }
                case "-D": {
                    this.debug = true;
                    continue block26;
                }
                case "-A": {
                    this.action = option.getValue();
                    continue block26;
                }
                case "-q": {
                    this.quiet = true;
                    continue block26;
                }
            }
            Logger.log(3, String.format("Unsupported parameter %s", option.getNames()[0]));
        }
    }

    public String toString() {
        return "Component{componentName='" + this.componentName + '\'' + ", disableCompactName=" + this.disableCompactName + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", frameworkVersion='" + this.frameworkVersion + '\'' + ", socket='" + this.socket + '\'' + ", " + "tcp" + "='" + this.tcp + '\'' + ", debug=" + this.debug + ", var=" + this.var + ", action=" + this.action + ", quiet=" + this.quiet + '}';
    }
}

