/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.api.component.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Logger {
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int DEBUG = 4;
    public static final String STANDARD_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String LOG_PATTERN = "%s [%s] [SDK] %s";
    private static boolean isActive;
    private static String id;

    private Logger() {
    }

    public static void activate() {
        isActive = true;
    }

    public static void deactivate() {
        isActive = false;
    }

    public static void setId(String id) {
        Logger.id = id;
    }

    public static void log(int type, String message) {
        if (isActive) {
            Logger.logToStdout(Logger.getLog(type, message));
        }
    }

    public static void log(Exception e) {
        StackTraceElement[] stackTrace;
        Logger.log(3, e.getMessage());
        for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
            Logger.log(3, stackTraceElement.toString());
        }
    }

    private static String getLog(int type, String message) {
        SimpleDateFormat standardDateFormat = new SimpleDateFormat(STANDARD_DATE_PATTERN);
        Date date = Calendar.getInstance().getTime();
        String time = standardDateFormat.format(date);
        return String.format(LOG_PATTERN, time, Logger.getType(type), message + (id == null ? "" : " |" + id + "|"));
    }

    private static String getType(int type) {
        switch (type) {
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "ERROR";
            }
            case 4: {
                return "DEBUG";
            }
        }
        return "INFO";
    }

    private static void logToStdout(String message) {
        System.out.println(message);
    }
}

