/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kusanagi.katana.api.Api;
import io.kusanagi.katana.api.commands.CallCommandPayload;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.commands.common.CommandMeta;
import io.kusanagi.katana.api.component.Component;
import io.kusanagi.katana.api.component.utils.Logger;
import io.kusanagi.katana.api.component.utils.MessagePackSerializer;
import io.kusanagi.katana.api.replies.ErrorPayload;
import io.kusanagi.katana.api.replies.ReturnReplyPayload;
import io.kusanagi.katana.api.serializers.ActionEntity;
import io.kusanagi.katana.api.serializers.TransportEntity;
import io.kusanagi.katana.sdk.ActionSchema;
import io.kusanagi.katana.sdk.Call;
import io.kusanagi.katana.sdk.Callee;
import io.kusanagi.katana.sdk.Error;
import io.kusanagi.katana.sdk.File;
import io.kusanagi.katana.sdk.Param;
import io.kusanagi.katana.sdk.ServiceSchema;
import io.kusanagi.katana.sdk.ServiceTransaction;
import io.kusanagi.katana.sdk.Transport;
import io.kusanagi.katana.sdk.TransportMeta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zeromq.ZMQ;

public class Action
extends Api {
    private ActionEntity actionEntity;
    private Transport transport;

    public Action(Component component, String path, String name, String version, String platformVersion, Map<String, String> variables, boolean isDebug, Mapping mapping, ActionEntity actionEntity, Transport transport) {
        super(component, path, name, version, platformVersion, variables, isDebug, mapping);
        this.actionEntity = actionEntity;
        this.transport = transport;
    }

    public Action() {
    }

    public Action(Action other) {
        super(other);
        this.actionEntity = other.actionEntity;
        this.transport = other.transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Object getReturnObject() {
        return this.actionEntity.getReturnObject();
    }

    public boolean isOrigin() {
        return this.transport.getOriginService().length != 0 && this.transport.getOriginService()[0].equals(this.getName());
    }

    public String getActionName() {
        return this.actionEntity.getActionName();
    }

    public Action setProperty(String name, String value) {
        TransportMeta meta = this.actionEntity.getTransport().getMeta();
        Map<String, String> properties = meta.getProperties();
        properties.put(name, value);
        return this;
    }

    public boolean hasParam(String name) {
        for (Param param : this.actionEntity.getParams()) {
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Param getParam(String name) {
        for (Param param : this.actionEntity.getParams()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        Param param = new Param();
        param.setName(name);
        param.setExists(false);
        return param;
    }

    public List<Param> getParams() {
        return this.actionEntity.getParams();
    }

    public Param newParam(String name, String value, String type) {
        Param param = new Param();
        param.setName(name);
        param.setValue(value);
        param.setType(type);
        return param;
    }

    public Param newParam(String name) {
        return this.newParam(name, "", "");
    }

    public boolean hasFile(String name) {
        Map<String, Map<String, Map<String, Map<String, Map<String, File>>>>> pathFiles = this.actionEntity.getTransport().getFiles();
        for (Map.Entry<String, Map<String, Map<String, Map<String, Map<String, File>>>>> path : pathFiles.entrySet()) {
            Map<String, Map<String, Map<String, Map<String, File>>>> serviceFiles = pathFiles.get(path.getKey());
            for (Map.Entry<String, Map<String, Map<String, Map<String, File>>>> service : serviceFiles.entrySet()) {
                Map<String, Map<String, Map<String, File>>> versionFiles = serviceFiles.get(service.getKey());
                for (Map.Entry<String, Map<String, Map<String, File>>> version : versionFiles.entrySet()) {
                    Map<String, Map<String, File>> actionFiles = versionFiles.get(version.getKey());
                    for (Map.Entry<String, Map<String, File>> action : actionFiles.entrySet()) {
                        Map<String, File> nameFiles = actionFiles.get(action.getKey());
                        if (!nameFiles.containsKey(name)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public File getFile(String name) {
        Map<String, Map<String, Map<String, Map<String, Map<String, File>>>>> pathFiles = this.actionEntity.getTransport().getFiles();
        for (Map.Entry<String, Map<String, Map<String, Map<String, Map<String, File>>>>> path : pathFiles.entrySet()) {
            Map<String, Map<String, Map<String, Map<String, File>>>> serviceFiles = pathFiles.get(path.getKey());
            for (Map.Entry<String, Map<String, Map<String, Map<String, File>>>> service : serviceFiles.entrySet()) {
                Map<String, Map<String, Map<String, File>>> versionFiles = serviceFiles.get(service.getKey());
                for (Map.Entry<String, Map<String, Map<String, File>>> version : versionFiles.entrySet()) {
                    Map<String, Map<String, File>> actionFiles = versionFiles.get(version.getKey());
                    for (Map.Entry<String, Map<String, File>> action : actionFiles.entrySet()) {
                        Map<String, File> nameFiles = actionFiles.get(action.getKey());
                        if (!nameFiles.containsKey(name)) continue;
                        return nameFiles.get(name);
                    }
                }
            }
        }
        File file = new File();
        file.setName(name);
        file.setPath("");
        return file;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Map<String, Map<String, Map<String, Map<String, Map<String, File>>>>> pathFiles = this.actionEntity.getTransport().getFiles();
        for (Map.Entry<String, Map<String, Map<String, Map<String, Map<String, File>>>>> path : pathFiles.entrySet()) {
            Map<String, Map<String, Map<String, Map<String, File>>>> serviceFiles = pathFiles.get(path.getKey());
            for (Map.Entry<String, Map<String, Map<String, Map<String, File>>>> service : serviceFiles.entrySet()) {
                Map<String, Map<String, Map<String, File>>> versionFiles = serviceFiles.get(service.getKey());
                for (Map.Entry<String, Map<String, Map<String, File>>> version : versionFiles.entrySet()) {
                    Map<String, Map<String, File>> actionFiles = versionFiles.get(version.getKey());
                    for (Map.Entry<String, Map<String, File>> action : actionFiles.entrySet()) {
                        Map<String, File> nameFiles = actionFiles.get(action.getKey());
                        for (Map.Entry<String, File> name : nameFiles.entrySet()) {
                            files.add(nameFiles.get(name.getKey()));
                        }
                    }
                }
            }
        }
        return files;
    }

    public File newFile(String name, String path, String mime) {
        File file = new File();
        file.setName(name);
        file.setPath(path);
        file.setMime(mime);
        return file;
    }

    public File newFile(String name, String path) {
        return this.newFile(name, path, "");
    }

    public Action setDownload(File file) {
        if (this.mapping != null && !this.getServiceSchema(this.getName(), this.getVersion()).hasFileServer()) {
            throw new IllegalArgumentException(String.format("File server not configured: \"%s\" (%s)", this.getName(), this.getVersion()));
        }
        this.actionEntity.getTransport().setBody(file);
        return this;
    }

    public Action setEntity(Object entity) {
        Map<String, Map<String, Map<String, Map<String, Object>>>> pathData = this.actionEntity.getTransport().getData();
        if (pathData == null) {
            pathData = new HashMap<String, Map<String, Map<String, Map<String, Object>>>>();
            this.actionEntity.getTransport().setData(pathData);
        }
        Map<Object, Object> serviceData = new HashMap();
        Map versionData = new HashMap();
        Map<String, ArrayList<Object>> actionData = new HashMap<String, Object>();
        if (pathData.containsKey(this.getPath())) {
            serviceData = pathData.get(this.getPath());
            if (serviceData.containsKey(this.getName())) {
                versionData = (Map)serviceData.get(this.getName());
                if (versionData.containsKey(this.getVersion())) {
                    actionData = (Map)versionData.get(this.getVersion());
                } else {
                    versionData.put(this.getVersion(), actionData);
                }
            } else {
                versionData.put(this.getVersion(), actionData);
                serviceData.put(this.getName(), versionData);
            }
        } else {
            versionData.put(this.getVersion(), actionData);
            serviceData.put(this.getName(), versionData);
            pathData.put(this.getPath(), serviceData);
        }
        if (!(entity instanceof List)) {
            ArrayList<Object> entities = new ArrayList<Object>();
            entities.add(entity);
            actionData.put(this.getActionName(), entities);
        } else {
            actionData.put(this.getActionName(), (ArrayList<Object>)entity);
        }
        return this;
    }

    public Action setCollection(List<?> collection) {
        this.setEntity(collection);
        return this;
    }

    public Action relateOne(String primaryKey, String service, String foreignKey) {
        Map<String, Map<String, Map<String, Map<String, Map<String, Object>>>>> relations = this.actionEntity.getTransport().getRelations();
        HashMap<String, String> relation = new HashMap<String, String>();
        relation.put(service, foreignKey);
        HashMap<String, HashMap<String, String>> primaryKeyRelation = new HashMap<String, HashMap<String, String>>();
        primaryKeyRelation.put(this.path, relation);
        HashMap<String, HashMap<String, HashMap<String, String>>> nameRelation = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        nameRelation.put(primaryKey, primaryKeyRelation);
        if (relations.containsKey(this.path)) {
            if (relations.get(this.path).containsKey(this.name)) {
                if (relations.get(this.path).get(this.name).containsKey(primaryKey)) {
                    if (relations.get(this.path).get(this.name).get(primaryKey).containsKey(this.path)) {
                        relations.get(this.path).get(this.name).get(primaryKey).get(this.path).put(service, foreignKey);
                    } else {
                        relations.get(this.path).get(this.name).get(primaryKey).put(this.path, relation);
                    }
                } else {
                    relations.get(this.path).get(this.name).put(primaryKey, primaryKeyRelation);
                }
            } else {
                relations.get(this.path).put(this.name, nameRelation);
            }
        } else {
            HashMap<String, HashMap<String, HashMap<String, HashMap<String, String>>>> pathRelation = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, String>>>>();
            pathRelation.put(this.name, nameRelation);
            relations.put(this.path, pathRelation);
        }
        return this;
    }

    public Action relateMany(String primaryKey, String service, List<String> foreignKey) {
        Map<String, Map<String, Map<String, Map<String, Map<String, Object>>>>> relations = this.actionEntity.getTransport().getRelations();
        HashMap<String, List<String>> relation = new HashMap<String, List<String>>();
        relation.put(service, foreignKey);
        HashMap<String, HashMap<String, List<String>>> primaryKeyRelation = new HashMap<String, HashMap<String, List<String>>>();
        primaryKeyRelation.put(this.path, relation);
        HashMap<String, HashMap<String, HashMap<String, List<String>>>> nameRelation = new HashMap<String, HashMap<String, HashMap<String, List<String>>>>();
        nameRelation.put(primaryKey, primaryKeyRelation);
        if (relations.containsKey(this.path)) {
            if (relations.get(this.path).containsKey(this.name)) {
                if (relations.get(this.path).get(this.name).containsKey(primaryKey)) {
                    if (relations.get(this.path).get(this.name).get(primaryKey).containsKey(this.path)) {
                        relations.get(this.path).get(this.name).get(primaryKey).get(this.path).put(service, foreignKey);
                    } else {
                        relations.get(this.path).get(this.name).get(primaryKey).put(this.path, relation);
                    }
                } else {
                    relations.get(this.path).get(this.name).put(primaryKey, primaryKeyRelation);
                }
            } else {
                relations.get(this.path).put(this.name, nameRelation);
            }
        } else {
            HashMap<String, HashMap<String, HashMap<String, HashMap<String, List<String>>>>> pathRelation = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, List<String>>>>>();
            pathRelation.put(this.name, nameRelation);
            relations.put(this.path, pathRelation);
        }
        return this;
    }

    public Action relateOneRemote(String primaryKey, String address, String service, String foreignKey) {
        Map<String, Map<String, Map<String, Map<String, Map<String, Object>>>>> relations = this.actionEntity.getTransport().getRelations();
        HashMap<String, String> relation = new HashMap<String, String>();
        relation.put(service, foreignKey);
        HashMap<String, HashMap<String, String>> primaryKeyRelation = new HashMap<String, HashMap<String, String>>();
        primaryKeyRelation.put(address, relation);
        HashMap<String, HashMap<String, HashMap<String, String>>> nameRelation = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        nameRelation.put(primaryKey, primaryKeyRelation);
        if (relations.containsKey(this.path)) {
            if (relations.get(this.path).containsKey(this.name)) {
                if (relations.get(this.path).get(this.name).containsKey(primaryKey)) {
                    if (relations.get(this.path).get(this.name).get(primaryKey).containsKey(address)) {
                        relations.get(this.path).get(this.name).get(primaryKey).get(address).put(service, foreignKey);
                    } else {
                        relations.get(this.path).get(this.name).get(primaryKey).put(address, relation);
                    }
                } else {
                    relations.get(this.path).get(this.name).put(primaryKey, primaryKeyRelation);
                }
            } else {
                relations.get(this.path).put(this.name, nameRelation);
            }
        } else {
            HashMap<String, HashMap<String, HashMap<String, HashMap<String, String>>>> pathRelation = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, String>>>>();
            pathRelation.put(this.name, nameRelation);
            relations.put(this.path, pathRelation);
        }
        return this;
    }

    public Action relateManyRemote(String primaryKey, String address, String service, List<String> foreignKey) {
        Map<String, Map<String, Map<String, Map<String, Map<String, Object>>>>> relations = this.actionEntity.getTransport().getRelations();
        HashMap<String, List<String>> relation = new HashMap<String, List<String>>();
        relation.put(service, foreignKey);
        HashMap<String, HashMap<String, List<String>>> primaryKeyRelation = new HashMap<String, HashMap<String, List<String>>>();
        primaryKeyRelation.put(address, relation);
        HashMap<String, HashMap<String, HashMap<String, List<String>>>> nameRelation = new HashMap<String, HashMap<String, HashMap<String, List<String>>>>();
        nameRelation.put(primaryKey, primaryKeyRelation);
        if (relations.containsKey(this.path)) {
            if (relations.get(this.path).containsKey(this.name)) {
                if (relations.get(this.path).get(this.name).containsKey(primaryKey)) {
                    if (relations.get(this.path).get(this.name).get(primaryKey).containsKey(address)) {
                        relations.get(this.path).get(this.name).get(primaryKey).get(address).put(service, foreignKey);
                    } else {
                        relations.get(this.path).get(this.name).get(primaryKey).put(address, relation);
                    }
                } else {
                    relations.get(this.path).get(this.name).put(primaryKey, primaryKeyRelation);
                }
            } else {
                relations.get(this.path).put(this.name, nameRelation);
            }
        } else {
            HashMap<String, HashMap<String, HashMap<String, HashMap<String, List<String>>>>> pathRelation = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, List<String>>>>>();
            pathRelation.put(this.name, nameRelation);
            relations.put(this.path, pathRelation);
        }
        return this;
    }

    public Action setLink(String link, String uri) {
        Map<String, Map<String, Map<String, String>>> pathLink = this.actionEntity.getTransport().getLinks();
        Map<Object, Object> serviceLink = new HashMap();
        Map<String, String> linkMap = new HashMap<String, String>();
        if (pathLink.containsKey(this.getPath())) {
            serviceLink = pathLink.get(this.getPath());
            if (serviceLink.containsKey(this.getName())) {
                linkMap = (Map)serviceLink.get(this.getName());
            } else {
                serviceLink.put(this.getName(), linkMap);
            }
        } else {
            serviceLink.put(this.getName(), linkMap);
            pathLink.put(this.getPath(), serviceLink);
        }
        linkMap.put(link, uri);
        return this;
    }

    public Action commit(String action, List<Param> params) {
        List<ServiceTransaction> commit = this.actionEntity.getTransport().getTransactions().getCommit();
        if (commit == null) {
            commit = new ArrayList<ServiceTransaction>();
        }
        ServiceTransaction serviceTransaction = new ServiceTransaction();
        serviceTransaction.setName(this.name);
        serviceTransaction.setVersion(this.version);
        serviceTransaction.setAction(action);
        serviceTransaction.setParams(params);
        commit.add(serviceTransaction);
        return this;
    }

    public Action rollback(String action, List<Param> params) {
        List<ServiceTransaction> rollback = this.actionEntity.getTransport().getTransactions().getRollback();
        if (rollback == null) {
            rollback = new ArrayList<ServiceTransaction>();
        }
        ServiceTransaction serviceTransaction = new ServiceTransaction();
        serviceTransaction.setName(this.name);
        serviceTransaction.setVersion(this.version);
        serviceTransaction.setAction(action);
        serviceTransaction.setParams(params);
        rollback.add(serviceTransaction);
        return this;
    }

    public Action complete(String action, List<Param> params) {
        List<ServiceTransaction> complete = this.actionEntity.getTransport().getTransactions().getComplete();
        if (complete == null) {
            complete = new ArrayList<ServiceTransaction>();
        }
        ServiceTransaction serviceTransaction = new ServiceTransaction();
        serviceTransaction.setName(this.name);
        serviceTransaction.setVersion(this.version);
        serviceTransaction.setAction(action);
        serviceTransaction.setParams(params);
        complete.add(serviceTransaction);
        return this;
    }

    public Object call(String service, String version, String action, List<Param> params, List<File> files, int timeout) {
        ServiceSchema serviceSchema = this.getServiceSchema(this.name, this.version);
        if (!serviceSchema.getActionSchema(this.actionEntity.getActionName()).hasCalls()) {
            throw new IllegalArgumentException(String.format("Call not configured, connection to action on \"%s\" (%s) aborted: \"%s\"", this.name, this.version, this.actionEntity.getActionName()));
        }
        if (files != null) {
            if (this.mapping != null && !this.getServiceSchema(this.name, this.version).hasFileServer()) {
                return false;
            }
            for (File file : files) {
                if (!file.isLocal()) continue;
                throw new IllegalArgumentException(String.format("Cannot reference local file, connection to action on \"%s\" (%s) aborted: \"%s\"", this.name, this.version, this.actionEntity.getActionName()));
            }
        }
        Callee callee = new Callee();
        callee.setAction(this.getActionName());
        callee.setCalleeInfo(new String[]{service, version, action});
        callee.setTransport(this.actionEntity.getTransport());
        callee.setParam(params);
        callee.setFiles(files);
        CallCommandPayload.CallCommand callCommand = new CallCommandPayload.CallCommand();
        callCommand.setName("runtime-call");
        callCommand.setArgument(callee);
        CommandMeta callCommandMeta = new CommandMeta();
        callCommandMeta.setScope("service");
        CallCommandPayload payload = new CallCommandPayload();
        payload.setCommandMeta(callCommandMeta);
        payload.setCommand(callCommand);
        MessagePackSerializer serializer = new MessagePackSerializer();
        ZMQ.Context context = ZMQ.context(1);
        ZMQ.Socket requester = context.socket(3);
        String addr = "tcp://" + serviceSchema.getAddress();
        requester.connect(addr);
        requester.send(new byte[]{1}, 2);
        try {
            requester.send(serializer.serializeInBytes(payload), 0);
        }
        catch (JsonProcessingException e) {
            Logger.log(e);
            throw new IllegalArgumentException(e.getMessage());
        }
        ZMQ.Poller poll = new ZMQ.Poller(1);
        poll.register(requester, 1);
        int response = poll.poll(timeout);
        if (response > 0) {
            byte[] bytes = requester.recv();
            try {
                ReturnReplyPayload returnCommandReply = serializer.deserialize(bytes, ReturnReplyPayload.class);
                TransportEntity responseTransport = returnCommandReply.getCommandReply().getResult().getTransport();
                this.merge(this.actionEntity.getTransport().getMeta().getFallback(), responseTransport.getMeta().getFallback());
                this.merge(this.actionEntity.getTransport().getMeta().getProperties(), responseTransport.getMeta().getProperties());
                this.merge(this.actionEntity.getTransport().getData(), responseTransport.getData());
                this.merge(this.actionEntity.getTransport().getRelations(), responseTransport.getRelations());
                this.merge(this.actionEntity.getTransport().getLinks(), responseTransport.getLinks());
                this.merge(this.actionEntity.getTransport().getCalls(), responseTransport.getCalls());
                this.merge(this.actionEntity.getTransport().getTransactions().getCommit(), responseTransport.getTransactions().getCommit());
                this.merge(this.actionEntity.getTransport().getTransactions().getComplete(), responseTransport.getTransactions().getComplete());
                this.merge(this.actionEntity.getTransport().getTransactions().getRollback(), responseTransport.getTransactions().getRollback());
                this.merge(this.actionEntity.getTransport().getErrors(), responseTransport.getErrors());
                this.actionEntity.getTransport().setBody(responseTransport.getBody());
                this.merge(this.actionEntity.getTransport().getFiles(), responseTransport.getFiles());
                Object object = returnCommandReply.getCommandReply().getResult().getReturnObject();
                return object;
            }
            catch (IOException e) {
                try {
                    ErrorPayload errorPayload = serializer.deserialize(bytes, ErrorPayload.class);
                    Logger.log(e);
                    throw new IllegalArgumentException(errorPayload.getError().getMessage());
                }
                catch (IOException e1) {
                    Logger.log(e1);
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            finally {
                requester.close();
                context.term();
            }
        }
        requester.close();
        context.term();
        throw new RuntimeException("Runtime call timeout");
    }

    private void merge(List list1, List list2) {
        if (list2 != null && list1 != null) {
            for (Object object : list2) {
                list1.add(object);
            }
        }
    }

    private void merge(Map map1, Map map2) {
        if (map2 != null && map1 != null) {
            for (Map.Entry entry : map2.entrySet()) {
                Object object = map2.get(entry.getKey());
                if (map1.containsKey(entry.getKey()) && map1.get(entry.getKey()) instanceof Map && object instanceof Map) {
                    this.merge((Map)map1.get(entry.getKey()), (Map)object);
                    continue;
                }
                map1.put(entry.getKey(), map2.get(entry.getKey()));
            }
        }
    }

    public Action deferCall(String service, String version, String action, List<Param> params, List<File> files) {
        Map<String, Map<String, List<Call>>> calls;
        ServiceSchema serviceSchema = this.getServiceSchema(this.name, this.version);
        if (this.mapping != null && !serviceSchema.getActionSchema(this.actionEntity.getActionName()).hasDeferCall(service, version, action)) {
            throw new IllegalArgumentException(String.format("Deferred call not configured, connection to action on \"%s\" (%s) aborted: \"%s\"", this.name, this.version, this.actionEntity.getActionName()));
        }
        if (files != null) {
            for (File file : files) {
                if (file.isLocal() && this.mapping != null && !serviceSchema.hasFileServer()) {
                    throw new IllegalArgumentException(String.format("File server not configured: \"%s\" (%s)", this.name, this.version));
                }
                this.transport.addFile(this.path, service, version, action, file);
            }
        }
        if ((calls = this.transport.getCalls()) == null) {
            calls = new HashMap<String, Map<String, List<Call>>>();
            this.actionEntity.getTransport().setCalls(calls);
        }
        Call call = new Call();
        call.setName(service);
        call.setVersion(version);
        call.setAction(action);
        call.setCaller(this.actionEntity.getActionName());
        call.setParams(params);
        List<Call> callList = new ArrayList<Call>();
        HashMap<String, ArrayList<Call>> versionCalls = new HashMap<String, ArrayList<Call>>();
        versionCalls.put(this.version, (ArrayList<Call>)callList);
        if (calls.containsKey(this.name)) {
            if (calls.get(this.name).containsKey(version)) {
                callList = calls.get(this.name).get(this.version);
            } else {
                calls.get(this.name).put(this.version, callList);
            }
        } else {
            calls.put(this.name, versionCalls);
        }
        callList.add(call);
        return this;
    }

    public Action remoteCall(String address, String service, String version, String action, List<Param> params, List<File> files, int timeout) {
        ServiceSchema serviceSchema = this.getServiceSchema(this.name, this.version);
        if (this.mapping != null && !serviceSchema.getActionSchema(this.actionEntity.getActionName()).hasRemoteCalls()) {
            throw new IllegalArgumentException(String.format("Remote call not configured, connection to action on [\"%s\"] \"%s\" (%s) aborted: \"%s\"", address, this.name, this.version, this.actionEntity.getActionName()));
        }
        if (files != null) {
            for (File file : files) {
                if (file.isLocal() && this.mapping != null && !serviceSchema.hasFileServer()) {
                    throw new IllegalArgumentException(String.format("File server not configured: \"%s\" (%s)", this.name, this.version));
                }
                this.transport.addFile(address, service, version, action, file);
            }
        }
        Map<String, Map<String, List<Call>>> calls = this.transport.getCalls();
        List<Object> callList = new ArrayList();
        HashMap versionCalls = new HashMap();
        versionCalls.put(this.version, callList);
        if (calls.containsKey(this.name)) {
            if (calls.get(this.name).containsKey(version)) {
                callList = calls.get(this.name).get(this.version);
            } else {
                calls.get(this.name).put(this.version, callList);
            }
        } else {
            calls.put(this.name, versionCalls);
        }
        Call call = new Call();
        call.setGateway(address);
        call.setName(service);
        call.setVersion(version);
        call.setAction(action);
        call.setCaller(this.actionEntity.getActionName());
        call.setTimeout(timeout);
        call.setParams(params);
        callList.add(call);
        return this;
    }

    public Action error(String message, int code, String status) {
        Error error = new Error();
        error.setMessage(message);
        error.setCode(code);
        error.setStatus(status);
        Map<String, Map<String, Map<String, List<Error>>>> pathError = this.actionEntity.getTransport().getErrors();
        Map<Object, Object> serviceError = new HashMap();
        Map versionError = new HashMap();
        List<Error> errors = new ArrayList<Error>();
        if (pathError.containsKey(this.getPath())) {
            serviceError = pathError.get(this.getPath());
            if (serviceError.containsKey(this.getName())) {
                versionError = (Map)serviceError.get(this.getName());
                if (versionError.containsKey(this.getVersion())) {
                    errors = (List)versionError.get(this.getVersion());
                } else {
                    versionError.put(this.getVersion(), errors);
                }
            } else {
                versionError.put(this.getVersion(), errors);
                serviceError.put(this.getName(), versionError);
            }
        } else {
            versionError.put(this.getVersion(), errors);
            serviceError.put(this.getName(), versionError);
            pathError.put(this.getPath(), serviceError);
        }
        errors.add(error);
        return this;
    }

    public void setReturn(Object returnObject) {
        ServiceSchema serviceSchema = this.getServiceSchema(this.getName(), this.getVersion());
        ActionSchema actionSchema = serviceSchema.getActionSchema(this.getActionName());
        if (!actionSchema.hasReturn()) {
            throw new IllegalArgumentException(String.format("Cannot set a return value in \"%s\" (%s) for action: \"%s\"", this.getName(), this.getVersion(), this.getActionName()));
        }
        this.actionEntity.setReturnObject(returnObject);
        this.validateReturnObjectType(actionSchema.getReturnType());
    }

    private void validateReturnObjectType(String returnType) {
        if (returnType.equals("boolean") && !(this.actionEntity.getReturnObject() instanceof Boolean) || returnType.equals("integer") && !(this.actionEntity.getReturnObject() instanceof Integer) || returnType.equals("float") && !(this.actionEntity.getReturnObject() instanceof Float) || returnType.equals("string") && !(this.actionEntity.getReturnObject() instanceof String) || returnType.equals("array") && !(this.actionEntity.getReturnObject() instanceof List) || returnType.equals("object") && !(this.actionEntity.getReturnObject() instanceof Map)) {
            this.throwInvalidTypeException();
        }
    }

    private Object throwInvalidTypeException() {
        throw new IllegalArgumentException(String.format("Invalid return type given in %s %s for action: %s", this.getName(), this.getVersion(), this.getActionName()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Action action = (Action)o;
        if (this.actionEntity != null ? !this.actionEntity.equals(action.actionEntity) : action.actionEntity != null) {
            return false;
        }
        return this.transport != null ? this.transport.equals(action.transport) : action.transport == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.actionEntity != null ? this.actionEntity.hashCode() : 0);
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Action{actionEntity=" + this.actionEntity + ", transport=" + this.transport + '}';
    }

    public static class Builder
    extends Api.Builder<Action> {
        private ActionEntity actionEntity;
        private Transport transport;

        public Builder setActionEntity(ActionEntity actionEntity) {
            this.actionEntity = actionEntity;
            this.transport = new Transport.Builder().setTransportEntity(actionEntity.getTransport()).build();
            return this;
        }

        @Override
        public Action build() {
            return new Action(this.getComponent(), this.getPath(), this.getName(), this.getVersion(), this.getPlatformVersion(), this.getVariables(), this.isDebug(), this.getMapping(), this.actionEntity, this.transport);
        }
    }
}

