/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;

public class ActionHttpSchema {
    @JsonProperty(value="g")
    private boolean gateway;
    @JsonProperty(value="p")
    private String path;
    @JsonProperty(value="m")
    private String method;
    @JsonProperty(value="i")
    private String input;
    @JsonProperty(value="b")
    private String[] body;

    public ActionHttpSchema() {
        this.gateway = true;
        this.path = "/";
        this.method = "get";
        this.input = "query";
        this.body = new String[]{"text/plain"};
    }

    public ActionHttpSchema(ActionHttpSchema other) {
        this.gateway = other.gateway;
        this.path = other.path;
        this.method = other.method;
        this.input = other.input;
        this.body = other.body;
    }

    public boolean isGateway() {
        return this.gateway;
    }

    public void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setBody(String[] body) {
        this.body = body;
    }

    @JsonIgnore
    public boolean isAccesible() {
        return this.isGateway();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getInput() {
        return this.input;
    }

    public String[] getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionHttpSchema that = (ActionHttpSchema)o;
        if (this.gateway != that.gateway) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.input != null ? !this.input.equals(that.input) : that.input != null) {
            return false;
        }
        return Arrays.equals(this.body, that.body);
    }

    public int hashCode() {
        int result = this.gateway ? 1 : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    public String toString() {
        return "ActionHttpSchema{gateway=" + this.gateway + ", path='" + this.path + '\'' + ", method='" + this.method + '\'' + ", input='" + this.input + '\'' + ", body='" + Arrays.toString(this.body) + '\'' + '}';
    }
}

