/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kusanagi.katana.sdk.ActionParamHttpSchema;
import java.util.ArrayList;
import java.util.List;

public class ActionParamSchema {
    @JsonProperty(value="n")
    private String name;
    @JsonProperty(value="t")
    private String type;
    @JsonProperty(value="f")
    private String format;
    @JsonProperty(value="af")
    private String arrayFormat;
    @JsonProperty(value="p")
    private String pattern;
    @JsonProperty(value="e")
    private boolean allowEmpty;
    @JsonProperty(value="d")
    private String defaultValue;
    @JsonProperty(value="r")
    private boolean required;
    @JsonProperty(value="i")
    private String items;
    @JsonProperty(value="mx")
    private int max;
    @JsonProperty(value="ex")
    private boolean exclusiveMax;
    @JsonProperty(value="mn")
    private int min;
    @JsonProperty(value="en")
    private boolean exclusiveMin;
    @JsonProperty(value="xl")
    private int maxLength;
    @JsonProperty(value="nl")
    private int minLength;
    @JsonProperty(value="xi")
    private int maxItems;
    @JsonProperty(value="ni")
    private int minItems;
    @JsonProperty(value="ui")
    private boolean uniqueItems;
    @JsonProperty(value="em")
    private List<String> enumeration;
    @JsonProperty(value="mo")
    private int multipleOf;
    @JsonProperty(value="h")
    private ActionParamHttpSchema http;

    public ActionParamSchema() {
        this.type = "string";
        this.format = "";
        this.pattern = "";
        this.defaultValue = "";
        this.arrayFormat = "";
        this.items = "";
        this.allowEmpty = false;
        this.required = false;
        this.max = Integer.MAX_VALUE;
        this.exclusiveMax = false;
        this.min = Integer.MIN_VALUE;
        this.exclusiveMin = false;
        this.maxLength = -1;
        this.minLength = -1;
        this.maxItems = -1;
        this.minItems = -1;
        this.enumeration = new ArrayList<String>();
        this.multipleOf = -1;
        this.uniqueItems = false;
        this.http = new ActionParamHttpSchema();
    }

    public ActionParamSchema(ActionParamSchema other) {
        this.type = other.type;
        this.format = other.format;
        this.arrayFormat = other.arrayFormat;
        this.pattern = other.pattern;
        this.allowEmpty = other.allowEmpty;
        this.defaultValue = other.defaultValue;
        this.required = other.required;
        this.items = other.items;
        this.max = other.max;
        this.exclusiveMax = other.exclusiveMax;
        this.min = other.min;
        this.exclusiveMin = other.exclusiveMin;
        this.maxLength = other.maxLength;
        this.minLength = other.minLength;
        this.maxItems = other.maxItems;
        this.minItems = other.minItems;
        this.uniqueItems = other.uniqueItems;
        this.enumeration = other.enumeration;
        this.multipleOf = other.multipleOf;
        this.http = other.http;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setArrayFormat(String arrayFormat) {
        this.arrayFormat = arrayFormat;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setExclusiveMax(boolean exclusiveMax) {
        this.exclusiveMax = exclusiveMax;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setExclusiveMin(boolean exclusiveMin) {
        this.exclusiveMin = exclusiveMin;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setMinItems(int minItems) {
        this.minItems = minItems;
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public void setEnumeration(List<String> enumeration) {
        this.enumeration = enumeration;
    }

    public void setMultipleOf(int multipleOf) {
        this.multipleOf = multipleOf;
    }

    public ActionParamHttpSchema getHttp() {
        return this.http;
    }

    public void setHttp(ActionParamHttpSchema http) {
        this.http = http;
    }

    public List<String> getEnumeration() {
        return this.enumeration;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public String getArrayFormat() {
        if (this.type.equals("array") && this.arrayFormat.isEmpty()) {
            return "csv";
        }
        return this.arrayFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean allowEmpty() {
        return this.isAllowEmpty();
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && !this.defaultValue.isEmpty();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getItems() {
        return this.items;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isExclusiveMax() {
        return this.exclusiveMax;
    }

    public int getMin() {
        return this.min;
    }

    public boolean isExclusiveMin() {
        return this.exclusiveMin;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    @JsonIgnore
    public List<String> getEnum() {
        return this.getEnumeration();
    }

    public int getMultipleOf() {
        return this.multipleOf;
    }

    @JsonIgnore
    public ActionParamHttpSchema getHttpSchema() {
        return this.getHttp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionParamSchema)) {
            return false;
        }
        ActionParamSchema that = (ActionParamSchema)o;
        if (this.isAllowEmpty() != that.isAllowEmpty()) {
            return false;
        }
        if (this.isRequired() != that.isRequired()) {
            return false;
        }
        if (this.getMax() != that.getMax()) {
            return false;
        }
        if (this.isExclusiveMax() != that.isExclusiveMax()) {
            return false;
        }
        if (this.getMin() != that.getMin()) {
            return false;
        }
        if (this.isExclusiveMin() != that.isExclusiveMin()) {
            return false;
        }
        if (this.getMaxLength() != that.getMaxLength()) {
            return false;
        }
        if (this.getMinLength() != that.getMinLength()) {
            return false;
        }
        if (this.getMaxItems() != that.getMaxItems()) {
            return false;
        }
        if (this.getMinItems() != that.getMinItems()) {
            return false;
        }
        if (this.isUniqueItems() != that.isUniqueItems()) {
            return false;
        }
        if (this.getMultipleOf() != that.getMultipleOf()) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
            return false;
        }
        if (this.getFormat() != null ? !this.getFormat().equals(that.getFormat()) : that.getFormat() != null) {
            return false;
        }
        if (this.getArrayFormat() != null ? !this.getArrayFormat().equals(that.getArrayFormat()) : that.getArrayFormat() != null) {
            return false;
        }
        if (this.getPattern() != null ? !this.getPattern().equals(that.getPattern()) : that.getPattern() != null) {
            return false;
        }
        if (this.getDefaultValue() != null ? !this.getDefaultValue().equals(that.getDefaultValue()) : that.getDefaultValue() != null) {
            return false;
        }
        if (this.getItems() != null ? !this.getItems().equals(that.getItems()) : that.getItems() != null) {
            return false;
        }
        if (this.getEnumeration() != null ? !this.getEnumeration().equals(that.getEnumeration()) : that.getEnumeration() != null) {
            return false;
        }
        return this.getHttp() != null ? this.getHttp().equals(that.getHttp()) : that.getHttp() == null;
    }

    public int hashCode() {
        int result = this.getType() != null ? this.getType().hashCode() : 0;
        result = 31 * result + (this.getFormat() != null ? this.getFormat().hashCode() : 0);
        result = 31 * result + (this.getArrayFormat() != null ? this.getArrayFormat().hashCode() : 0);
        result = 31 * result + (this.getPattern() != null ? this.getPattern().hashCode() : 0);
        result = 31 * result + (this.isAllowEmpty() ? 1 : 0);
        result = 31 * result + (this.getDefaultValue() != null ? this.getDefaultValue().hashCode() : 0);
        result = 31 * result + (this.isRequired() ? 1 : 0);
        result = 31 * result + (this.getItems() != null ? this.getItems().hashCode() : 0);
        result = 31 * result + this.getMax();
        result = 31 * result + (this.isExclusiveMax() ? 1 : 0);
        result = 31 * result + this.getMin();
        result = 31 * result + (this.isExclusiveMin() ? 1 : 0);
        result = 31 * result + this.getMaxLength();
        result = 31 * result + this.getMinLength();
        result = 31 * result + this.getMaxItems();
        result = 31 * result + this.getMinItems();
        result = 31 * result + (this.isUniqueItems() ? 1 : 0);
        result = 31 * result + (this.getEnumeration() != null ? this.getEnumeration().hashCode() : 0);
        result = 31 * result + this.getMultipleOf();
        result = 31 * result + (this.getHttp() != null ? this.getHttp().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ActionParamSchema{type='" + this.type + '\'' + ", format='" + this.format + '\'' + ", arrayFormat='" + this.arrayFormat + '\'' + ", pattern='" + this.pattern + '\'' + ", allowEmpty=" + this.allowEmpty + ", defaultValue='" + this.defaultValue + '\'' + ", required=" + this.required + ", items='" + this.items + '\'' + ", max=" + this.max + ", exclusiveMax=" + this.exclusiveMax + ", min=" + this.min + ", exclusiveMin=" + this.exclusiveMin + ", maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", maxItems=" + this.maxItems + ", minItems=" + this.minItems + ", uniqueItems=" + this.uniqueItems + ", enumeration=" + this.enumeration + ", multipleOf=" + this.multipleOf + ", http=" + this.http + '}';
    }
}

