/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kusanagi.katana.api.component.utils.Logger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class File {
    private String name;
    @JsonProperty(value="p")
    private String path;
    @JsonProperty(value="m")
    private String mime;
    @JsonProperty(value="f")
    private String filename;
    @JsonProperty(value="s")
    private String size;
    @JsonProperty(value="t")
    private String token;
    private boolean exists;

    public File() {
        this.path = "";
        this.mime = "text/plain";
        this.token = "";
    }

    public File(String name, String path, String mime, String filename, String size, String token, boolean exists) {
        this.name = name;
        this.path = path;
        this.mime = mime;
        this.filename = filename;
        this.size = size;
        this.token = token;
        this.exists = exists;
    }

    public File(File other) {
        this.name = other.name;
        this.path = other.path;
        this.mime = other.mime;
        this.filename = other.filename;
        this.size = other.size;
        this.token = other.token;
        this.exists = other.exists;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getMime() {
        return this.mime;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getSize() {
        return this.size;
    }

    public String getToken() {
        return this.token;
    }

    public boolean exists() {
        return this.exists;
    }

    @JsonIgnore
    public boolean isLocal() {
        try {
            URI uri = new URI(this.path);
            return "file".equals(uri.getScheme());
        }
        catch (URISyntaxException e) {
            Logger.log(e);
            return false;
        }
    }

    public String read() {
        try {
            return new String(Files.readAllBytes(Paths.get(this.path, new String[0])));
        }
        catch (IOException e) {
            Logger.log(e);
            throw new IllegalArgumentException(String.format("File does not exist in path: %s", this.path));
        }
    }

    public File copyWithName(String name) {
        return new File(name, this.path, this.mime, this.filename, this.size, this.token, this.exists);
    }

    public File copyWithMime(String mime) {
        return new File(this.name, this.path, mime, this.filename, this.size, this.token, this.exists);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File file = (File)o;
        if (this.exists != file.exists) {
            return false;
        }
        if (this.name != null ? !this.name.equals(file.name) : file.name != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(file.path) : file.path != null) {
            return false;
        }
        if (this.mime != null ? !this.mime.equals(file.mime) : file.mime != null) {
            return false;
        }
        if (this.filename != null ? !this.filename.equals(file.filename) : file.filename != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(file.size) : file.size != null) {
            return false;
        }
        return this.token != null ? this.token.equals(file.token) : file.token == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.mime != null ? this.mime.hashCode() : 0);
        result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + (this.exists ? 1 : 0);
        return result;
    }

    public String toString() {
        return "File{name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", mime='" + this.mime + '\'' + ", filename='" + this.filename + '\'' + ", size='" + this.size + '\'' + ", token='" + this.token + '\'' + ", exists=" + this.exists + '}';
    }
}

