/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kusanagi.katana.api.replies.common.CommandReplyResult;
import io.kusanagi.katana.api.serializers.HttpResponseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpResponse
implements CommandReplyResult {
    private HttpResponseEntity httpResponseEntity;

    private HttpResponse(HttpResponseEntity httpResponseEntity) {
        this.httpResponseEntity = httpResponseEntity;
    }

    public HttpResponse(HttpResponse other) {
        this.httpResponseEntity = other.httpResponseEntity;
    }

    public boolean isProtocolVersion(String version) {
        return this.httpResponseEntity.getProtocolVersion().equals(version);
    }

    @JsonIgnore
    public String getProtocolVersion() {
        return this.httpResponseEntity.getProtocolVersion();
    }

    public HttpResponse setProtocolVersion(String version) {
        this.httpResponseEntity.setProtocolVersion(version);
        return this;
    }

    public boolean isStatus(String status) {
        return this.httpResponseEntity.getStatus().equals(status);
    }

    public String getStatus() {
        return this.httpResponseEntity.getStatus();
    }

    @JsonIgnore
    public int getStatusCode() {
        return Integer.valueOf(this.httpResponseEntity.getStatus().split(" ")[0]);
    }

    @JsonIgnore
    public String getStatusText() {
        String[] split = this.httpResponseEntity.getStatus().split(" ");
        StringBuilder statusText = new StringBuilder();
        for (int i = 1; i < split.length; ++i) {
            statusText.append(split[i]);
        }
        return statusText.toString();
    }

    public HttpResponse setStatus(int code, String text) {
        this.httpResponseEntity.setStatus(code + " " + text);
        return this;
    }

    public boolean hasHeader(String name) {
        return this.httpResponseEntity.getHeaders().containsKey(name);
    }

    public String getHeader(String name, String defaultValue) {
        if (!this.httpResponseEntity.getHeaders().containsKey(name)) {
            return defaultValue;
        }
        return this.httpResponseEntity.getHeaders().get(name).get(0);
    }

    public String getHeader(String name) {
        return this.getHeader(name, "");
    }

    public List<String> getHeaderArray(String name, List<String> defaultArray) {
        if (this.httpResponseEntity.getHeaders() == null) {
            this.httpResponseEntity.setHeaders(new HashMap<String, List<String>>());
        }
        if (!this.httpResponseEntity.getHeaders().containsKey(name)) {
            return defaultArray;
        }
        return this.httpResponseEntity.getHeaders().get(name);
    }

    public List<String> getHeaderArray(String name) {
        return this.getHeaderArray(name, new ArrayList<String>());
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> key : this.httpResponseEntity.getHeaders().entrySet()) {
            if (this.httpResponseEntity.getHeaders().get(key.getKey()).isEmpty()) continue;
            headers.put(key.getKey(), this.httpResponseEntity.getHeaders().get(key.getKey()).get(0));
        }
        return headers;
    }

    public Map<String, List<String>> getHeadersArray() {
        if (this.httpResponseEntity.getHeaders() == null) {
            this.httpResponseEntity.setHeaders(new HashMap<String, List<String>>());
        }
        return this.httpResponseEntity.getHeaders();
    }

    public HttpResponse setHeader(String name, String value) {
        if (this.httpResponseEntity.getHeaders() != null && this.httpResponseEntity.getHeaders().containsKey(name)) {
            this.httpResponseEntity.getHeaders().get(name).add(value);
        } else {
            if (this.httpResponseEntity.getHeaders() == null) {
                this.httpResponseEntity.setHeaders(new HashMap<String, List<String>>());
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.httpResponseEntity.getHeaders().put(name, values);
        }
        return this;
    }

    public boolean hasBody() {
        return this.httpResponseEntity.getBody() != null;
    }

    public String getBody() {
        return this.httpResponseEntity.getBody();
    }

    public HttpResponse setBody(String body) {
        this.httpResponseEntity.setBody(body == null ? "" : body);
        return this;
    }

    public HttpResponse setBody() {
        return this.setBody("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResponse that = (HttpResponse)o;
        return this.httpResponseEntity != null ? this.httpResponseEntity.equals(that.httpResponseEntity) : that.httpResponseEntity == null;
    }

    public int hashCode() {
        return this.httpResponseEntity != null ? this.httpResponseEntity.hashCode() : 0;
    }

    public String toString() {
        return "HttpResponse{httpResponseEntity=" + this.httpResponseEntity + '}';
    }

    public static class Builder {
        private HttpResponseEntity httpResponseEntity;

        public Builder setHttpResponseEntity(HttpResponseEntity httpResponseEntity) {
            this.httpResponseEntity = httpResponseEntity;
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this.httpResponseEntity);
        }
    }
}

