/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import io.kusanagi.katana.api.Api;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.component.Component;
import io.kusanagi.katana.api.serializers.HttpResponseEntity;
import io.kusanagi.katana.api.serializers.RequestEntity;
import io.kusanagi.katana.api.serializers.ResponseEntity;
import io.kusanagi.katana.sdk.HttpRequest;
import io.kusanagi.katana.sdk.HttpResponse;
import io.kusanagi.katana.sdk.Param;
import io.kusanagi.katana.sdk.RequestCall;
import io.kusanagi.katana.sdk.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Request
extends Api {
    private RequestEntity requestEntity;
    private HttpRequest httpRequest;

    public Request() {
    }

    public Request(Component component, String path, String name, String version, String platformVersion, Map<String, String> variables, boolean isDebug, Mapping mapping, RequestEntity requestEntity, HttpRequest httpRequest) {
        super(component, path, name, version, platformVersion, variables, isDebug, mapping);
        this.requestEntity = requestEntity;
        this.httpRequest = httpRequest;
    }

    public Request(Request other) {
        super(other);
        this.requestEntity = other.requestEntity;
        this.httpRequest = other.httpRequest;
    }

    public RequestCall getRequestCall() {
        return this.requestEntity.getRequestCall();
    }

    public String getId() {
        return this.requestEntity.getMeta().getId();
    }

    public String getTimeStamp() {
        return this.requestEntity.getMeta().getDatetime();
    }

    public String getGatewayProtocol() {
        return this.requestEntity.getMeta().getProtocol();
    }

    public String getGatewayAddress() {
        return this.requestEntity.getMeta().getGateway().get(1);
    }

    public String getClientAddress() {
        return this.requestEntity.getMeta().getClient();
    }

    public Request setAttribute(String name, String value) {
        this.requestEntity.getMeta().getAttributes().put(name, value);
        return this;
    }

    public String getServiceName() {
        return this.requestEntity.getRequestCall().getService();
    }

    public Request setServiceName(String name) {
        this.requestEntity.getRequestCall().setService(name);
        return this;
    }

    public String getServiceVersion() {
        return this.requestEntity.getRequestCall().getVersion();
    }

    public Request setServiceVersion(String version) {
        this.requestEntity.getRequestCall().setVersion(version);
        return this;
    }

    public String getActionName() {
        return this.requestEntity.getRequestCall().getAction();
    }

    public Request setActionName(String action) {
        this.requestEntity.getRequestCall().setAction(action);
        return this;
    }

    public boolean hasParam(String name) {
        if (this.requestEntity.getRequestCall().getParams() == null) {
            return false;
        }
        for (Param param : this.requestEntity.getRequestCall().getParams()) {
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Param getParam(String name) {
        if (this.requestEntity.getRequestCall().getParams() == null) {
            this.requestEntity.getRequestCall().setParams(new ArrayList<Param>());
        }
        for (Param param : this.requestEntity.getRequestCall().getParams()) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        Param param = new Param();
        param.setName(name);
        param.setExists(false);
        return param;
    }

    public List<Param> getParams() {
        if (this.requestEntity.getRequestCall().getParams() == null) {
            return new ArrayList<Param>();
        }
        return this.requestEntity.getRequestCall().getParams();
    }

    public Request setParam(Param param) {
        if (this.requestEntity.getRequestCall() == null) {
            this.requestEntity.getRequestCall().setParams(new ArrayList<Param>());
        }
        this.requestEntity.getRequestCall().getParams().add(param);
        return this;
    }

    public Param newParam(String name, String value, String type) {
        Param param = new Param();
        param.setName(name);
        param.setType(type);
        param.setValue(value);
        return param;
    }

    public Param newParam(String name) {
        return this.newParam(name, "", "");
    }

    public Response newResponse(int code, String text) {
        HttpResponse httpResponse = new HttpResponse.Builder().setHttpResponseEntity(new HttpResponseEntity()).build();
        if (this.getGatewayProtocol().equals("urn:katana:protocol:http")) {
            httpResponse.setStatus(code, text);
        }
        return (Response)new Response.Builder().setResponseEntity(new ResponseEntity()).setComponent(this.component).setPath(this.path).setName(this.name).setVersion(this.version).setPlatformVersion(this.platformVersion).setVariables(this.variables).setDebug(this.isDebug).setMapping(this.mapping).build();
    }

    public Response newResponse() {
        return this.newResponse(200, "OK");
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Request request = (Request)o;
        if (this.requestEntity != null ? !this.requestEntity.equals(request.requestEntity) : request.requestEntity != null) {
            return false;
        }
        return this.httpRequest != null ? this.httpRequest.equals(request.httpRequest) : request.httpRequest == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.requestEntity != null ? this.requestEntity.hashCode() : 0);
        result = 31 * result + (this.httpRequest != null ? this.httpRequest.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Request{requestEntity=" + this.requestEntity + ", httpRequest=" + this.httpRequest + '}';
    }

    public static class Builder
    extends Api.Builder<Request> {
        private RequestEntity requestEntity;
        private HttpRequest httpRequest;

        public Builder setRequestEntity(RequestEntity requestEntity) {
            this.requestEntity = requestEntity;
            this.httpRequest = new HttpRequest.Builder().setHttpRequestEntity(requestEntity.getHttpRequest()).build();
            return this;
        }

        @Override
        public Request build() {
            return new Request(this.getComponent(), this.getPath(), this.getName(), this.getVersion(), this.getPlatformVersion(), this.getVariables(), this.isDebug(), this.getMapping(), this.requestEntity, this.httpRequest);
        }
    }
}

