/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kusanagi.katana.api.Api;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.component.Component;
import io.kusanagi.katana.api.serializers.ResponseEntity;
import io.kusanagi.katana.sdk.HttpRequest;
import io.kusanagi.katana.sdk.HttpResponse;
import io.kusanagi.katana.sdk.Transport;
import java.util.Map;

public class Response
extends Api {
    private ResponseEntity responseEntity;
    private HttpRequest httpRequest;
    private HttpResponse httpResponse;
    private Transport transport;

    public Response() {
    }

    public Response(Component component, String path, String name, String version, String platformVersion, Map<String, String> variables, boolean isDebug, Mapping mapping, ResponseEntity responseEntity, HttpRequest httpRequest, HttpResponse httpResponse, Transport transport) {
        super(component, path, name, version, platformVersion, variables, isDebug, mapping);
        this.responseEntity = responseEntity;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.transport = transport;
    }

    public Response(Response other) {
        super(other);
        this.responseEntity = other.responseEntity;
        this.httpRequest = other.httpRequest;
        this.httpResponse = other.httpResponse;
        this.transport = other.transport;
    }

    @JsonIgnore
    public String getGatewayProtocol() {
        return this.responseEntity.getMeta().getProtocol();
    }

    @JsonIgnore
    public String getGatewayAddress() {
        return this.responseEntity.getMeta().getGateway().get(1);
    }

    public String getRequestAttribute(String name, String defaultValue) {
        String attr = this.responseEntity.getMeta().getAttributes().get(name);
        return attr == null ? defaultValue : attr;
    }

    public String getRequestAttribute(String name) {
        return this.getRequestAttribute(name, "");
    }

    public Map<String, String> getRequestAttributes() {
        return this.responseEntity.getMeta().getAttributes();
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public boolean hasReturn() {
        return this.responseEntity.getReturnObject() != null;
    }

    @JsonIgnore
    public Object getReturn() {
        if (this.responseEntity.getReturnObject() == null) {
            throw new IllegalArgumentException("No return value defined on " + this.getName() + " (" + this.version + ")");
        }
        return this.responseEntity.getReturnObject();
    }

    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Response response = (Response)o;
        if (this.responseEntity != null ? !this.responseEntity.equals(response.responseEntity) : response.responseEntity != null) {
            return false;
        }
        if (this.httpRequest != null ? !this.httpRequest.equals(response.httpRequest) : response.httpRequest != null) {
            return false;
        }
        if (this.httpResponse != null ? !this.httpResponse.equals(response.httpResponse) : response.httpResponse != null) {
            return false;
        }
        return this.transport != null ? this.transport.equals(response.transport) : response.transport == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.responseEntity != null ? this.responseEntity.hashCode() : 0);
        result = 31 * result + (this.httpRequest != null ? this.httpRequest.hashCode() : 0);
        result = 31 * result + (this.httpResponse != null ? this.httpResponse.hashCode() : 0);
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Response{responseEntity=" + this.responseEntity + ", httpRequest=" + this.httpRequest + ", httpResponse=" + this.httpResponse + ", transport=" + this.transport + '}';
    }

    public static class Builder
    extends Api.Builder<Response> {
        private ResponseEntity responseEntity;
        private HttpRequest httpRequest;
        private HttpResponse httpResponse;
        private Transport transport;

        public Builder setResponseEntity(ResponseEntity responseEntity) {
            this.responseEntity = responseEntity;
            this.httpRequest = new HttpRequest.Builder().setHttpRequestEntity(responseEntity.getHttpRequest()).build();
            this.httpResponse = new HttpResponse.Builder().setHttpResponseEntity(responseEntity.getHttpResponse()).build();
            this.transport = new Transport.Builder().setTransportEntity(responseEntity.getTransport()).build();
            return this;
        }

        @Override
        public Response build() {
            return new Response(this.getComponent(), this.getPath(), this.getName(), this.getVersion(), this.getPlatformVersion(), this.getVariables(), this.isDebug(), this.getMapping(), this.responseEntity, this.httpRequest, this.httpResponse, this.transport);
        }
    }
}

