/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kusanagi.katana.api.replies.common.CommandReplyResult;
import io.kusanagi.katana.api.serializers.TransportEntity;
import io.kusanagi.katana.sdk.Call;
import io.kusanagi.katana.sdk.Error;
import io.kusanagi.katana.sdk.File;
import io.kusanagi.katana.sdk.ServiceTransaction;
import io.kusanagi.katana.sdk.Transaction;
import io.kusanagi.katana.sdk.TransportMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transport
implements CommandReplyResult {
    private TransportEntity transportEntity;

    public Transport() {
    }

    public Transport(TransportEntity transportEntity) {
        this.transportEntity = transportEntity;
    }

    public Transport(Transport other) {
        this.transportEntity = other.transportEntity;
    }

    public TransportMeta getMeta() {
        return this.transportEntity.getMeta();
    }

    public File getBody() {
        return this.transportEntity.getBody();
    }

    public Map<String, Map<String, Map<String, Map<String, Map<String, File>>>>> getFilesEntity() {
        return this.transportEntity.getFiles();
    }

    public Map<String, Map<String, Map<String, Map<String, Object>>>> getData() {
        return this.transportEntity.getData();
    }

    public Map<String, Map<String, Map<String, Map<String, Map<String, Object>>>>> getRelations() {
        return this.transportEntity.getRelations();
    }

    public Map<String, Map<String, Map<String, String>>> getLinks() {
        return this.transportEntity.getLinks();
    }

    public Map<String, Map<String, List<Call>>> getCalls() {
        return this.transportEntity.getCalls();
    }

    public Transaction getTransactions() {
        return this.transportEntity.getTransactions();
    }

    public Map<String, Map<String, Map<String, List<Error>>>> getErrors() {
        return this.transportEntity.getErrors();
    }

    @JsonIgnore
    public String getRequestId() {
        return this.transportEntity.getMeta().getId();
    }

    @JsonIgnore
    public String getRequestTimeStamp() {
        return this.transportEntity.getMeta().getDatetime();
    }

    @JsonIgnore
    public String[] getOriginService() {
        return this.transportEntity.getMeta().getOrigin();
    }

    @JsonIgnore
    public int getOriginDuration() {
        return this.transportEntity.getMeta().getDuration();
    }

    @JsonIgnore
    public String getProperty(String name, String defaultString) {
        String property = this.transportEntity.getMeta().getProperties().get(name);
        return property == null ? (defaultString == null ? "" : defaultString) : property;
    }

    @JsonIgnore
    public String getProperty(String name) {
        return this.getProperty(name, "");
    }

    @JsonIgnore
    public Map<String, String> getProperties() {
        return this.transportEntity.getMeta().getProperties();
    }

    public boolean hasDownload() {
        return this.transportEntity.getBody() != null;
    }

    @JsonIgnore
    public File getDownload() {
        return this.transportEntity.getBody();
    }

    public Object getData(String address, String service, String version, String action) {
        if (address != null) {
            if (service != null) {
                if (version != null) {
                    if (action != null) {
                        return this.transportEntity.getData().get(address).get(service).get(version).get(action);
                    }
                    return this.transportEntity.getData().get(address).get(service).get(version);
                }
                return this.transportEntity.getData().get(address).get(service);
            }
            return this.transportEntity.getData().get(address);
        }
        return this.transportEntity.getData();
    }

    public Object getData(String address, String service, String version) {
        return this.getData(address, service, version, null);
    }

    public Object getData(String address, String service) {
        return this.getData(address, service, null, null);
    }

    public Object getData(String address) {
        return this.getData(address, null, null, null);
    }

    public Object getRelations(String address, String service) {
        if (address != null) {
            if (service != null) {
                return this.transportEntity.getRelations().get(address).get(service);
            }
            return this.transportEntity.getRelations().get(address);
        }
        return this.transportEntity.getRelations();
    }

    public Object getRelations(String address) {
        return this.getRelations(address, null);
    }

    public Object getLinks(String address, String service) {
        if (address != null) {
            if (service != null) {
                return this.transportEntity.getLinks().get(address).get(service);
            }
            return this.transportEntity.getLinks().get(address);
        }
        return this.transportEntity.getLinks();
    }

    public Object getLinks(String address) {
        return this.getLinks(address, null);
    }

    public Object getCalls(String service) {
        if (service != null) {
            return this.transportEntity.getCalls().get(service);
        }
        return this.transportEntity.getCalls();
    }

    public Transaction getTransactions(String service) {
        Transaction transaction = new Transaction();
        transaction.setCommit(new ArrayList<ServiceTransaction>());
        transaction.setRollback(new ArrayList<ServiceTransaction>());
        transaction.setComplete(new ArrayList<ServiceTransaction>());
        for (ServiceTransaction serviceTransaction : this.transportEntity.getTransactions().getCommit()) {
            if (!serviceTransaction.getName().equals(service)) continue;
            transaction.getCommit().add(serviceTransaction);
        }
        for (ServiceTransaction serviceTransaction : this.transportEntity.getTransactions().getRollback()) {
            if (!serviceTransaction.getName().equals(service)) continue;
            transaction.getRollback().add(serviceTransaction);
        }
        for (ServiceTransaction serviceTransaction : this.transportEntity.getTransactions().getComplete()) {
            if (!serviceTransaction.getName().equals(service)) continue;
            transaction.getComplete().add(serviceTransaction);
        }
        return transaction;
    }

    public Object getErrors(String address, String service) {
        if (address != null) {
            if (service != null) {
                return this.transportEntity.getErrors().get(address).get(service);
            }
            return this.transportEntity.getErrors().get(address);
        }
        return this.transportEntity.getErrors();
    }

    public Object getErrors(String address) {
        return this.getErrors(address, null);
    }

    public void addFile(String path, String service, String version, String action, File file) {
        Map<String, Map<String, Map<String, Map<String, Map<String, File>>>>> pathFile = this.transportEntity.getFiles();
        Map<Object, Object> serviceFile = new HashMap();
        Map versionFile = new HashMap();
        Map actionFile = new HashMap();
        Map<String, File> nameFile = new HashMap<String, File>();
        if (pathFile.containsKey(path)) {
            serviceFile = pathFile.get(path);
            if (serviceFile.containsKey(service)) {
                versionFile = (Map)serviceFile.get(service);
                if (versionFile.containsKey(version)) {
                    actionFile = (Map)versionFile.get(version);
                    if (actionFile.containsKey(action)) {
                        nameFile = (Map)actionFile.get(action);
                    } else {
                        actionFile.put(action, nameFile);
                    }
                } else {
                    actionFile.put(action, nameFile);
                    versionFile.put(version, actionFile);
                }
            } else {
                actionFile.put(action, nameFile);
                versionFile.put(version, actionFile);
                serviceFile.put(service, versionFile);
            }
        } else {
            actionFile.put(action, nameFile);
            versionFile.put(version, actionFile);
            serviceFile.put(service, versionFile);
            pathFile.put(path, serviceFile);
        }
        nameFile.put(file.getName(), file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transport transport = (Transport)o;
        return this.transportEntity != null ? this.transportEntity.equals(transport.transportEntity) : transport.transportEntity == null;
    }

    public int hashCode() {
        return this.transportEntity != null ? this.transportEntity.hashCode() : 0;
    }

    public String toString() {
        return "Transport{transportEntity=" + this.transportEntity + '}';
    }

    public static class Builder {
        private TransportEntity transportEntity = new TransportEntity();

        public Builder setTransportEntity(TransportEntity transportEntity) {
            this.transportEntity = transportEntity;
            return this;
        }

        public Transport build() {
            return new Transport(this.transportEntity);
        }
    }
}

