/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

public class Pair
extends SocketBase {
    private Pipe pipe;

    public Pair(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 0;
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean icanhasall) {
        assert (pipe != null);
        if (this.pipe == null) {
            this.pipe = pipe;
        } else {
            pipe.terminate(false);
        }
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        if (this.pipe == pipe) {
            this.pipe = null;
        }
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (this.pipe == null || !this.pipe.write(msg)) {
            this.errno.set(35);
            return false;
        }
        if ((msg.flags() & 2) == 0) {
            this.pipe.flush();
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        Msg msg;
        Msg msg2 = msg = this.pipe == null ? null : this.pipe.read();
        if (msg == null) {
            this.errno.set(35);
            return null;
        }
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return this.pipe != null && this.pipe.checkRead();
    }

    @Override
    protected boolean xhasOut() {
        return this.pipe != null && this.pipe.checkWrite();
    }

    public static class PairSession
    extends SessionBase {
        public PairSession(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
            super(ioThread, connect, socket, options, addr);
        }
    }
}

