/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.api.component.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.kusanagi.katana.api.component.Serializer;
import java.io.IOException;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MessagePackSerializer
implements Serializer {
    private ObjectMapper msgPackMapper = new ObjectMapper(new MessagePackFactory());
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> T deserialize(byte[] message, Class<T> aClass) throws IOException {
        return this.msgPackMapper.readValue(message, aClass);
    }

    @Override
    public <T> T deserialize(String jsonMessage, Class<T> aClass) throws IOException {
        return this.objectMapper.readValue(jsonMessage, aClass);
    }

    @Override
    public byte[] serializeInBytes(Object message) throws JsonProcessingException {
        this.msgPackMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return this.msgPackMapper.writeValueAsBytes(message);
    }

    @Override
    public String serializeInJson(Object message) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(message);
    }
}

