/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.api.component.utils;

import io.kusanagi.katana.api.component.utils.Option;
import io.kusanagi.katana.api.component.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class OptionManager {
    private static final String HAS_BEEN_SET_MORE_THAN_ONCE = "has been set more than once";
    private static final String IS_REQUIRED = "is required";
    private static final String IS_NOT_VALID = "is not valid";
    private List<Option> options;

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<Option> extractOptions(String[] args) {
        ArrayList<Option> currentOptions = new ArrayList<Option>();
        int[] optionCounts = new int[this.options.size()];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                boolean exist = false;
                for (int j = 0; j < this.options.size() && !exist; ++j) {
                    if (!Utils.contain(this.options.get(j).getNames(), args[i])) continue;
                    if (this.options.get(j).isHasValue()) {
                        ++i;
                    }
                    Option currentOption = new Option(this.options.get(j));
                    currentOption.setValue(args[i]);
                    currentOptions.add(currentOption);
                    int n = j;
                    optionCounts[n] = optionCounts[n] + 1;
                    exist = true;
                }
                if (exist) continue;
                throw new IllegalArgumentException(args[i] + " " + IS_NOT_VALID);
            }
            throw new IllegalArgumentException(args[i] + " " + IS_NOT_VALID);
        }
        this.validateConstrains(optionCounts);
        return currentOptions;
    }

    public void validateConstrains(int[] optionCounts) {
        for (int j = 0; j < this.options.size(); ++j) {
            if (this.options.get(j).isRequired() && optionCounts[j] == 0) {
                throw new IllegalArgumentException(this.getOptionName(this.options.get(j)) + " " + IS_REQUIRED);
            }
            if (!this.options.get(j).isUnique() || optionCounts[j] <= 1) continue;
            throw new IllegalArgumentException(this.getOptionName(this.options.get(j)) + " " + HAS_BEEN_SET_MORE_THAN_ONCE);
        }
    }

    private String getOptionName(Option appOption) {
        return appOption.getNames()[0] + " or " + appOption.getNames()[1];
    }
}

