/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kusanagi.katana.sdk.ActionHttpSchema;
import io.kusanagi.katana.sdk.ActionParamSchema;
import io.kusanagi.katana.sdk.EntitySchema;
import io.kusanagi.katana.sdk.FileSchema;
import io.kusanagi.katana.sdk.RelationSchema;
import io.kusanagi.katana.sdk.ReturnSchema;
import io.kusanagi.katana.sdk.TransportSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionSchema {
    private String name;
    @JsonProperty(value="x")
    private int timeout;
    @JsonProperty(value="e")
    private String entityPath;
    @JsonProperty(value="d")
    private String pathDelimiter;
    @JsonProperty(value="k")
    private String primaryKey;
    @JsonProperty(value="c")
    private boolean collection;
    @JsonProperty(value="C")
    private String[][] calls;
    @JsonProperty(value="dc")
    private String[][] deferredCalls;
    @JsonProperty(value="rc")
    private String[][] remoteCalls;
    @JsonProperty(value="F")
    private Map<String, TransportSchema> fallbacks;
    @JsonProperty(value="D")
    private boolean deprecated;
    @JsonProperty(value="h")
    private ActionHttpSchema http;
    @JsonProperty(value="p")
    private Map<String, ActionParamSchema> params;
    @JsonProperty(value="f")
    private Map<String, FileSchema> files;
    @JsonProperty(value="E")
    private EntitySchema entity;
    @JsonProperty(value="r")
    private List<RelationSchema> relations;
    @JsonProperty(value="rv")
    private ReturnSchema returnObject;

    public ActionSchema() {
        this.timeout = 1000;
        this.pathDelimiter = "/";
        this.primaryKey = "id";
        this.collection = false;
        this.deprecated = false;
        this.files = new HashMap<String, FileSchema>();
        this.entityPath = "";
        this.entity = new EntitySchema();
        this.relations = new ArrayList<RelationSchema>();
        this.calls = new String[0][0];
        this.deferredCalls = new String[0][0];
        this.remoteCalls = new String[0][0];
    }

    public ActionSchema(ActionSchema other) {
        this.timeout = other.timeout;
        this.entityPath = other.entityPath;
        this.pathDelimiter = other.pathDelimiter;
        this.primaryKey = other.primaryKey;
        this.collection = other.collection;
        this.calls = other.calls;
        this.deferredCalls = other.deferredCalls;
        this.remoteCalls = other.remoteCalls;
        this.fallbacks = other.fallbacks;
        this.deprecated = other.deprecated;
        this.http = other.http;
        this.params = other.params;
        this.files = other.files;
        this.entity = other.entity;
        this.relations = other.relations;
        this.returnObject = other.returnObject;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public void setPathDelimiter(String pathDelimiter) {
        this.pathDelimiter = pathDelimiter;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public void setCalls(String[][] calls) {
        this.calls = calls;
    }

    public String[][] getDeferredCalls() {
        return this.deferredCalls;
    }

    public void setDeferredCalls(String[][] deferredCalls) {
        this.deferredCalls = deferredCalls;
    }

    public void setRemoteCalls(String[][] remoteCalls) {
        this.remoteCalls = remoteCalls;
    }

    public Map<String, TransportSchema> getFallbacks() {
        return this.fallbacks;
    }

    public void setFallbacks(Map<String, TransportSchema> fallbacks) {
        this.fallbacks = fallbacks;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public ActionHttpSchema getHttp() {
        return this.http;
    }

    public void setHttp(ActionHttpSchema http) {
        this.http = http;
    }

    public void setParams(Map<String, ActionParamSchema> params) {
        this.params = params;
    }

    public void setFiles(Map<String, FileSchema> files) {
        this.files = files;
    }

    public void setEntity(EntitySchema entity) {
        this.entity = entity;
    }

    public void setRelations(List<RelationSchema> relations) {
        this.relations = relations;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isCollection() {
        return this.collection;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getPathDelimiter() {
        return this.pathDelimiter;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Object resolveEntity(Map<String, Object> data) {
        if (this.entityPath == null || this.entityPath.isEmpty()) {
            return data;
        }
        String[] keys = this.entityPath.split(this.pathDelimiter);
        return this.getEntityObject(data, keys, 0);
    }

    private Object getEntityObject(Map<String, Object> data, String[] keys, int keyIndex) {
        if (!data.containsKey(keys[keyIndex])) {
            throw new IllegalArgumentException(String.format("Cannot resolve entity for action: %s", this.name));
        }
        if (keyIndex < keys.length - 1) {
            return this.getEntityObject((Map)data.get(keys[keyIndex]), keys, keyIndex + 1);
        }
        return data.get(keys[keyIndex]);
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public EntitySchema getEntity() {
        return this.entity;
    }

    public boolean hasRelations() {
        return this.relations != null && !this.relations.isEmpty();
    }

    public List<RelationSchema> getRelations() {
        return this.relations;
    }

    public boolean hasCall(String name, String version, String action) {
        for (String[] call : this.calls) {
            if (!call[0].equals(name) || !call[1].equals(version) && version != null && !version.isEmpty() || !call[2].equals(action) && action != null && !action.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCalls() {
        return this.calls != null && this.calls.length != 0;
    }

    public String[][] getCalls() {
        return this.calls;
    }

    public boolean hasDeferCall(String name, String version, String action) {
        for (String[] call : this.deferredCalls) {
            if (!call[0].equals(name) || !call[1].equals(version) || !call[2].equals(action)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeferCalls() {
        return this.deferredCalls != null && this.deferredCalls.length != 0;
    }

    @JsonIgnore
    public String[][] getDeferCalls() {
        return this.getDeferredCalls();
    }

    public boolean hasRemoteCall(String address, String name, String version, String action) {
        for (String[] call : this.remoteCalls) {
            if (!call[0].equals(address) || !call[1].equals(name) || !call[2].equals(version) || !call[3].equals(action)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemoteCalls() {
        return this.remoteCalls != null && this.remoteCalls.length != 0;
    }

    public String[][] getRemoteCalls() {
        return this.remoteCalls;
    }

    public boolean hasReturn() {
        return this.returnObject != null || this.returnObject.getType() == null;
    }

    @JsonIgnore
    public String getReturnType() {
        return this.returnObject.getType();
    }

    public Map<String, ActionParamSchema> getParams() {
        return this.params;
    }

    public boolean hasParam(String name) {
        return this.params != null && this.params.containsKey(name);
    }

    public ActionParamSchema getParamSchema(String name) {
        if (!this.params.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot resolve schema for parameter: %s", name));
        }
        return this.params.get(name);
    }

    public Map<String, FileSchema> getFiles() {
        return this.files;
    }

    public boolean hasFile(String name) {
        return this.files != null && this.files.containsKey(name);
    }

    public FileSchema getFileSchema(String name) {
        if (!this.files.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot resolve schema for file: %s", name));
        }
        FileSchema fileSchema = this.files.get(name);
        fileSchema.setName(name);
        return fileSchema;
    }

    @JsonIgnore
    public ActionHttpSchema getHttpSchema() {
        return this.getHttp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionSchema that = (ActionSchema)o;
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.collection != that.collection) {
            return false;
        }
        if (this.deprecated != that.deprecated) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.entityPath != null ? !this.entityPath.equals(that.entityPath) : that.entityPath != null) {
            return false;
        }
        if (this.pathDelimiter != null ? !this.pathDelimiter.equals(that.pathDelimiter) : that.pathDelimiter != null) {
            return false;
        }
        if (this.primaryKey != null ? !this.primaryKey.equals(that.primaryKey) : that.primaryKey != null) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.calls, (Object[])that.calls)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.deferredCalls, (Object[])that.deferredCalls)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.remoteCalls, (Object[])that.remoteCalls)) {
            return false;
        }
        if (this.fallbacks != null ? !this.fallbacks.equals(that.fallbacks) : that.fallbacks != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.files != null ? !this.files.equals(that.files) : that.files != null) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(that.entity) : that.entity != null) {
            return false;
        }
        if (this.relations != null ? !this.relations.equals(that.relations) : that.relations != null) {
            return false;
        }
        return this.returnObject != null ? this.returnObject.equals(that.returnObject) : that.returnObject == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.timeout;
        result = 31 * result + (this.entityPath != null ? this.entityPath.hashCode() : 0);
        result = 31 * result + (this.pathDelimiter != null ? this.pathDelimiter.hashCode() : 0);
        result = 31 * result + (this.primaryKey != null ? this.primaryKey.hashCode() : 0);
        result = 31 * result + (this.collection ? 1 : 0);
        result = 31 * result + Arrays.deepHashCode((Object[])this.calls);
        result = 31 * result + Arrays.deepHashCode((Object[])this.deferredCalls);
        result = 31 * result + Arrays.deepHashCode((Object[])this.remoteCalls);
        result = 31 * result + (this.fallbacks != null ? this.fallbacks.hashCode() : 0);
        result = 31 * result + (this.deprecated ? 1 : 0);
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.files != null ? this.files.hashCode() : 0);
        result = 31 * result + (this.entity != null ? this.entity.hashCode() : 0);
        result = 31 * result + (this.relations != null ? this.relations.hashCode() : 0);
        result = 31 * result + (this.returnObject != null ? this.returnObject.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ActionSchema{name='" + this.name + '\'' + ", timeout=" + this.timeout + ", entityPath='" + this.entityPath + '\'' + ", pathDelimiter='" + this.pathDelimiter + '\'' + ", primaryKey='" + this.primaryKey + '\'' + ", collection=" + this.collection + ", calls=" + Arrays.toString((Object[])this.calls) + ", deferredCalls=" + Arrays.toString((Object[])this.deferredCalls) + ", remoteCalls=" + Arrays.toString((Object[])this.remoteCalls) + ", fallbacks=" + this.fallbacks + ", deprecated=" + this.deprecated + ", http=" + this.http + ", params=" + this.params + ", files=" + this.files + ", entity=" + this.entity + ", relations=" + this.relations + ", returnObject=" + this.returnObject + '}';
    }
}

