/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kusanagi.katana.sdk.FileHttpSchema;

public class FileSchema {
    private String name;
    @JsonProperty(value="m")
    private String mime;
    @JsonProperty(value="r")
    private boolean required;
    @JsonProperty(value="mx")
    private int max;
    @JsonProperty(value="ex")
    private boolean exclusiveMax;
    @JsonProperty(value="mn")
    private int min;
    @JsonProperty(value="en")
    private boolean exclusiveMin;
    @JsonProperty(value="h")
    private FileHttpSchema http;

    public FileSchema() {
        this.required = false;
        this.max = Integer.MAX_VALUE;
        this.exclusiveMax = false;
        this.min = 0;
        this.exclusiveMax = false;
        this.http = new FileHttpSchema();
        this.mime = "text/plain";
    }

    public FileSchema(FileSchema other) {
        this.mime = other.mime;
        this.required = other.required;
        this.max = other.max;
        this.exclusiveMax = other.exclusiveMax;
        this.min = other.min;
        this.exclusiveMin = other.exclusiveMin;
        this.http = other.http;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setExclusiveMax(boolean exclusiveMax) {
        this.exclusiveMax = exclusiveMax;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setExclusiveMin(boolean exclusiveMin) {
        this.exclusiveMin = exclusiveMin;
    }

    public FileHttpSchema getHttp() {
        return this.http;
    }

    public void setHttp(FileHttpSchema http) {
        this.http = http;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public String getMime() {
        return this.mime;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isExclusiveMax() {
        return this.exclusiveMax;
    }

    public int getMin() {
        return this.min;
    }

    public boolean isExclusiveMin() {
        return this.exclusiveMin;
    }

    @JsonIgnore
    public FileHttpSchema getHttpSchema() {
        return this.getHttp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileSchema)) {
            return false;
        }
        FileSchema that = (FileSchema)o;
        if (this.isRequired() != that.isRequired()) {
            return false;
        }
        if (this.getMax() != that.getMax()) {
            return false;
        }
        if (this.isExclusiveMax() != that.isExclusiveMax()) {
            return false;
        }
        if (this.getMin() != that.getMin()) {
            return false;
        }
        if (this.isExclusiveMin() != that.isExclusiveMin()) {
            return false;
        }
        if (this.getMime() != null ? !this.getMime().equals(that.getMime()) : that.getMime() != null) {
            return false;
        }
        return this.getHttp() != null ? this.getHttp().equals(that.getHttp()) : that.getHttp() == null;
    }

    public int hashCode() {
        int result = this.getMime() != null ? this.getMime().hashCode() : 0;
        result = 31 * result + (this.isRequired() ? 1 : 0);
        result = 31 * result + this.getMax();
        result = 31 * result + (this.isExclusiveMax() ? 1 : 0);
        result = 31 * result + this.getMin();
        result = 31 * result + (this.isExclusiveMin() ? 1 : 0);
        result = 31 * result + (this.getHttp() != null ? this.getHttp().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FileSchema{mime='" + this.mime + '\'' + ", required=" + this.required + ", max=" + this.max + ", exclusiveMax=" + this.exclusiveMax + ", min=" + this.min + ", exclusiveMin=" + this.exclusiveMin + ", http=" + this.http + '}';
    }
}

