/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kusanagi.katana.api.component.utils.Logger;
import io.kusanagi.katana.api.serializers.HttpRequestEntity;
import io.kusanagi.katana.sdk.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    private HttpRequestEntity httpRequestEntity;

    private HttpRequest(HttpRequestEntity httpRequestEntity) {
        this.httpRequestEntity = httpRequestEntity;
    }

    public HttpRequest(HttpRequest other) {
        this.httpRequestEntity = other.httpRequestEntity;
    }

    public boolean isMethod(String method) {
        return this.getMethod().equals(method);
    }

    public String getMethod() {
        return this.httpRequestEntity.getMethod();
    }

    public String getUrl() {
        return this.httpRequestEntity.getUrl();
    }

    @JsonIgnore
    public String getUrlScheme() {
        try {
            return new URL(this.httpRequestEntity.getUrl()).getProtocol();
        }
        catch (MalformedURLException e) {
            Logger.log(e);
            return "";
        }
    }

    @JsonIgnore
    public String getUrlHost() {
        try {
            return new URL(this.httpRequestEntity.getUrl()).getHost();
        }
        catch (MalformedURLException e) {
            Logger.log(e);
            return "";
        }
    }

    @JsonIgnore
    public String getUrlPath() {
        try {
            return new URL(this.httpRequestEntity.getUrl()).getPath();
        }
        catch (MalformedURLException e) {
            Logger.log(e);
            return "";
        }
    }

    public boolean hasQueryParam(String name) {
        return this.httpRequestEntity.getQueryParamsArray().containsKey(name);
    }

    public String getQueryParam(String name, String defaultValue) {
        List<String> values = this.httpRequestEntity.getQueryParamsArray().get(name);
        return values == null || values.isEmpty() ? (defaultValue == null ? "" : defaultValue) : values.get(0);
    }

    public String getQueryParam(String name) {
        return this.getQueryParam(name, "");
    }

    public List<String> getQueryParamArray(String name, List<String> defaultArray) {
        List<String> values = this.httpRequestEntity.getQueryParamsArray().get(name);
        return values != null && !values.isEmpty() ? values : (defaultArray != null ? defaultArray : new ArrayList());
    }

    public List<String> getQueryParamArray(String name) {
        return this.getQueryParamArray(name, new ArrayList<String>());
    }

    @JsonIgnore
    public Map<String, String> getQueryParams() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> key : this.httpRequestEntity.getQueryParamsArray().entrySet()) {
            queryParams.put(key.getKey(), this.httpRequestEntity.getQueryParamsArray().get(key.getKey()).get(0));
        }
        return queryParams;
    }

    public Map<String, List<String>> getQueryParamsArray() {
        return this.httpRequestEntity.getQueryParamsArray();
    }

    public boolean hasPostParam(String name) {
        return this.httpRequestEntity.getPostParamsArray().containsKey(name);
    }

    @JsonIgnore
    public String getPostParam(String name, String defaultValue) {
        List<String> values = this.httpRequestEntity.getPostParamsArray().get(name);
        return values == null || values.isEmpty() ? (defaultValue == null ? "" : defaultValue) : values.get(0);
    }

    @JsonIgnore
    public List<String> getPostParamArray(String name, List<String> defaultArray) {
        List<String> values = this.httpRequestEntity.getPostParamsArray().get(name);
        return values != null && !values.isEmpty() ? values : (defaultArray != null ? defaultArray : new ArrayList());
    }

    @JsonIgnore
    public Map<String, String> getPostParams() {
        HashMap<String, String> postParams = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> key : this.httpRequestEntity.getPostParamsArray().entrySet()) {
            postParams.put(key.getKey(), this.httpRequestEntity.getPostParamsArray().get(key.getKey()).get(0));
        }
        return postParams;
    }

    public Map<String, List<String>> getPostParamsArray() {
        return this.httpRequestEntity.getPostParamsArray();
    }

    public boolean isProtocolVersion(String version) {
        return this.httpRequestEntity.getProtocolVersion().equals(version);
    }

    public String getProtocolVersion() {
        return this.httpRequestEntity.getProtocolVersion();
    }

    public boolean hasHeader(String name) {
        return this.httpRequestEntity.getHeaders().containsKey(name);
    }

    public String getHeader(String name, String defaultValue) {
        List<String> values = this.httpRequestEntity.getHeaders().get(name);
        return values == null || values.isEmpty() ? (defaultValue == null ? "" : defaultValue) : values.get(0);
    }

    public String getHeader(String name) {
        return this.getHeader(name, "");
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> key : this.httpRequestEntity.getHeaders().entrySet()) {
            if (this.httpRequestEntity.getHeaders().get(key.getKey()).isEmpty()) continue;
            headers.put(key.getKey(), this.httpRequestEntity.getHeaders().get(key.getKey()).get(0));
        }
        return headers;
    }

    public Map<String, List<String>> getHeadersArray() {
        return this.httpRequestEntity.getHeaders();
    }

    public boolean hasBody() {
        return this.httpRequestEntity.getBody() != null && !this.httpRequestEntity.getBody().isEmpty();
    }

    public String getBody() {
        return this.httpRequestEntity.getBody();
    }

    public boolean hasFile(String name) {
        for (File file : this.httpRequestEntity.getFiles()) {
            if (!file.getFilename().equals(name)) continue;
            return true;
        }
        return false;
    }

    public File getFile(String name) {
        for (File file : this.httpRequestEntity.getFiles()) {
            if (!file.getFilename().equals(name)) continue;
            return file;
        }
        File file = new File();
        file.setName(name);
        return file;
    }

    public List<File> getFiles() {
        return this.httpRequestEntity.getFiles();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.httpRequestEntity != null ? this.httpRequestEntity.equals(that.httpRequestEntity) : that.httpRequestEntity == null;
    }

    public int hashCode() {
        return this.httpRequestEntity != null ? this.httpRequestEntity.hashCode() : 0;
    }

    public String toString() {
        return "HttpRequest{httpRequestEntity=" + this.httpRequestEntity + '}';
    }

    public static class Builder {
        private HttpRequestEntity httpRequestEntity;

        public Builder setHttpRequestEntity(HttpRequestEntity httpRequestEntity) {
            this.httpRequestEntity = httpRequestEntity;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.httpRequestEntity);
        }
    }
}

