/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import io.kusanagi.katana.api.Api;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.commands.RequestCommandPayload;
import io.kusanagi.katana.api.commands.ResponseCommandPayload;
import io.kusanagi.katana.api.commands.common.CommandPayload;
import io.kusanagi.katana.api.component.Component;
import io.kusanagi.katana.api.replies.CallReplyPayload;
import io.kusanagi.katana.api.replies.ResponseReplyPayload;
import io.kusanagi.katana.api.replies.common.CommandReplyResult;
import io.kusanagi.katana.api.serializers.HttpResponseEntity;
import io.kusanagi.katana.api.serializers.RequestEntity;
import io.kusanagi.katana.api.serializers.ResponseEntity;
import io.kusanagi.katana.sdk.Callable;
import io.kusanagi.katana.sdk.HttpResponse;
import io.kusanagi.katana.sdk.Request;
import io.kusanagi.katana.sdk.RequestCall;
import io.kusanagi.katana.sdk.Response;
import java.io.IOException;

public class Middleware
extends Component<Api, CommandReplyResult, Middleware> {
    private Callable<Request> requestCallable;
    private Callable<Response> responseCallable;

    public Middleware(String[] args) {
        super(args);
    }

    public Middleware request(Callable<Request> callable) {
        this.requestCallable = callable;
        return this;
    }

    public Middleware response(Callable<Response> callable) {
        this.responseCallable = callable;
        return this;
    }

    @Override
    protected Api getSdkCommand(String componentType, Mapping mappings, byte[] commandBytes) throws IOException {
        if (componentType.equals("request")) {
            CommandPayload command = this.serializer.deserialize(commandBytes, RequestCommandPayload.class);
            RequestEntity requestEntity = (RequestEntity)command.getCommand().getArgument();
            return (Api)new Request.Builder().setRequestEntity(requestEntity).setComponent(this).setName(this.getName()).setVersion(this.getVersion()).setPlatformVersion(this.getFrameworkVersion()).setVariables(this.getVar()).setDebug(this.isDebug()).setMapping(mappings).build();
        }
        CommandPayload command = this.serializer.deserialize(commandBytes, ResponseCommandPayload.class);
        ResponseEntity responseEntity = (ResponseEntity)command.getCommand().getArgument();
        return (Api)new Response.Builder().setResponseEntity(responseEntity).setComponent(this).setPath(responseEntity.getTransport().getMeta().getGateway().get(1)).setName(this.getName()).setVersion(this.getVersion()).setPlatformVersion(this.getFrameworkVersion()).setVariables(this.getVar()).setDebug(this.isDebug()).setMapping(mappings).build();
    }

    @Override
    protected Api getSdkCommand(String componentType, Mapping mappings, String jsonCommand) throws IOException {
        if (componentType.equals("request")) {
            CommandPayload command = this.serializer.deserialize(jsonCommand, RequestCommandPayload.class);
            RequestEntity requestEntity = (RequestEntity)command.getCommand().getArgument();
            return (Api)new Request.Builder().setRequestEntity(requestEntity).setComponent(this).setName(this.getName()).setVersion(this.getVersion()).setPlatformVersion(this.getFrameworkVersion()).setVariables(this.getVar()).setDebug(this.isDebug()).setMapping(mappings).build();
        }
        CommandPayload command = this.serializer.deserialize(jsonCommand, ResponseCommandPayload.class);
        ResponseEntity responseEntity = (ResponseEntity)command.getCommand().getArgument();
        return (Api)new Response.Builder().setResponseEntity(responseEntity).setComponent(this).setPath(responseEntity.getTransport().getMeta().getGateway().get(1)).setName(this.getName()).setVersion(this.getVersion()).setPlatformVersion(this.getFrameworkVersion()).setVariables(this.getVar()).setDebug(this.isDebug()).setMapping(mappings).build();
    }

    @Override
    protected CommandReplyResult getCommandReplyPayload(String componentType, Api response) {
        if (componentType.equals("request")) {
            CallReplyPayload commandReplyPayload = new CallReplyPayload();
            CallReplyPayload.CallCommandReply callCommandReply = new CallReplyPayload.CallCommandReply();
            CallReplyPayload.CallResult callResult = new CallReplyPayload.CallResult();
            callResult.setRequestCall((RequestCall)this.getReply(componentType, response));
            callCommandReply.setName(this.getName());
            callCommandReply.setResult(callResult);
            commandReplyPayload.setCommandReply(callCommandReply);
            return commandReplyPayload;
        }
        ResponseReplyPayload commandReplyPayload = new ResponseReplyPayload();
        ResponseReplyPayload.ResponseCommandReply responseCommandReply = new ResponseReplyPayload.ResponseCommandReply();
        ResponseReplyPayload.ResponseResult responseResult = new ResponseReplyPayload.ResponseResult();
        HttpResponse httpResponse = (HttpResponse)this.getReply(componentType, response);
        HttpResponseEntity httpResponseEntity = new HttpResponseEntity();
        httpResponseEntity.setHeaders(httpResponse.getHeadersArray());
        httpResponseEntity.setStatus(httpResponse.getStatus());
        httpResponseEntity.setProtocolVersion(httpResponse.getProtocolVersion());
        httpResponseEntity.setBody(httpResponse.getBody());
        responseResult.setHttpResponse(httpResponseEntity);
        responseCommandReply.setName(this.getName());
        responseCommandReply.setResult(responseResult);
        commandReplyPayload.setCommandReply(responseCommandReply);
        return commandReplyPayload;
    }

    @Override
    protected CommandReplyResult getReply(String componentType, Api response) {
        return componentType.equals("request") ? ((Request)response).getRequestCall() : ((Response)response).getHttpResponse();
    }

    @Override
    protected byte[] getReplyMetadata(CommandReplyResult reply) {
        return new byte[0];
    }

    @Override
    protected Callable getCallable(String componentType) {
        return componentType.equals("request") ? this.requestCallable : this.responseCallable;
    }

    @Override
    public void run() {
        if (this.startupCallable != null) {
            this.startupCallable.run(this);
        }
        super.run();
    }

    @Override
    protected void runShutdown() {
        if (this.shutdownCallable != null) {
            this.shutdownCallable.run(this);
        }
    }

    @Override
    protected void runErrorCallback() {
        if (this.errorCallable != null) {
            this.errorCallable.run(this);
        }
    }
}

