/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonProperty;

public class Param {
    @JsonProperty(value="n")
    private String name;
    @JsonProperty(value="v")
    private Object value;
    @JsonProperty(value="t")
    private String type;
    private boolean exists;

    public Param() {
        this.value = "";
        this.type = "string";
        this.exists = false;
    }

    public Param(String name, Object value, String type, boolean exists) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.exists = exists;
    }

    public Param(Param other) {
        this.name = other.name;
        this.value = other.value;
        this.type = other.type;
        this.exists = other.exists;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public boolean exists() {
        return this.exists;
    }

    public Param copyWithName(String name) {
        return new Param(name, this.value, this.type, this.exists);
    }

    public Param copyWithValue(String value) {
        return new Param(this.name, value, this.type, this.exists);
    }

    public Param copyWithType(String type) {
        return new Param(this.name, this.value, type, this.exists);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Param param = (Param)o;
        if (this.exists != param.exists) {
            return false;
        }
        if (this.name != null ? !this.name.equals(param.name) : param.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(param.value) : param.value != null) {
            return false;
        }
        return this.type != null ? this.type.equals(param.type) : param.type == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.exists ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Param{name='" + this.name + '\'' + ", value=" + this.value + ", type='" + this.type + '\'' + ", exists=" + this.exists + '}';
    }
}

