/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import io.kusanagi.katana.api.commands.ActionCommandPayload;
import io.kusanagi.katana.api.commands.Mapping;
import io.kusanagi.katana.api.commands.common.CommandPayload;
import io.kusanagi.katana.api.component.Component;
import io.kusanagi.katana.api.replies.TransportReplyPayload;
import io.kusanagi.katana.api.replies.common.CommandReplyResult;
import io.kusanagi.katana.api.serializers.ActionEntity;
import io.kusanagi.katana.api.serializers.TransportEntity;
import io.kusanagi.katana.sdk.Action;
import io.kusanagi.katana.sdk.Callable;
import io.kusanagi.katana.sdk.Transport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Service
extends Component<Action, TransportReplyPayload, Service> {
    private Map<String, Callable<Action>> callables = new HashMap<String, Callable<Action>>();

    public Service(String[] args) {
        super(args);
    }

    public Service action(String action, Callable<Action> callable) {
        this.callables.put(action, callable);
        return this;
    }

    @Override
    protected CommandReplyResult getReply(String componentType, Action action) {
        return action.getTransport();
    }

    @Override
    protected byte[] getReplyMetadata(TransportReplyPayload reply) {
        byte[] replyMetaData;
        TransportEntity transport = reply.getCommandReply().getResult().getTransport();
        byte callsByte = 0;
        byte filesByte = 0;
        byte transactionsByte = 0;
        byte downloadByte = 0;
        int byteSize = 0;
        if (transport.getCalls() != null && !transport.getCalls().isEmpty()) {
            callsByte = 1;
            ++byteSize;
        }
        if (transport.getFiles() != null && !transport.getFiles().isEmpty()) {
            filesByte = 2;
            ++byteSize;
        }
        if (transport.getTransactions() != null && !transport.getTransactions().getCommit().isEmpty()) {
            transactionsByte = 3;
            ++byteSize;
        }
        if (transport.getBody() != null) {
            downloadByte = 4;
            ++byteSize;
        }
        if (byteSize > 0) {
            replyMetaData = new byte[byteSize];
            int position = 0;
            position = this.registerByte(callsByte, replyMetaData, position) ? position + 1 : position;
            position = this.registerByte(filesByte, replyMetaData, position) ? position + 1 : position;
            position = this.registerByte(transactionsByte, replyMetaData, position) ? position + 1 : position;
            this.registerByte(downloadByte, replyMetaData, position);
        } else {
            replyMetaData = new byte[]{0};
        }
        return replyMetaData;
    }

    private boolean registerByte(byte aByte, byte[] byteArray, int position) {
        if (aByte != 0) {
            byteArray[position] = aByte;
            return true;
        }
        return false;
    }

    @Override
    protected Callable<Action> getCallable(String componentType) {
        return this.callables.get(componentType);
    }

    @Override
    protected Action getSdkCommand(String componentType, Mapping mappings, byte[] commandBytes) throws IOException {
        CommandPayload command = this.serializer.deserialize(commandBytes, ActionCommandPayload.class);
        ActionEntity actionEntity = (ActionEntity)command.getCommand().getArgument();
        actionEntity.setActionName(componentType);
        return (Action)new Action.Builder().setActionEntity(actionEntity).setComponent(this).setPath(actionEntity.getTransport().getMeta().getGateway().get(1)).setName(this.getName()).setVersion(this.getVersion()).setPlatformVersion(this.getFrameworkVersion()).setVariables(this.getVar()).setDebug(this.isDebug()).setMapping(mappings).build();
    }

    @Override
    protected Action getSdkCommand(String componentType, Mapping mappings, String jsonCommand) throws IOException {
        CommandPayload command = this.serializer.deserialize(jsonCommand, ActionCommandPayload.class);
        ActionEntity actionEntity = (ActionEntity)command.getCommand().getArgument();
        actionEntity.setActionName(componentType);
        return (Action)new Action.Builder().setActionEntity(actionEntity).setComponent(this).setPath(actionEntity.getTransport().getMeta().getGateway().get(1)).setName(this.getName()).setVersion(this.getVersion()).setPlatformVersion(this.getFrameworkVersion()).setVariables(this.getVar()).setDebug(this.isDebug()).setMapping(mappings).build();
    }

    @Override
    protected TransportReplyPayload getCommandReplyPayload(String componentType, Action action) {
        TransportReplyPayload commandReplyPayload = new TransportReplyPayload();
        TransportReplyPayload.TransportCommandReply transportCommandReply = new TransportReplyPayload.TransportCommandReply();
        TransportReplyPayload.TransportResult transportResult = new TransportReplyPayload.TransportResult();
        Transport transport = (Transport)this.getReply(componentType, action);
        TransportEntity transportEntity = new TransportEntity();
        transportEntity.setMeta(transport.getMeta());
        transportEntity.setBody(transport.getBody());
        transportEntity.setFiles(transport.getFilesEntity());
        transportEntity.setData(transport.getData());
        transportEntity.setRelations(transport.getRelations());
        transportEntity.setLinks(transport.getLinks());
        transportEntity.setCalls(transport.getCalls());
        transportEntity.setTransactions(transport.getTransactions());
        transportEntity.setErrors(transport.getErrors());
        transportResult.setTransport(transportEntity);
        transportResult.setReturnObject(action.getReturnObject());
        transportCommandReply.setName(this.getName());
        transportCommandReply.setResult(transportResult);
        commandReplyPayload.setCommandReply(transportCommandReply);
        return commandReplyPayload;
    }

    @Override
    public void run() {
        if (this.startupCallable != null) {
            this.startupCallable.run(this);
        }
        super.run();
    }

    @Override
    protected void runShutdown() {
        if (this.shutdownCallable != null) {
            this.shutdownCallable.run(this);
        }
    }

    @Override
    protected void runErrorCallback() {
        if (this.errorCallable != null) {
            this.errorCallable.run(this);
        }
    }
}

