/*
 * Decompiled with CFR 0.152.
 */
package io.kusanagi.katana.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kusanagi.katana.sdk.ActionSchema;
import io.kusanagi.katana.sdk.HttpSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSchema {
    private String name;
    private String version;
    @JsonProperty(value="a")
    private String address;
    @JsonProperty(value="f")
    private boolean files;
    @JsonProperty(value="h")
    private HttpSchema httpSchema;
    @JsonProperty(value="ac")
    private Map<String, ActionSchema> actionSchemas;

    public ServiceSchema() {
        this.files = false;
        this.httpSchema = new HttpSchema();
        this.actionSchemas = new HashMap<String, ActionSchema>();
    }

    public ServiceSchema(ServiceSchema other) {
        this.address = other.address;
        this.files = other.files;
        this.httpSchema = other.httpSchema;
        this.actionSchemas = other.actionSchemas;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setFiles(boolean files) {
        this.files = files;
    }

    public boolean isFiles() {
        return this.files;
    }

    public void setHttpSchema(HttpSchema httpSchema) {
        this.httpSchema = httpSchema;
    }

    public Map<String, ActionSchema> getActionSchemas() {
        return this.actionSchemas;
    }

    public void setActionSchemas(Map<String, ActionSchema> actionSchemas) {
        this.actionSchemas = actionSchemas;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getVersion() {
        return this.version;
    }

    public boolean hasFileServer() {
        return this.isFiles();
    }

    @JsonIgnore
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        for (String s : this.actionSchemas.keySet()) {
            actions.add(s);
        }
        return actions;
    }

    public boolean hasAction(String name) {
        return this.actionSchemas.containsKey(name);
    }

    public ActionSchema getActionSchema(String name) {
        if (!this.actionSchemas.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot resolve schema for action: %s", name));
        }
        return this.actionSchemas.get(name);
    }

    public HttpSchema getHttpSchema() {
        return this.httpSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceSchema)) {
            return false;
        }
        ServiceSchema that = (ServiceSchema)o;
        if (this.isFiles() != that.isFiles()) {
            return false;
        }
        if (this.getAddress() != null ? !this.getAddress().equals(that.getAddress()) : that.getAddress() != null) {
            return false;
        }
        if (this.getHttpSchema() != null ? !this.getHttpSchema().equals(that.getHttpSchema()) : that.getHttpSchema() != null) {
            return false;
        }
        return this.getActions() != null ? this.getActions().equals(that.getActions()) : that.getActions() == null;
    }

    public int hashCode() {
        int result = this.getAddress() != null ? this.getAddress().hashCode() : 0;
        result = 31 * result + (this.isFiles() ? 1 : 0);
        result = 31 * result + (this.getHttpSchema() != null ? this.getHttpSchema().hashCode() : 0);
        result = 31 * result + (this.getActions() != null ? this.getActions().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceSchema{address='" + this.address + '\'' + ", files=" + this.files + ", httpSchema=" + this.httpSchema + ", actionSchemas=" + this.actionSchemas + '}';
    }
}

