/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import zmq.Ctx;
import zmq.IOThread;
import zmq.Options;
import zmq.ZObject;

abstract class Own
extends ZObject {
    protected final Options options;
    private boolean terminating;
    private final AtomicLong sendSeqnum;
    private long processedSeqnum;
    private Own owner;
    private final Set<Own> owned;
    private int termAcks;

    public Own(Ctx parent, int tid) {
        super(parent, tid);
        this.terminating = false;
        this.sendSeqnum = new AtomicLong(0L);
        this.processedSeqnum = 0L;
        this.owner = null;
        this.termAcks = 0;
        this.options = new Options();
        this.owned = new HashSet<Own>();
    }

    public Own(IOThread ioThread, Options options) {
        super(ioThread);
        this.options = options;
        this.terminating = false;
        this.sendSeqnum = new AtomicLong(0L);
        this.processedSeqnum = 0L;
        this.owner = null;
        this.termAcks = 0;
        this.owned = new HashSet<Own>();
    }

    public abstract void destroy();

    protected void processDestroy() {
        this.destroy();
    }

    private void setOwner(Own owner) {
        assert (this.owner == null);
        this.owner = owner;
    }

    void incSeqnum() {
        this.sendSeqnum.incrementAndGet();
    }

    @Override
    protected void processSeqnum() {
        ++this.processedSeqnum;
        this.checkTermAcks();
    }

    protected void launchChild(Own object) {
        object.setOwner(this);
        this.sendPlug(object);
        this.sendOwn(this, object);
    }

    protected void termChild(Own object) {
        this.processTermReq(object);
    }

    @Override
    protected void processTermReq(Own object) {
        if (this.terminating) {
            return;
        }
        if (!this.owned.contains(object)) {
            return;
        }
        this.owned.remove(object);
        this.registerTermAcks(1);
        this.sendTerm(object, this.options.linger);
    }

    @Override
    protected void processOwn(Own object) {
        if (this.terminating) {
            this.registerTermAcks(1);
            this.sendTerm(object, 0);
            return;
        }
        this.owned.add(object);
    }

    protected void terminate() {
        if (this.terminating) {
            return;
        }
        if (this.owner == null) {
            this.processTerm(this.options.linger);
            return;
        }
        this.sendTermReq(this.owner, this);
    }

    protected boolean isTerminating() {
        return this.terminating;
    }

    @Override
    protected void processTerm(int linger) {
        assert (!this.terminating);
        for (Own it : this.owned) {
            this.sendTerm(it, linger);
        }
        this.registerTermAcks(this.owned.size());
        this.owned.clear();
        this.terminating = true;
        this.checkTermAcks();
    }

    public void registerTermAcks(int count) {
        this.termAcks += count;
    }

    public void unregisterTermAck() {
        assert (this.termAcks > 0);
        --this.termAcks;
        this.checkTermAcks();
    }

    @Override
    protected void processTermAck() {
        this.unregisterTermAck();
    }

    private void checkTermAcks() {
        if (this.terminating && this.processedSeqnum == this.sendSeqnum.get() && this.termAcks == 0) {
            assert (this.owned.isEmpty());
            if (this.owner != null) {
                this.sendTermAck(this.owner);
            }
            this.processDestroy();
        }
    }
}

