(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kvision-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kvision-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-chart-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kvision-kvision-chart-js-legacy'.");
    }
    if (typeof this['kvision-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kvision-kvision-chart-js-legacy'. Its dependency 'kvision-js-legacy' was not found. Please, check whether 'kvision-js-legacy' is loaded prior to 'kvision-kvision-chart-js-legacy'.");
    }
    root['kvision-kvision-chart-js-legacy'] = factory(typeof this['kvision-kvision-chart-js-legacy'] === 'undefined' ? {} : this['kvision-kvision-chart-js-legacy'], kotlin, this['kvision-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kvision_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ModuleInitializer = $module$kvision_js_legacy.io.kvision.ModuleInitializer;
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var Widget = $module$kvision_js_legacy.io.kvision.core.Widget;
  var getCallableRef = Kotlin.getCallableRef;
  var ensureNotNull = Kotlin.ensureNotNull;
  var Unit = Kotlin.kotlin.Unit;
  var i18n = $module$kvision_js_legacy.io.kvision.i18n;
  var equals = Kotlin.equals;
  var createInstance = $module$kvision_js_legacy.io.kvision.utils.createInstance_aevmdv$;
  var Canvas = $module$kvision_js_legacy.io.kvision.html.Canvas;
  var throwCCE = Kotlin.throwCCE;
  var Object_init = Object;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  UpdateMode.prototype = Object.create(Enum.prototype);
  UpdateMode.prototype.constructor = UpdateMode;
  Chart.prototype = Object.create(Widget.prototype);
  Chart.prototype.constructor = Chart;
  ChartCanvas.prototype = Object.create(Canvas.prototype);
  ChartCanvas.prototype.constructor = ChartCanvas;
  ChartType.prototype = Object.create(Enum.prototype);
  ChartType.prototype.constructor = ChartType;
  InteractionMode.prototype = Object.create(Enum.prototype);
  InteractionMode.prototype.constructor = InteractionMode;
  Eeasing.prototype = Object.create(Enum.prototype);
  Eeasing.prototype.constructor = Eeasing;
  Position.prototype = Object.create(Enum.prototype);
  Position.prototype.constructor = Position;
  TooltipPosition.prototype = Object.create(Enum.prototype);
  TooltipPosition.prototype.constructor = TooltipPosition;
  PointStyle.prototype = Object.create(Enum.prototype);
  PointStyle.prototype.constructor = PointStyle;
  InterpolationMode.prototype = Object.create(Enum.prototype);
  InterpolationMode.prototype.constructor = InterpolationMode;
  ScalesType.prototype = Object.create(Enum.prototype);
  ScalesType.prototype.constructor = ScalesType;
  LineCap.prototype = Object.create(Enum.prototype);
  LineCap.prototype.constructor = LineCap;
  LineJoin.prototype = Object.create(Enum.prototype);
  LineJoin.prototype.constructor = LineJoin;
  LegendAlign.prototype = Object.create(Enum.prototype);
  LegendAlign.prototype.constructor = LegendAlign;
  TooltipAlign.prototype = Object.create(Enum.prototype);
  TooltipAlign.prototype.constructor = TooltipAlign;
  LegendLabelAlign.prototype = Object.create(Enum.prototype);
  LegendLabelAlign.prototype.constructor = LegendLabelAlign;
  TitleAlign.prototype = Object.create(Enum.prototype);
  TitleAlign.prototype.constructor = TitleAlign;
  TextDirection.prototype = Object.create(Enum.prototype);
  TextDirection.prototype.constructor = TextDirection;
  SkipMode.prototype = Object.create(Enum.prototype);
  SkipMode.prototype.constructor = SkipMode;
  BorderAlign.prototype = Object.create(Enum.prototype);
  BorderAlign.prototype.constructor = BorderAlign;
  CrossAlign.prototype = Object.create(Enum.prototype);
  CrossAlign.prototype.constructor = CrossAlign;
  ScaleBounds.prototype = Object.create(Enum.prototype);
  ScaleBounds.prototype.constructor = ScaleBounds;
  function ChartModule() {
    ChartModule_instance = this;
    this.chartjs_0 = require('chart.js/auto').default;
  }
  ChartModule.prototype.getConstructor = function () {
    return this.chartjs_0;
  };
  ChartModule.prototype.initialize = function () {
  };
  ChartModule.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ChartModule',
    interfaces: [ModuleInitializer]
  };
  var ChartModule_instance = null;
  function ChartModule_getInstance() {
    if (ChartModule_instance === null) {
      new ChartModule();
    }
    return ChartModule_instance;
  }
  function UpdateMode(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function UpdateMode_initFields() {
    UpdateMode_initFields = function () {
    };
    UpdateMode$ACTIVE_instance = new UpdateMode('ACTIVE', 0, 'active');
    UpdateMode$HIDE_instance = new UpdateMode('HIDE', 1, 'hide');
    UpdateMode$RESET_instance = new UpdateMode('RESET', 2, 'reset');
    UpdateMode$RESIZE_instance = new UpdateMode('RESIZE', 3, 'resize');
    UpdateMode$SHOW_instance = new UpdateMode('SHOW', 4, 'show');
    UpdateMode$NONE_instance = new UpdateMode('NONE', 5, 'none');
  }
  var UpdateMode$ACTIVE_instance;
  function UpdateMode$ACTIVE_getInstance() {
    UpdateMode_initFields();
    return UpdateMode$ACTIVE_instance;
  }
  var UpdateMode$HIDE_instance;
  function UpdateMode$HIDE_getInstance() {
    UpdateMode_initFields();
    return UpdateMode$HIDE_instance;
  }
  var UpdateMode$RESET_instance;
  function UpdateMode$RESET_getInstance() {
    UpdateMode_initFields();
    return UpdateMode$RESET_instance;
  }
  var UpdateMode$RESIZE_instance;
  function UpdateMode$RESIZE_getInstance() {
    UpdateMode_initFields();
    return UpdateMode$RESIZE_instance;
  }
  var UpdateMode$SHOW_instance;
  function UpdateMode$SHOW_getInstance() {
    UpdateMode_initFields();
    return UpdateMode$SHOW_instance;
  }
  var UpdateMode$NONE_instance;
  function UpdateMode$NONE_getInstance() {
    UpdateMode_initFields();
    return UpdateMode$NONE_instance;
  }
  UpdateMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UpdateMode',
    interfaces: [Enum]
  };
  function UpdateMode$values() {
    return [UpdateMode$ACTIVE_getInstance(), UpdateMode$HIDE_getInstance(), UpdateMode$RESET_getInstance(), UpdateMode$RESIZE_getInstance(), UpdateMode$SHOW_getInstance(), UpdateMode$NONE_getInstance()];
  }
  UpdateMode.values = UpdateMode$values;
  function UpdateMode$valueOf(name) {
    switch (name) {
      case 'ACTIVE':
        return UpdateMode$ACTIVE_getInstance();
      case 'HIDE':
        return UpdateMode$HIDE_getInstance();
      case 'RESET':
        return UpdateMode$RESET_getInstance();
      case 'RESIZE':
        return UpdateMode$RESIZE_getInstance();
      case 'SHOW':
        return UpdateMode$SHOW_getInstance();
      case 'NONE':
        return UpdateMode$NONE_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.UpdateMode.' + name);
    }
  }
  UpdateMode.valueOf_61zpoe$ = UpdateMode$valueOf;
  function Chart(configuration, chartWidth, chartHeight, className, init) {
    Chart$Companion_getInstance();
    if (chartWidth === void 0)
      chartWidth = null;
    if (chartHeight === void 0)
      chartHeight = null;
    if (className === void 0)
      className = null;
    if (init === void 0)
      init = null;
    Widget.call(this, className);
    this.chartCanvas_8be2vx$ = new ChartCanvas(chartWidth, chartHeight, configuration);
    init != null ? init(this) : null;
  }
  Object.defineProperty(Chart.prototype, 'configuration', {
    configurable: true,
    get: function () {
      return this.chartCanvas_8be2vx$.configuration;
    },
    set: function (value) {
      this.chartCanvas_8be2vx$.configuration = value;
    }
  });
  Object.defineProperty(Chart.prototype, 'jsChart', {
    configurable: true,
    get: function () {
      return this.chartCanvas_8be2vx$.jsChart;
    }
  });
  Chart.prototype.render = function () {
    return this.render_pjwf99$('div', [this.chartCanvas_8be2vx$.renderVNode()]);
  };
  Chart.prototype.getNativeConfig = function () {
    return this.chartCanvas_8be2vx$.getNativeConfig();
  };
  Chart.prototype.reset = function () {
    this.chartCanvas_8be2vx$.reset();
  };
  Chart.prototype.renderChart = function () {
    this.chartCanvas_8be2vx$.renderChart();
  };
  Chart.prototype.stop = function () {
    this.chartCanvas_8be2vx$.stop();
  };
  Chart.prototype.resizeChart = function () {
    this.chartCanvas_8be2vx$.resizeChart();
  };
  Chart.prototype.clearChart = function () {
    this.chartCanvas_8be2vx$.clearChart();
  };
  Chart.prototype.update_lxfvj4$$default = function (updateMode) {
    this.chartCanvas_8be2vx$.update_lxfvj4$(updateMode);
  };
  Chart.prototype.update_lxfvj4$ = function (updateMode, callback$default) {
    if (updateMode === void 0)
      updateMode = null;
    callback$default ? callback$default(updateMode) : this.update_lxfvj4$$default(updateMode);
  };
  Chart.prototype.toBase64Image = function () {
    return this.chartCanvas_8be2vx$.toBase64Image();
  };
  function Chart$Companion() {
    Chart$Companion_instance = this;
    ChartModule_getInstance().initialize();
  }
  Chart$Companion.prototype.registerPlugin_za3rmp$ = function (plugin) {
    ChartModule_getInstance().getConstructor().register(plugin);
  };
  Chart$Companion.prototype.unregisterPlugin_za3rmp$ = function (plugin) {
    ChartModule_getInstance().getConstructor().unregister(plugin);
  };
  Chart$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Chart$Companion_instance = null;
  function Chart$Companion_getInstance() {
    if (Chart$Companion_instance === null) {
      new Chart$Companion();
    }
    return Chart$Companion_instance;
  }
  Chart.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Chart',
    interfaces: [Widget]
  };
  function chart($receiver, configuration, chartWidth, chartHeight, className, init) {
    if (chartWidth === void 0)
      chartWidth = null;
    if (chartHeight === void 0)
      chartHeight = null;
    if (className === void 0)
      className = null;
    if (init === void 0)
      init = null;
    var chart = new Chart(configuration, chartWidth, chartHeight, className, init);
    $receiver.add_87eobz$(chart);
    return chart;
  }
  function ChartCanvas(canvasWidth, canvasHeight, configuration, className) {
    ChartCanvas$Companion_getInstance();
    if (canvasWidth === void 0)
      canvasWidth = null;
    if (canvasHeight === void 0)
      canvasHeight = null;
    if (className === void 0)
      className = null;
    Canvas.call(this, canvasWidth, canvasHeight, className);
    this.configuration_s7uvm7$_0 = configuration;
    this.jsChart = null;
    this.useSnabbdomDistinctKey();
  }
  Object.defineProperty(ChartCanvas.prototype, 'configuration', {
    configurable: true,
    get: function () {
      return this.configuration_s7uvm7$_0;
    },
    set: function (value) {
      var tmp$, tmp$_0, tmp$_1;
      this.configuration_s7uvm7$_0 = value;
      var newConfig = toJs_22(value, getCallableRef('translate', function ($receiver, p1) {
        return $receiver.translate_61zpoe$(p1);
      }.bind(null, this)));
      if (newConfig.data != null)
        (tmp$ = this.jsChart) != null ? (tmp$.data = ensureNotNull(newConfig.data)) : null;
      if (newConfig.options != null)
        (tmp$_0 = this.jsChart) != null ? (tmp$_0.options = ensureNotNull(newConfig.options)) : null;
      (tmp$_1 = this.jsChart) != null ? (tmp$_1.update(), Unit) : null;
    }
  });
  ChartCanvas.prototype.render = function () {
    var tmp$, tmp$_0, tmp$_1;
    if (this.lastLanguage != null && !equals(this.lastLanguage, i18n.I18n.language)) {
      var newConfig = toJs_22(this.configuration, getCallableRef('translate', function ($receiver, p1) {
        return $receiver.translate_61zpoe$(p1);
      }.bind(null, this)));
      if (newConfig.data != null)
        (tmp$ = this.jsChart) != null ? (tmp$.data = ensureNotNull(newConfig.data)) : null;
      if (newConfig.options != null)
        (tmp$_0 = this.jsChart) != null ? (tmp$_0.options = ensureNotNull(newConfig.options)) : null;
      (tmp$_1 = this.jsChart) != null ? (tmp$_1.update(), Unit) : null;
    }
    return this.render_61zpoe$('canvas');
  };
  ChartCanvas.prototype.afterInsert_77isfd$ = function (node) {
    this.jsChart = createInstance(ChartModule_getInstance().getConstructor(), [this.context2D, toJs_22(this.configuration, getCallableRef('translate', function ($receiver, p1) {
      return $receiver.translate_61zpoe$(p1);
    }.bind(null, this)))]);
  };
  ChartCanvas.prototype.afterDestroy = function () {
    var tmp$;
    (tmp$ = this.jsChart) != null ? (tmp$.destroy(), Unit) : null;
    this.jsChart = null;
  };
  ChartCanvas.prototype.getNativeConfig = function () {
    var tmp$;
    return (tmp$ = this.jsChart) != null ? tmp$.config : null;
  };
  ChartCanvas.prototype.reset = function () {
    var tmp$;
    (tmp$ = this.jsChart) != null ? (tmp$.reset(), Unit) : null;
  };
  ChartCanvas.prototype.renderChart = function () {
    var tmp$;
    (tmp$ = this.jsChart) != null ? (tmp$.render(), Unit) : null;
  };
  ChartCanvas.prototype.stop = function () {
    var tmp$;
    (tmp$ = this.jsChart) != null ? tmp$.stop() : null;
  };
  ChartCanvas.prototype.resizeChart = function () {
    var tmp$;
    (tmp$ = this.jsChart) != null ? (tmp$.resize(), Unit) : null;
  };
  ChartCanvas.prototype.clearChart = function () {
    var tmp$;
    (tmp$ = this.jsChart) != null ? tmp$.clear() : null;
  };
  ChartCanvas.prototype.update_lxfvj4$ = function (updateMode) {
    if (updateMode === void 0)
      updateMode = null;
    var tmp$;
    (tmp$ = this.jsChart) != null ? (tmp$.update(updateMode != null ? updateMode : undefined), Unit) : null;
  };
  ChartCanvas.prototype.toBase64Image = function () {
    var tmp$;
    return (tmp$ = this.jsChart) != null ? tmp$.toBase64Image() : null;
  };
  function ChartCanvas$Companion() {
    ChartCanvas$Companion_instance = this;
    ChartModule_getInstance().initialize();
  }
  ChartCanvas$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ChartCanvas$Companion_instance = null;
  function ChartCanvas$Companion_getInstance() {
    if (ChartCanvas$Companion_instance === null) {
      new ChartCanvas$Companion();
    }
    return ChartCanvas$Companion_instance;
  }
  ChartCanvas.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChartCanvas',
    interfaces: [Canvas]
  };
  function ChartType(name, ordinal, type) {
    Enum.call(this);
    this.type_8be2vx$ = type;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ChartType_initFields() {
    ChartType_initFields = function () {
    };
    ChartType$LINE_instance = new ChartType('LINE', 0, 'line');
    ChartType$BAR_instance = new ChartType('BAR', 1, 'bar');
    ChartType$RADAR_instance = new ChartType('RADAR', 2, 'radar');
    ChartType$DOUGHNUT_instance = new ChartType('DOUGHNUT', 3, 'doughnut');
    ChartType$PIE_instance = new ChartType('PIE', 4, 'pie');
    ChartType$POLARAREA_instance = new ChartType('POLARAREA', 5, 'polarArea');
    ChartType$BUBBLE_instance = new ChartType('BUBBLE', 6, 'bubble');
    ChartType$SCATTER_instance = new ChartType('SCATTER', 7, 'scatter');
  }
  var ChartType$LINE_instance;
  function ChartType$LINE_getInstance() {
    ChartType_initFields();
    return ChartType$LINE_instance;
  }
  var ChartType$BAR_instance;
  function ChartType$BAR_getInstance() {
    ChartType_initFields();
    return ChartType$BAR_instance;
  }
  var ChartType$RADAR_instance;
  function ChartType$RADAR_getInstance() {
    ChartType_initFields();
    return ChartType$RADAR_instance;
  }
  var ChartType$DOUGHNUT_instance;
  function ChartType$DOUGHNUT_getInstance() {
    ChartType_initFields();
    return ChartType$DOUGHNUT_instance;
  }
  var ChartType$PIE_instance;
  function ChartType$PIE_getInstance() {
    ChartType_initFields();
    return ChartType$PIE_instance;
  }
  var ChartType$POLARAREA_instance;
  function ChartType$POLARAREA_getInstance() {
    ChartType_initFields();
    return ChartType$POLARAREA_instance;
  }
  var ChartType$BUBBLE_instance;
  function ChartType$BUBBLE_getInstance() {
    ChartType_initFields();
    return ChartType$BUBBLE_instance;
  }
  var ChartType$SCATTER_instance;
  function ChartType$SCATTER_getInstance() {
    ChartType_initFields();
    return ChartType$SCATTER_instance;
  }
  ChartType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChartType',
    interfaces: [Enum]
  };
  function ChartType$values() {
    return [ChartType$LINE_getInstance(), ChartType$BAR_getInstance(), ChartType$RADAR_getInstance(), ChartType$DOUGHNUT_getInstance(), ChartType$PIE_getInstance(), ChartType$POLARAREA_getInstance(), ChartType$BUBBLE_getInstance(), ChartType$SCATTER_getInstance()];
  }
  ChartType.values = ChartType$values;
  function ChartType$valueOf(name) {
    switch (name) {
      case 'LINE':
        return ChartType$LINE_getInstance();
      case 'BAR':
        return ChartType$BAR_getInstance();
      case 'RADAR':
        return ChartType$RADAR_getInstance();
      case 'DOUGHNUT':
        return ChartType$DOUGHNUT_getInstance();
      case 'PIE':
        return ChartType$PIE_getInstance();
      case 'POLARAREA':
        return ChartType$POLARAREA_getInstance();
      case 'BUBBLE':
        return ChartType$BUBBLE_getInstance();
      case 'SCATTER':
        return ChartType$SCATTER_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.ChartType.' + name);
    }
  }
  ChartType.valueOf_61zpoe$ = ChartType$valueOf;
  function InteractionMode(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function InteractionMode_initFields() {
    InteractionMode_initFields = function () {
    };
    InteractionMode$POINT_instance = new InteractionMode('POINT', 0, 'point');
    InteractionMode$NEAREST_instance = new InteractionMode('NEAREST', 1, 'nearest');
    InteractionMode$INDEX_instance = new InteractionMode('INDEX', 2, 'index');
    InteractionMode$DATASET_instance = new InteractionMode('DATASET', 3, 'dataset');
    InteractionMode$X_instance = new InteractionMode('X', 4, 'x');
    InteractionMode$Y_instance = new InteractionMode('Y', 5, 'y');
  }
  var InteractionMode$POINT_instance;
  function InteractionMode$POINT_getInstance() {
    InteractionMode_initFields();
    return InteractionMode$POINT_instance;
  }
  var InteractionMode$NEAREST_instance;
  function InteractionMode$NEAREST_getInstance() {
    InteractionMode_initFields();
    return InteractionMode$NEAREST_instance;
  }
  var InteractionMode$INDEX_instance;
  function InteractionMode$INDEX_getInstance() {
    InteractionMode_initFields();
    return InteractionMode$INDEX_instance;
  }
  var InteractionMode$DATASET_instance;
  function InteractionMode$DATASET_getInstance() {
    InteractionMode_initFields();
    return InteractionMode$DATASET_instance;
  }
  var InteractionMode$X_instance;
  function InteractionMode$X_getInstance() {
    InteractionMode_initFields();
    return InteractionMode$X_instance;
  }
  var InteractionMode$Y_instance;
  function InteractionMode$Y_getInstance() {
    InteractionMode_initFields();
    return InteractionMode$Y_instance;
  }
  InteractionMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InteractionMode',
    interfaces: [Enum]
  };
  function InteractionMode$values() {
    return [InteractionMode$POINT_getInstance(), InteractionMode$NEAREST_getInstance(), InteractionMode$INDEX_getInstance(), InteractionMode$DATASET_getInstance(), InteractionMode$X_getInstance(), InteractionMode$Y_getInstance()];
  }
  InteractionMode.values = InteractionMode$values;
  function InteractionMode$valueOf(name) {
    switch (name) {
      case 'POINT':
        return InteractionMode$POINT_getInstance();
      case 'NEAREST':
        return InteractionMode$NEAREST_getInstance();
      case 'INDEX':
        return InteractionMode$INDEX_getInstance();
      case 'DATASET':
        return InteractionMode$DATASET_getInstance();
      case 'X':
        return InteractionMode$X_getInstance();
      case 'Y':
        return InteractionMode$Y_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.InteractionMode.' + name);
    }
  }
  InteractionMode.valueOf_61zpoe$ = InteractionMode$valueOf;
  function Eeasing(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Eeasing_initFields() {
    Eeasing_initFields = function () {
    };
    Eeasing$LINEAR_instance = new Eeasing('LINEAR', 0, 'linear');
    Eeasing$EASEINQUAD_instance = new Eeasing('EASEINQUAD', 1, 'easeInQuad');
    Eeasing$EASEOUTQUAD_instance = new Eeasing('EASEOUTQUAD', 2, 'easeOutQuad');
    Eeasing$EASEINOUTQUAD_instance = new Eeasing('EASEINOUTQUAD', 3, 'easeInOutQuad');
    Eeasing$EASEINCUBIC_instance = new Eeasing('EASEINCUBIC', 4, 'easeInCubic');
    Eeasing$EASEOUTCUBIC_instance = new Eeasing('EASEOUTCUBIC', 5, 'easeOutCubic');
    Eeasing$EASEINOUTCUBIC_instance = new Eeasing('EASEINOUTCUBIC', 6, 'easeInOutCubic');
    Eeasing$EASEINQUART_instance = new Eeasing('EASEINQUART', 7, 'easeInQuart');
    Eeasing$EASEOUTQUART_instance = new Eeasing('EASEOUTQUART', 8, 'easeOutQuart');
    Eeasing$EASEINOUTQUART_instance = new Eeasing('EASEINOUTQUART', 9, 'easeInOutQuart');
    Eeasing$EASEINQUINT_instance = new Eeasing('EASEINQUINT', 10, 'easeInQuint');
    Eeasing$EASEOUTQUINT_instance = new Eeasing('EASEOUTQUINT', 11, 'easeOutQuint');
    Eeasing$EASEINOUTQUINT_instance = new Eeasing('EASEINOUTQUINT', 12, 'easeInOutQuint');
    Eeasing$EASEINSINE_instance = new Eeasing('EASEINSINE', 13, 'easeInSine');
    Eeasing$EASEOUTSINE_instance = new Eeasing('EASEOUTSINE', 14, 'easeOutSine');
    Eeasing$EASEINOUTSINE_instance = new Eeasing('EASEINOUTSINE', 15, 'easeInOutSine');
    Eeasing$EASEINEXPO_instance = new Eeasing('EASEINEXPO', 16, 'easeInExpo');
    Eeasing$EASEOUTEXPO_instance = new Eeasing('EASEOUTEXPO', 17, 'easeOutExpo');
    Eeasing$EASEINOUTEXPO_instance = new Eeasing('EASEINOUTEXPO', 18, 'easeInOutExpo');
    Eeasing$EASEINCIRC_instance = new Eeasing('EASEINCIRC', 19, 'easeInCirc');
    Eeasing$EASEOUTCIRC_instance = new Eeasing('EASEOUTCIRC', 20, 'easeOutCirc');
    Eeasing$EASEINOUTCIRC_instance = new Eeasing('EASEINOUTCIRC', 21, 'easeInOutCirc');
    Eeasing$EASEINELASTIC_instance = new Eeasing('EASEINELASTIC', 22, 'easeInElastic');
    Eeasing$EASEOUTELASTIC_instance = new Eeasing('EASEOUTELASTIC', 23, 'easeOutElastic');
    Eeasing$EASEINOUTELASTIC_instance = new Eeasing('EASEINOUTELASTIC', 24, 'easeInOutElastic');
    Eeasing$EASEINBACK_instance = new Eeasing('EASEINBACK', 25, 'easeInBack');
    Eeasing$EASEOUTBACK_instance = new Eeasing('EASEOUTBACK', 26, 'easeOutBack');
    Eeasing$EASEINOUTBACK_instance = new Eeasing('EASEINOUTBACK', 27, 'easeInOutBack');
    Eeasing$EASEINBOUNCE_instance = new Eeasing('EASEINBOUNCE', 28, 'easeInBounce');
    Eeasing$EASEOUTBOUNCE_instance = new Eeasing('EASEOUTBOUNCE', 29, 'easeOutBounce');
    Eeasing$EASEINOUTBOUNCE_instance = new Eeasing('EASEINOUTBOUNCE', 30, 'easeInOutBounce');
  }
  var Eeasing$LINEAR_instance;
  function Eeasing$LINEAR_getInstance() {
    Eeasing_initFields();
    return Eeasing$LINEAR_instance;
  }
  var Eeasing$EASEINQUAD_instance;
  function Eeasing$EASEINQUAD_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINQUAD_instance;
  }
  var Eeasing$EASEOUTQUAD_instance;
  function Eeasing$EASEOUTQUAD_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTQUAD_instance;
  }
  var Eeasing$EASEINOUTQUAD_instance;
  function Eeasing$EASEINOUTQUAD_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTQUAD_instance;
  }
  var Eeasing$EASEINCUBIC_instance;
  function Eeasing$EASEINCUBIC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINCUBIC_instance;
  }
  var Eeasing$EASEOUTCUBIC_instance;
  function Eeasing$EASEOUTCUBIC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTCUBIC_instance;
  }
  var Eeasing$EASEINOUTCUBIC_instance;
  function Eeasing$EASEINOUTCUBIC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTCUBIC_instance;
  }
  var Eeasing$EASEINQUART_instance;
  function Eeasing$EASEINQUART_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINQUART_instance;
  }
  var Eeasing$EASEOUTQUART_instance;
  function Eeasing$EASEOUTQUART_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTQUART_instance;
  }
  var Eeasing$EASEINOUTQUART_instance;
  function Eeasing$EASEINOUTQUART_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTQUART_instance;
  }
  var Eeasing$EASEINQUINT_instance;
  function Eeasing$EASEINQUINT_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINQUINT_instance;
  }
  var Eeasing$EASEOUTQUINT_instance;
  function Eeasing$EASEOUTQUINT_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTQUINT_instance;
  }
  var Eeasing$EASEINOUTQUINT_instance;
  function Eeasing$EASEINOUTQUINT_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTQUINT_instance;
  }
  var Eeasing$EASEINSINE_instance;
  function Eeasing$EASEINSINE_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINSINE_instance;
  }
  var Eeasing$EASEOUTSINE_instance;
  function Eeasing$EASEOUTSINE_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTSINE_instance;
  }
  var Eeasing$EASEINOUTSINE_instance;
  function Eeasing$EASEINOUTSINE_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTSINE_instance;
  }
  var Eeasing$EASEINEXPO_instance;
  function Eeasing$EASEINEXPO_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINEXPO_instance;
  }
  var Eeasing$EASEOUTEXPO_instance;
  function Eeasing$EASEOUTEXPO_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTEXPO_instance;
  }
  var Eeasing$EASEINOUTEXPO_instance;
  function Eeasing$EASEINOUTEXPO_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTEXPO_instance;
  }
  var Eeasing$EASEINCIRC_instance;
  function Eeasing$EASEINCIRC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINCIRC_instance;
  }
  var Eeasing$EASEOUTCIRC_instance;
  function Eeasing$EASEOUTCIRC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTCIRC_instance;
  }
  var Eeasing$EASEINOUTCIRC_instance;
  function Eeasing$EASEINOUTCIRC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTCIRC_instance;
  }
  var Eeasing$EASEINELASTIC_instance;
  function Eeasing$EASEINELASTIC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINELASTIC_instance;
  }
  var Eeasing$EASEOUTELASTIC_instance;
  function Eeasing$EASEOUTELASTIC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTELASTIC_instance;
  }
  var Eeasing$EASEINOUTELASTIC_instance;
  function Eeasing$EASEINOUTELASTIC_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTELASTIC_instance;
  }
  var Eeasing$EASEINBACK_instance;
  function Eeasing$EASEINBACK_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINBACK_instance;
  }
  var Eeasing$EASEOUTBACK_instance;
  function Eeasing$EASEOUTBACK_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTBACK_instance;
  }
  var Eeasing$EASEINOUTBACK_instance;
  function Eeasing$EASEINOUTBACK_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTBACK_instance;
  }
  var Eeasing$EASEINBOUNCE_instance;
  function Eeasing$EASEINBOUNCE_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINBOUNCE_instance;
  }
  var Eeasing$EASEOUTBOUNCE_instance;
  function Eeasing$EASEOUTBOUNCE_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEOUTBOUNCE_instance;
  }
  var Eeasing$EASEINOUTBOUNCE_instance;
  function Eeasing$EASEINOUTBOUNCE_getInstance() {
    Eeasing_initFields();
    return Eeasing$EASEINOUTBOUNCE_instance;
  }
  Eeasing.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Eeasing',
    interfaces: [Enum]
  };
  function Eeasing$values() {
    return [Eeasing$LINEAR_getInstance(), Eeasing$EASEINQUAD_getInstance(), Eeasing$EASEOUTQUAD_getInstance(), Eeasing$EASEINOUTQUAD_getInstance(), Eeasing$EASEINCUBIC_getInstance(), Eeasing$EASEOUTCUBIC_getInstance(), Eeasing$EASEINOUTCUBIC_getInstance(), Eeasing$EASEINQUART_getInstance(), Eeasing$EASEOUTQUART_getInstance(), Eeasing$EASEINOUTQUART_getInstance(), Eeasing$EASEINQUINT_getInstance(), Eeasing$EASEOUTQUINT_getInstance(), Eeasing$EASEINOUTQUINT_getInstance(), Eeasing$EASEINSINE_getInstance(), Eeasing$EASEOUTSINE_getInstance(), Eeasing$EASEINOUTSINE_getInstance(), Eeasing$EASEINEXPO_getInstance(), Eeasing$EASEOUTEXPO_getInstance(), Eeasing$EASEINOUTEXPO_getInstance(), Eeasing$EASEINCIRC_getInstance(), Eeasing$EASEOUTCIRC_getInstance(), Eeasing$EASEINOUTCIRC_getInstance(), Eeasing$EASEINELASTIC_getInstance(), Eeasing$EASEOUTELASTIC_getInstance(), Eeasing$EASEINOUTELASTIC_getInstance(), Eeasing$EASEINBACK_getInstance(), Eeasing$EASEOUTBACK_getInstance(), Eeasing$EASEINOUTBACK_getInstance(), Eeasing$EASEINBOUNCE_getInstance(), Eeasing$EASEOUTBOUNCE_getInstance(), Eeasing$EASEINOUTBOUNCE_getInstance()];
  }
  Eeasing.values = Eeasing$values;
  function Eeasing$valueOf(name) {
    switch (name) {
      case 'LINEAR':
        return Eeasing$LINEAR_getInstance();
      case 'EASEINQUAD':
        return Eeasing$EASEINQUAD_getInstance();
      case 'EASEOUTQUAD':
        return Eeasing$EASEOUTQUAD_getInstance();
      case 'EASEINOUTQUAD':
        return Eeasing$EASEINOUTQUAD_getInstance();
      case 'EASEINCUBIC':
        return Eeasing$EASEINCUBIC_getInstance();
      case 'EASEOUTCUBIC':
        return Eeasing$EASEOUTCUBIC_getInstance();
      case 'EASEINOUTCUBIC':
        return Eeasing$EASEINOUTCUBIC_getInstance();
      case 'EASEINQUART':
        return Eeasing$EASEINQUART_getInstance();
      case 'EASEOUTQUART':
        return Eeasing$EASEOUTQUART_getInstance();
      case 'EASEINOUTQUART':
        return Eeasing$EASEINOUTQUART_getInstance();
      case 'EASEINQUINT':
        return Eeasing$EASEINQUINT_getInstance();
      case 'EASEOUTQUINT':
        return Eeasing$EASEOUTQUINT_getInstance();
      case 'EASEINOUTQUINT':
        return Eeasing$EASEINOUTQUINT_getInstance();
      case 'EASEINSINE':
        return Eeasing$EASEINSINE_getInstance();
      case 'EASEOUTSINE':
        return Eeasing$EASEOUTSINE_getInstance();
      case 'EASEINOUTSINE':
        return Eeasing$EASEINOUTSINE_getInstance();
      case 'EASEINEXPO':
        return Eeasing$EASEINEXPO_getInstance();
      case 'EASEOUTEXPO':
        return Eeasing$EASEOUTEXPO_getInstance();
      case 'EASEINOUTEXPO':
        return Eeasing$EASEINOUTEXPO_getInstance();
      case 'EASEINCIRC':
        return Eeasing$EASEINCIRC_getInstance();
      case 'EASEOUTCIRC':
        return Eeasing$EASEOUTCIRC_getInstance();
      case 'EASEINOUTCIRC':
        return Eeasing$EASEINOUTCIRC_getInstance();
      case 'EASEINELASTIC':
        return Eeasing$EASEINELASTIC_getInstance();
      case 'EASEOUTELASTIC':
        return Eeasing$EASEOUTELASTIC_getInstance();
      case 'EASEINOUTELASTIC':
        return Eeasing$EASEINOUTELASTIC_getInstance();
      case 'EASEINBACK':
        return Eeasing$EASEINBACK_getInstance();
      case 'EASEOUTBACK':
        return Eeasing$EASEOUTBACK_getInstance();
      case 'EASEINOUTBACK':
        return Eeasing$EASEINOUTBACK_getInstance();
      case 'EASEINBOUNCE':
        return Eeasing$EASEINBOUNCE_getInstance();
      case 'EASEOUTBOUNCE':
        return Eeasing$EASEOUTBOUNCE_getInstance();
      case 'EASEINOUTBOUNCE':
        return Eeasing$EASEINOUTBOUNCE_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.Eeasing.' + name);
    }
  }
  Eeasing.valueOf_61zpoe$ = Eeasing$valueOf;
  function Position(name, ordinal, position) {
    Enum.call(this);
    this.position_8be2vx$ = position;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Position_initFields() {
    Position_initFields = function () {
    };
    Position$TOP_instance = new Position('TOP', 0, 'top');
    Position$LEFT_instance = new Position('LEFT', 1, 'left');
    Position$RIGHT_instance = new Position('RIGHT', 2, 'right');
    Position$BOTTOM_instance = new Position('BOTTOM', 3, 'bottom');
    Position$CENTER_instance = new Position('CENTER', 4, 'center');
    Position$CHARTAREA_instance = new Position('CHARTAREA', 5, 'chartArea');
  }
  var Position$TOP_instance;
  function Position$TOP_getInstance() {
    Position_initFields();
    return Position$TOP_instance;
  }
  var Position$LEFT_instance;
  function Position$LEFT_getInstance() {
    Position_initFields();
    return Position$LEFT_instance;
  }
  var Position$RIGHT_instance;
  function Position$RIGHT_getInstance() {
    Position_initFields();
    return Position$RIGHT_instance;
  }
  var Position$BOTTOM_instance;
  function Position$BOTTOM_getInstance() {
    Position_initFields();
    return Position$BOTTOM_instance;
  }
  var Position$CENTER_instance;
  function Position$CENTER_getInstance() {
    Position_initFields();
    return Position$CENTER_instance;
  }
  var Position$CHARTAREA_instance;
  function Position$CHARTAREA_getInstance() {
    Position_initFields();
    return Position$CHARTAREA_instance;
  }
  Position.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Position',
    interfaces: [Enum]
  };
  function Position$values() {
    return [Position$TOP_getInstance(), Position$LEFT_getInstance(), Position$RIGHT_getInstance(), Position$BOTTOM_getInstance(), Position$CENTER_getInstance(), Position$CHARTAREA_getInstance()];
  }
  Position.values = Position$values;
  function Position$valueOf(name) {
    switch (name) {
      case 'TOP':
        return Position$TOP_getInstance();
      case 'LEFT':
        return Position$LEFT_getInstance();
      case 'RIGHT':
        return Position$RIGHT_getInstance();
      case 'BOTTOM':
        return Position$BOTTOM_getInstance();
      case 'CENTER':
        return Position$CENTER_getInstance();
      case 'CHARTAREA':
        return Position$CHARTAREA_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.Position.' + name);
    }
  }
  Position.valueOf_61zpoe$ = Position$valueOf;
  function TooltipPosition(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TooltipPosition_initFields() {
    TooltipPosition_initFields = function () {
    };
    TooltipPosition$AVERAGE_instance = new TooltipPosition('AVERAGE', 0, 'average');
    TooltipPosition$NEAREST_instance = new TooltipPosition('NEAREST', 1, 'nearest');
  }
  var TooltipPosition$AVERAGE_instance;
  function TooltipPosition$AVERAGE_getInstance() {
    TooltipPosition_initFields();
    return TooltipPosition$AVERAGE_instance;
  }
  var TooltipPosition$NEAREST_instance;
  function TooltipPosition$NEAREST_getInstance() {
    TooltipPosition_initFields();
    return TooltipPosition$NEAREST_instance;
  }
  TooltipPosition.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TooltipPosition',
    interfaces: [Enum]
  };
  function TooltipPosition$values() {
    return [TooltipPosition$AVERAGE_getInstance(), TooltipPosition$NEAREST_getInstance()];
  }
  TooltipPosition.values = TooltipPosition$values;
  function TooltipPosition$valueOf(name) {
    switch (name) {
      case 'AVERAGE':
        return TooltipPosition$AVERAGE_getInstance();
      case 'NEAREST':
        return TooltipPosition$NEAREST_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.TooltipPosition.' + name);
    }
  }
  TooltipPosition.valueOf_61zpoe$ = TooltipPosition$valueOf;
  function PointStyle(name, ordinal, style) {
    Enum.call(this);
    this.style_8be2vx$ = style;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PointStyle_initFields() {
    PointStyle_initFields = function () {
    };
    PointStyle$CIRCLE_instance = new PointStyle('CIRCLE', 0, 'circle');
    PointStyle$CROSS_instance = new PointStyle('CROSS', 1, 'cross');
    PointStyle$CROSSROT_instance = new PointStyle('CROSSROT', 2, 'crossRot');
    PointStyle$DASH_instance = new PointStyle('DASH', 3, 'dash');
    PointStyle$LINE_instance = new PointStyle('LINE', 4, 'line');
    PointStyle$RECT_instance = new PointStyle('RECT', 5, 'rect');
    PointStyle$RECTROUNDED_instance = new PointStyle('RECTROUNDED', 6, 'rectRounded');
    PointStyle$RECTROT_instance = new PointStyle('RECTROT', 7, 'rectRot');
    PointStyle$START_instance = new PointStyle('START', 8, 'star');
    PointStyle$TRIANGLE_instance = new PointStyle('TRIANGLE', 9, 'triangle');
  }
  var PointStyle$CIRCLE_instance;
  function PointStyle$CIRCLE_getInstance() {
    PointStyle_initFields();
    return PointStyle$CIRCLE_instance;
  }
  var PointStyle$CROSS_instance;
  function PointStyle$CROSS_getInstance() {
    PointStyle_initFields();
    return PointStyle$CROSS_instance;
  }
  var PointStyle$CROSSROT_instance;
  function PointStyle$CROSSROT_getInstance() {
    PointStyle_initFields();
    return PointStyle$CROSSROT_instance;
  }
  var PointStyle$DASH_instance;
  function PointStyle$DASH_getInstance() {
    PointStyle_initFields();
    return PointStyle$DASH_instance;
  }
  var PointStyle$LINE_instance;
  function PointStyle$LINE_getInstance() {
    PointStyle_initFields();
    return PointStyle$LINE_instance;
  }
  var PointStyle$RECT_instance;
  function PointStyle$RECT_getInstance() {
    PointStyle_initFields();
    return PointStyle$RECT_instance;
  }
  var PointStyle$RECTROUNDED_instance;
  function PointStyle$RECTROUNDED_getInstance() {
    PointStyle_initFields();
    return PointStyle$RECTROUNDED_instance;
  }
  var PointStyle$RECTROT_instance;
  function PointStyle$RECTROT_getInstance() {
    PointStyle_initFields();
    return PointStyle$RECTROT_instance;
  }
  var PointStyle$START_instance;
  function PointStyle$START_getInstance() {
    PointStyle_initFields();
    return PointStyle$START_instance;
  }
  var PointStyle$TRIANGLE_instance;
  function PointStyle$TRIANGLE_getInstance() {
    PointStyle_initFields();
    return PointStyle$TRIANGLE_instance;
  }
  PointStyle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PointStyle',
    interfaces: [Enum]
  };
  function PointStyle$values() {
    return [PointStyle$CIRCLE_getInstance(), PointStyle$CROSS_getInstance(), PointStyle$CROSSROT_getInstance(), PointStyle$DASH_getInstance(), PointStyle$LINE_getInstance(), PointStyle$RECT_getInstance(), PointStyle$RECTROUNDED_getInstance(), PointStyle$RECTROT_getInstance(), PointStyle$START_getInstance(), PointStyle$TRIANGLE_getInstance()];
  }
  PointStyle.values = PointStyle$values;
  function PointStyle$valueOf(name) {
    switch (name) {
      case 'CIRCLE':
        return PointStyle$CIRCLE_getInstance();
      case 'CROSS':
        return PointStyle$CROSS_getInstance();
      case 'CROSSROT':
        return PointStyle$CROSSROT_getInstance();
      case 'DASH':
        return PointStyle$DASH_getInstance();
      case 'LINE':
        return PointStyle$LINE_getInstance();
      case 'RECT':
        return PointStyle$RECT_getInstance();
      case 'RECTROUNDED':
        return PointStyle$RECTROUNDED_getInstance();
      case 'RECTROT':
        return PointStyle$RECTROT_getInstance();
      case 'START':
        return PointStyle$START_getInstance();
      case 'TRIANGLE':
        return PointStyle$TRIANGLE_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.PointStyle.' + name);
    }
  }
  PointStyle.valueOf_61zpoe$ = PointStyle$valueOf;
  function InterpolationMode(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function InterpolationMode_initFields() {
    InterpolationMode_initFields = function () {
    };
    InterpolationMode$DEFAULT_instance = new InterpolationMode('DEFAULT', 0, 'default');
    InterpolationMode$MONOTONE_instance = new InterpolationMode('MONOTONE', 1, 'monotone');
  }
  var InterpolationMode$DEFAULT_instance;
  function InterpolationMode$DEFAULT_getInstance() {
    InterpolationMode_initFields();
    return InterpolationMode$DEFAULT_instance;
  }
  var InterpolationMode$MONOTONE_instance;
  function InterpolationMode$MONOTONE_getInstance() {
    InterpolationMode_initFields();
    return InterpolationMode$MONOTONE_instance;
  }
  InterpolationMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InterpolationMode',
    interfaces: [Enum]
  };
  function InterpolationMode$values() {
    return [InterpolationMode$DEFAULT_getInstance(), InterpolationMode$MONOTONE_getInstance()];
  }
  InterpolationMode.values = InterpolationMode$values;
  function InterpolationMode$valueOf(name) {
    switch (name) {
      case 'DEFAULT':
        return InterpolationMode$DEFAULT_getInstance();
      case 'MONOTONE':
        return InterpolationMode$MONOTONE_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.InterpolationMode.' + name);
    }
  }
  InterpolationMode.valueOf_61zpoe$ = InterpolationMode$valueOf;
  function ScalesType(name, ordinal, type) {
    Enum.call(this);
    this.type_8be2vx$ = type;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ScalesType_initFields() {
    ScalesType_initFields = function () {
    };
    ScalesType$CATEGORY_instance = new ScalesType('CATEGORY', 0, 'category');
    ScalesType$LINEAR_instance = new ScalesType('LINEAR', 1, 'linear');
    ScalesType$LOGARITHMIC_instance = new ScalesType('LOGARITHMIC', 2, 'logarithmic');
    ScalesType$TIME_instance = new ScalesType('TIME', 3, 'time');
    ScalesType$TIMESERIES_instance = new ScalesType('TIMESERIES', 4, 'timeseries');
    ScalesType$RADIALLINEAR_instance = new ScalesType('RADIALLINEAR', 5, 'radialLinear');
  }
  var ScalesType$CATEGORY_instance;
  function ScalesType$CATEGORY_getInstance() {
    ScalesType_initFields();
    return ScalesType$CATEGORY_instance;
  }
  var ScalesType$LINEAR_instance;
  function ScalesType$LINEAR_getInstance() {
    ScalesType_initFields();
    return ScalesType$LINEAR_instance;
  }
  var ScalesType$LOGARITHMIC_instance;
  function ScalesType$LOGARITHMIC_getInstance() {
    ScalesType_initFields();
    return ScalesType$LOGARITHMIC_instance;
  }
  var ScalesType$TIME_instance;
  function ScalesType$TIME_getInstance() {
    ScalesType_initFields();
    return ScalesType$TIME_instance;
  }
  var ScalesType$TIMESERIES_instance;
  function ScalesType$TIMESERIES_getInstance() {
    ScalesType_initFields();
    return ScalesType$TIMESERIES_instance;
  }
  var ScalesType$RADIALLINEAR_instance;
  function ScalesType$RADIALLINEAR_getInstance() {
    ScalesType_initFields();
    return ScalesType$RADIALLINEAR_instance;
  }
  ScalesType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ScalesType',
    interfaces: [Enum]
  };
  function ScalesType$values() {
    return [ScalesType$CATEGORY_getInstance(), ScalesType$LINEAR_getInstance(), ScalesType$LOGARITHMIC_getInstance(), ScalesType$TIME_getInstance(), ScalesType$TIMESERIES_getInstance(), ScalesType$RADIALLINEAR_getInstance()];
  }
  ScalesType.values = ScalesType$values;
  function ScalesType$valueOf(name) {
    switch (name) {
      case 'CATEGORY':
        return ScalesType$CATEGORY_getInstance();
      case 'LINEAR':
        return ScalesType$LINEAR_getInstance();
      case 'LOGARITHMIC':
        return ScalesType$LOGARITHMIC_getInstance();
      case 'TIME':
        return ScalesType$TIME_getInstance();
      case 'TIMESERIES':
        return ScalesType$TIMESERIES_getInstance();
      case 'RADIALLINEAR':
        return ScalesType$RADIALLINEAR_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.ScalesType.' + name);
    }
  }
  ScalesType.valueOf_61zpoe$ = ScalesType$valueOf;
  function LineCap(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function LineCap_initFields() {
    LineCap_initFields = function () {
    };
    LineCap$BUTT_instance = new LineCap('BUTT', 0, 'butt');
    LineCap$ROUND_instance = new LineCap('ROUND', 1, 'round');
    LineCap$SQUARE_instance = new LineCap('SQUARE', 2, 'square');
  }
  var LineCap$BUTT_instance;
  function LineCap$BUTT_getInstance() {
    LineCap_initFields();
    return LineCap$BUTT_instance;
  }
  var LineCap$ROUND_instance;
  function LineCap$ROUND_getInstance() {
    LineCap_initFields();
    return LineCap$ROUND_instance;
  }
  var LineCap$SQUARE_instance;
  function LineCap$SQUARE_getInstance() {
    LineCap_initFields();
    return LineCap$SQUARE_instance;
  }
  LineCap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineCap',
    interfaces: [Enum]
  };
  function LineCap$values() {
    return [LineCap$BUTT_getInstance(), LineCap$ROUND_getInstance(), LineCap$SQUARE_getInstance()];
  }
  LineCap.values = LineCap$values;
  function LineCap$valueOf(name) {
    switch (name) {
      case 'BUTT':
        return LineCap$BUTT_getInstance();
      case 'ROUND':
        return LineCap$ROUND_getInstance();
      case 'SQUARE':
        return LineCap$SQUARE_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.LineCap.' + name);
    }
  }
  LineCap.valueOf_61zpoe$ = LineCap$valueOf;
  function LineJoin(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function LineJoin_initFields() {
    LineJoin_initFields = function () {
    };
    LineJoin$BEVEL_instance = new LineJoin('BEVEL', 0, 'bevel');
    LineJoin$ROUND_instance = new LineJoin('ROUND', 1, 'round');
    LineJoin$MITER_instance = new LineJoin('MITER', 2, 'miter');
  }
  var LineJoin$BEVEL_instance;
  function LineJoin$BEVEL_getInstance() {
    LineJoin_initFields();
    return LineJoin$BEVEL_instance;
  }
  var LineJoin$ROUND_instance;
  function LineJoin$ROUND_getInstance() {
    LineJoin_initFields();
    return LineJoin$ROUND_instance;
  }
  var LineJoin$MITER_instance;
  function LineJoin$MITER_getInstance() {
    LineJoin_initFields();
    return LineJoin$MITER_instance;
  }
  LineJoin.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineJoin',
    interfaces: [Enum]
  };
  function LineJoin$values() {
    return [LineJoin$BEVEL_getInstance(), LineJoin$ROUND_getInstance(), LineJoin$MITER_getInstance()];
  }
  LineJoin.values = LineJoin$values;
  function LineJoin$valueOf(name) {
    switch (name) {
      case 'BEVEL':
        return LineJoin$BEVEL_getInstance();
      case 'ROUND':
        return LineJoin$ROUND_getInstance();
      case 'MITER':
        return LineJoin$MITER_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.LineJoin.' + name);
    }
  }
  LineJoin.valueOf_61zpoe$ = LineJoin$valueOf;
  function LegendAlign(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function LegendAlign_initFields() {
    LegendAlign_initFields = function () {
    };
    LegendAlign$CENTER_instance = new LegendAlign('CENTER', 0, 'center');
    LegendAlign$END_instance = new LegendAlign('END', 1, 'end');
    LegendAlign$START_instance = new LegendAlign('START', 2, 'start');
  }
  var LegendAlign$CENTER_instance;
  function LegendAlign$CENTER_getInstance() {
    LegendAlign_initFields();
    return LegendAlign$CENTER_instance;
  }
  var LegendAlign$END_instance;
  function LegendAlign$END_getInstance() {
    LegendAlign_initFields();
    return LegendAlign$END_instance;
  }
  var LegendAlign$START_instance;
  function LegendAlign$START_getInstance() {
    LegendAlign_initFields();
    return LegendAlign$START_instance;
  }
  LegendAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LegendAlign',
    interfaces: [Enum]
  };
  function LegendAlign$values() {
    return [LegendAlign$CENTER_getInstance(), LegendAlign$END_getInstance(), LegendAlign$START_getInstance()];
  }
  LegendAlign.values = LegendAlign$values;
  function LegendAlign$valueOf(name) {
    switch (name) {
      case 'CENTER':
        return LegendAlign$CENTER_getInstance();
      case 'END':
        return LegendAlign$END_getInstance();
      case 'START':
        return LegendAlign$START_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.LegendAlign.' + name);
    }
  }
  LegendAlign.valueOf_61zpoe$ = LegendAlign$valueOf;
  function TooltipAlign(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TooltipAlign_initFields() {
    TooltipAlign_initFields = function () {
    };
    TooltipAlign$CENTER_instance = new TooltipAlign('CENTER', 0, 'center');
    TooltipAlign$LEFT_instance = new TooltipAlign('LEFT', 1, 'left');
    TooltipAlign$RIGHT_instance = new TooltipAlign('RIGHT', 2, 'right');
  }
  var TooltipAlign$CENTER_instance;
  function TooltipAlign$CENTER_getInstance() {
    TooltipAlign_initFields();
    return TooltipAlign$CENTER_instance;
  }
  var TooltipAlign$LEFT_instance;
  function TooltipAlign$LEFT_getInstance() {
    TooltipAlign_initFields();
    return TooltipAlign$LEFT_instance;
  }
  var TooltipAlign$RIGHT_instance;
  function TooltipAlign$RIGHT_getInstance() {
    TooltipAlign_initFields();
    return TooltipAlign$RIGHT_instance;
  }
  TooltipAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TooltipAlign',
    interfaces: [Enum]
  };
  function TooltipAlign$values() {
    return [TooltipAlign$CENTER_getInstance(), TooltipAlign$LEFT_getInstance(), TooltipAlign$RIGHT_getInstance()];
  }
  TooltipAlign.values = TooltipAlign$values;
  function TooltipAlign$valueOf(name) {
    switch (name) {
      case 'CENTER':
        return TooltipAlign$CENTER_getInstance();
      case 'LEFT':
        return TooltipAlign$LEFT_getInstance();
      case 'RIGHT':
        return TooltipAlign$RIGHT_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.TooltipAlign.' + name);
    }
  }
  TooltipAlign.valueOf_61zpoe$ = TooltipAlign$valueOf;
  function LegendLabelAlign(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function LegendLabelAlign_initFields() {
    LegendLabelAlign_initFields = function () {
    };
    LegendLabelAlign$CENTER_instance = new LegendLabelAlign('CENTER', 0, 'center');
    LegendLabelAlign$LEFT_instance = new LegendLabelAlign('LEFT', 1, 'left');
    LegendLabelAlign$RIGHT_instance = new LegendLabelAlign('RIGHT', 2, 'right');
  }
  var LegendLabelAlign$CENTER_instance;
  function LegendLabelAlign$CENTER_getInstance() {
    LegendLabelAlign_initFields();
    return LegendLabelAlign$CENTER_instance;
  }
  var LegendLabelAlign$LEFT_instance;
  function LegendLabelAlign$LEFT_getInstance() {
    LegendLabelAlign_initFields();
    return LegendLabelAlign$LEFT_instance;
  }
  var LegendLabelAlign$RIGHT_instance;
  function LegendLabelAlign$RIGHT_getInstance() {
    LegendLabelAlign_initFields();
    return LegendLabelAlign$RIGHT_instance;
  }
  LegendLabelAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LegendLabelAlign',
    interfaces: [Enum]
  };
  function LegendLabelAlign$values() {
    return [LegendLabelAlign$CENTER_getInstance(), LegendLabelAlign$LEFT_getInstance(), LegendLabelAlign$RIGHT_getInstance()];
  }
  LegendLabelAlign.values = LegendLabelAlign$values;
  function LegendLabelAlign$valueOf(name) {
    switch (name) {
      case 'CENTER':
        return LegendLabelAlign$CENTER_getInstance();
      case 'LEFT':
        return LegendLabelAlign$LEFT_getInstance();
      case 'RIGHT':
        return LegendLabelAlign$RIGHT_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.LegendLabelAlign.' + name);
    }
  }
  LegendLabelAlign.valueOf_61zpoe$ = LegendLabelAlign$valueOf;
  function TitleAlign(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TitleAlign_initFields() {
    TitleAlign_initFields = function () {
    };
    TitleAlign$CENTER_instance = new TitleAlign('CENTER', 0, 'center');
    TitleAlign$LEFT_instance = new TitleAlign('LEFT', 1, 'left');
    TitleAlign$RIGHT_instance = new TitleAlign('RIGHT', 2, 'right');
    TitleAlign$INNER_instance = new TitleAlign('INNER', 3, 'inner');
  }
  var TitleAlign$CENTER_instance;
  function TitleAlign$CENTER_getInstance() {
    TitleAlign_initFields();
    return TitleAlign$CENTER_instance;
  }
  var TitleAlign$LEFT_instance;
  function TitleAlign$LEFT_getInstance() {
    TitleAlign_initFields();
    return TitleAlign$LEFT_instance;
  }
  var TitleAlign$RIGHT_instance;
  function TitleAlign$RIGHT_getInstance() {
    TitleAlign_initFields();
    return TitleAlign$RIGHT_instance;
  }
  var TitleAlign$INNER_instance;
  function TitleAlign$INNER_getInstance() {
    TitleAlign_initFields();
    return TitleAlign$INNER_instance;
  }
  TitleAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TitleAlign',
    interfaces: [Enum]
  };
  function TitleAlign$values() {
    return [TitleAlign$CENTER_getInstance(), TitleAlign$LEFT_getInstance(), TitleAlign$RIGHT_getInstance(), TitleAlign$INNER_getInstance()];
  }
  TitleAlign.values = TitleAlign$values;
  function TitleAlign$valueOf(name) {
    switch (name) {
      case 'CENTER':
        return TitleAlign$CENTER_getInstance();
      case 'LEFT':
        return TitleAlign$LEFT_getInstance();
      case 'RIGHT':
        return TitleAlign$RIGHT_getInstance();
      case 'INNER':
        return TitleAlign$INNER_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.TitleAlign.' + name);
    }
  }
  TitleAlign.valueOf_61zpoe$ = TitleAlign$valueOf;
  function TextDirection(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TextDirection_initFields() {
    TextDirection_initFields = function () {
    };
    TextDirection$LTR_instance = new TextDirection('LTR', 0, 'ltr');
    TextDirection$RTL_instance = new TextDirection('RTL', 1, 'rtl');
  }
  var TextDirection$LTR_instance;
  function TextDirection$LTR_getInstance() {
    TextDirection_initFields();
    return TextDirection$LTR_instance;
  }
  var TextDirection$RTL_instance;
  function TextDirection$RTL_getInstance() {
    TextDirection_initFields();
    return TextDirection$RTL_instance;
  }
  TextDirection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextDirection',
    interfaces: [Enum]
  };
  function TextDirection$values() {
    return [TextDirection$LTR_getInstance(), TextDirection$RTL_getInstance()];
  }
  TextDirection.values = TextDirection$values;
  function TextDirection$valueOf(name) {
    switch (name) {
      case 'LTR':
        return TextDirection$LTR_getInstance();
      case 'RTL':
        return TextDirection$RTL_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.TextDirection.' + name);
    }
  }
  TextDirection.valueOf_61zpoe$ = TextDirection$valueOf;
  function SkipMode(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function SkipMode_initFields() {
    SkipMode_initFields = function () {
    };
    SkipMode$TOP_instance = new SkipMode('TOP', 0, 'top');
    SkipMode$LEFT_instance = new SkipMode('LEFT', 1, 'left');
    SkipMode$RIGHT_instance = new SkipMode('RIGHT', 2, 'right');
    SkipMode$BOTTOM_instance = new SkipMode('BOTTOM', 3, 'bottom');
    SkipMode$START_instance = new SkipMode('START', 4, 'start');
    SkipMode$END_instance = new SkipMode('END', 5, 'end');
    SkipMode$MIDDLE_instance = new SkipMode('MIDDLE', 6, 'middle');
  }
  var SkipMode$TOP_instance;
  function SkipMode$TOP_getInstance() {
    SkipMode_initFields();
    return SkipMode$TOP_instance;
  }
  var SkipMode$LEFT_instance;
  function SkipMode$LEFT_getInstance() {
    SkipMode_initFields();
    return SkipMode$LEFT_instance;
  }
  var SkipMode$RIGHT_instance;
  function SkipMode$RIGHT_getInstance() {
    SkipMode_initFields();
    return SkipMode$RIGHT_instance;
  }
  var SkipMode$BOTTOM_instance;
  function SkipMode$BOTTOM_getInstance() {
    SkipMode_initFields();
    return SkipMode$BOTTOM_instance;
  }
  var SkipMode$START_instance;
  function SkipMode$START_getInstance() {
    SkipMode_initFields();
    return SkipMode$START_instance;
  }
  var SkipMode$END_instance;
  function SkipMode$END_getInstance() {
    SkipMode_initFields();
    return SkipMode$END_instance;
  }
  var SkipMode$MIDDLE_instance;
  function SkipMode$MIDDLE_getInstance() {
    SkipMode_initFields();
    return SkipMode$MIDDLE_instance;
  }
  SkipMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SkipMode',
    interfaces: [Enum]
  };
  function SkipMode$values() {
    return [SkipMode$TOP_getInstance(), SkipMode$LEFT_getInstance(), SkipMode$RIGHT_getInstance(), SkipMode$BOTTOM_getInstance(), SkipMode$START_getInstance(), SkipMode$END_getInstance(), SkipMode$MIDDLE_getInstance()];
  }
  SkipMode.values = SkipMode$values;
  function SkipMode$valueOf(name) {
    switch (name) {
      case 'TOP':
        return SkipMode$TOP_getInstance();
      case 'LEFT':
        return SkipMode$LEFT_getInstance();
      case 'RIGHT':
        return SkipMode$RIGHT_getInstance();
      case 'BOTTOM':
        return SkipMode$BOTTOM_getInstance();
      case 'START':
        return SkipMode$START_getInstance();
      case 'END':
        return SkipMode$END_getInstance();
      case 'MIDDLE':
        return SkipMode$MIDDLE_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.SkipMode.' + name);
    }
  }
  SkipMode.valueOf_61zpoe$ = SkipMode$valueOf;
  function BorderAlign(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function BorderAlign_initFields() {
    BorderAlign_initFields = function () {
    };
    BorderAlign$CENTER_instance = new BorderAlign('CENTER', 0, 'center');
    BorderAlign$INNER_instance = new BorderAlign('INNER', 1, 'inner');
  }
  var BorderAlign$CENTER_instance;
  function BorderAlign$CENTER_getInstance() {
    BorderAlign_initFields();
    return BorderAlign$CENTER_instance;
  }
  var BorderAlign$INNER_instance;
  function BorderAlign$INNER_getInstance() {
    BorderAlign_initFields();
    return BorderAlign$INNER_instance;
  }
  BorderAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BorderAlign',
    interfaces: [Enum]
  };
  function BorderAlign$values() {
    return [BorderAlign$CENTER_getInstance(), BorderAlign$INNER_getInstance()];
  }
  BorderAlign.values = BorderAlign$values;
  function BorderAlign$valueOf(name) {
    switch (name) {
      case 'CENTER':
        return BorderAlign$CENTER_getInstance();
      case 'INNER':
        return BorderAlign$INNER_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.BorderAlign.' + name);
    }
  }
  BorderAlign.valueOf_61zpoe$ = BorderAlign$valueOf;
  function CrossAlign(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function CrossAlign_initFields() {
    CrossAlign_initFields = function () {
    };
    CrossAlign$CENTER_instance = new CrossAlign('CENTER', 0, 'center');
    CrossAlign$NEAR_instance = new CrossAlign('NEAR', 1, 'near');
    CrossAlign$FAR_instance = new CrossAlign('FAR', 2, 'far');
  }
  var CrossAlign$CENTER_instance;
  function CrossAlign$CENTER_getInstance() {
    CrossAlign_initFields();
    return CrossAlign$CENTER_instance;
  }
  var CrossAlign$NEAR_instance;
  function CrossAlign$NEAR_getInstance() {
    CrossAlign_initFields();
    return CrossAlign$NEAR_instance;
  }
  var CrossAlign$FAR_instance;
  function CrossAlign$FAR_getInstance() {
    CrossAlign_initFields();
    return CrossAlign$FAR_instance;
  }
  CrossAlign.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CrossAlign',
    interfaces: [Enum]
  };
  function CrossAlign$values() {
    return [CrossAlign$CENTER_getInstance(), CrossAlign$NEAR_getInstance(), CrossAlign$FAR_getInstance()];
  }
  CrossAlign.values = CrossAlign$values;
  function CrossAlign$valueOf(name) {
    switch (name) {
      case 'CENTER':
        return CrossAlign$CENTER_getInstance();
      case 'NEAR':
        return CrossAlign$NEAR_getInstance();
      case 'FAR':
        return CrossAlign$FAR_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.CrossAlign.' + name);
    }
  }
  CrossAlign.valueOf_61zpoe$ = CrossAlign$valueOf;
  function ScaleBounds(name, ordinal, mode) {
    Enum.call(this);
    this.mode_8be2vx$ = mode;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ScaleBounds_initFields() {
    ScaleBounds_initFields = function () {
    };
    ScaleBounds$DATA_instance = new ScaleBounds('DATA', 0, 'data');
    ScaleBounds$TICKS_instance = new ScaleBounds('TICKS', 1, 'ticks');
  }
  var ScaleBounds$DATA_instance;
  function ScaleBounds$DATA_getInstance() {
    ScaleBounds_initFields();
    return ScaleBounds$DATA_instance;
  }
  var ScaleBounds$TICKS_instance;
  function ScaleBounds$TICKS_getInstance() {
    ScaleBounds_initFields();
    return ScaleBounds$TICKS_instance;
  }
  ScaleBounds.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ScaleBounds',
    interfaces: [Enum]
  };
  function ScaleBounds$values() {
    return [ScaleBounds$DATA_getInstance(), ScaleBounds$TICKS_getInstance()];
  }
  ScaleBounds.values = ScaleBounds$values;
  function ScaleBounds$valueOf(name) {
    switch (name) {
      case 'DATA':
        return ScaleBounds$DATA_getInstance();
      case 'TICKS':
        return ScaleBounds$TICKS_getInstance();
      default:
        throwISE('No enum constant io.kvision.chart.ScaleBounds.' + name);
    }
  }
  ScaleBounds.valueOf_61zpoe$ = ScaleBounds$valueOf;
  function ChartFont(family, size, style, weight, lineHeight) {
    if (family === void 0)
      family = null;
    if (size === void 0)
      size = null;
    if (style === void 0)
      style = null;
    if (weight === void 0)
      weight = null;
    if (lineHeight === void 0)
      lineHeight = null;
    this.family = family;
    this.size = size;
    this.style = style;
    this.weight = weight;
    this.lineHeight = lineHeight;
  }
  ChartFont.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChartFont',
    interfaces: []
  };
  ChartFont.prototype.component1 = function () {
    return this.family;
  };
  ChartFont.prototype.component2 = function () {
    return this.size;
  };
  ChartFont.prototype.component3 = function () {
    return this.style;
  };
  ChartFont.prototype.component4 = function () {
    return this.weight;
  };
  ChartFont.prototype.component5 = function () {
    return this.lineHeight;
  };
  ChartFont.prototype.copy_gzhpxd$ = function (family, size, style, weight, lineHeight) {
    return new ChartFont(family === void 0 ? this.family : family, size === void 0 ? this.size : size, style === void 0 ? this.style : style, weight === void 0 ? this.weight : weight, lineHeight === void 0 ? this.lineHeight : lineHeight);
  };
  ChartFont.prototype.toString = function () {
    return 'ChartFont(family=' + Kotlin.toString(this.family) + (', size=' + Kotlin.toString(this.size)) + (', style=' + Kotlin.toString(this.style)) + (', weight=' + Kotlin.toString(this.weight)) + (', lineHeight=' + Kotlin.toString(this.lineHeight)) + ')';
  };
  ChartFont.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.family) | 0;
    result = result * 31 + Kotlin.hashCode(this.size) | 0;
    result = result * 31 + Kotlin.hashCode(this.style) | 0;
    result = result * 31 + Kotlin.hashCode(this.weight) | 0;
    result = result * 31 + Kotlin.hashCode(this.lineHeight) | 0;
    return result;
  };
  ChartFont.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.family, other.family) && Kotlin.equals(this.size, other.size) && Kotlin.equals(this.style, other.style) && Kotlin.equals(this.weight, other.weight) && Kotlin.equals(this.lineHeight, other.lineHeight)))));
  };
  function toJs($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.family != null)
      $receiver_0.family = $receiver.family;
    if ($receiver.size != null)
      $receiver_0.size = $receiver.size;
    if ($receiver.style != null)
      $receiver_0.style = $receiver.style;
    if ($receiver.weight != null)
      $receiver_0.weight = $receiver.weight;
    if ($receiver.lineHeight != null)
      $receiver_0.lineHeight = $receiver.lineHeight;
    return $receiver_0;
  }
  function InteractionOptions(mode, intersect, axis, includeInvisible) {
    if (mode === void 0)
      mode = InteractionMode$NEAREST_getInstance();
    if (intersect === void 0)
      intersect = true;
    if (axis === void 0)
      axis = 'x';
    if (includeInvisible === void 0)
      includeInvisible = true;
    this.mode = mode;
    this.intersect = intersect;
    this.axis = axis;
    this.includeInvisible = includeInvisible;
  }
  InteractionOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InteractionOptions',
    interfaces: []
  };
  InteractionOptions.prototype.component1 = function () {
    return this.mode;
  };
  InteractionOptions.prototype.component2 = function () {
    return this.intersect;
  };
  InteractionOptions.prototype.component3 = function () {
    return this.axis;
  };
  InteractionOptions.prototype.component4 = function () {
    return this.includeInvisible;
  };
  InteractionOptions.prototype.copy_9zm440$ = function (mode, intersect, axis, includeInvisible) {
    return new InteractionOptions(mode === void 0 ? this.mode : mode, intersect === void 0 ? this.intersect : intersect, axis === void 0 ? this.axis : axis, includeInvisible === void 0 ? this.includeInvisible : includeInvisible);
  };
  InteractionOptions.prototype.toString = function () {
    return 'InteractionOptions(mode=' + Kotlin.toString(this.mode) + (', intersect=' + Kotlin.toString(this.intersect)) + (', axis=' + Kotlin.toString(this.axis)) + (', includeInvisible=' + Kotlin.toString(this.includeInvisible)) + ')';
  };
  InteractionOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.mode) | 0;
    result = result * 31 + Kotlin.hashCode(this.intersect) | 0;
    result = result * 31 + Kotlin.hashCode(this.axis) | 0;
    result = result * 31 + Kotlin.hashCode(this.includeInvisible) | 0;
    return result;
  };
  InteractionOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.mode, other.mode) && Kotlin.equals(this.intersect, other.intersect) && Kotlin.equals(this.axis, other.axis) && Kotlin.equals(this.includeInvisible, other.includeInvisible)))));
  };
  function toJs_0($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.mode = $receiver.mode.mode_8be2vx$;
    $receiver_0.intersect = $receiver.intersect;
    $receiver_0.axis = $receiver.axis;
    $receiver_0.includeInvisible = $receiver.includeInvisible;
    return $receiver_0;
  }
  function AnimationOptions(duration, easing, delay, loop, onProgress, onComplete, disabled) {
    if (duration === void 0)
      duration = 1000;
    if (easing === void 0)
      easing = Eeasing$EASEOUTQUART_getInstance();
    if (delay === void 0)
      delay = null;
    if (loop === void 0)
      loop = null;
    if (onProgress === void 0)
      onProgress = null;
    if (onComplete === void 0)
      onComplete = null;
    if (disabled === void 0)
      disabled = null;
    this.duration = duration;
    this.easing = easing;
    this.delay = delay;
    this.loop = loop;
    this.onProgress = onProgress;
    this.onComplete = onComplete;
    this.disabled = disabled;
  }
  AnimationOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnimationOptions',
    interfaces: []
  };
  AnimationOptions.prototype.component1 = function () {
    return this.duration;
  };
  AnimationOptions.prototype.component2 = function () {
    return this.easing;
  };
  AnimationOptions.prototype.component3 = function () {
    return this.delay;
  };
  AnimationOptions.prototype.component4 = function () {
    return this.loop;
  };
  AnimationOptions.prototype.component5 = function () {
    return this.onProgress;
  };
  AnimationOptions.prototype.component6 = function () {
    return this.onComplete;
  };
  AnimationOptions.prototype.component7 = function () {
    return this.disabled;
  };
  AnimationOptions.prototype.copy_bpgkji$ = function (duration, easing, delay, loop, onProgress, onComplete, disabled) {
    return new AnimationOptions(duration === void 0 ? this.duration : duration, easing === void 0 ? this.easing : easing, delay === void 0 ? this.delay : delay, loop === void 0 ? this.loop : loop, onProgress === void 0 ? this.onProgress : onProgress, onComplete === void 0 ? this.onComplete : onComplete, disabled === void 0 ? this.disabled : disabled);
  };
  AnimationOptions.prototype.toString = function () {
    return 'AnimationOptions(duration=' + Kotlin.toString(this.duration) + (', easing=' + Kotlin.toString(this.easing)) + (', delay=' + Kotlin.toString(this.delay)) + (', loop=' + Kotlin.toString(this.loop)) + (', onProgress=' + Kotlin.toString(this.onProgress)) + (', onComplete=' + Kotlin.toString(this.onComplete)) + (', disabled=' + Kotlin.toString(this.disabled)) + ')';
  };
  AnimationOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.easing) | 0;
    result = result * 31 + Kotlin.hashCode(this.delay) | 0;
    result = result * 31 + Kotlin.hashCode(this.loop) | 0;
    result = result * 31 + Kotlin.hashCode(this.onProgress) | 0;
    result = result * 31 + Kotlin.hashCode(this.onComplete) | 0;
    result = result * 31 + Kotlin.hashCode(this.disabled) | 0;
    return result;
  };
  AnimationOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.easing, other.easing) && Kotlin.equals(this.delay, other.delay) && Kotlin.equals(this.loop, other.loop) && Kotlin.equals(this.onProgress, other.onProgress) && Kotlin.equals(this.onComplete, other.onComplete) && Kotlin.equals(this.disabled, other.disabled)))));
  };
  function toJs_1($receiver) {
    var tmp$;
    if ($receiver.disabled === true)
      tmp$ = false;
    else {
      var $receiver_0 = new Object_init();
      $receiver_0.duration = $receiver.duration;
      $receiver_0.easing = $receiver.easing.mode_8be2vx$;
      if ($receiver.delay != null)
        $receiver_0.delay = $receiver.delay;
      if ($receiver.loop != null)
        $receiver_0.loop = $receiver.loop;
      if ($receiver.onProgress != null)
        $receiver_0.onProgress = $receiver.onProgress;
      if ($receiver.onComplete != null)
        $receiver_0.onComplete = $receiver.onComplete;
      tmp$ = $receiver_0;
    }
    return tmp$;
  }
  function LayoutPaddingObject(top, right, bottom, left) {
    if (top === void 0)
      top = null;
    if (right === void 0)
      right = null;
    if (bottom === void 0)
      bottom = null;
    if (left === void 0)
      left = null;
    this.top = top;
    this.right = right;
    this.bottom = bottom;
    this.left = left;
  }
  LayoutPaddingObject.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LayoutPaddingObject',
    interfaces: []
  };
  LayoutPaddingObject.prototype.component1 = function () {
    return this.top;
  };
  LayoutPaddingObject.prototype.component2 = function () {
    return this.right;
  };
  LayoutPaddingObject.prototype.component3 = function () {
    return this.bottom;
  };
  LayoutPaddingObject.prototype.component4 = function () {
    return this.left;
  };
  LayoutPaddingObject.prototype.copy_po2tg0$ = function (top, right, bottom, left) {
    return new LayoutPaddingObject(top === void 0 ? this.top : top, right === void 0 ? this.right : right, bottom === void 0 ? this.bottom : bottom, left === void 0 ? this.left : left);
  };
  LayoutPaddingObject.prototype.toString = function () {
    return 'LayoutPaddingObject(top=' + Kotlin.toString(this.top) + (', right=' + Kotlin.toString(this.right)) + (', bottom=' + Kotlin.toString(this.bottom)) + (', left=' + Kotlin.toString(this.left)) + ')';
  };
  LayoutPaddingObject.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.top) | 0;
    result = result * 31 + Kotlin.hashCode(this.right) | 0;
    result = result * 31 + Kotlin.hashCode(this.bottom) | 0;
    result = result * 31 + Kotlin.hashCode(this.left) | 0;
    return result;
  };
  LayoutPaddingObject.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.top, other.top) && Kotlin.equals(this.right, other.right) && Kotlin.equals(this.bottom, other.bottom) && Kotlin.equals(this.left, other.left)))));
  };
  function toJs_2($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.top != null)
      $receiver_0.top = $receiver.top;
    if ($receiver.right != null)
      $receiver_0.right = $receiver.right;
    if ($receiver.bottom != null)
      $receiver_0.bottom = $receiver.bottom;
    if ($receiver.left != null)
      $receiver_0.left = $receiver.left;
    return $receiver_0;
  }
  function LayoutOptions(autoPadding, padding) {
    if (autoPadding === void 0)
      autoPadding = true;
    if (padding === void 0)
      padding = null;
    this.autoPadding = autoPadding;
    this.padding = padding;
  }
  LayoutOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LayoutOptions',
    interfaces: []
  };
  LayoutOptions.prototype.component1 = function () {
    return this.autoPadding;
  };
  LayoutOptions.prototype.component2 = function () {
    return this.padding;
  };
  LayoutOptions.prototype.copy_atu2th$ = function (autoPadding, padding) {
    return new LayoutOptions(autoPadding === void 0 ? this.autoPadding : autoPadding, padding === void 0 ? this.padding : padding);
  };
  LayoutOptions.prototype.toString = function () {
    return 'LayoutOptions(autoPadding=' + Kotlin.toString(this.autoPadding) + (', padding=' + Kotlin.toString(this.padding)) + ')';
  };
  LayoutOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.autoPadding) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    return result;
  };
  LayoutOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.autoPadding, other.autoPadding) && Kotlin.equals(this.padding, other.padding)))));
  };
  function toJs_3($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.autoPadding = $receiver.autoPadding;
    if ($receiver.padding != null)
      $receiver_0.padding = toJs_2($receiver.padding);
    return $receiver_0;
  }
  function LegendLabelOptions(boxWidth, boxHeight, color, font, padding, generateLabels, filter, sort, usePointStyle, pointStyle, textAlign) {
    if (boxWidth === void 0)
      boxWidth = 40;
    if (boxHeight === void 0)
      boxHeight = null;
    if (color === void 0)
      color = null;
    if (font === void 0)
      font = null;
    if (padding === void 0)
      padding = 10;
    if (generateLabels === void 0)
      generateLabels = null;
    if (filter === void 0)
      filter = null;
    if (sort === void 0)
      sort = null;
    if (usePointStyle === void 0)
      usePointStyle = false;
    if (pointStyle === void 0)
      pointStyle = null;
    if (textAlign === void 0)
      textAlign = null;
    this.boxWidth = boxWidth;
    this.boxHeight = boxHeight;
    this.color = color;
    this.font = font;
    this.padding = padding;
    this.generateLabels = generateLabels;
    this.filter = filter;
    this.sort = sort;
    this.usePointStyle = usePointStyle;
    this.pointStyle = pointStyle;
    this.textAlign = textAlign;
  }
  LegendLabelOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LegendLabelOptions',
    interfaces: []
  };
  LegendLabelOptions.prototype.component1 = function () {
    return this.boxWidth;
  };
  LegendLabelOptions.prototype.component2 = function () {
    return this.boxHeight;
  };
  LegendLabelOptions.prototype.component3 = function () {
    return this.color;
  };
  LegendLabelOptions.prototype.component4 = function () {
    return this.font;
  };
  LegendLabelOptions.prototype.component5 = function () {
    return this.padding;
  };
  LegendLabelOptions.prototype.component6 = function () {
    return this.generateLabels;
  };
  LegendLabelOptions.prototype.component7 = function () {
    return this.filter;
  };
  LegendLabelOptions.prototype.component8 = function () {
    return this.sort;
  };
  LegendLabelOptions.prototype.component9 = function () {
    return this.usePointStyle;
  };
  LegendLabelOptions.prototype.component10 = function () {
    return this.pointStyle;
  };
  LegendLabelOptions.prototype.component11 = function () {
    return this.textAlign;
  };
  LegendLabelOptions.prototype.copy_wr3551$ = function (boxWidth, boxHeight, color, font, padding, generateLabels, filter, sort, usePointStyle, pointStyle, textAlign) {
    return new LegendLabelOptions(boxWidth === void 0 ? this.boxWidth : boxWidth, boxHeight === void 0 ? this.boxHeight : boxHeight, color === void 0 ? this.color : color, font === void 0 ? this.font : font, padding === void 0 ? this.padding : padding, generateLabels === void 0 ? this.generateLabels : generateLabels, filter === void 0 ? this.filter : filter, sort === void 0 ? this.sort : sort, usePointStyle === void 0 ? this.usePointStyle : usePointStyle, pointStyle === void 0 ? this.pointStyle : pointStyle, textAlign === void 0 ? this.textAlign : textAlign);
  };
  LegendLabelOptions.prototype.toString = function () {
    return 'LegendLabelOptions(boxWidth=' + Kotlin.toString(this.boxWidth) + (', boxHeight=' + Kotlin.toString(this.boxHeight)) + (', color=' + Kotlin.toString(this.color)) + (', font=' + Kotlin.toString(this.font)) + (', padding=' + Kotlin.toString(this.padding)) + (', generateLabels=' + Kotlin.toString(this.generateLabels)) + (', filter=' + Kotlin.toString(this.filter)) + (', sort=' + Kotlin.toString(this.sort)) + (', usePointStyle=' + Kotlin.toString(this.usePointStyle)) + (', pointStyle=' + Kotlin.toString(this.pointStyle)) + (', textAlign=' + Kotlin.toString(this.textAlign)) + ')';
  };
  LegendLabelOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.boxWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.boxHeight) | 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.font) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    result = result * 31 + Kotlin.hashCode(this.generateLabels) | 0;
    result = result * 31 + Kotlin.hashCode(this.filter) | 0;
    result = result * 31 + Kotlin.hashCode(this.sort) | 0;
    result = result * 31 + Kotlin.hashCode(this.usePointStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.textAlign) | 0;
    return result;
  };
  LegendLabelOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.boxWidth, other.boxWidth) && Kotlin.equals(this.boxHeight, other.boxHeight) && Kotlin.equals(this.color, other.color) && Kotlin.equals(this.font, other.font) && Kotlin.equals(this.padding, other.padding) && Kotlin.equals(this.generateLabels, other.generateLabels) && Kotlin.equals(this.filter, other.filter) && Kotlin.equals(this.sort, other.sort) && Kotlin.equals(this.usePointStyle, other.usePointStyle) && Kotlin.equals(this.pointStyle, other.pointStyle) && Kotlin.equals(this.textAlign, other.textAlign)))));
  };
  function toJs_4($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.boxWidth = $receiver.boxWidth;
    if ($receiver.boxHeight != null)
      $receiver_0.boxHeight = $receiver.boxHeight;
    if ($receiver.color != null)
      $receiver_0.color = $receiver.color.asString();
    if ($receiver.font != null)
      $receiver_0.font = toJs($receiver.font);
    $receiver_0.padding = $receiver.padding;
    if ($receiver.generateLabels != null)
      $receiver_0.generateLabels = $receiver.generateLabels;
    if ($receiver.filter != null)
      $receiver_0.filter = $receiver.filter;
    if ($receiver.sort != null)
      $receiver_0.sort = $receiver.sort;
    $receiver_0.usePointStyle = $receiver.usePointStyle;
    if ($receiver.pointStyle != null)
      $receiver_0.pointStyle = $receiver.pointStyle.style_8be2vx$;
    if ($receiver.textAlign != null)
      $receiver_0.textAlign = $receiver.textAlign.mode_8be2vx$;
    return $receiver_0;
  }
  function LegendTitleOptions(display, color, font, padding, text) {
    if (display === void 0)
      display = null;
    if (color === void 0)
      color = null;
    if (font === void 0)
      font = null;
    if (padding === void 0)
      padding = null;
    if (text === void 0)
      text = null;
    this.display = display;
    this.color = color;
    this.font = font;
    this.padding = padding;
    this.text = text;
  }
  LegendTitleOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LegendTitleOptions',
    interfaces: []
  };
  LegendTitleOptions.prototype.component1 = function () {
    return this.display;
  };
  LegendTitleOptions.prototype.component2 = function () {
    return this.color;
  };
  LegendTitleOptions.prototype.component3 = function () {
    return this.font;
  };
  LegendTitleOptions.prototype.component4 = function () {
    return this.padding;
  };
  LegendTitleOptions.prototype.component5 = function () {
    return this.text;
  };
  LegendTitleOptions.prototype.copy_5jyrvx$ = function (display, color, font, padding, text) {
    return new LegendTitleOptions(display === void 0 ? this.display : display, color === void 0 ? this.color : color, font === void 0 ? this.font : font, padding === void 0 ? this.padding : padding, text === void 0 ? this.text : text);
  };
  LegendTitleOptions.prototype.toString = function () {
    return 'LegendTitleOptions(display=' + Kotlin.toString(this.display) + (', color=' + Kotlin.toString(this.color)) + (', font=' + Kotlin.toString(this.font)) + (', padding=' + Kotlin.toString(this.padding)) + (', text=' + Kotlin.toString(this.text)) + ')';
  };
  LegendTitleOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.font) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    return result;
  };
  LegendTitleOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.display, other.display) && Kotlin.equals(this.color, other.color) && Kotlin.equals(this.font, other.font) && Kotlin.equals(this.padding, other.padding) && Kotlin.equals(this.text, other.text)))));
  };
  function toJs_5($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    if ($receiver.display != null)
      $receiver_0.display = $receiver.display;
    if ($receiver.color != null)
      $receiver_0.color = $receiver.color.asString();
    if ($receiver.font != null)
      $receiver_0.font = toJs($receiver.font);
    if ($receiver.padding != null)
      $receiver_0.padding = $receiver.padding;
    if ($receiver.text != null)
      $receiver_0.text = i18nTranslator($receiver.text);
    return $receiver_0;
  }
  function LegendOptions(display, position, align, maxHeight, maxWidth, fullSize, reverse, labels, rtl, textDirection, title, onClick, onHover, onLeave) {
    if (display === void 0)
      display = true;
    if (position === void 0)
      position = Position$TOP_getInstance();
    if (align === void 0)
      align = null;
    if (maxHeight === void 0)
      maxHeight = null;
    if (maxWidth === void 0)
      maxWidth = null;
    if (fullSize === void 0)
      fullSize = true;
    if (reverse === void 0)
      reverse = false;
    if (labels === void 0)
      labels = null;
    if (rtl === void 0)
      rtl = null;
    if (textDirection === void 0)
      textDirection = null;
    if (title === void 0)
      title = null;
    if (onClick === void 0)
      onClick = null;
    if (onHover === void 0)
      onHover = null;
    if (onLeave === void 0)
      onLeave = null;
    this.display = display;
    this.position = position;
    this.align = align;
    this.maxHeight = maxHeight;
    this.maxWidth = maxWidth;
    this.fullSize = fullSize;
    this.reverse = reverse;
    this.labels = labels;
    this.rtl = rtl;
    this.textDirection = textDirection;
    this.title = title;
    this.onClick = onClick;
    this.onHover = onHover;
    this.onLeave = onLeave;
  }
  LegendOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LegendOptions',
    interfaces: []
  };
  LegendOptions.prototype.component1 = function () {
    return this.display;
  };
  LegendOptions.prototype.component2 = function () {
    return this.position;
  };
  LegendOptions.prototype.component3 = function () {
    return this.align;
  };
  LegendOptions.prototype.component4 = function () {
    return this.maxHeight;
  };
  LegendOptions.prototype.component5 = function () {
    return this.maxWidth;
  };
  LegendOptions.prototype.component6 = function () {
    return this.fullSize;
  };
  LegendOptions.prototype.component7 = function () {
    return this.reverse;
  };
  LegendOptions.prototype.component8 = function () {
    return this.labels;
  };
  LegendOptions.prototype.component9 = function () {
    return this.rtl;
  };
  LegendOptions.prototype.component10 = function () {
    return this.textDirection;
  };
  LegendOptions.prototype.component11 = function () {
    return this.title;
  };
  LegendOptions.prototype.component12 = function () {
    return this.onClick;
  };
  LegendOptions.prototype.component13 = function () {
    return this.onHover;
  };
  LegendOptions.prototype.component14 = function () {
    return this.onLeave;
  };
  LegendOptions.prototype.copy_12xseo$ = function (display, position, align, maxHeight, maxWidth, fullSize, reverse, labels, rtl, textDirection, title, onClick, onHover, onLeave) {
    return new LegendOptions(display === void 0 ? this.display : display, position === void 0 ? this.position : position, align === void 0 ? this.align : align, maxHeight === void 0 ? this.maxHeight : maxHeight, maxWidth === void 0 ? this.maxWidth : maxWidth, fullSize === void 0 ? this.fullSize : fullSize, reverse === void 0 ? this.reverse : reverse, labels === void 0 ? this.labels : labels, rtl === void 0 ? this.rtl : rtl, textDirection === void 0 ? this.textDirection : textDirection, title === void 0 ? this.title : title, onClick === void 0 ? this.onClick : onClick, onHover === void 0 ? this.onHover : onHover, onLeave === void 0 ? this.onLeave : onLeave);
  };
  LegendOptions.prototype.toString = function () {
    return 'LegendOptions(display=' + Kotlin.toString(this.display) + (', position=' + Kotlin.toString(this.position)) + (', align=' + Kotlin.toString(this.align)) + (', maxHeight=' + Kotlin.toString(this.maxHeight)) + (', maxWidth=' + Kotlin.toString(this.maxWidth)) + (', fullSize=' + Kotlin.toString(this.fullSize)) + (', reverse=' + Kotlin.toString(this.reverse)) + (', labels=' + Kotlin.toString(this.labels)) + (', rtl=' + Kotlin.toString(this.rtl)) + (', textDirection=' + Kotlin.toString(this.textDirection)) + (', title=' + Kotlin.toString(this.title)) + (', onClick=' + Kotlin.toString(this.onClick)) + (', onHover=' + Kotlin.toString(this.onHover)) + (', onLeave=' + Kotlin.toString(this.onLeave)) + ')';
  };
  LegendOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.position) | 0;
    result = result * 31 + Kotlin.hashCode(this.align) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxHeight) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.fullSize) | 0;
    result = result * 31 + Kotlin.hashCode(this.reverse) | 0;
    result = result * 31 + Kotlin.hashCode(this.labels) | 0;
    result = result * 31 + Kotlin.hashCode(this.rtl) | 0;
    result = result * 31 + Kotlin.hashCode(this.textDirection) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.onClick) | 0;
    result = result * 31 + Kotlin.hashCode(this.onHover) | 0;
    result = result * 31 + Kotlin.hashCode(this.onLeave) | 0;
    return result;
  };
  LegendOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.display, other.display) && Kotlin.equals(this.position, other.position) && Kotlin.equals(this.align, other.align) && Kotlin.equals(this.maxHeight, other.maxHeight) && Kotlin.equals(this.maxWidth, other.maxWidth) && Kotlin.equals(this.fullSize, other.fullSize) && Kotlin.equals(this.reverse, other.reverse) && Kotlin.equals(this.labels, other.labels) && Kotlin.equals(this.rtl, other.rtl) && Kotlin.equals(this.textDirection, other.textDirection) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.onClick, other.onClick) && Kotlin.equals(this.onHover, other.onHover) && Kotlin.equals(this.onLeave, other.onLeave)))));
  };
  function toJs_6($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    $receiver_0.display = $receiver.display;
    $receiver_0.position = $receiver.position.position_8be2vx$;
    if ($receiver.align != null)
      $receiver_0.align = $receiver.align.mode_8be2vx$;
    if ($receiver.maxHeight != null)
      $receiver_0.maxHeight = $receiver.maxHeight;
    if ($receiver.maxWidth != null)
      $receiver_0.maxWidth = $receiver.maxWidth;
    $receiver_0.fullSize = $receiver.fullSize;
    $receiver_0.reverse = $receiver.reverse;
    if ($receiver.labels != null)
      $receiver_0.labels = toJs_4($receiver.labels);
    if ($receiver.rtl != null)
      $receiver_0.rtl = $receiver.rtl;
    if ($receiver.textDirection != null)
      $receiver_0.textDirection = $receiver.textDirection.mode_8be2vx$;
    if ($receiver.title != null)
      $receiver_0.title = toJs_5($receiver.title, i18nTranslator);
    if ($receiver.onClick != null)
      $receiver_0.onClick = $receiver.onClick;
    if ($receiver.onHover != null)
      $receiver_0.onHover = $receiver.onHover;
    if ($receiver.onLeave != null)
      $receiver_0.onLeave = $receiver.onLeave;
    return $receiver_0;
  }
  function TitleOptions(align, display, position, color, font, padding, fullSize, text) {
    if (align === void 0)
      align = null;
    if (display === void 0)
      display = false;
    if (position === void 0)
      position = Position$TOP_getInstance();
    if (color === void 0)
      color = null;
    if (font === void 0)
      font = null;
    if (padding === void 0)
      padding = 10;
    if (fullSize === void 0)
      fullSize = null;
    if (text === void 0)
      text = null;
    this.align = align;
    this.display = display;
    this.position = position;
    this.color = color;
    this.font = font;
    this.padding = padding;
    this.fullSize = fullSize;
    this.text = text;
  }
  TitleOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TitleOptions',
    interfaces: []
  };
  TitleOptions.prototype.component1 = function () {
    return this.align;
  };
  TitleOptions.prototype.component2 = function () {
    return this.display;
  };
  TitleOptions.prototype.component3 = function () {
    return this.position;
  };
  TitleOptions.prototype.component4 = function () {
    return this.color;
  };
  TitleOptions.prototype.component5 = function () {
    return this.font;
  };
  TitleOptions.prototype.component6 = function () {
    return this.padding;
  };
  TitleOptions.prototype.component7 = function () {
    return this.fullSize;
  };
  TitleOptions.prototype.component8 = function () {
    return this.text;
  };
  TitleOptions.prototype.copy_zfaft3$ = function (align, display, position, color, font, padding, fullSize, text) {
    return new TitleOptions(align === void 0 ? this.align : align, display === void 0 ? this.display : display, position === void 0 ? this.position : position, color === void 0 ? this.color : color, font === void 0 ? this.font : font, padding === void 0 ? this.padding : padding, fullSize === void 0 ? this.fullSize : fullSize, text === void 0 ? this.text : text);
  };
  TitleOptions.prototype.toString = function () {
    return 'TitleOptions(align=' + Kotlin.toString(this.align) + (', display=' + Kotlin.toString(this.display)) + (', position=' + Kotlin.toString(this.position)) + (', color=' + Kotlin.toString(this.color)) + (', font=' + Kotlin.toString(this.font)) + (', padding=' + Kotlin.toString(this.padding)) + (', fullSize=' + Kotlin.toString(this.fullSize)) + (', text=' + Kotlin.toString(this.text)) + ')';
  };
  TitleOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.align) | 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.position) | 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.font) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    result = result * 31 + Kotlin.hashCode(this.fullSize) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    return result;
  };
  TitleOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.align, other.align) && Kotlin.equals(this.display, other.display) && Kotlin.equals(this.position, other.position) && Kotlin.equals(this.color, other.color) && Kotlin.equals(this.font, other.font) && Kotlin.equals(this.padding, other.padding) && Kotlin.equals(this.fullSize, other.fullSize) && Kotlin.equals(this.text, other.text)))));
  };
  function toJs_7($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    $receiver_0.display = $receiver.display;
    $receiver_0.position = $receiver.position.position_8be2vx$;
    $receiver_0.fontSize = $receiver_0.fontSize;
    if ($receiver_0.fontStyle != null)
      $receiver_0.fontStyle = $receiver_0.fontStyle.name;
    if ($receiver_0.fontColor != null)
      $receiver_0.fontColor = $receiver_0.fontColor.asString();
    if ($receiver_0.fontFamily != null)
      $receiver_0.fontFamily = $receiver_0.fontFamily;
    $receiver_0.padding = $receiver.padding;
    if ($receiver_0.lineHeight != null)
      $receiver_0.lineHeight = $receiver_0.lineHeight;
    if ($receiver.text != null) {
      var $receiver_1 = $receiver.text;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$;
      tmp$ = $receiver_1.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(i18nTranslator(item));
      }
      $receiver_0.text = copyToArray(destination);
    }
    if ($receiver_0.fullWidth != null)
      $receiver_0.fullWidth = $receiver_0.fullWidth;
    return $receiver_0;
  }
  function TooltipCallback(beforeTitle, title, afterTitle, beforeBody, beforeLabel, label, labelColor, labelTextColor, afterLabel, afterBody, beforeFooter, footer, afterFooter) {
    if (beforeTitle === void 0)
      beforeTitle = null;
    if (title === void 0)
      title = null;
    if (afterTitle === void 0)
      afterTitle = null;
    if (beforeBody === void 0)
      beforeBody = null;
    if (beforeLabel === void 0)
      beforeLabel = null;
    if (label === void 0)
      label = null;
    if (labelColor === void 0)
      labelColor = null;
    if (labelTextColor === void 0)
      labelTextColor = null;
    if (afterLabel === void 0)
      afterLabel = null;
    if (afterBody === void 0)
      afterBody = null;
    if (beforeFooter === void 0)
      beforeFooter = null;
    if (footer === void 0)
      footer = null;
    if (afterFooter === void 0)
      afterFooter = null;
    this.beforeTitle = beforeTitle;
    this.title = title;
    this.afterTitle = afterTitle;
    this.beforeBody = beforeBody;
    this.beforeLabel = beforeLabel;
    this.label = label;
    this.labelColor = labelColor;
    this.labelTextColor = labelTextColor;
    this.afterLabel = afterLabel;
    this.afterBody = afterBody;
    this.beforeFooter = beforeFooter;
    this.footer = footer;
    this.afterFooter = afterFooter;
  }
  TooltipCallback.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TooltipCallback',
    interfaces: []
  };
  TooltipCallback.prototype.component1 = function () {
    return this.beforeTitle;
  };
  TooltipCallback.prototype.component2 = function () {
    return this.title;
  };
  TooltipCallback.prototype.component3 = function () {
    return this.afterTitle;
  };
  TooltipCallback.prototype.component4 = function () {
    return this.beforeBody;
  };
  TooltipCallback.prototype.component5 = function () {
    return this.beforeLabel;
  };
  TooltipCallback.prototype.component6 = function () {
    return this.label;
  };
  TooltipCallback.prototype.component7 = function () {
    return this.labelColor;
  };
  TooltipCallback.prototype.component8 = function () {
    return this.labelTextColor;
  };
  TooltipCallback.prototype.component9 = function () {
    return this.afterLabel;
  };
  TooltipCallback.prototype.component10 = function () {
    return this.afterBody;
  };
  TooltipCallback.prototype.component11 = function () {
    return this.beforeFooter;
  };
  TooltipCallback.prototype.component12 = function () {
    return this.footer;
  };
  TooltipCallback.prototype.component13 = function () {
    return this.afterFooter;
  };
  TooltipCallback.prototype.copy_yl1o48$ = function (beforeTitle, title, afterTitle, beforeBody, beforeLabel, label, labelColor, labelTextColor, afterLabel, afterBody, beforeFooter, footer, afterFooter) {
    return new TooltipCallback(beforeTitle === void 0 ? this.beforeTitle : beforeTitle, title === void 0 ? this.title : title, afterTitle === void 0 ? this.afterTitle : afterTitle, beforeBody === void 0 ? this.beforeBody : beforeBody, beforeLabel === void 0 ? this.beforeLabel : beforeLabel, label === void 0 ? this.label : label, labelColor === void 0 ? this.labelColor : labelColor, labelTextColor === void 0 ? this.labelTextColor : labelTextColor, afterLabel === void 0 ? this.afterLabel : afterLabel, afterBody === void 0 ? this.afterBody : afterBody, beforeFooter === void 0 ? this.beforeFooter : beforeFooter, footer === void 0 ? this.footer : footer, afterFooter === void 0 ? this.afterFooter : afterFooter);
  };
  TooltipCallback.prototype.toString = function () {
    return 'TooltipCallback(beforeTitle=' + Kotlin.toString(this.beforeTitle) + (', title=' + Kotlin.toString(this.title)) + (', afterTitle=' + Kotlin.toString(this.afterTitle)) + (', beforeBody=' + Kotlin.toString(this.beforeBody)) + (', beforeLabel=' + Kotlin.toString(this.beforeLabel)) + (', label=' + Kotlin.toString(this.label)) + (', labelColor=' + Kotlin.toString(this.labelColor)) + (', labelTextColor=' + Kotlin.toString(this.labelTextColor)) + (', afterLabel=' + Kotlin.toString(this.afterLabel)) + (', afterBody=' + Kotlin.toString(this.afterBody)) + (', beforeFooter=' + Kotlin.toString(this.beforeFooter)) + (', footer=' + Kotlin.toString(this.footer)) + (', afterFooter=' + Kotlin.toString(this.afterFooter)) + ')';
  };
  TooltipCallback.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.beforeTitle) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.afterTitle) | 0;
    result = result * 31 + Kotlin.hashCode(this.beforeBody) | 0;
    result = result * 31 + Kotlin.hashCode(this.beforeLabel) | 0;
    result = result * 31 + Kotlin.hashCode(this.label) | 0;
    result = result * 31 + Kotlin.hashCode(this.labelColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.labelTextColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.afterLabel) | 0;
    result = result * 31 + Kotlin.hashCode(this.afterBody) | 0;
    result = result * 31 + Kotlin.hashCode(this.beforeFooter) | 0;
    result = result * 31 + Kotlin.hashCode(this.footer) | 0;
    result = result * 31 + Kotlin.hashCode(this.afterFooter) | 0;
    return result;
  };
  TooltipCallback.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.beforeTitle, other.beforeTitle) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.afterTitle, other.afterTitle) && Kotlin.equals(this.beforeBody, other.beforeBody) && Kotlin.equals(this.beforeLabel, other.beforeLabel) && Kotlin.equals(this.label, other.label) && Kotlin.equals(this.labelColor, other.labelColor) && Kotlin.equals(this.labelTextColor, other.labelTextColor) && Kotlin.equals(this.afterLabel, other.afterLabel) && Kotlin.equals(this.afterBody, other.afterBody) && Kotlin.equals(this.beforeFooter, other.beforeFooter) && Kotlin.equals(this.footer, other.footer) && Kotlin.equals(this.afterFooter, other.afterFooter)))));
  };
  function toJs_8($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.beforeTitle != null)
      $receiver_0.beforeTitle = $receiver.beforeTitle;
    if ($receiver.title != null)
      $receiver_0.title = $receiver.title;
    if ($receiver.afterTitle != null)
      $receiver_0.afterTitle = $receiver.afterTitle;
    if ($receiver.beforeBody != null)
      $receiver_0.beforeBody = $receiver.beforeBody;
    if ($receiver.beforeLabel != null)
      $receiver_0.beforeLabel = $receiver.beforeLabel;
    if ($receiver.label != null)
      $receiver_0.label = $receiver.label;
    if ($receiver.labelColor != null)
      $receiver_0.labelColor = $receiver.labelColor;
    if ($receiver.labelTextColor != null)
      $receiver_0.labelTextColor = $receiver.labelTextColor;
    if ($receiver.afterLabel != null)
      $receiver_0.afterLabel = $receiver.afterLabel;
    if ($receiver.afterBody != null)
      $receiver_0.afterBody = $receiver.afterBody;
    if ($receiver.beforeFooter != null)
      $receiver_0.beforeFooter = $receiver.beforeFooter;
    if ($receiver.footer != null)
      $receiver_0.footer = $receiver.footer;
    if ($receiver.afterFooter != null)
      $receiver_0.afterFooter = $receiver.afterFooter;
    return $receiver_0;
  }
  function TooltipOptions(enabled, external, mode, intersect, position, callbacks, filter, itemSort, backgroundColor, titleColor, titleFont, titleAlign, titleSpacing, titleMarginBottom, bodyColor, bodyFont, bodyAlign, bodySpacing, footerColor, footerFont, footerAlign, footerSpacing, footerMarginTop, padding, caretPadding, caretSize, cornerRadius, multiKeyBackground, displayColors, boxWidth, boxHeight, boxPadding, usePointStyle, borderColor, borderWidth, rtl, textDirection, xAlign, yAlign) {
    if (enabled === void 0)
      enabled = true;
    if (external === void 0)
      external = null;
    if (mode === void 0)
      mode = null;
    if (intersect === void 0)
      intersect = null;
    if (position === void 0)
      position = null;
    if (callbacks === void 0)
      callbacks = null;
    if (filter === void 0)
      filter = null;
    if (itemSort === void 0)
      itemSort = null;
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (titleColor === void 0)
      titleColor = null;
    if (titleFont === void 0)
      titleFont = null;
    if (titleAlign === void 0)
      titleAlign = null;
    if (titleSpacing === void 0)
      titleSpacing = null;
    if (titleMarginBottom === void 0)
      titleMarginBottom = null;
    if (bodyColor === void 0)
      bodyColor = null;
    if (bodyFont === void 0)
      bodyFont = null;
    if (bodyAlign === void 0)
      bodyAlign = null;
    if (bodySpacing === void 0)
      bodySpacing = null;
    if (footerColor === void 0)
      footerColor = null;
    if (footerFont === void 0)
      footerFont = null;
    if (footerAlign === void 0)
      footerAlign = null;
    if (footerSpacing === void 0)
      footerSpacing = null;
    if (footerMarginTop === void 0)
      footerMarginTop = null;
    if (padding === void 0)
      padding = null;
    if (caretPadding === void 0)
      caretPadding = null;
    if (caretSize === void 0)
      caretSize = null;
    if (cornerRadius === void 0)
      cornerRadius = null;
    if (multiKeyBackground === void 0)
      multiKeyBackground = null;
    if (displayColors === void 0)
      displayColors = null;
    if (boxWidth === void 0)
      boxWidth = null;
    if (boxHeight === void 0)
      boxHeight = null;
    if (boxPadding === void 0)
      boxPadding = null;
    if (usePointStyle === void 0)
      usePointStyle = null;
    if (borderColor === void 0)
      borderColor = null;
    if (borderWidth === void 0)
      borderWidth = null;
    if (rtl === void 0)
      rtl = null;
    if (textDirection === void 0)
      textDirection = null;
    if (xAlign === void 0)
      xAlign = null;
    if (yAlign === void 0)
      yAlign = null;
    this.enabled = enabled;
    this.external = external;
    this.mode = mode;
    this.intersect = intersect;
    this.position = position;
    this.callbacks = callbacks;
    this.filter = filter;
    this.itemSort = itemSort;
    this.backgroundColor = backgroundColor;
    this.titleColor = titleColor;
    this.titleFont = titleFont;
    this.titleAlign = titleAlign;
    this.titleSpacing = titleSpacing;
    this.titleMarginBottom = titleMarginBottom;
    this.bodyColor = bodyColor;
    this.bodyFont = bodyFont;
    this.bodyAlign = bodyAlign;
    this.bodySpacing = bodySpacing;
    this.footerColor = footerColor;
    this.footerFont = footerFont;
    this.footerAlign = footerAlign;
    this.footerSpacing = footerSpacing;
    this.footerMarginTop = footerMarginTop;
    this.padding = padding;
    this.caretPadding = caretPadding;
    this.caretSize = caretSize;
    this.cornerRadius = cornerRadius;
    this.multiKeyBackground = multiKeyBackground;
    this.displayColors = displayColors;
    this.boxWidth = boxWidth;
    this.boxHeight = boxHeight;
    this.boxPadding = boxPadding;
    this.usePointStyle = usePointStyle;
    this.borderColor = borderColor;
    this.borderWidth = borderWidth;
    this.rtl = rtl;
    this.textDirection = textDirection;
    this.xAlign = xAlign;
    this.yAlign = yAlign;
  }
  TooltipOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TooltipOptions',
    interfaces: []
  };
  TooltipOptions.prototype.component1 = function () {
    return this.enabled;
  };
  TooltipOptions.prototype.component2 = function () {
    return this.external;
  };
  TooltipOptions.prototype.component3 = function () {
    return this.mode;
  };
  TooltipOptions.prototype.component4 = function () {
    return this.intersect;
  };
  TooltipOptions.prototype.component5 = function () {
    return this.position;
  };
  TooltipOptions.prototype.component6 = function () {
    return this.callbacks;
  };
  TooltipOptions.prototype.component7 = function () {
    return this.filter;
  };
  TooltipOptions.prototype.component8 = function () {
    return this.itemSort;
  };
  TooltipOptions.prototype.component9 = function () {
    return this.backgroundColor;
  };
  TooltipOptions.prototype.component10 = function () {
    return this.titleColor;
  };
  TooltipOptions.prototype.component11 = function () {
    return this.titleFont;
  };
  TooltipOptions.prototype.component12 = function () {
    return this.titleAlign;
  };
  TooltipOptions.prototype.component13 = function () {
    return this.titleSpacing;
  };
  TooltipOptions.prototype.component14 = function () {
    return this.titleMarginBottom;
  };
  TooltipOptions.prototype.component15 = function () {
    return this.bodyColor;
  };
  TooltipOptions.prototype.component16 = function () {
    return this.bodyFont;
  };
  TooltipOptions.prototype.component17 = function () {
    return this.bodyAlign;
  };
  TooltipOptions.prototype.component18 = function () {
    return this.bodySpacing;
  };
  TooltipOptions.prototype.component19 = function () {
    return this.footerColor;
  };
  TooltipOptions.prototype.component20 = function () {
    return this.footerFont;
  };
  TooltipOptions.prototype.component21 = function () {
    return this.footerAlign;
  };
  TooltipOptions.prototype.component22 = function () {
    return this.footerSpacing;
  };
  TooltipOptions.prototype.component23 = function () {
    return this.footerMarginTop;
  };
  TooltipOptions.prototype.component24 = function () {
    return this.padding;
  };
  TooltipOptions.prototype.component25 = function () {
    return this.caretPadding;
  };
  TooltipOptions.prototype.component26 = function () {
    return this.caretSize;
  };
  TooltipOptions.prototype.component27 = function () {
    return this.cornerRadius;
  };
  TooltipOptions.prototype.component28 = function () {
    return this.multiKeyBackground;
  };
  TooltipOptions.prototype.component29 = function () {
    return this.displayColors;
  };
  TooltipOptions.prototype.component30 = function () {
    return this.boxWidth;
  };
  TooltipOptions.prototype.component31 = function () {
    return this.boxHeight;
  };
  TooltipOptions.prototype.component32 = function () {
    return this.boxPadding;
  };
  TooltipOptions.prototype.component33 = function () {
    return this.usePointStyle;
  };
  TooltipOptions.prototype.component34 = function () {
    return this.borderColor;
  };
  TooltipOptions.prototype.component35 = function () {
    return this.borderWidth;
  };
  TooltipOptions.prototype.component36 = function () {
    return this.rtl;
  };
  TooltipOptions.prototype.component37 = function () {
    return this.textDirection;
  };
  TooltipOptions.prototype.component38 = function () {
    return this.xAlign;
  };
  TooltipOptions.prototype.component39 = function () {
    return this.yAlign;
  };
  TooltipOptions.prototype.copy_dwna98$ = function (enabled, external, mode, intersect, position, callbacks, filter, itemSort, backgroundColor, titleColor, titleFont, titleAlign, titleSpacing, titleMarginBottom, bodyColor, bodyFont, bodyAlign, bodySpacing, footerColor, footerFont, footerAlign, footerSpacing, footerMarginTop, padding, caretPadding, caretSize, cornerRadius, multiKeyBackground, displayColors, boxWidth, boxHeight, boxPadding, usePointStyle, borderColor, borderWidth, rtl, textDirection, xAlign, yAlign) {
    return new TooltipOptions(enabled === void 0 ? this.enabled : enabled, external === void 0 ? this.external : external, mode === void 0 ? this.mode : mode, intersect === void 0 ? this.intersect : intersect, position === void 0 ? this.position : position, callbacks === void 0 ? this.callbacks : callbacks, filter === void 0 ? this.filter : filter, itemSort === void 0 ? this.itemSort : itemSort, backgroundColor === void 0 ? this.backgroundColor : backgroundColor, titleColor === void 0 ? this.titleColor : titleColor, titleFont === void 0 ? this.titleFont : titleFont, titleAlign === void 0 ? this.titleAlign : titleAlign, titleSpacing === void 0 ? this.titleSpacing : titleSpacing, titleMarginBottom === void 0 ? this.titleMarginBottom : titleMarginBottom, bodyColor === void 0 ? this.bodyColor : bodyColor, bodyFont === void 0 ? this.bodyFont : bodyFont, bodyAlign === void 0 ? this.bodyAlign : bodyAlign, bodySpacing === void 0 ? this.bodySpacing : bodySpacing, footerColor === void 0 ? this.footerColor : footerColor, footerFont === void 0 ? this.footerFont : footerFont, footerAlign === void 0 ? this.footerAlign : footerAlign, footerSpacing === void 0 ? this.footerSpacing : footerSpacing, footerMarginTop === void 0 ? this.footerMarginTop : footerMarginTop, padding === void 0 ? this.padding : padding, caretPadding === void 0 ? this.caretPadding : caretPadding, caretSize === void 0 ? this.caretSize : caretSize, cornerRadius === void 0 ? this.cornerRadius : cornerRadius, multiKeyBackground === void 0 ? this.multiKeyBackground : multiKeyBackground, displayColors === void 0 ? this.displayColors : displayColors, boxWidth === void 0 ? this.boxWidth : boxWidth, boxHeight === void 0 ? this.boxHeight : boxHeight, boxPadding === void 0 ? this.boxPadding : boxPadding, usePointStyle === void 0 ? this.usePointStyle : usePointStyle, borderColor === void 0 ? this.borderColor : borderColor, borderWidth === void 0 ? this.borderWidth : borderWidth, rtl === void 0 ? this.rtl : rtl, textDirection === void 0 ? this.textDirection : textDirection, xAlign === void 0 ? this.xAlign : xAlign, yAlign === void 0 ? this.yAlign : yAlign);
  };
  TooltipOptions.prototype.toString = function () {
    return 'TooltipOptions(enabled=' + Kotlin.toString(this.enabled) + (', external=' + Kotlin.toString(this.external)) + (', mode=' + Kotlin.toString(this.mode)) + (', intersect=' + Kotlin.toString(this.intersect)) + (', position=' + Kotlin.toString(this.position)) + (', callbacks=' + Kotlin.toString(this.callbacks)) + (', filter=' + Kotlin.toString(this.filter)) + (', itemSort=' + Kotlin.toString(this.itemSort)) + (', backgroundColor=' + Kotlin.toString(this.backgroundColor)) + (', titleColor=' + Kotlin.toString(this.titleColor)) + (', titleFont=' + Kotlin.toString(this.titleFont)) + (', titleAlign=' + Kotlin.toString(this.titleAlign)) + (', titleSpacing=' + Kotlin.toString(this.titleSpacing)) + (', titleMarginBottom=' + Kotlin.toString(this.titleMarginBottom)) + (', bodyColor=' + Kotlin.toString(this.bodyColor)) + (', bodyFont=' + Kotlin.toString(this.bodyFont)) + (', bodyAlign=' + Kotlin.toString(this.bodyAlign)) + (', bodySpacing=' + Kotlin.toString(this.bodySpacing)) + (', footerColor=' + Kotlin.toString(this.footerColor)) + (', footerFont=' + Kotlin.toString(this.footerFont)) + (', footerAlign=' + Kotlin.toString(this.footerAlign)) + (', footerSpacing=' + Kotlin.toString(this.footerSpacing)) + (', footerMarginTop=' + Kotlin.toString(this.footerMarginTop)) + (', padding=' + Kotlin.toString(this.padding)) + (', caretPadding=' + Kotlin.toString(this.caretPadding)) + (', caretSize=' + Kotlin.toString(this.caretSize)) + (', cornerRadius=' + Kotlin.toString(this.cornerRadius)) + (', multiKeyBackground=' + Kotlin.toString(this.multiKeyBackground)) + (', displayColors=' + Kotlin.toString(this.displayColors)) + (', boxWidth=' + Kotlin.toString(this.boxWidth)) + (', boxHeight=' + Kotlin.toString(this.boxHeight)) + (', boxPadding=' + Kotlin.toString(this.boxPadding)) + (', usePointStyle=' + Kotlin.toString(this.usePointStyle)) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', rtl=' + Kotlin.toString(this.rtl)) + (', textDirection=' + Kotlin.toString(this.textDirection)) + (', xAlign=' + Kotlin.toString(this.xAlign)) + (', yAlign=' + Kotlin.toString(this.yAlign)) + ')';
  };
  TooltipOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.enabled) | 0;
    result = result * 31 + Kotlin.hashCode(this.external) | 0;
    result = result * 31 + Kotlin.hashCode(this.mode) | 0;
    result = result * 31 + Kotlin.hashCode(this.intersect) | 0;
    result = result * 31 + Kotlin.hashCode(this.position) | 0;
    result = result * 31 + Kotlin.hashCode(this.callbacks) | 0;
    result = result * 31 + Kotlin.hashCode(this.filter) | 0;
    result = result * 31 + Kotlin.hashCode(this.itemSort) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.titleColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.titleFont) | 0;
    result = result * 31 + Kotlin.hashCode(this.titleAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.titleSpacing) | 0;
    result = result * 31 + Kotlin.hashCode(this.titleMarginBottom) | 0;
    result = result * 31 + Kotlin.hashCode(this.bodyColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.bodyFont) | 0;
    result = result * 31 + Kotlin.hashCode(this.bodyAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.bodySpacing) | 0;
    result = result * 31 + Kotlin.hashCode(this.footerColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.footerFont) | 0;
    result = result * 31 + Kotlin.hashCode(this.footerAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.footerSpacing) | 0;
    result = result * 31 + Kotlin.hashCode(this.footerMarginTop) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    result = result * 31 + Kotlin.hashCode(this.caretPadding) | 0;
    result = result * 31 + Kotlin.hashCode(this.caretSize) | 0;
    result = result * 31 + Kotlin.hashCode(this.cornerRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.multiKeyBackground) | 0;
    result = result * 31 + Kotlin.hashCode(this.displayColors) | 0;
    result = result * 31 + Kotlin.hashCode(this.boxWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.boxHeight) | 0;
    result = result * 31 + Kotlin.hashCode(this.boxPadding) | 0;
    result = result * 31 + Kotlin.hashCode(this.usePointStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.rtl) | 0;
    result = result * 31 + Kotlin.hashCode(this.textDirection) | 0;
    result = result * 31 + Kotlin.hashCode(this.xAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.yAlign) | 0;
    return result;
  };
  TooltipOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.enabled, other.enabled) && Kotlin.equals(this.external, other.external) && Kotlin.equals(this.mode, other.mode) && Kotlin.equals(this.intersect, other.intersect) && Kotlin.equals(this.position, other.position) && Kotlin.equals(this.callbacks, other.callbacks) && Kotlin.equals(this.filter, other.filter) && Kotlin.equals(this.itemSort, other.itemSort) && Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.titleColor, other.titleColor) && Kotlin.equals(this.titleFont, other.titleFont) && Kotlin.equals(this.titleAlign, other.titleAlign) && Kotlin.equals(this.titleSpacing, other.titleSpacing) && Kotlin.equals(this.titleMarginBottom, other.titleMarginBottom) && Kotlin.equals(this.bodyColor, other.bodyColor) && Kotlin.equals(this.bodyFont, other.bodyFont) && Kotlin.equals(this.bodyAlign, other.bodyAlign) && Kotlin.equals(this.bodySpacing, other.bodySpacing) && Kotlin.equals(this.footerColor, other.footerColor) && Kotlin.equals(this.footerFont, other.footerFont) && Kotlin.equals(this.footerAlign, other.footerAlign) && Kotlin.equals(this.footerSpacing, other.footerSpacing) && Kotlin.equals(this.footerMarginTop, other.footerMarginTop) && Kotlin.equals(this.padding, other.padding) && Kotlin.equals(this.caretPadding, other.caretPadding) && Kotlin.equals(this.caretSize, other.caretSize) && Kotlin.equals(this.cornerRadius, other.cornerRadius) && Kotlin.equals(this.multiKeyBackground, other.multiKeyBackground) && Kotlin.equals(this.displayColors, other.displayColors) && Kotlin.equals(this.boxWidth, other.boxWidth) && Kotlin.equals(this.boxHeight, other.boxHeight) && Kotlin.equals(this.boxPadding, other.boxPadding) && Kotlin.equals(this.usePointStyle, other.usePointStyle) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.rtl, other.rtl) && Kotlin.equals(this.textDirection, other.textDirection) && Kotlin.equals(this.xAlign, other.xAlign) && Kotlin.equals(this.yAlign, other.yAlign)))));
  };
  function toJs_9($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.enabled = $receiver.enabled;
    if ($receiver.external != null)
      $receiver_0.external = $receiver.external;
    if ($receiver.mode != null)
      $receiver_0.mode = $receiver.mode.mode_8be2vx$;
    if ($receiver.intersect != null)
      $receiver_0.intersect = $receiver.intersect;
    if ($receiver.position != null)
      $receiver_0.position = $receiver.position.mode_8be2vx$;
    if ($receiver.callbacks != null)
      $receiver_0.callbacks = toJs_8($receiver.callbacks);
    if ($receiver.filter != null)
      $receiver_0.filter = $receiver.filter;
    if ($receiver.itemSort != null)
      $receiver_0.itemSort = $receiver.itemSort;
    if ($receiver.backgroundColor != null)
      $receiver_0.backgroundColor = $receiver.backgroundColor.asString();
    if ($receiver.titleColor != null)
      $receiver_0.titleColor = $receiver.titleColor.asString();
    if ($receiver.titleFont != null)
      $receiver_0.titleFont = toJs($receiver.titleFont);
    if ($receiver.titleAlign != null)
      $receiver_0.titleAlign = $receiver.titleAlign.mode_8be2vx$;
    if ($receiver.titleSpacing != null)
      $receiver_0.titleSpacing = $receiver.titleSpacing;
    if ($receiver.titleMarginBottom != null)
      $receiver_0.titleMarginBottom = $receiver.titleMarginBottom;
    if ($receiver.bodyColor != null)
      $receiver_0.bodyColor = $receiver.bodyColor.asString();
    if ($receiver.bodyFont != null)
      $receiver_0.bodyFont = toJs($receiver.bodyFont);
    if ($receiver.bodyAlign != null)
      $receiver_0.bodyAlign = $receiver.bodyAlign.mode_8be2vx$;
    if ($receiver.bodySpacing != null)
      $receiver_0.bodySpacing = $receiver.bodySpacing;
    if ($receiver.footerColor != null)
      $receiver_0.footerColor = $receiver.footerColor.asString();
    if ($receiver.footerFont != null)
      $receiver_0.footerFont = toJs($receiver.footerFont);
    if ($receiver.footerAlign != null)
      $receiver_0.footerAlign = $receiver.footerAlign.mode_8be2vx$;
    if ($receiver.footerSpacing != null)
      $receiver_0.footerSpacing = $receiver.footerSpacing;
    if ($receiver.footerMarginTop != null)
      $receiver_0.footerMarginTop = $receiver.footerMarginTop;
    if ($receiver.padding != null)
      $receiver_0.padding = toJs_2($receiver.padding);
    if ($receiver.caretPadding != null)
      $receiver_0.caretPadding = $receiver.caretPadding;
    if ($receiver.caretSize != null)
      $receiver_0.caretSize = $receiver.caretSize;
    if ($receiver.cornerRadius != null)
      $receiver_0.cornerRadius = $receiver.cornerRadius;
    if ($receiver.multiKeyBackground != null)
      $receiver_0.multiKeyBackground = $receiver.multiKeyBackground.asString();
    if ($receiver.displayColors != null)
      $receiver_0.displayColors = $receiver.displayColors;
    if ($receiver.boxWidth != null)
      $receiver_0.boxWidth = $receiver.boxWidth;
    if ($receiver.boxHeight != null)
      $receiver_0.boxHeight = $receiver.boxHeight;
    if ($receiver.boxPadding != null)
      $receiver_0.boxPadding = $receiver.boxPadding;
    if ($receiver.usePointStyle != null)
      $receiver_0.usePointStyle = $receiver.usePointStyle;
    if ($receiver.borderColor != null)
      $receiver_0.borderColor = $receiver.borderColor.asString();
    if ($receiver.borderWidth != null)
      $receiver_0.borderWidth = $receiver.borderWidth;
    if ($receiver.rtl != null)
      $receiver_0.rtl = $receiver.rtl;
    if ($receiver.textDirection != null)
      $receiver_0.textDirection = $receiver.textDirection.mode_8be2vx$;
    if ($receiver.xAlign != null)
      $receiver_0.xAlign = $receiver.xAlign;
    if ($receiver.yAlign != null)
      $receiver_0.yAlign = $receiver.yAlign;
    return $receiver_0;
  }
  function PointOptions(radius, pointStyle, backgroundColor, borderWidth, borderColor, hitRadius, hoverRadius, hoverBorderWidth) {
    if (radius === void 0)
      radius = 3;
    if (pointStyle === void 0)
      pointStyle = PointStyle$CIRCLE_getInstance();
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (borderWidth === void 0)
      borderWidth = 1;
    if (borderColor === void 0)
      borderColor = null;
    if (hitRadius === void 0)
      hitRadius = 1;
    if (hoverRadius === void 0)
      hoverRadius = 4;
    if (hoverBorderWidth === void 0)
      hoverBorderWidth = 1;
    this.radius = radius;
    this.pointStyle = pointStyle;
    this.backgroundColor = backgroundColor;
    this.borderWidth = borderWidth;
    this.borderColor = borderColor;
    this.hitRadius = hitRadius;
    this.hoverRadius = hoverRadius;
    this.hoverBorderWidth = hoverBorderWidth;
  }
  PointOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PointOptions',
    interfaces: []
  };
  PointOptions.prototype.component1 = function () {
    return this.radius;
  };
  PointOptions.prototype.component2 = function () {
    return this.pointStyle;
  };
  PointOptions.prototype.component3 = function () {
    return this.backgroundColor;
  };
  PointOptions.prototype.component4 = function () {
    return this.borderWidth;
  };
  PointOptions.prototype.component5 = function () {
    return this.borderColor;
  };
  PointOptions.prototype.component6 = function () {
    return this.hitRadius;
  };
  PointOptions.prototype.component7 = function () {
    return this.hoverRadius;
  };
  PointOptions.prototype.component8 = function () {
    return this.hoverBorderWidth;
  };
  PointOptions.prototype.copy_mvqjky$ = function (radius, pointStyle, backgroundColor, borderWidth, borderColor, hitRadius, hoverRadius, hoverBorderWidth) {
    return new PointOptions(radius === void 0 ? this.radius : radius, pointStyle === void 0 ? this.pointStyle : pointStyle, backgroundColor === void 0 ? this.backgroundColor : backgroundColor, borderWidth === void 0 ? this.borderWidth : borderWidth, borderColor === void 0 ? this.borderColor : borderColor, hitRadius === void 0 ? this.hitRadius : hitRadius, hoverRadius === void 0 ? this.hoverRadius : hoverRadius, hoverBorderWidth === void 0 ? this.hoverBorderWidth : hoverBorderWidth);
  };
  PointOptions.prototype.toString = function () {
    return 'PointOptions(radius=' + Kotlin.toString(this.radius) + (', pointStyle=' + Kotlin.toString(this.pointStyle)) + (', backgroundColor=' + Kotlin.toString(this.backgroundColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', hitRadius=' + Kotlin.toString(this.hitRadius)) + (', hoverRadius=' + Kotlin.toString(this.hoverRadius)) + (', hoverBorderWidth=' + Kotlin.toString(this.hoverBorderWidth)) + ')';
  };
  PointOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.radius) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.hitRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderWidth) | 0;
    return result;
  };
  PointOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.radius, other.radius) && Kotlin.equals(this.pointStyle, other.pointStyle) && Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.hitRadius, other.hitRadius) && Kotlin.equals(this.hoverRadius, other.hoverRadius) && Kotlin.equals(this.hoverBorderWidth, other.hoverBorderWidth)))));
  };
  function toJs_10($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.radius = $receiver.radius;
    $receiver_0.pointStyle = $receiver.pointStyle.style_8be2vx$;
    if ($receiver.backgroundColor != null)
      $receiver_0.backgroundColor = $receiver.backgroundColor.asString();
    $receiver_0.borderWidth = $receiver.borderWidth;
    if ($receiver.borderColor != null)
      $receiver_0.borderColor = $receiver.borderColor.asString();
    $receiver_0.hitRadius = $receiver.hitRadius;
    $receiver_0.hoverRadius = $receiver.hoverRadius;
    $receiver_0.hoverBorderWidth = $receiver.hoverBorderWidth;
    return $receiver_0;
  }
  function LineOptions(cubicInterpolationMode, tension, backgroundColor, borderWidth, borderColor, borderCapStyle, borderDash, borderDashOffset, borderJoinStyle, capBezierPoints, fill, stepped) {
    if (cubicInterpolationMode === void 0)
      cubicInterpolationMode = InterpolationMode$DEFAULT_getInstance();
    if (tension === void 0)
      tension = null;
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (borderWidth === void 0)
      borderWidth = null;
    if (borderColor === void 0)
      borderColor = null;
    if (borderCapStyle === void 0)
      borderCapStyle = null;
    if (borderDash === void 0)
      borderDash = null;
    if (borderDashOffset === void 0)
      borderDashOffset = null;
    if (borderJoinStyle === void 0)
      borderJoinStyle = null;
    if (capBezierPoints === void 0)
      capBezierPoints = null;
    if (fill === void 0)
      fill = null;
    if (stepped === void 0)
      stepped = null;
    this.cubicInterpolationMode = cubicInterpolationMode;
    this.tension = tension;
    this.backgroundColor = backgroundColor;
    this.borderWidth = borderWidth;
    this.borderColor = borderColor;
    this.borderCapStyle = borderCapStyle;
    this.borderDash = borderDash;
    this.borderDashOffset = borderDashOffset;
    this.borderJoinStyle = borderJoinStyle;
    this.capBezierPoints = capBezierPoints;
    this.fill = fill;
    this.stepped = stepped;
  }
  LineOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LineOptions',
    interfaces: []
  };
  LineOptions.prototype.component1 = function () {
    return this.cubicInterpolationMode;
  };
  LineOptions.prototype.component2 = function () {
    return this.tension;
  };
  LineOptions.prototype.component3 = function () {
    return this.backgroundColor;
  };
  LineOptions.prototype.component4 = function () {
    return this.borderWidth;
  };
  LineOptions.prototype.component5 = function () {
    return this.borderColor;
  };
  LineOptions.prototype.component6 = function () {
    return this.borderCapStyle;
  };
  LineOptions.prototype.component7 = function () {
    return this.borderDash;
  };
  LineOptions.prototype.component8 = function () {
    return this.borderDashOffset;
  };
  LineOptions.prototype.component9 = function () {
    return this.borderJoinStyle;
  };
  LineOptions.prototype.component10 = function () {
    return this.capBezierPoints;
  };
  LineOptions.prototype.component11 = function () {
    return this.fill;
  };
  LineOptions.prototype.component12 = function () {
    return this.stepped;
  };
  LineOptions.prototype.copy_ch2mis$ = function (cubicInterpolationMode, tension, backgroundColor, borderWidth, borderColor, borderCapStyle, borderDash, borderDashOffset, borderJoinStyle, capBezierPoints, fill, stepped) {
    return new LineOptions(cubicInterpolationMode === void 0 ? this.cubicInterpolationMode : cubicInterpolationMode, tension === void 0 ? this.tension : tension, backgroundColor === void 0 ? this.backgroundColor : backgroundColor, borderWidth === void 0 ? this.borderWidth : borderWidth, borderColor === void 0 ? this.borderColor : borderColor, borderCapStyle === void 0 ? this.borderCapStyle : borderCapStyle, borderDash === void 0 ? this.borderDash : borderDash, borderDashOffset === void 0 ? this.borderDashOffset : borderDashOffset, borderJoinStyle === void 0 ? this.borderJoinStyle : borderJoinStyle, capBezierPoints === void 0 ? this.capBezierPoints : capBezierPoints, fill === void 0 ? this.fill : fill, stepped === void 0 ? this.stepped : stepped);
  };
  LineOptions.prototype.toString = function () {
    return 'LineOptions(cubicInterpolationMode=' + Kotlin.toString(this.cubicInterpolationMode) + (', tension=' + Kotlin.toString(this.tension)) + (', backgroundColor=' + Kotlin.toString(this.backgroundColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', borderCapStyle=' + Kotlin.toString(this.borderCapStyle)) + (', borderDash=' + Kotlin.toString(this.borderDash)) + (', borderDashOffset=' + Kotlin.toString(this.borderDashOffset)) + (', borderJoinStyle=' + Kotlin.toString(this.borderJoinStyle)) + (', capBezierPoints=' + Kotlin.toString(this.capBezierPoints)) + (', fill=' + Kotlin.toString(this.fill)) + (', stepped=' + Kotlin.toString(this.stepped)) + ')';
  };
  LineOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.cubicInterpolationMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.tension) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderCapStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderDash) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderDashOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderJoinStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.capBezierPoints) | 0;
    result = result * 31 + Kotlin.hashCode(this.fill) | 0;
    result = result * 31 + Kotlin.hashCode(this.stepped) | 0;
    return result;
  };
  LineOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.cubicInterpolationMode, other.cubicInterpolationMode) && Kotlin.equals(this.tension, other.tension) && Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.borderCapStyle, other.borderCapStyle) && Kotlin.equals(this.borderDash, other.borderDash) && Kotlin.equals(this.borderDashOffset, other.borderDashOffset) && Kotlin.equals(this.borderJoinStyle, other.borderJoinStyle) && Kotlin.equals(this.capBezierPoints, other.capBezierPoints) && Kotlin.equals(this.fill, other.fill) && Kotlin.equals(this.stepped, other.stepped)))));
  };
  function toJs_11($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.cubicInterpolationMode = $receiver.cubicInterpolationMode.mode_8be2vx$;
    if ($receiver.tension != null)
      $receiver_0.tension = $receiver.tension;
    if ($receiver.backgroundColor != null)
      $receiver_0.backgroundColor = $receiver.backgroundColor.asString();
    if ($receiver.borderWidth != null)
      $receiver_0.borderWidth = $receiver.borderWidth;
    if ($receiver.borderColor != null)
      $receiver_0.borderColor = $receiver.borderColor.asString();
    if ($receiver.borderCapStyle != null)
      $receiver_0.borderCapStyle = $receiver.borderCapStyle.mode_8be2vx$;
    if ($receiver.borderDash != null) {
      $receiver_0.borderDash = copyToArray($receiver.borderDash);
    }
    if ($receiver.borderDashOffset != null)
      $receiver_0.borderDashOffset = $receiver.borderDashOffset;
    if ($receiver.borderJoinStyle != null)
      $receiver_0.borderJoinStyle = $receiver.borderJoinStyle.mode_8be2vx$;
    if ($receiver.capBezierPoints != null)
      $receiver_0.capBezierPoints = $receiver.capBezierPoints;
    if ($receiver.fill != null)
      $receiver_0.fill = $receiver.fill;
    if ($receiver.stepped != null)
      $receiver_0.stepped = $receiver.stepped;
    return $receiver_0;
  }
  function ArcOptions(angle, backgroundColor, borderAlign, borderColor, borderWidth, borderJoinStyle) {
    if (angle === void 0)
      angle = null;
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (borderAlign === void 0)
      borderAlign = null;
    if (borderColor === void 0)
      borderColor = null;
    if (borderWidth === void 0)
      borderWidth = null;
    if (borderJoinStyle === void 0)
      borderJoinStyle = null;
    this.angle = angle;
    this.backgroundColor = backgroundColor;
    this.borderAlign = borderAlign;
    this.borderColor = borderColor;
    this.borderWidth = borderWidth;
    this.borderJoinStyle = borderJoinStyle;
  }
  ArcOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ArcOptions',
    interfaces: []
  };
  ArcOptions.prototype.component1 = function () {
    return this.angle;
  };
  ArcOptions.prototype.component2 = function () {
    return this.backgroundColor;
  };
  ArcOptions.prototype.component3 = function () {
    return this.borderAlign;
  };
  ArcOptions.prototype.component4 = function () {
    return this.borderColor;
  };
  ArcOptions.prototype.component5 = function () {
    return this.borderWidth;
  };
  ArcOptions.prototype.component6 = function () {
    return this.borderJoinStyle;
  };
  ArcOptions.prototype.copy_35qzaj$ = function (angle, backgroundColor, borderAlign, borderColor, borderWidth, borderJoinStyle) {
    return new ArcOptions(angle === void 0 ? this.angle : angle, backgroundColor === void 0 ? this.backgroundColor : backgroundColor, borderAlign === void 0 ? this.borderAlign : borderAlign, borderColor === void 0 ? this.borderColor : borderColor, borderWidth === void 0 ? this.borderWidth : borderWidth, borderJoinStyle === void 0 ? this.borderJoinStyle : borderJoinStyle);
  };
  ArcOptions.prototype.toString = function () {
    return 'ArcOptions(angle=' + Kotlin.toString(this.angle) + (', backgroundColor=' + Kotlin.toString(this.backgroundColor)) + (', borderAlign=' + Kotlin.toString(this.borderAlign)) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', borderJoinStyle=' + Kotlin.toString(this.borderJoinStyle)) + ')';
  };
  ArcOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.angle) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderJoinStyle) | 0;
    return result;
  };
  ArcOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.angle, other.angle) && Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.borderAlign, other.borderAlign) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.borderJoinStyle, other.borderJoinStyle)))));
  };
  function toJs_12($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.angle != null)
      $receiver_0.angle = $receiver.angle;
    if ($receiver.backgroundColor != null)
      $receiver_0.backgroundColor = $receiver.backgroundColor.asString();
    if ($receiver.borderAlign != null)
      $receiver_0.borderAlign = $receiver.borderAlign.mode_8be2vx$;
    if ($receiver.borderColor != null)
      $receiver_0.borderColor = $receiver.borderColor.asString();
    if ($receiver.borderWidth != null)
      $receiver_0.borderWidth = $receiver.borderWidth;
    if ($receiver.borderJoinStyle != null)
      $receiver_0.borderJoinStyle = $receiver.borderJoinStyle.mode_8be2vx$;
    return $receiver_0;
  }
  function BarOptions(backgroundColor, borderColor, borderWidth, borderSkipped, borderRadius, inflateAmount, pointStyle) {
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (borderColor === void 0)
      borderColor = null;
    if (borderWidth === void 0)
      borderWidth = null;
    if (borderSkipped === void 0)
      borderSkipped = null;
    if (borderRadius === void 0)
      borderRadius = null;
    if (inflateAmount === void 0)
      inflateAmount = null;
    if (pointStyle === void 0)
      pointStyle = null;
    this.backgroundColor = backgroundColor;
    this.borderColor = borderColor;
    this.borderWidth = borderWidth;
    this.borderSkipped = borderSkipped;
    this.borderRadius = borderRadius;
    this.inflateAmount = inflateAmount;
    this.pointStyle = pointStyle;
  }
  BarOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BarOptions',
    interfaces: []
  };
  BarOptions.prototype.component1 = function () {
    return this.backgroundColor;
  };
  BarOptions.prototype.component2 = function () {
    return this.borderColor;
  };
  BarOptions.prototype.component3 = function () {
    return this.borderWidth;
  };
  BarOptions.prototype.component4 = function () {
    return this.borderSkipped;
  };
  BarOptions.prototype.component5 = function () {
    return this.borderRadius;
  };
  BarOptions.prototype.component6 = function () {
    return this.inflateAmount;
  };
  BarOptions.prototype.component7 = function () {
    return this.pointStyle;
  };
  BarOptions.prototype.copy_hg2k0y$ = function (backgroundColor, borderColor, borderWidth, borderSkipped, borderRadius, inflateAmount, pointStyle) {
    return new BarOptions(backgroundColor === void 0 ? this.backgroundColor : backgroundColor, borderColor === void 0 ? this.borderColor : borderColor, borderWidth === void 0 ? this.borderWidth : borderWidth, borderSkipped === void 0 ? this.borderSkipped : borderSkipped, borderRadius === void 0 ? this.borderRadius : borderRadius, inflateAmount === void 0 ? this.inflateAmount : inflateAmount, pointStyle === void 0 ? this.pointStyle : pointStyle);
  };
  BarOptions.prototype.toString = function () {
    return 'BarOptions(backgroundColor=' + Kotlin.toString(this.backgroundColor) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', borderSkipped=' + Kotlin.toString(this.borderSkipped)) + (', borderRadius=' + Kotlin.toString(this.borderRadius)) + (', inflateAmount=' + Kotlin.toString(this.inflateAmount)) + (', pointStyle=' + Kotlin.toString(this.pointStyle)) + ')';
  };
  BarOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderSkipped) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.inflateAmount) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointStyle) | 0;
    return result;
  };
  BarOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.borderSkipped, other.borderSkipped) && Kotlin.equals(this.borderRadius, other.borderRadius) && Kotlin.equals(this.inflateAmount, other.inflateAmount) && Kotlin.equals(this.pointStyle, other.pointStyle)))));
  };
  function toJs_13($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.backgroundColor != null)
      $receiver_0.backgroundColor = $receiver.backgroundColor.asString();
    if ($receiver.borderColor != null)
      $receiver_0.borderColor = $receiver.borderColor.asString();
    if ($receiver.borderWidth != null)
      $receiver_0.borderWidth = $receiver.borderWidth;
    if ($receiver.borderSkipped != null)
      $receiver_0.borderSkipped = $receiver.borderSkipped.mode_8be2vx$;
    if ($receiver.borderRadius != null)
      $receiver_0.borderRadius = $receiver.borderRadius;
    if ($receiver.inflateAmount != null)
      $receiver_0.inflateAmount = $receiver.inflateAmount;
    if ($receiver.pointStyle != null)
      $receiver_0.pointStyle = $receiver.pointStyle.style_8be2vx$;
    return $receiver_0;
  }
  function ElementsOptions(point, line, arc, bar) {
    if (point === void 0)
      point = null;
    if (line === void 0)
      line = null;
    if (arc === void 0)
      arc = null;
    if (bar === void 0)
      bar = null;
    this.point = point;
    this.line = line;
    this.arc = arc;
    this.bar = bar;
  }
  ElementsOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ElementsOptions',
    interfaces: []
  };
  ElementsOptions.prototype.component1 = function () {
    return this.point;
  };
  ElementsOptions.prototype.component2 = function () {
    return this.line;
  };
  ElementsOptions.prototype.component3 = function () {
    return this.arc;
  };
  ElementsOptions.prototype.component4 = function () {
    return this.bar;
  };
  ElementsOptions.prototype.copy_resmf9$ = function (point, line, arc, bar) {
    return new ElementsOptions(point === void 0 ? this.point : point, line === void 0 ? this.line : line, arc === void 0 ? this.arc : arc, bar === void 0 ? this.bar : bar);
  };
  ElementsOptions.prototype.toString = function () {
    return 'ElementsOptions(point=' + Kotlin.toString(this.point) + (', line=' + Kotlin.toString(this.line)) + (', arc=' + Kotlin.toString(this.arc)) + (', bar=' + Kotlin.toString(this.bar)) + ')';
  };
  ElementsOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.point) | 0;
    result = result * 31 + Kotlin.hashCode(this.line) | 0;
    result = result * 31 + Kotlin.hashCode(this.arc) | 0;
    result = result * 31 + Kotlin.hashCode(this.bar) | 0;
    return result;
  };
  ElementsOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.point, other.point) && Kotlin.equals(this.line, other.line) && Kotlin.equals(this.arc, other.arc) && Kotlin.equals(this.bar, other.bar)))));
  };
  function toJs_14($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.point != null)
      $receiver_0.point = toJs_10($receiver.point);
    if ($receiver.line != null)
      $receiver_0.line = toJs_11($receiver.line);
    if ($receiver.arc != null)
      $receiver_0.arc = toJs_12($receiver.arc);
    if ($receiver.bar != null)
      $receiver_0.bar = toJs_13($receiver.bar);
    return $receiver_0;
  }
  function GridLineOptions(display, color, borderColor, borderWidth, borderDash, borderDashOffset, lineWidth, drawBorder, drawOnChartArea, drawTicks, offset, tickLength, tickWidth, tickColor, tickBorderDash, tickBorderDashOffset, circular, z) {
    if (display === void 0)
      display = true;
    if (color === void 0)
      color = null;
    if (borderColor === void 0)
      borderColor = null;
    if (borderWidth === void 0)
      borderWidth = null;
    if (borderDash === void 0)
      borderDash = null;
    if (borderDashOffset === void 0)
      borderDashOffset = null;
    if (lineWidth === void 0)
      lineWidth = null;
    if (drawBorder === void 0)
      drawBorder = null;
    if (drawOnChartArea === void 0)
      drawOnChartArea = null;
    if (drawTicks === void 0)
      drawTicks = null;
    if (offset === void 0)
      offset = null;
    if (tickLength === void 0)
      tickLength = null;
    if (tickWidth === void 0)
      tickWidth = null;
    if (tickColor === void 0)
      tickColor = null;
    if (tickBorderDash === void 0)
      tickBorderDash = null;
    if (tickBorderDashOffset === void 0)
      tickBorderDashOffset = null;
    if (circular === void 0)
      circular = null;
    if (z === void 0)
      z = null;
    this.display = display;
    this.color = color;
    this.borderColor = borderColor;
    this.borderWidth = borderWidth;
    this.borderDash = borderDash;
    this.borderDashOffset = borderDashOffset;
    this.lineWidth = lineWidth;
    this.drawBorder = drawBorder;
    this.drawOnChartArea = drawOnChartArea;
    this.drawTicks = drawTicks;
    this.offset = offset;
    this.tickLength = tickLength;
    this.tickWidth = tickWidth;
    this.tickColor = tickColor;
    this.tickBorderDash = tickBorderDash;
    this.tickBorderDashOffset = tickBorderDashOffset;
    this.circular = circular;
    this.z = z;
  }
  GridLineOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GridLineOptions',
    interfaces: []
  };
  GridLineOptions.prototype.component1 = function () {
    return this.display;
  };
  GridLineOptions.prototype.component2 = function () {
    return this.color;
  };
  GridLineOptions.prototype.component3 = function () {
    return this.borderColor;
  };
  GridLineOptions.prototype.component4 = function () {
    return this.borderWidth;
  };
  GridLineOptions.prototype.component5 = function () {
    return this.borderDash;
  };
  GridLineOptions.prototype.component6 = function () {
    return this.borderDashOffset;
  };
  GridLineOptions.prototype.component7 = function () {
    return this.lineWidth;
  };
  GridLineOptions.prototype.component8 = function () {
    return this.drawBorder;
  };
  GridLineOptions.prototype.component9 = function () {
    return this.drawOnChartArea;
  };
  GridLineOptions.prototype.component10 = function () {
    return this.drawTicks;
  };
  GridLineOptions.prototype.component11 = function () {
    return this.offset;
  };
  GridLineOptions.prototype.component12 = function () {
    return this.tickLength;
  };
  GridLineOptions.prototype.component13 = function () {
    return this.tickWidth;
  };
  GridLineOptions.prototype.component14 = function () {
    return this.tickColor;
  };
  GridLineOptions.prototype.component15 = function () {
    return this.tickBorderDash;
  };
  GridLineOptions.prototype.component16 = function () {
    return this.tickBorderDashOffset;
  };
  GridLineOptions.prototype.component17 = function () {
    return this.circular;
  };
  GridLineOptions.prototype.component18 = function () {
    return this.z;
  };
  GridLineOptions.prototype.copy_lqexju$ = function (display, color, borderColor, borderWidth, borderDash, borderDashOffset, lineWidth, drawBorder, drawOnChartArea, drawTicks, offset, tickLength, tickWidth, tickColor, tickBorderDash, tickBorderDashOffset, circular, z) {
    return new GridLineOptions(display === void 0 ? this.display : display, color === void 0 ? this.color : color, borderColor === void 0 ? this.borderColor : borderColor, borderWidth === void 0 ? this.borderWidth : borderWidth, borderDash === void 0 ? this.borderDash : borderDash, borderDashOffset === void 0 ? this.borderDashOffset : borderDashOffset, lineWidth === void 0 ? this.lineWidth : lineWidth, drawBorder === void 0 ? this.drawBorder : drawBorder, drawOnChartArea === void 0 ? this.drawOnChartArea : drawOnChartArea, drawTicks === void 0 ? this.drawTicks : drawTicks, offset === void 0 ? this.offset : offset, tickLength === void 0 ? this.tickLength : tickLength, tickWidth === void 0 ? this.tickWidth : tickWidth, tickColor === void 0 ? this.tickColor : tickColor, tickBorderDash === void 0 ? this.tickBorderDash : tickBorderDash, tickBorderDashOffset === void 0 ? this.tickBorderDashOffset : tickBorderDashOffset, circular === void 0 ? this.circular : circular, z === void 0 ? this.z : z);
  };
  GridLineOptions.prototype.toString = function () {
    return 'GridLineOptions(display=' + Kotlin.toString(this.display) + (', color=' + Kotlin.toString(this.color)) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', borderDash=' + Kotlin.toString(this.borderDash)) + (', borderDashOffset=' + Kotlin.toString(this.borderDashOffset)) + (', lineWidth=' + Kotlin.toString(this.lineWidth)) + (', drawBorder=' + Kotlin.toString(this.drawBorder)) + (', drawOnChartArea=' + Kotlin.toString(this.drawOnChartArea)) + (', drawTicks=' + Kotlin.toString(this.drawTicks)) + (', offset=' + Kotlin.toString(this.offset)) + (', tickLength=' + Kotlin.toString(this.tickLength)) + (', tickWidth=' + Kotlin.toString(this.tickWidth)) + (', tickColor=' + Kotlin.toString(this.tickColor)) + (', tickBorderDash=' + Kotlin.toString(this.tickBorderDash)) + (', tickBorderDashOffset=' + Kotlin.toString(this.tickBorderDashOffset)) + (', circular=' + Kotlin.toString(this.circular)) + (', z=' + Kotlin.toString(this.z)) + ')';
  };
  GridLineOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderDash) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderDashOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.lineWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.drawBorder) | 0;
    result = result * 31 + Kotlin.hashCode(this.drawOnChartArea) | 0;
    result = result * 31 + Kotlin.hashCode(this.drawTicks) | 0;
    result = result * 31 + Kotlin.hashCode(this.offset) | 0;
    result = result * 31 + Kotlin.hashCode(this.tickLength) | 0;
    result = result * 31 + Kotlin.hashCode(this.tickWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.tickColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.tickBorderDash) | 0;
    result = result * 31 + Kotlin.hashCode(this.tickBorderDashOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.circular) | 0;
    result = result * 31 + Kotlin.hashCode(this.z) | 0;
    return result;
  };
  GridLineOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.display, other.display) && Kotlin.equals(this.color, other.color) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.borderDash, other.borderDash) && Kotlin.equals(this.borderDashOffset, other.borderDashOffset) && Kotlin.equals(this.lineWidth, other.lineWidth) && Kotlin.equals(this.drawBorder, other.drawBorder) && Kotlin.equals(this.drawOnChartArea, other.drawOnChartArea) && Kotlin.equals(this.drawTicks, other.drawTicks) && Kotlin.equals(this.offset, other.offset) && Kotlin.equals(this.tickLength, other.tickLength) && Kotlin.equals(this.tickWidth, other.tickWidth) && Kotlin.equals(this.tickColor, other.tickColor) && Kotlin.equals(this.tickBorderDash, other.tickBorderDash) && Kotlin.equals(this.tickBorderDashOffset, other.tickBorderDashOffset) && Kotlin.equals(this.circular, other.circular) && Kotlin.equals(this.z, other.z)))));
  };
  function toJs_15($receiver) {
    var $receiver_0 = new Object_init();
    $receiver_0.display = $receiver.display;
    if ($receiver.color != null)
      $receiver_0.color = $receiver.color.asString();
    if ($receiver.borderColor != null)
      $receiver_0.borderColor = $receiver.borderColor.asString();
    if ($receiver.borderWidth != null)
      $receiver_0.borderWidth = $receiver.borderWidth;
    if ($receiver.borderDash != null) {
      $receiver_0.borderDash = copyToArray($receiver.borderDash);
    }
    if ($receiver.borderDashOffset != null)
      $receiver_0.borderDashOffset = $receiver.borderDashOffset;
    if ($receiver.lineWidth != null)
      $receiver_0.lineWidth = $receiver.lineWidth;
    if ($receiver.drawBorder != null)
      $receiver_0.drawBorder = $receiver.drawBorder;
    if ($receiver.drawOnChartArea != null)
      $receiver_0.drawOnChartArea = $receiver.drawOnChartArea;
    if ($receiver.drawTicks != null)
      $receiver_0.drawTicks = $receiver.drawTicks;
    if ($receiver.offset != null)
      $receiver_0.offset = $receiver.offset;
    if ($receiver.tickLength != null)
      $receiver_0.tickLength = $receiver.tickLength;
    if ($receiver.tickWidth != null)
      $receiver_0.tickWidth = $receiver.tickWidth;
    if ($receiver.tickColor != null)
      $receiver_0.tickColor = $receiver.tickColor.asString();
    if ($receiver.tickBorderDash != null) {
      $receiver_0.tickBorderDash = copyToArray($receiver.tickBorderDash);
    }
    if ($receiver.tickBorderDashOffset != null)
      $receiver_0.tickBorderDashOffset = $receiver.tickBorderDashOffset;
    if ($receiver.circular != null)
      $receiver_0.circular = $receiver.circular;
    if ($receiver.z != null)
      $receiver_0.z = $receiver.z;
    return $receiver_0;
  }
  function ScaleTitleOptions(display, color, font, padding, align, text) {
    if (display === void 0)
      display = null;
    if (color === void 0)
      color = null;
    if (font === void 0)
      font = null;
    if (padding === void 0)
      padding = null;
    if (align === void 0)
      align = null;
    if (text === void 0)
      text = null;
    this.display = display;
    this.color = color;
    this.font = font;
    this.padding = padding;
    this.align = align;
    this.text = text;
  }
  ScaleTitleOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ScaleTitleOptions',
    interfaces: []
  };
  ScaleTitleOptions.prototype.component1 = function () {
    return this.display;
  };
  ScaleTitleOptions.prototype.component2 = function () {
    return this.color;
  };
  ScaleTitleOptions.prototype.component3 = function () {
    return this.font;
  };
  ScaleTitleOptions.prototype.component4 = function () {
    return this.padding;
  };
  ScaleTitleOptions.prototype.component5 = function () {
    return this.align;
  };
  ScaleTitleOptions.prototype.component6 = function () {
    return this.text;
  };
  ScaleTitleOptions.prototype.copy_6206dx$ = function (display, color, font, padding, align, text) {
    return new ScaleTitleOptions(display === void 0 ? this.display : display, color === void 0 ? this.color : color, font === void 0 ? this.font : font, padding === void 0 ? this.padding : padding, align === void 0 ? this.align : align, text === void 0 ? this.text : text);
  };
  ScaleTitleOptions.prototype.toString = function () {
    return 'ScaleTitleOptions(display=' + Kotlin.toString(this.display) + (', color=' + Kotlin.toString(this.color)) + (', font=' + Kotlin.toString(this.font)) + (', padding=' + Kotlin.toString(this.padding)) + (', align=' + Kotlin.toString(this.align)) + (', text=' + Kotlin.toString(this.text)) + ')';
  };
  ScaleTitleOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.font) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    result = result * 31 + Kotlin.hashCode(this.align) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    return result;
  };
  ScaleTitleOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.display, other.display) && Kotlin.equals(this.color, other.color) && Kotlin.equals(this.font, other.font) && Kotlin.equals(this.padding, other.padding) && Kotlin.equals(this.align, other.align) && Kotlin.equals(this.text, other.text)))));
  };
  function toJs_16($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    if ($receiver.display != null)
      $receiver_0.display = $receiver.display;
    if ($receiver.color != null)
      $receiver_0.color = $receiver.color.asString();
    if ($receiver.font != null)
      $receiver_0.font = toJs($receiver.font);
    if ($receiver.padding != null)
      $receiver_0.padding = toJs_2($receiver.padding);
    if ($receiver.align != null)
      $receiver_0.align = $receiver.align.mode_8be2vx$;
    if ($receiver.text != null)
      $receiver_0.text = i18nTranslator($receiver.text);
    return $receiver_0;
  }
  function TickOptions(callback, display, backdropColor, backdropPadding, color, font, major, padding, showLabelBackdrop, textStrokeColor, textStrokeWidth, z, align, crossAlign, sampleSize, autoSkip, autoSkipPadding, includeBounds, labelOffset, maxRotation, minRotation, mirror, count, format, maxTicksLimit, precision, stepSize, source) {
    if (callback === void 0)
      callback = null;
    if (display === void 0)
      display = true;
    if (backdropColor === void 0)
      backdropColor = null;
    if (backdropPadding === void 0)
      backdropPadding = null;
    if (color === void 0)
      color = null;
    if (font === void 0)
      font = null;
    if (major === void 0)
      major = null;
    if (padding === void 0)
      padding = null;
    if (showLabelBackdrop === void 0)
      showLabelBackdrop = null;
    if (textStrokeColor === void 0)
      textStrokeColor = null;
    if (textStrokeWidth === void 0)
      textStrokeWidth = null;
    if (z === void 0)
      z = null;
    if (align === void 0)
      align = null;
    if (crossAlign === void 0)
      crossAlign = null;
    if (sampleSize === void 0)
      sampleSize = null;
    if (autoSkip === void 0)
      autoSkip = null;
    if (autoSkipPadding === void 0)
      autoSkipPadding = null;
    if (includeBounds === void 0)
      includeBounds = null;
    if (labelOffset === void 0)
      labelOffset = null;
    if (maxRotation === void 0)
      maxRotation = null;
    if (minRotation === void 0)
      minRotation = null;
    if (mirror === void 0)
      mirror = null;
    if (count === void 0)
      count = null;
    if (format === void 0)
      format = null;
    if (maxTicksLimit === void 0)
      maxTicksLimit = null;
    if (precision === void 0)
      precision = null;
    if (stepSize === void 0)
      stepSize = null;
    if (source === void 0)
      source = null;
    this.callback = callback;
    this.display = display;
    this.backdropColor = backdropColor;
    this.backdropPadding = backdropPadding;
    this.color = color;
    this.font = font;
    this.major = major;
    this.padding = padding;
    this.showLabelBackdrop = showLabelBackdrop;
    this.textStrokeColor = textStrokeColor;
    this.textStrokeWidth = textStrokeWidth;
    this.z = z;
    this.align = align;
    this.crossAlign = crossAlign;
    this.sampleSize = sampleSize;
    this.autoSkip = autoSkip;
    this.autoSkipPadding = autoSkipPadding;
    this.includeBounds = includeBounds;
    this.labelOffset = labelOffset;
    this.maxRotation = maxRotation;
    this.minRotation = minRotation;
    this.mirror = mirror;
    this.count = count;
    this.format = format;
    this.maxTicksLimit = maxTicksLimit;
    this.precision = precision;
    this.stepSize = stepSize;
    this.source = source;
  }
  TickOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TickOptions',
    interfaces: []
  };
  TickOptions.prototype.component1 = function () {
    return this.callback;
  };
  TickOptions.prototype.component2 = function () {
    return this.display;
  };
  TickOptions.prototype.component3 = function () {
    return this.backdropColor;
  };
  TickOptions.prototype.component4 = function () {
    return this.backdropPadding;
  };
  TickOptions.prototype.component5 = function () {
    return this.color;
  };
  TickOptions.prototype.component6 = function () {
    return this.font;
  };
  TickOptions.prototype.component7 = function () {
    return this.major;
  };
  TickOptions.prototype.component8 = function () {
    return this.padding;
  };
  TickOptions.prototype.component9 = function () {
    return this.showLabelBackdrop;
  };
  TickOptions.prototype.component10 = function () {
    return this.textStrokeColor;
  };
  TickOptions.prototype.component11 = function () {
    return this.textStrokeWidth;
  };
  TickOptions.prototype.component12 = function () {
    return this.z;
  };
  TickOptions.prototype.component13 = function () {
    return this.align;
  };
  TickOptions.prototype.component14 = function () {
    return this.crossAlign;
  };
  TickOptions.prototype.component15 = function () {
    return this.sampleSize;
  };
  TickOptions.prototype.component16 = function () {
    return this.autoSkip;
  };
  TickOptions.prototype.component17 = function () {
    return this.autoSkipPadding;
  };
  TickOptions.prototype.component18 = function () {
    return this.includeBounds;
  };
  TickOptions.prototype.component19 = function () {
    return this.labelOffset;
  };
  TickOptions.prototype.component20 = function () {
    return this.maxRotation;
  };
  TickOptions.prototype.component21 = function () {
    return this.minRotation;
  };
  TickOptions.prototype.component22 = function () {
    return this.mirror;
  };
  TickOptions.prototype.component23 = function () {
    return this.count;
  };
  TickOptions.prototype.component24 = function () {
    return this.format;
  };
  TickOptions.prototype.component25 = function () {
    return this.maxTicksLimit;
  };
  TickOptions.prototype.component26 = function () {
    return this.precision;
  };
  TickOptions.prototype.component27 = function () {
    return this.stepSize;
  };
  TickOptions.prototype.component28 = function () {
    return this.source;
  };
  TickOptions.prototype.copy_ypq0su$ = function (callback, display, backdropColor, backdropPadding, color, font, major, padding, showLabelBackdrop, textStrokeColor, textStrokeWidth, z, align, crossAlign, sampleSize, autoSkip, autoSkipPadding, includeBounds, labelOffset, maxRotation, minRotation, mirror, count, format, maxTicksLimit, precision, stepSize, source) {
    return new TickOptions(callback === void 0 ? this.callback : callback, display === void 0 ? this.display : display, backdropColor === void 0 ? this.backdropColor : backdropColor, backdropPadding === void 0 ? this.backdropPadding : backdropPadding, color === void 0 ? this.color : color, font === void 0 ? this.font : font, major === void 0 ? this.major : major, padding === void 0 ? this.padding : padding, showLabelBackdrop === void 0 ? this.showLabelBackdrop : showLabelBackdrop, textStrokeColor === void 0 ? this.textStrokeColor : textStrokeColor, textStrokeWidth === void 0 ? this.textStrokeWidth : textStrokeWidth, z === void 0 ? this.z : z, align === void 0 ? this.align : align, crossAlign === void 0 ? this.crossAlign : crossAlign, sampleSize === void 0 ? this.sampleSize : sampleSize, autoSkip === void 0 ? this.autoSkip : autoSkip, autoSkipPadding === void 0 ? this.autoSkipPadding : autoSkipPadding, includeBounds === void 0 ? this.includeBounds : includeBounds, labelOffset === void 0 ? this.labelOffset : labelOffset, maxRotation === void 0 ? this.maxRotation : maxRotation, minRotation === void 0 ? this.minRotation : minRotation, mirror === void 0 ? this.mirror : mirror, count === void 0 ? this.count : count, format === void 0 ? this.format : format, maxTicksLimit === void 0 ? this.maxTicksLimit : maxTicksLimit, precision === void 0 ? this.precision : precision, stepSize === void 0 ? this.stepSize : stepSize, source === void 0 ? this.source : source);
  };
  TickOptions.prototype.toString = function () {
    return 'TickOptions(callback=' + Kotlin.toString(this.callback) + (', display=' + Kotlin.toString(this.display)) + (', backdropColor=' + Kotlin.toString(this.backdropColor)) + (', backdropPadding=' + Kotlin.toString(this.backdropPadding)) + (', color=' + Kotlin.toString(this.color)) + (', font=' + Kotlin.toString(this.font)) + (', major=' + Kotlin.toString(this.major)) + (', padding=' + Kotlin.toString(this.padding)) + (', showLabelBackdrop=' + Kotlin.toString(this.showLabelBackdrop)) + (', textStrokeColor=' + Kotlin.toString(this.textStrokeColor)) + (', textStrokeWidth=' + Kotlin.toString(this.textStrokeWidth)) + (', z=' + Kotlin.toString(this.z)) + (', align=' + Kotlin.toString(this.align)) + (', crossAlign=' + Kotlin.toString(this.crossAlign)) + (', sampleSize=' + Kotlin.toString(this.sampleSize)) + (', autoSkip=' + Kotlin.toString(this.autoSkip)) + (', autoSkipPadding=' + Kotlin.toString(this.autoSkipPadding)) + (', includeBounds=' + Kotlin.toString(this.includeBounds)) + (', labelOffset=' + Kotlin.toString(this.labelOffset)) + (', maxRotation=' + Kotlin.toString(this.maxRotation)) + (', minRotation=' + Kotlin.toString(this.minRotation)) + (', mirror=' + Kotlin.toString(this.mirror)) + (', count=' + Kotlin.toString(this.count)) + (', format=' + Kotlin.toString(this.format)) + (', maxTicksLimit=' + Kotlin.toString(this.maxTicksLimit)) + (', precision=' + Kotlin.toString(this.precision)) + (', stepSize=' + Kotlin.toString(this.stepSize)) + (', source=' + Kotlin.toString(this.source)) + ')';
  };
  TickOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.callback) | 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.backdropColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.backdropPadding) | 0;
    result = result * 31 + Kotlin.hashCode(this.color) | 0;
    result = result * 31 + Kotlin.hashCode(this.font) | 0;
    result = result * 31 + Kotlin.hashCode(this.major) | 0;
    result = result * 31 + Kotlin.hashCode(this.padding) | 0;
    result = result * 31 + Kotlin.hashCode(this.showLabelBackdrop) | 0;
    result = result * 31 + Kotlin.hashCode(this.textStrokeColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.textStrokeWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.z) | 0;
    result = result * 31 + Kotlin.hashCode(this.align) | 0;
    result = result * 31 + Kotlin.hashCode(this.crossAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.sampleSize) | 0;
    result = result * 31 + Kotlin.hashCode(this.autoSkip) | 0;
    result = result * 31 + Kotlin.hashCode(this.autoSkipPadding) | 0;
    result = result * 31 + Kotlin.hashCode(this.includeBounds) | 0;
    result = result * 31 + Kotlin.hashCode(this.labelOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxRotation) | 0;
    result = result * 31 + Kotlin.hashCode(this.minRotation) | 0;
    result = result * 31 + Kotlin.hashCode(this.mirror) | 0;
    result = result * 31 + Kotlin.hashCode(this.count) | 0;
    result = result * 31 + Kotlin.hashCode(this.format) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxTicksLimit) | 0;
    result = result * 31 + Kotlin.hashCode(this.precision) | 0;
    result = result * 31 + Kotlin.hashCode(this.stepSize) | 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    return result;
  };
  TickOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.callback, other.callback) && Kotlin.equals(this.display, other.display) && Kotlin.equals(this.backdropColor, other.backdropColor) && Kotlin.equals(this.backdropPadding, other.backdropPadding) && Kotlin.equals(this.color, other.color) && Kotlin.equals(this.font, other.font) && Kotlin.equals(this.major, other.major) && Kotlin.equals(this.padding, other.padding) && Kotlin.equals(this.showLabelBackdrop, other.showLabelBackdrop) && Kotlin.equals(this.textStrokeColor, other.textStrokeColor) && Kotlin.equals(this.textStrokeWidth, other.textStrokeWidth) && Kotlin.equals(this.z, other.z) && Kotlin.equals(this.align, other.align) && Kotlin.equals(this.crossAlign, other.crossAlign) && Kotlin.equals(this.sampleSize, other.sampleSize) && Kotlin.equals(this.autoSkip, other.autoSkip) && Kotlin.equals(this.autoSkipPadding, other.autoSkipPadding) && Kotlin.equals(this.includeBounds, other.includeBounds) && Kotlin.equals(this.labelOffset, other.labelOffset) && Kotlin.equals(this.maxRotation, other.maxRotation) && Kotlin.equals(this.minRotation, other.minRotation) && Kotlin.equals(this.mirror, other.mirror) && Kotlin.equals(this.count, other.count) && Kotlin.equals(this.format, other.format) && Kotlin.equals(this.maxTicksLimit, other.maxTicksLimit) && Kotlin.equals(this.precision, other.precision) && Kotlin.equals(this.stepSize, other.stepSize) && Kotlin.equals(this.source, other.source)))));
  };
  function toJs_17($receiver) {
    var $receiver_0 = new Object_init();
    if ($receiver.callback != null)
      $receiver_0.callback = $receiver.callback;
    $receiver_0.display = $receiver.display;
    if ($receiver.backdropColor != null)
      $receiver_0.backdropColor = $receiver.backdropColor.asString();
    if ($receiver.backdropPadding != null)
      $receiver_0.backdropPadding = toJs_2($receiver.backdropPadding);
    if ($receiver.color != null)
      $receiver_0.color = $receiver.color.asString();
    if ($receiver.font != null)
      $receiver_0.font = toJs($receiver.font);
    if ($receiver.major != null)
      $receiver_0.major = $receiver.major;
    if ($receiver.padding != null)
      $receiver_0.padding = $receiver.padding;
    if ($receiver.showLabelBackdrop != null)
      $receiver_0.showLabelBackdrop = $receiver.showLabelBackdrop;
    if ($receiver.textStrokeColor != null)
      $receiver_0.textStrokeColor = $receiver.textStrokeColor.asString();
    if ($receiver.textStrokeWidth != null)
      $receiver_0.textStrokeWidth = $receiver.textStrokeWidth;
    if ($receiver.align != null)
      $receiver_0.align = $receiver.align.mode_8be2vx$;
    if ($receiver.crossAlign != null)
      $receiver_0.crossAlign = $receiver.crossAlign.mode_8be2vx$;
    if ($receiver.sampleSize != null)
      $receiver_0.sampleSize = $receiver.sampleSize;
    if ($receiver.autoSkip != null)
      $receiver_0.autoSkip = $receiver.autoSkip;
    if ($receiver.autoSkipPadding != null)
      $receiver_0.autoSkipPadding = $receiver.autoSkipPadding;
    if ($receiver.includeBounds != null)
      $receiver_0.includeBounds = $receiver.includeBounds;
    if ($receiver.labelOffset != null)
      $receiver_0.labelOffset = $receiver.labelOffset;
    if ($receiver.maxRotation != null)
      $receiver_0.maxRotation = $receiver.maxRotation;
    if ($receiver.minRotation != null)
      $receiver_0.minRotation = $receiver.minRotation;
    if ($receiver.mirror != null)
      $receiver_0.mirror = $receiver.mirror;
    if ($receiver.count != null)
      $receiver_0.count = $receiver.count;
    if ($receiver.format != null)
      $receiver_0.format = $receiver.format;
    if ($receiver.maxTicksLimit != null)
      $receiver_0.maxTicksLimit = $receiver.maxTicksLimit;
    if ($receiver.precision != null)
      $receiver_0.precision = $receiver.precision;
    if ($receiver.stepSize != null)
      $receiver_0.stepSize = $receiver.stepSize;
    if ($receiver.source != null)
      $receiver_0.source = $receiver.source;
    return $receiver_0;
  }
  function ChartScales(type, alignToPixels, backgroundColor, display, grid, min, max, reverse, stacked, suggestedMax, suggestedMin, ticks, weight, bounds, position, stack, stackWeight, axis, offset, title, labels, beginAtZero, grace, adapters, time, animate, angleLines, pointLabels, startAngle) {
    if (type === void 0)
      type = null;
    if (alignToPixels === void 0)
      alignToPixels = null;
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (display === void 0)
      display = null;
    if (grid === void 0)
      grid = null;
    if (min === void 0)
      min = null;
    if (max === void 0)
      max = null;
    if (reverse === void 0)
      reverse = null;
    if (stacked === void 0)
      stacked = null;
    if (suggestedMax === void 0)
      suggestedMax = null;
    if (suggestedMin === void 0)
      suggestedMin = null;
    if (ticks === void 0)
      ticks = null;
    if (weight === void 0)
      weight = null;
    if (bounds === void 0)
      bounds = null;
    if (position === void 0)
      position = null;
    if (stack === void 0)
      stack = null;
    if (stackWeight === void 0)
      stackWeight = null;
    if (axis === void 0)
      axis = null;
    if (offset === void 0)
      offset = null;
    if (title === void 0)
      title = null;
    if (labels === void 0)
      labels = null;
    if (beginAtZero === void 0)
      beginAtZero = null;
    if (grace === void 0)
      grace = null;
    if (adapters === void 0)
      adapters = null;
    if (time === void 0)
      time = null;
    if (animate === void 0)
      animate = null;
    if (angleLines === void 0)
      angleLines = null;
    if (pointLabels === void 0)
      pointLabels = null;
    if (startAngle === void 0)
      startAngle = null;
    this.type = type;
    this.alignToPixels = alignToPixels;
    this.backgroundColor = backgroundColor;
    this.display = display;
    this.grid = grid;
    this.min = min;
    this.max = max;
    this.reverse = reverse;
    this.stacked = stacked;
    this.suggestedMax = suggestedMax;
    this.suggestedMin = suggestedMin;
    this.ticks = ticks;
    this.weight = weight;
    this.bounds = bounds;
    this.position = position;
    this.stack = stack;
    this.stackWeight = stackWeight;
    this.axis = axis;
    this.offset = offset;
    this.title = title;
    this.labels = labels;
    this.beginAtZero = beginAtZero;
    this.grace = grace;
    this.adapters = adapters;
    this.time = time;
    this.animate = animate;
    this.angleLines = angleLines;
    this.pointLabels = pointLabels;
    this.startAngle = startAngle;
  }
  ChartScales.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChartScales',
    interfaces: []
  };
  ChartScales.prototype.component1 = function () {
    return this.type;
  };
  ChartScales.prototype.component2 = function () {
    return this.alignToPixels;
  };
  ChartScales.prototype.component3 = function () {
    return this.backgroundColor;
  };
  ChartScales.prototype.component4 = function () {
    return this.display;
  };
  ChartScales.prototype.component5 = function () {
    return this.grid;
  };
  ChartScales.prototype.component6 = function () {
    return this.min;
  };
  ChartScales.prototype.component7 = function () {
    return this.max;
  };
  ChartScales.prototype.component8 = function () {
    return this.reverse;
  };
  ChartScales.prototype.component9 = function () {
    return this.stacked;
  };
  ChartScales.prototype.component10 = function () {
    return this.suggestedMax;
  };
  ChartScales.prototype.component11 = function () {
    return this.suggestedMin;
  };
  ChartScales.prototype.component12 = function () {
    return this.ticks;
  };
  ChartScales.prototype.component13 = function () {
    return this.weight;
  };
  ChartScales.prototype.component14 = function () {
    return this.bounds;
  };
  ChartScales.prototype.component15 = function () {
    return this.position;
  };
  ChartScales.prototype.component16 = function () {
    return this.stack;
  };
  ChartScales.prototype.component17 = function () {
    return this.stackWeight;
  };
  ChartScales.prototype.component18 = function () {
    return this.axis;
  };
  ChartScales.prototype.component19 = function () {
    return this.offset;
  };
  ChartScales.prototype.component20 = function () {
    return this.title;
  };
  ChartScales.prototype.component21 = function () {
    return this.labels;
  };
  ChartScales.prototype.component22 = function () {
    return this.beginAtZero;
  };
  ChartScales.prototype.component23 = function () {
    return this.grace;
  };
  ChartScales.prototype.component24 = function () {
    return this.adapters;
  };
  ChartScales.prototype.component25 = function () {
    return this.time;
  };
  ChartScales.prototype.component26 = function () {
    return this.animate;
  };
  ChartScales.prototype.component27 = function () {
    return this.angleLines;
  };
  ChartScales.prototype.component28 = function () {
    return this.pointLabels;
  };
  ChartScales.prototype.component29 = function () {
    return this.startAngle;
  };
  ChartScales.prototype.copy_qpytlo$ = function (type, alignToPixels, backgroundColor, display, grid, min, max, reverse, stacked, suggestedMax, suggestedMin, ticks, weight, bounds, position, stack, stackWeight, axis, offset, title, labels, beginAtZero, grace, adapters, time, animate, angleLines, pointLabels, startAngle) {
    return new ChartScales(type === void 0 ? this.type : type, alignToPixels === void 0 ? this.alignToPixels : alignToPixels, backgroundColor === void 0 ? this.backgroundColor : backgroundColor, display === void 0 ? this.display : display, grid === void 0 ? this.grid : grid, min === void 0 ? this.min : min, max === void 0 ? this.max : max, reverse === void 0 ? this.reverse : reverse, stacked === void 0 ? this.stacked : stacked, suggestedMax === void 0 ? this.suggestedMax : suggestedMax, suggestedMin === void 0 ? this.suggestedMin : suggestedMin, ticks === void 0 ? this.ticks : ticks, weight === void 0 ? this.weight : weight, bounds === void 0 ? this.bounds : bounds, position === void 0 ? this.position : position, stack === void 0 ? this.stack : stack, stackWeight === void 0 ? this.stackWeight : stackWeight, axis === void 0 ? this.axis : axis, offset === void 0 ? this.offset : offset, title === void 0 ? this.title : title, labels === void 0 ? this.labels : labels, beginAtZero === void 0 ? this.beginAtZero : beginAtZero, grace === void 0 ? this.grace : grace, adapters === void 0 ? this.adapters : adapters, time === void 0 ? this.time : time, animate === void 0 ? this.animate : animate, angleLines === void 0 ? this.angleLines : angleLines, pointLabels === void 0 ? this.pointLabels : pointLabels, startAngle === void 0 ? this.startAngle : startAngle);
  };
  ChartScales.prototype.toString = function () {
    return 'ChartScales(type=' + Kotlin.toString(this.type) + (', alignToPixels=' + Kotlin.toString(this.alignToPixels)) + (', backgroundColor=' + Kotlin.toString(this.backgroundColor)) + (', display=' + Kotlin.toString(this.display)) + (', grid=' + Kotlin.toString(this.grid)) + (', min=' + Kotlin.toString(this.min)) + (', max=' + Kotlin.toString(this.max)) + (', reverse=' + Kotlin.toString(this.reverse)) + (', stacked=' + Kotlin.toString(this.stacked)) + (', suggestedMax=' + Kotlin.toString(this.suggestedMax)) + (', suggestedMin=' + Kotlin.toString(this.suggestedMin)) + (', ticks=' + Kotlin.toString(this.ticks)) + (', weight=' + Kotlin.toString(this.weight)) + (', bounds=' + Kotlin.toString(this.bounds)) + (', position=' + Kotlin.toString(this.position)) + (', stack=' + Kotlin.toString(this.stack)) + (', stackWeight=' + Kotlin.toString(this.stackWeight)) + (', axis=' + Kotlin.toString(this.axis)) + (', offset=' + Kotlin.toString(this.offset)) + (', title=' + Kotlin.toString(this.title)) + (', labels=' + Kotlin.toString(this.labels)) + (', beginAtZero=' + Kotlin.toString(this.beginAtZero)) + (', grace=' + Kotlin.toString(this.grace)) + (', adapters=' + Kotlin.toString(this.adapters)) + (', time=' + Kotlin.toString(this.time)) + (', animate=' + Kotlin.toString(this.animate)) + (', angleLines=' + Kotlin.toString(this.angleLines)) + (', pointLabels=' + Kotlin.toString(this.pointLabels)) + (', startAngle=' + Kotlin.toString(this.startAngle)) + ')';
  };
  ChartScales.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.alignToPixels) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.display) | 0;
    result = result * 31 + Kotlin.hashCode(this.grid) | 0;
    result = result * 31 + Kotlin.hashCode(this.min) | 0;
    result = result * 31 + Kotlin.hashCode(this.max) | 0;
    result = result * 31 + Kotlin.hashCode(this.reverse) | 0;
    result = result * 31 + Kotlin.hashCode(this.stacked) | 0;
    result = result * 31 + Kotlin.hashCode(this.suggestedMax) | 0;
    result = result * 31 + Kotlin.hashCode(this.suggestedMin) | 0;
    result = result * 31 + Kotlin.hashCode(this.ticks) | 0;
    result = result * 31 + Kotlin.hashCode(this.weight) | 0;
    result = result * 31 + Kotlin.hashCode(this.bounds) | 0;
    result = result * 31 + Kotlin.hashCode(this.position) | 0;
    result = result * 31 + Kotlin.hashCode(this.stack) | 0;
    result = result * 31 + Kotlin.hashCode(this.stackWeight) | 0;
    result = result * 31 + Kotlin.hashCode(this.axis) | 0;
    result = result * 31 + Kotlin.hashCode(this.offset) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.labels) | 0;
    result = result * 31 + Kotlin.hashCode(this.beginAtZero) | 0;
    result = result * 31 + Kotlin.hashCode(this.grace) | 0;
    result = result * 31 + Kotlin.hashCode(this.adapters) | 0;
    result = result * 31 + Kotlin.hashCode(this.time) | 0;
    result = result * 31 + Kotlin.hashCode(this.animate) | 0;
    result = result * 31 + Kotlin.hashCode(this.angleLines) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointLabels) | 0;
    result = result * 31 + Kotlin.hashCode(this.startAngle) | 0;
    return result;
  };
  ChartScales.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.alignToPixels, other.alignToPixels) && Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.display, other.display) && Kotlin.equals(this.grid, other.grid) && Kotlin.equals(this.min, other.min) && Kotlin.equals(this.max, other.max) && Kotlin.equals(this.reverse, other.reverse) && Kotlin.equals(this.stacked, other.stacked) && Kotlin.equals(this.suggestedMax, other.suggestedMax) && Kotlin.equals(this.suggestedMin, other.suggestedMin) && Kotlin.equals(this.ticks, other.ticks) && Kotlin.equals(this.weight, other.weight) && Kotlin.equals(this.bounds, other.bounds) && Kotlin.equals(this.position, other.position) && Kotlin.equals(this.stack, other.stack) && Kotlin.equals(this.stackWeight, other.stackWeight) && Kotlin.equals(this.axis, other.axis) && Kotlin.equals(this.offset, other.offset) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.labels, other.labels) && Kotlin.equals(this.beginAtZero, other.beginAtZero) && Kotlin.equals(this.grace, other.grace) && Kotlin.equals(this.adapters, other.adapters) && Kotlin.equals(this.time, other.time) && Kotlin.equals(this.animate, other.animate) && Kotlin.equals(this.angleLines, other.angleLines) && Kotlin.equals(this.pointLabels, other.pointLabels) && Kotlin.equals(this.startAngle, other.startAngle)))));
  };
  function toJs_18($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    if ($receiver.type != null)
      $receiver_0.type = $receiver.type.type_8be2vx$;
    if ($receiver.alignToPixels != null)
      $receiver_0.alignToPixels = $receiver.alignToPixels;
    if ($receiver.backgroundColor != null)
      $receiver_0.backgroundColor = $receiver.backgroundColor.asString();
    if ($receiver.display != null)
      $receiver_0.display = $receiver.display;
    if ($receiver.grid != null)
      $receiver_0.grid = toJs_15($receiver.grid);
    if ($receiver.min != null)
      $receiver_0.min = $receiver.min;
    if ($receiver.max != null)
      $receiver_0.max = $receiver.max;
    if ($receiver.reverse != null)
      $receiver_0.reverse = $receiver.reverse;
    if ($receiver.stacked != null)
      $receiver_0.stacked = $receiver.stacked;
    if ($receiver.suggestedMax != null)
      $receiver_0.suggestedMax = $receiver.suggestedMax;
    if ($receiver.suggestedMin != null)
      $receiver_0.suggestedMin = $receiver.suggestedMin;
    if ($receiver.ticks != null)
      $receiver_0.ticks = toJs_17($receiver.ticks);
    if ($receiver.weight != null)
      $receiver_0.weight = $receiver.max;
    if ($receiver.bounds != null)
      $receiver_0.bounds = $receiver.bounds.mode_8be2vx$;
    if ($receiver.position != null)
      $receiver_0.position = $receiver.position.position_8be2vx$;
    if ($receiver.stack != null)
      $receiver_0.stack = $receiver.stack;
    if ($receiver.stackWeight != null)
      $receiver_0.stackWeight = $receiver.stackWeight;
    if ($receiver.axis != null)
      $receiver_0.axis = $receiver.axis;
    if ($receiver.offset != null)
      $receiver_0.offset = $receiver.offset;
    if ($receiver.title != null)
      $receiver_0.title = toJs_16($receiver.title, i18nTranslator);
    if ($receiver.labels != null) {
      var $receiver_1 = $receiver.labels;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$;
      tmp$ = $receiver_1.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(i18nTranslator(item));
      }
      $receiver_0.labels = copyToArray(destination);
    }
    if ($receiver.beginAtZero != null)
      $receiver_0.beginAtZero = $receiver.beginAtZero;
    if ($receiver.grace != null)
      $receiver_0.grace = $receiver.grace;
    if ($receiver.adapters != null)
      $receiver_0.adapters = $receiver.adapters;
    if ($receiver.time != null)
      $receiver_0.time = $receiver.time;
    if ($receiver.animate != null)
      $receiver_0.animate = $receiver.animate;
    if ($receiver.angleLines != null)
      $receiver_0.angleLines = $receiver.angleLines;
    if ($receiver.pointLabels != null)
      $receiver_0.pointLabels = $receiver.pointLabels;
    if ($receiver.startAngle != null)
      $receiver_0.startAngle = $receiver.startAngle;
    return $receiver_0;
  }
  function PluginsOptions(legend, title, subtitle, tooltip) {
    if (legend === void 0)
      legend = null;
    if (title === void 0)
      title = null;
    if (subtitle === void 0)
      subtitle = null;
    if (tooltip === void 0)
      tooltip = null;
    this.legend = legend;
    this.title = title;
    this.subtitle = subtitle;
    this.tooltip = tooltip;
  }
  PluginsOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PluginsOptions',
    interfaces: []
  };
  PluginsOptions.prototype.component1 = function () {
    return this.legend;
  };
  PluginsOptions.prototype.component2 = function () {
    return this.title;
  };
  PluginsOptions.prototype.component3 = function () {
    return this.subtitle;
  };
  PluginsOptions.prototype.component4 = function () {
    return this.tooltip;
  };
  PluginsOptions.prototype.copy_ykg5oc$ = function (legend, title, subtitle, tooltip) {
    return new PluginsOptions(legend === void 0 ? this.legend : legend, title === void 0 ? this.title : title, subtitle === void 0 ? this.subtitle : subtitle, tooltip === void 0 ? this.tooltip : tooltip);
  };
  PluginsOptions.prototype.toString = function () {
    return 'PluginsOptions(legend=' + Kotlin.toString(this.legend) + (', title=' + Kotlin.toString(this.title)) + (', subtitle=' + Kotlin.toString(this.subtitle)) + (', tooltip=' + Kotlin.toString(this.tooltip)) + ')';
  };
  PluginsOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.legend) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.subtitle) | 0;
    result = result * 31 + Kotlin.hashCode(this.tooltip) | 0;
    return result;
  };
  PluginsOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.legend, other.legend) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.subtitle, other.subtitle) && Kotlin.equals(this.tooltip, other.tooltip)))));
  };
  function toJs_19($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    if ($receiver.legend != null)
      $receiver_0.legend = toJs_6($receiver.legend, i18nTranslator);
    if ($receiver.title != null)
      $receiver_0.title = toJs_7($receiver.title, i18nTranslator);
    if ($receiver.subtitle != null)
      $receiver_0.subtitle = toJs_7($receiver.subtitle, i18nTranslator);
    if ($receiver.tooltip != null)
      $receiver_0.tooltip = toJs_9($receiver.tooltip);
    return $receiver_0;
  }
  function ChartOptions(responsive, aspectRatio, maintainAspectRatio, onResize, resizeDelay, devicePixelRatio, locale, interaction, hover, events, onHover, onClick, animation, animations, transitions, layout, elements, elementsDynamic, scales, scalesDynamic, showLine, spanGaps, cutoutPercentage, circumference, rotation, plugins, pluginsDynamic, datasets) {
    if (responsive === void 0)
      responsive = true;
    if (aspectRatio === void 0)
      aspectRatio = null;
    if (maintainAspectRatio === void 0)
      maintainAspectRatio = true;
    if (onResize === void 0)
      onResize = null;
    if (resizeDelay === void 0)
      resizeDelay = null;
    if (devicePixelRatio === void 0)
      devicePixelRatio = null;
    if (locale === void 0)
      locale = null;
    if (interaction === void 0)
      interaction = null;
    if (hover === void 0)
      hover = null;
    if (events === void 0)
      events = null;
    if (onHover === void 0)
      onHover = null;
    if (onClick === void 0)
      onClick = null;
    if (animation === void 0)
      animation = null;
    if (animations === void 0)
      animations = null;
    if (transitions === void 0)
      transitions = null;
    if (layout === void 0)
      layout = null;
    if (elements === void 0)
      elements = null;
    if (elementsDynamic === void 0)
      elementsDynamic = null;
    if (scales === void 0)
      scales = null;
    if (scalesDynamic === void 0)
      scalesDynamic = null;
    if (showLine === void 0)
      showLine = null;
    if (spanGaps === void 0)
      spanGaps = null;
    if (cutoutPercentage === void 0)
      cutoutPercentage = null;
    if (circumference === void 0)
      circumference = null;
    if (rotation === void 0)
      rotation = null;
    if (plugins === void 0)
      plugins = null;
    if (pluginsDynamic === void 0)
      pluginsDynamic = null;
    if (datasets === void 0)
      datasets = null;
    this.responsive = responsive;
    this.aspectRatio = aspectRatio;
    this.maintainAspectRatio = maintainAspectRatio;
    this.onResize = onResize;
    this.resizeDelay = resizeDelay;
    this.devicePixelRatio = devicePixelRatio;
    this.locale = locale;
    this.interaction = interaction;
    this.hover = hover;
    this.events = events;
    this.onHover = onHover;
    this.onClick = onClick;
    this.animation = animation;
    this.animations = animations;
    this.transitions = transitions;
    this.layout = layout;
    this.elements = elements;
    this.elementsDynamic = elementsDynamic;
    this.scales = scales;
    this.scalesDynamic = scalesDynamic;
    this.showLine = showLine;
    this.spanGaps = spanGaps;
    this.cutoutPercentage = cutoutPercentage;
    this.circumference = circumference;
    this.rotation = rotation;
    this.plugins = plugins;
    this.pluginsDynamic = pluginsDynamic;
    this.datasets = datasets;
  }
  ChartOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChartOptions',
    interfaces: []
  };
  ChartOptions.prototype.component1 = function () {
    return this.responsive;
  };
  ChartOptions.prototype.component2 = function () {
    return this.aspectRatio;
  };
  ChartOptions.prototype.component3 = function () {
    return this.maintainAspectRatio;
  };
  ChartOptions.prototype.component4 = function () {
    return this.onResize;
  };
  ChartOptions.prototype.component5 = function () {
    return this.resizeDelay;
  };
  ChartOptions.prototype.component6 = function () {
    return this.devicePixelRatio;
  };
  ChartOptions.prototype.component7 = function () {
    return this.locale;
  };
  ChartOptions.prototype.component8 = function () {
    return this.interaction;
  };
  ChartOptions.prototype.component9 = function () {
    return this.hover;
  };
  ChartOptions.prototype.component10 = function () {
    return this.events;
  };
  ChartOptions.prototype.component11 = function () {
    return this.onHover;
  };
  ChartOptions.prototype.component12 = function () {
    return this.onClick;
  };
  ChartOptions.prototype.component13 = function () {
    return this.animation;
  };
  ChartOptions.prototype.component14 = function () {
    return this.animations;
  };
  ChartOptions.prototype.component15 = function () {
    return this.transitions;
  };
  ChartOptions.prototype.component16 = function () {
    return this.layout;
  };
  ChartOptions.prototype.component17 = function () {
    return this.elements;
  };
  ChartOptions.prototype.component18 = function () {
    return this.elementsDynamic;
  };
  ChartOptions.prototype.component19 = function () {
    return this.scales;
  };
  ChartOptions.prototype.component20 = function () {
    return this.scalesDynamic;
  };
  ChartOptions.prototype.component21 = function () {
    return this.showLine;
  };
  ChartOptions.prototype.component22 = function () {
    return this.spanGaps;
  };
  ChartOptions.prototype.component23 = function () {
    return this.cutoutPercentage;
  };
  ChartOptions.prototype.component24 = function () {
    return this.circumference;
  };
  ChartOptions.prototype.component25 = function () {
    return this.rotation;
  };
  ChartOptions.prototype.component26 = function () {
    return this.plugins;
  };
  ChartOptions.prototype.component27 = function () {
    return this.pluginsDynamic;
  };
  ChartOptions.prototype.component28 = function () {
    return this.datasets;
  };
  ChartOptions.prototype.copy_b80oz5$ = function (responsive, aspectRatio, maintainAspectRatio, onResize, resizeDelay, devicePixelRatio, locale, interaction, hover, events, onHover, onClick, animation, animations, transitions, layout, elements, elementsDynamic, scales, scalesDynamic, showLine, spanGaps, cutoutPercentage, circumference, rotation, plugins, pluginsDynamic, datasets) {
    return new ChartOptions(responsive === void 0 ? this.responsive : responsive, aspectRatio === void 0 ? this.aspectRatio : aspectRatio, maintainAspectRatio === void 0 ? this.maintainAspectRatio : maintainAspectRatio, onResize === void 0 ? this.onResize : onResize, resizeDelay === void 0 ? this.resizeDelay : resizeDelay, devicePixelRatio === void 0 ? this.devicePixelRatio : devicePixelRatio, locale === void 0 ? this.locale : locale, interaction === void 0 ? this.interaction : interaction, hover === void 0 ? this.hover : hover, events === void 0 ? this.events : events, onHover === void 0 ? this.onHover : onHover, onClick === void 0 ? this.onClick : onClick, animation === void 0 ? this.animation : animation, animations === void 0 ? this.animations : animations, transitions === void 0 ? this.transitions : transitions, layout === void 0 ? this.layout : layout, elements === void 0 ? this.elements : elements, elementsDynamic === void 0 ? this.elementsDynamic : elementsDynamic, scales === void 0 ? this.scales : scales, scalesDynamic === void 0 ? this.scalesDynamic : scalesDynamic, showLine === void 0 ? this.showLine : showLine, spanGaps === void 0 ? this.spanGaps : spanGaps, cutoutPercentage === void 0 ? this.cutoutPercentage : cutoutPercentage, circumference === void 0 ? this.circumference : circumference, rotation === void 0 ? this.rotation : rotation, plugins === void 0 ? this.plugins : plugins, pluginsDynamic === void 0 ? this.pluginsDynamic : pluginsDynamic, datasets === void 0 ? this.datasets : datasets);
  };
  ChartOptions.prototype.toString = function () {
    return 'ChartOptions(responsive=' + Kotlin.toString(this.responsive) + (', aspectRatio=' + Kotlin.toString(this.aspectRatio)) + (', maintainAspectRatio=' + Kotlin.toString(this.maintainAspectRatio)) + (', onResize=' + Kotlin.toString(this.onResize)) + (', resizeDelay=' + Kotlin.toString(this.resizeDelay)) + (', devicePixelRatio=' + Kotlin.toString(this.devicePixelRatio)) + (', locale=' + Kotlin.toString(this.locale)) + (', interaction=' + Kotlin.toString(this.interaction)) + (', hover=' + Kotlin.toString(this.hover)) + (', events=' + Kotlin.toString(this.events)) + (', onHover=' + Kotlin.toString(this.onHover)) + (', onClick=' + Kotlin.toString(this.onClick)) + (', animation=' + Kotlin.toString(this.animation)) + (', animations=' + Kotlin.toString(this.animations)) + (', transitions=' + Kotlin.toString(this.transitions)) + (', layout=' + Kotlin.toString(this.layout)) + (', elements=' + Kotlin.toString(this.elements)) + (', elementsDynamic=' + Kotlin.toString(this.elementsDynamic)) + (', scales=' + Kotlin.toString(this.scales)) + (', scalesDynamic=' + Kotlin.toString(this.scalesDynamic)) + (', showLine=' + Kotlin.toString(this.showLine)) + (', spanGaps=' + Kotlin.toString(this.spanGaps)) + (', cutoutPercentage=' + Kotlin.toString(this.cutoutPercentage)) + (', circumference=' + Kotlin.toString(this.circumference)) + (', rotation=' + Kotlin.toString(this.rotation)) + (', plugins=' + Kotlin.toString(this.plugins)) + (', pluginsDynamic=' + Kotlin.toString(this.pluginsDynamic)) + (', datasets=' + Kotlin.toString(this.datasets)) + ')';
  };
  ChartOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.responsive) | 0;
    result = result * 31 + Kotlin.hashCode(this.aspectRatio) | 0;
    result = result * 31 + Kotlin.hashCode(this.maintainAspectRatio) | 0;
    result = result * 31 + Kotlin.hashCode(this.onResize) | 0;
    result = result * 31 + Kotlin.hashCode(this.resizeDelay) | 0;
    result = result * 31 + Kotlin.hashCode(this.devicePixelRatio) | 0;
    result = result * 31 + Kotlin.hashCode(this.locale) | 0;
    result = result * 31 + Kotlin.hashCode(this.interaction) | 0;
    result = result * 31 + Kotlin.hashCode(this.hover) | 0;
    result = result * 31 + Kotlin.hashCode(this.events) | 0;
    result = result * 31 + Kotlin.hashCode(this.onHover) | 0;
    result = result * 31 + Kotlin.hashCode(this.onClick) | 0;
    result = result * 31 + Kotlin.hashCode(this.animation) | 0;
    result = result * 31 + Kotlin.hashCode(this.animations) | 0;
    result = result * 31 + Kotlin.hashCode(this.transitions) | 0;
    result = result * 31 + Kotlin.hashCode(this.layout) | 0;
    result = result * 31 + Kotlin.hashCode(this.elements) | 0;
    result = result * 31 + Kotlin.hashCode(this.elementsDynamic) | 0;
    result = result * 31 + Kotlin.hashCode(this.scales) | 0;
    result = result * 31 + Kotlin.hashCode(this.scalesDynamic) | 0;
    result = result * 31 + Kotlin.hashCode(this.showLine) | 0;
    result = result * 31 + Kotlin.hashCode(this.spanGaps) | 0;
    result = result * 31 + Kotlin.hashCode(this.cutoutPercentage) | 0;
    result = result * 31 + Kotlin.hashCode(this.circumference) | 0;
    result = result * 31 + Kotlin.hashCode(this.rotation) | 0;
    result = result * 31 + Kotlin.hashCode(this.plugins) | 0;
    result = result * 31 + Kotlin.hashCode(this.pluginsDynamic) | 0;
    result = result * 31 + Kotlin.hashCode(this.datasets) | 0;
    return result;
  };
  ChartOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.responsive, other.responsive) && Kotlin.equals(this.aspectRatio, other.aspectRatio) && Kotlin.equals(this.maintainAspectRatio, other.maintainAspectRatio) && Kotlin.equals(this.onResize, other.onResize) && Kotlin.equals(this.resizeDelay, other.resizeDelay) && Kotlin.equals(this.devicePixelRatio, other.devicePixelRatio) && Kotlin.equals(this.locale, other.locale) && Kotlin.equals(this.interaction, other.interaction) && Kotlin.equals(this.hover, other.hover) && Kotlin.equals(this.events, other.events) && Kotlin.equals(this.onHover, other.onHover) && Kotlin.equals(this.onClick, other.onClick) && Kotlin.equals(this.animation, other.animation) && Kotlin.equals(this.animations, other.animations) && Kotlin.equals(this.transitions, other.transitions) && Kotlin.equals(this.layout, other.layout) && Kotlin.equals(this.elements, other.elements) && Kotlin.equals(this.elementsDynamic, other.elementsDynamic) && Kotlin.equals(this.scales, other.scales) && Kotlin.equals(this.scalesDynamic, other.scalesDynamic) && Kotlin.equals(this.showLine, other.showLine) && Kotlin.equals(this.spanGaps, other.spanGaps) && Kotlin.equals(this.cutoutPercentage, other.cutoutPercentage) && Kotlin.equals(this.circumference, other.circumference) && Kotlin.equals(this.rotation, other.rotation) && Kotlin.equals(this.plugins, other.plugins) && Kotlin.equals(this.pluginsDynamic, other.pluginsDynamic) && Kotlin.equals(this.datasets, other.datasets)))));
  };
  function toJs_20($receiver, i18nTranslator) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if ($receiver.elementsDynamic != null) {
      if ($receiver.elements == null) {
        tmp$_0 = $receiver.elementsDynamic;
      } else {
        tmp$_0 = Object.assign($receiver.elementsDynamic, toJs_14($receiver.elements));
      }
    } else {
      tmp$_0 = (tmp$ = $receiver.elements) != null ? toJs_14(tmp$) : null;
    }
    var elementsTmp = tmp$_0;
    if ($receiver.scalesDynamic != null) {
      if ($receiver.scales == null) {
        tmp$_1 = $receiver.scalesDynamic;
      } else {
        var s = {};
        var tmp$_4;
        tmp$_4 = $receiver.scales.entries.iterator();
        while (tmp$_4.hasNext()) {
          var element = tmp$_4.next();
          s[element.key] = toJs_18(element.value, i18nTranslator);
        }
        tmp$_1 = Object.assign($receiver.scalesDynamic, s);
      }
    } else if ($receiver.scales != null) {
      var s_0 = {};
      var tmp$_5;
      tmp$_5 = $receiver.scales.entries.iterator();
      while (tmp$_5.hasNext()) {
        var element_0 = tmp$_5.next();
        s_0[element_0.key] = toJs_18(element_0.value, i18nTranslator);
      }
      tmp$_1 = s_0;
    } else
      tmp$_1 = null;
    var scalesTmp = tmp$_1;
    if ($receiver.pluginsDynamic != null) {
      if ($receiver.plugins == null) {
        tmp$_3 = $receiver.pluginsDynamic;
      } else {
        tmp$_3 = Object.assign($receiver.pluginsDynamic, toJs_19($receiver.plugins, i18nTranslator));
      }
    } else {
      tmp$_3 = (tmp$_2 = $receiver.plugins) != null ? toJs_19(tmp$_2, i18nTranslator) : null;
    }
    var pluginsTmp = tmp$_3;
    var $receiver_0 = new Object_init();
    var tmp$_6;
    $receiver_0.responsive = $receiver.responsive;
    $receiver_0.responsiveAnimationDuration = $receiver_0.responsiveAnimationDuration;
    if ($receiver.aspectRatio != null)
      $receiver_0.aspectRatio = $receiver.aspectRatio;
    $receiver_0.maintainAspectRatio = $receiver.maintainAspectRatio;
    if ($receiver.onResize != null)
      $receiver_0.onResize = $receiver.onResize;
    if ($receiver.resizeDelay != null)
      $receiver_0.resizeDelay = $receiver.resizeDelay;
    if ($receiver.devicePixelRatio != null)
      $receiver_0.devicePixelRatio = $receiver.devicePixelRatio;
    $receiver_0.locale = (tmp$_6 = $receiver.locale) != null ? tmp$_6 : i18n.I18n.language;
    if ($receiver.interaction != null)
      $receiver_0.interaction = toJs_0($receiver.interaction);
    if ($receiver.hover != null)
      $receiver_0.hover = toJs_0($receiver.hover);
    if ($receiver.events != null) {
      $receiver_0.events = copyToArray($receiver.events);
    }
    if ($receiver.onHover != null)
      $receiver_0.onHover = $receiver.onHover;
    if ($receiver.onClick != null)
      $receiver_0.onClick = $receiver.onClick;
    if ($receiver.animation != null)
      $receiver_0.animation = toJs_1($receiver.animation);
    if ($receiver.animations != null)
      $receiver_0.animations = $receiver.animations;
    if ($receiver.transitions != null)
      $receiver_0.transitions = $receiver.transitions;
    if ($receiver.layout != null)
      $receiver_0.layout = toJs_3($receiver.layout);
    if (elementsTmp != null)
      $receiver_0.elements = elementsTmp;
    if (scalesTmp != null)
      $receiver_0.scales = scalesTmp;
    if ($receiver.showLine != null)
      $receiver_0.showLine = $receiver.showLine;
    if ($receiver.spanGaps != null)
      $receiver_0.spanGaps = $receiver.spanGaps;
    if ($receiver.cutoutPercentage != null)
      $receiver_0.cutoutPercentage = $receiver.cutoutPercentage;
    if ($receiver.circumference != null)
      $receiver_0.circumference = $receiver.circumference;
    if ($receiver.rotation != null)
      $receiver_0.rotation = $receiver.rotation;
    if (pluginsTmp != null)
      $receiver_0.plugins = pluginsTmp;
    if ($receiver.datasets != null)
      $receiver_0.datasets = $receiver.datasets;
    return $receiver_0;
  }
  function DataSets(cubicInterpolationMode, backgroundColor, borderWidth, borderColor, borderCapStyle, borderDash, borderDashOffset, borderJoinStyle, borderSkipped, clip, data, fill, hoverBackgroundColor, hoverBorderColor, hoverBorderWidth, hoverBorderCapStyle, hoverBorderDash, hoverBorderDashOffset, hoverBorderJoinStyle, indexAxis, label, order, pointBorderColor, pointBackgroundColor, pointBorderWidth, pointRadius, pointHoverRadius, pointHitRadius, pointHoverBackgroundColor, pointHoverBorderColor, pointHoverBorderWidth, pointRotation, pointStyle, segment, showLine, spanGaps, stack, stepped, tension, xAxisID, yAxisID, base, barPercentage, barThickness, borderRadius, categoryPercentage, grouped, hoverBorderRadius, inflateAmount, maxBarThickness, minBarLegth, skipNull, circumference, offset, rotation, spacing, weight, hitRadius, hoverRadius, radius, borderAlign, cutout, animation, drawActiveElementsOnTop, circular) {
    if (cubicInterpolationMode === void 0)
      cubicInterpolationMode = null;
    if (backgroundColor === void 0)
      backgroundColor = null;
    if (borderWidth === void 0)
      borderWidth = null;
    if (borderColor === void 0)
      borderColor = null;
    if (borderCapStyle === void 0)
      borderCapStyle = null;
    if (borderDash === void 0)
      borderDash = null;
    if (borderDashOffset === void 0)
      borderDashOffset = null;
    if (borderJoinStyle === void 0)
      borderJoinStyle = null;
    if (borderSkipped === void 0)
      borderSkipped = null;
    if (clip === void 0)
      clip = null;
    if (data === void 0)
      data = null;
    if (fill === void 0)
      fill = null;
    if (hoverBackgroundColor === void 0)
      hoverBackgroundColor = null;
    if (hoverBorderColor === void 0)
      hoverBorderColor = null;
    if (hoverBorderWidth === void 0)
      hoverBorderWidth = null;
    if (hoverBorderCapStyle === void 0)
      hoverBorderCapStyle = null;
    if (hoverBorderDash === void 0)
      hoverBorderDash = null;
    if (hoverBorderDashOffset === void 0)
      hoverBorderDashOffset = null;
    if (hoverBorderJoinStyle === void 0)
      hoverBorderJoinStyle = null;
    if (indexAxis === void 0)
      indexAxis = null;
    if (label === void 0)
      label = null;
    if (order === void 0)
      order = null;
    if (pointBorderColor === void 0)
      pointBorderColor = null;
    if (pointBackgroundColor === void 0)
      pointBackgroundColor = null;
    if (pointBorderWidth === void 0)
      pointBorderWidth = null;
    if (pointRadius === void 0)
      pointRadius = null;
    if (pointHoverRadius === void 0)
      pointHoverRadius = null;
    if (pointHitRadius === void 0)
      pointHitRadius = null;
    if (pointHoverBackgroundColor === void 0)
      pointHoverBackgroundColor = null;
    if (pointHoverBorderColor === void 0)
      pointHoverBorderColor = null;
    if (pointHoverBorderWidth === void 0)
      pointHoverBorderWidth = null;
    if (pointRotation === void 0)
      pointRotation = null;
    if (pointStyle === void 0)
      pointStyle = null;
    if (segment === void 0)
      segment = null;
    if (showLine === void 0)
      showLine = null;
    if (spanGaps === void 0)
      spanGaps = null;
    if (stack === void 0)
      stack = null;
    if (stepped === void 0)
      stepped = null;
    if (tension === void 0)
      tension = null;
    if (xAxisID === void 0)
      xAxisID = null;
    if (yAxisID === void 0)
      yAxisID = null;
    if (base === void 0)
      base = null;
    if (barPercentage === void 0)
      barPercentage = null;
    if (barThickness === void 0)
      barThickness = null;
    if (borderRadius === void 0)
      borderRadius = null;
    if (categoryPercentage === void 0)
      categoryPercentage = null;
    if (grouped === void 0)
      grouped = null;
    if (hoverBorderRadius === void 0)
      hoverBorderRadius = null;
    if (inflateAmount === void 0)
      inflateAmount = null;
    if (maxBarThickness === void 0)
      maxBarThickness = null;
    if (minBarLegth === void 0)
      minBarLegth = null;
    if (skipNull === void 0)
      skipNull = null;
    if (circumference === void 0)
      circumference = null;
    if (offset === void 0)
      offset = null;
    if (rotation === void 0)
      rotation = null;
    if (spacing === void 0)
      spacing = null;
    if (weight === void 0)
      weight = null;
    if (hitRadius === void 0)
      hitRadius = null;
    if (hoverRadius === void 0)
      hoverRadius = null;
    if (radius === void 0)
      radius = null;
    if (borderAlign === void 0)
      borderAlign = null;
    if (cutout === void 0)
      cutout = null;
    if (animation === void 0)
      animation = null;
    if (drawActiveElementsOnTop === void 0)
      drawActiveElementsOnTop = null;
    if (circular === void 0)
      circular = null;
    this.cubicInterpolationMode = cubicInterpolationMode;
    this.backgroundColor = backgroundColor;
    this.borderWidth = borderWidth;
    this.borderColor = borderColor;
    this.borderCapStyle = borderCapStyle;
    this.borderDash = borderDash;
    this.borderDashOffset = borderDashOffset;
    this.borderJoinStyle = borderJoinStyle;
    this.borderSkipped = borderSkipped;
    this.clip = clip;
    this.data = data;
    this.fill = fill;
    this.hoverBackgroundColor = hoverBackgroundColor;
    this.hoverBorderColor = hoverBorderColor;
    this.hoverBorderWidth = hoverBorderWidth;
    this.hoverBorderCapStyle = hoverBorderCapStyle;
    this.hoverBorderDash = hoverBorderDash;
    this.hoverBorderDashOffset = hoverBorderDashOffset;
    this.hoverBorderJoinStyle = hoverBorderJoinStyle;
    this.indexAxis = indexAxis;
    this.label = label;
    this.order = order;
    this.pointBorderColor = pointBorderColor;
    this.pointBackgroundColor = pointBackgroundColor;
    this.pointBorderWidth = pointBorderWidth;
    this.pointRadius = pointRadius;
    this.pointHoverRadius = pointHoverRadius;
    this.pointHitRadius = pointHitRadius;
    this.pointHoverBackgroundColor = pointHoverBackgroundColor;
    this.pointHoverBorderColor = pointHoverBorderColor;
    this.pointHoverBorderWidth = pointHoverBorderWidth;
    this.pointRotation = pointRotation;
    this.pointStyle = pointStyle;
    this.segment = segment;
    this.showLine = showLine;
    this.spanGaps = spanGaps;
    this.stack = stack;
    this.stepped = stepped;
    this.tension = tension;
    this.xAxisID = xAxisID;
    this.yAxisID = yAxisID;
    this.base = base;
    this.barPercentage = barPercentage;
    this.barThickness = barThickness;
    this.borderRadius = borderRadius;
    this.categoryPercentage = categoryPercentage;
    this.grouped = grouped;
    this.hoverBorderRadius = hoverBorderRadius;
    this.inflateAmount = inflateAmount;
    this.maxBarThickness = maxBarThickness;
    this.minBarLegth = minBarLegth;
    this.skipNull = skipNull;
    this.circumference = circumference;
    this.offset = offset;
    this.rotation = rotation;
    this.spacing = spacing;
    this.weight = weight;
    this.hitRadius = hitRadius;
    this.hoverRadius = hoverRadius;
    this.radius = radius;
    this.borderAlign = borderAlign;
    this.cutout = cutout;
    this.animation = animation;
    this.drawActiveElementsOnTop = drawActiveElementsOnTop;
    this.circular = circular;
  }
  DataSets.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DataSets',
    interfaces: []
  };
  DataSets.prototype.component1 = function () {
    return this.cubicInterpolationMode;
  };
  DataSets.prototype.component2 = function () {
    return this.backgroundColor;
  };
  DataSets.prototype.component3 = function () {
    return this.borderWidth;
  };
  DataSets.prototype.component4 = function () {
    return this.borderColor;
  };
  DataSets.prototype.component5 = function () {
    return this.borderCapStyle;
  };
  DataSets.prototype.component6 = function () {
    return this.borderDash;
  };
  DataSets.prototype.component7 = function () {
    return this.borderDashOffset;
  };
  DataSets.prototype.component8 = function () {
    return this.borderJoinStyle;
  };
  DataSets.prototype.component9 = function () {
    return this.borderSkipped;
  };
  DataSets.prototype.component10 = function () {
    return this.clip;
  };
  DataSets.prototype.component11 = function () {
    return this.data;
  };
  DataSets.prototype.component12 = function () {
    return this.fill;
  };
  DataSets.prototype.component13 = function () {
    return this.hoverBackgroundColor;
  };
  DataSets.prototype.component14 = function () {
    return this.hoverBorderColor;
  };
  DataSets.prototype.component15 = function () {
    return this.hoverBorderWidth;
  };
  DataSets.prototype.component16 = function () {
    return this.hoverBorderCapStyle;
  };
  DataSets.prototype.component17 = function () {
    return this.hoverBorderDash;
  };
  DataSets.prototype.component18 = function () {
    return this.hoverBorderDashOffset;
  };
  DataSets.prototype.component19 = function () {
    return this.hoverBorderJoinStyle;
  };
  DataSets.prototype.component20 = function () {
    return this.indexAxis;
  };
  DataSets.prototype.component21 = function () {
    return this.label;
  };
  DataSets.prototype.component22 = function () {
    return this.order;
  };
  DataSets.prototype.component23 = function () {
    return this.pointBorderColor;
  };
  DataSets.prototype.component24 = function () {
    return this.pointBackgroundColor;
  };
  DataSets.prototype.component25 = function () {
    return this.pointBorderWidth;
  };
  DataSets.prototype.component26 = function () {
    return this.pointRadius;
  };
  DataSets.prototype.component27 = function () {
    return this.pointHoverRadius;
  };
  DataSets.prototype.component28 = function () {
    return this.pointHitRadius;
  };
  DataSets.prototype.component29 = function () {
    return this.pointHoverBackgroundColor;
  };
  DataSets.prototype.component30 = function () {
    return this.pointHoverBorderColor;
  };
  DataSets.prototype.component31 = function () {
    return this.pointHoverBorderWidth;
  };
  DataSets.prototype.component32 = function () {
    return this.pointRotation;
  };
  DataSets.prototype.component33 = function () {
    return this.pointStyle;
  };
  DataSets.prototype.component34 = function () {
    return this.segment;
  };
  DataSets.prototype.component35 = function () {
    return this.showLine;
  };
  DataSets.prototype.component36 = function () {
    return this.spanGaps;
  };
  DataSets.prototype.component37 = function () {
    return this.stack;
  };
  DataSets.prototype.component38 = function () {
    return this.stepped;
  };
  DataSets.prototype.component39 = function () {
    return this.tension;
  };
  DataSets.prototype.component40 = function () {
    return this.xAxisID;
  };
  DataSets.prototype.component41 = function () {
    return this.yAxisID;
  };
  DataSets.prototype.component42 = function () {
    return this.base;
  };
  DataSets.prototype.component43 = function () {
    return this.barPercentage;
  };
  DataSets.prototype.component44 = function () {
    return this.barThickness;
  };
  DataSets.prototype.component45 = function () {
    return this.borderRadius;
  };
  DataSets.prototype.component46 = function () {
    return this.categoryPercentage;
  };
  DataSets.prototype.component47 = function () {
    return this.grouped;
  };
  DataSets.prototype.component48 = function () {
    return this.hoverBorderRadius;
  };
  DataSets.prototype.component49 = function () {
    return this.inflateAmount;
  };
  DataSets.prototype.component50 = function () {
    return this.maxBarThickness;
  };
  DataSets.prototype.component51 = function () {
    return this.minBarLegth;
  };
  DataSets.prototype.component52 = function () {
    return this.skipNull;
  };
  DataSets.prototype.component53 = function () {
    return this.circumference;
  };
  DataSets.prototype.component54 = function () {
    return this.offset;
  };
  DataSets.prototype.component55 = function () {
    return this.rotation;
  };
  DataSets.prototype.component56 = function () {
    return this.spacing;
  };
  DataSets.prototype.component57 = function () {
    return this.weight;
  };
  DataSets.prototype.component58 = function () {
    return this.hitRadius;
  };
  DataSets.prototype.component59 = function () {
    return this.hoverRadius;
  };
  DataSets.prototype.component60 = function () {
    return this.radius;
  };
  DataSets.prototype.component61 = function () {
    return this.borderAlign;
  };
  DataSets.prototype.component62 = function () {
    return this.cutout;
  };
  DataSets.prototype.component63 = function () {
    return this.animation;
  };
  DataSets.prototype.component64 = function () {
    return this.drawActiveElementsOnTop;
  };
  DataSets.prototype.component65 = function () {
    return this.circular;
  };
  DataSets.prototype.copy_20i9ko$ = function (cubicInterpolationMode, backgroundColor, borderWidth, borderColor, borderCapStyle, borderDash, borderDashOffset, borderJoinStyle, borderSkipped, clip, data, fill, hoverBackgroundColor, hoverBorderColor, hoverBorderWidth, hoverBorderCapStyle, hoverBorderDash, hoverBorderDashOffset, hoverBorderJoinStyle, indexAxis, label, order, pointBorderColor, pointBackgroundColor, pointBorderWidth, pointRadius, pointHoverRadius, pointHitRadius, pointHoverBackgroundColor, pointHoverBorderColor, pointHoverBorderWidth, pointRotation, pointStyle, segment, showLine, spanGaps, stack, stepped, tension, xAxisID, yAxisID, base, barPercentage, barThickness, borderRadius, categoryPercentage, grouped, hoverBorderRadius, inflateAmount, maxBarThickness, minBarLegth, skipNull, circumference, offset, rotation, spacing, weight, hitRadius, hoverRadius, radius, borderAlign, cutout, animation, drawActiveElementsOnTop, circular) {
    return new DataSets(cubicInterpolationMode === void 0 ? this.cubicInterpolationMode : cubicInterpolationMode, backgroundColor === void 0 ? this.backgroundColor : backgroundColor, borderWidth === void 0 ? this.borderWidth : borderWidth, borderColor === void 0 ? this.borderColor : borderColor, borderCapStyle === void 0 ? this.borderCapStyle : borderCapStyle, borderDash === void 0 ? this.borderDash : borderDash, borderDashOffset === void 0 ? this.borderDashOffset : borderDashOffset, borderJoinStyle === void 0 ? this.borderJoinStyle : borderJoinStyle, borderSkipped === void 0 ? this.borderSkipped : borderSkipped, clip === void 0 ? this.clip : clip, data === void 0 ? this.data : data, fill === void 0 ? this.fill : fill, hoverBackgroundColor === void 0 ? this.hoverBackgroundColor : hoverBackgroundColor, hoverBorderColor === void 0 ? this.hoverBorderColor : hoverBorderColor, hoverBorderWidth === void 0 ? this.hoverBorderWidth : hoverBorderWidth, hoverBorderCapStyle === void 0 ? this.hoverBorderCapStyle : hoverBorderCapStyle, hoverBorderDash === void 0 ? this.hoverBorderDash : hoverBorderDash, hoverBorderDashOffset === void 0 ? this.hoverBorderDashOffset : hoverBorderDashOffset, hoverBorderJoinStyle === void 0 ? this.hoverBorderJoinStyle : hoverBorderJoinStyle, indexAxis === void 0 ? this.indexAxis : indexAxis, label === void 0 ? this.label : label, order === void 0 ? this.order : order, pointBorderColor === void 0 ? this.pointBorderColor : pointBorderColor, pointBackgroundColor === void 0 ? this.pointBackgroundColor : pointBackgroundColor, pointBorderWidth === void 0 ? this.pointBorderWidth : pointBorderWidth, pointRadius === void 0 ? this.pointRadius : pointRadius, pointHoverRadius === void 0 ? this.pointHoverRadius : pointHoverRadius, pointHitRadius === void 0 ? this.pointHitRadius : pointHitRadius, pointHoverBackgroundColor === void 0 ? this.pointHoverBackgroundColor : pointHoverBackgroundColor, pointHoverBorderColor === void 0 ? this.pointHoverBorderColor : pointHoverBorderColor, pointHoverBorderWidth === void 0 ? this.pointHoverBorderWidth : pointHoverBorderWidth, pointRotation === void 0 ? this.pointRotation : pointRotation, pointStyle === void 0 ? this.pointStyle : pointStyle, segment === void 0 ? this.segment : segment, showLine === void 0 ? this.showLine : showLine, spanGaps === void 0 ? this.spanGaps : spanGaps, stack === void 0 ? this.stack : stack, stepped === void 0 ? this.stepped : stepped, tension === void 0 ? this.tension : tension, xAxisID === void 0 ? this.xAxisID : xAxisID, yAxisID === void 0 ? this.yAxisID : yAxisID, base === void 0 ? this.base : base, barPercentage === void 0 ? this.barPercentage : barPercentage, barThickness === void 0 ? this.barThickness : barThickness, borderRadius === void 0 ? this.borderRadius : borderRadius, categoryPercentage === void 0 ? this.categoryPercentage : categoryPercentage, grouped === void 0 ? this.grouped : grouped, hoverBorderRadius === void 0 ? this.hoverBorderRadius : hoverBorderRadius, inflateAmount === void 0 ? this.inflateAmount : inflateAmount, maxBarThickness === void 0 ? this.maxBarThickness : maxBarThickness, minBarLegth === void 0 ? this.minBarLegth : minBarLegth, skipNull === void 0 ? this.skipNull : skipNull, circumference === void 0 ? this.circumference : circumference, offset === void 0 ? this.offset : offset, rotation === void 0 ? this.rotation : rotation, spacing === void 0 ? this.spacing : spacing, weight === void 0 ? this.weight : weight, hitRadius === void 0 ? this.hitRadius : hitRadius, hoverRadius === void 0 ? this.hoverRadius : hoverRadius, radius === void 0 ? this.radius : radius, borderAlign === void 0 ? this.borderAlign : borderAlign, cutout === void 0 ? this.cutout : cutout, animation === void 0 ? this.animation : animation, drawActiveElementsOnTop === void 0 ? this.drawActiveElementsOnTop : drawActiveElementsOnTop, circular === void 0 ? this.circular : circular);
  };
  DataSets.prototype.toString = function () {
    return 'DataSets(cubicInterpolationMode=' + Kotlin.toString(this.cubicInterpolationMode) + (', backgroundColor=' + Kotlin.toString(this.backgroundColor)) + (', borderWidth=' + Kotlin.toString(this.borderWidth)) + (', borderColor=' + Kotlin.toString(this.borderColor)) + (', borderCapStyle=' + Kotlin.toString(this.borderCapStyle)) + (', borderDash=' + Kotlin.toString(this.borderDash)) + (', borderDashOffset=' + Kotlin.toString(this.borderDashOffset)) + (', borderJoinStyle=' + Kotlin.toString(this.borderJoinStyle)) + (', borderSkipped=' + Kotlin.toString(this.borderSkipped)) + (', clip=' + Kotlin.toString(this.clip)) + (', data=' + Kotlin.toString(this.data)) + (', fill=' + Kotlin.toString(this.fill)) + (', hoverBackgroundColor=' + Kotlin.toString(this.hoverBackgroundColor)) + (', hoverBorderColor=' + Kotlin.toString(this.hoverBorderColor)) + (', hoverBorderWidth=' + Kotlin.toString(this.hoverBorderWidth)) + (', hoverBorderCapStyle=' + Kotlin.toString(this.hoverBorderCapStyle)) + (', hoverBorderDash=' + Kotlin.toString(this.hoverBorderDash)) + (', hoverBorderDashOffset=' + Kotlin.toString(this.hoverBorderDashOffset)) + (', hoverBorderJoinStyle=' + Kotlin.toString(this.hoverBorderJoinStyle)) + (', indexAxis=' + Kotlin.toString(this.indexAxis)) + (', label=' + Kotlin.toString(this.label)) + (', order=' + Kotlin.toString(this.order)) + (', pointBorderColor=' + Kotlin.toString(this.pointBorderColor)) + (', pointBackgroundColor=' + Kotlin.toString(this.pointBackgroundColor)) + (', pointBorderWidth=' + Kotlin.toString(this.pointBorderWidth)) + (', pointRadius=' + Kotlin.toString(this.pointRadius)) + (', pointHoverRadius=' + Kotlin.toString(this.pointHoverRadius)) + (', pointHitRadius=' + Kotlin.toString(this.pointHitRadius)) + (', pointHoverBackgroundColor=' + Kotlin.toString(this.pointHoverBackgroundColor)) + (', pointHoverBorderColor=' + Kotlin.toString(this.pointHoverBorderColor)) + (', pointHoverBorderWidth=' + Kotlin.toString(this.pointHoverBorderWidth)) + (', pointRotation=' + Kotlin.toString(this.pointRotation)) + (', pointStyle=' + Kotlin.toString(this.pointStyle)) + (', segment=' + Kotlin.toString(this.segment)) + (', showLine=' + Kotlin.toString(this.showLine)) + (', spanGaps=' + Kotlin.toString(this.spanGaps)) + (', stack=' + Kotlin.toString(this.stack)) + (', stepped=' + Kotlin.toString(this.stepped)) + (', tension=' + Kotlin.toString(this.tension)) + (', xAxisID=' + Kotlin.toString(this.xAxisID)) + (', yAxisID=' + Kotlin.toString(this.yAxisID)) + (', base=' + Kotlin.toString(this.base)) + (', barPercentage=' + Kotlin.toString(this.barPercentage)) + (', barThickness=' + Kotlin.toString(this.barThickness)) + (', borderRadius=' + Kotlin.toString(this.borderRadius)) + (', categoryPercentage=' + Kotlin.toString(this.categoryPercentage)) + (', grouped=' + Kotlin.toString(this.grouped)) + (', hoverBorderRadius=' + Kotlin.toString(this.hoverBorderRadius)) + (', inflateAmount=' + Kotlin.toString(this.inflateAmount)) + (', maxBarThickness=' + Kotlin.toString(this.maxBarThickness)) + (', minBarLegth=' + Kotlin.toString(this.minBarLegth)) + (', skipNull=' + Kotlin.toString(this.skipNull)) + (', circumference=' + Kotlin.toString(this.circumference)) + (', offset=' + Kotlin.toString(this.offset)) + (', rotation=' + Kotlin.toString(this.rotation)) + (', spacing=' + Kotlin.toString(this.spacing)) + (', weight=' + Kotlin.toString(this.weight)) + (', hitRadius=' + Kotlin.toString(this.hitRadius)) + (', hoverRadius=' + Kotlin.toString(this.hoverRadius)) + (', radius=' + Kotlin.toString(this.radius)) + (', borderAlign=' + Kotlin.toString(this.borderAlign)) + (', cutout=' + Kotlin.toString(this.cutout)) + (', animation=' + Kotlin.toString(this.animation)) + (', drawActiveElementsOnTop=' + Kotlin.toString(this.drawActiveElementsOnTop)) + (', circular=' + Kotlin.toString(this.circular)) + ')';
  };
  DataSets.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.cubicInterpolationMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.backgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderCapStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderDash) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderDashOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderJoinStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderSkipped) | 0;
    result = result * 31 + Kotlin.hashCode(this.clip) | 0;
    result = result * 31 + Kotlin.hashCode(this.data) | 0;
    result = result * 31 + Kotlin.hashCode(this.fill) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBackgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderCapStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderDash) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderDashOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderJoinStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.indexAxis) | 0;
    result = result * 31 + Kotlin.hashCode(this.label) | 0;
    result = result * 31 + Kotlin.hashCode(this.order) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointBorderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointBackgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointBorderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointHoverRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointHitRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointHoverBackgroundColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointHoverBorderColor) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointHoverBorderWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointRotation) | 0;
    result = result * 31 + Kotlin.hashCode(this.pointStyle) | 0;
    result = result * 31 + Kotlin.hashCode(this.segment) | 0;
    result = result * 31 + Kotlin.hashCode(this.showLine) | 0;
    result = result * 31 + Kotlin.hashCode(this.spanGaps) | 0;
    result = result * 31 + Kotlin.hashCode(this.stack) | 0;
    result = result * 31 + Kotlin.hashCode(this.stepped) | 0;
    result = result * 31 + Kotlin.hashCode(this.tension) | 0;
    result = result * 31 + Kotlin.hashCode(this.xAxisID) | 0;
    result = result * 31 + Kotlin.hashCode(this.yAxisID) | 0;
    result = result * 31 + Kotlin.hashCode(this.base) | 0;
    result = result * 31 + Kotlin.hashCode(this.barPercentage) | 0;
    result = result * 31 + Kotlin.hashCode(this.barThickness) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.categoryPercentage) | 0;
    result = result * 31 + Kotlin.hashCode(this.grouped) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverBorderRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.inflateAmount) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxBarThickness) | 0;
    result = result * 31 + Kotlin.hashCode(this.minBarLegth) | 0;
    result = result * 31 + Kotlin.hashCode(this.skipNull) | 0;
    result = result * 31 + Kotlin.hashCode(this.circumference) | 0;
    result = result * 31 + Kotlin.hashCode(this.offset) | 0;
    result = result * 31 + Kotlin.hashCode(this.rotation) | 0;
    result = result * 31 + Kotlin.hashCode(this.spacing) | 0;
    result = result * 31 + Kotlin.hashCode(this.weight) | 0;
    result = result * 31 + Kotlin.hashCode(this.hitRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.hoverRadius) | 0;
    result = result * 31 + Kotlin.hashCode(this.radius) | 0;
    result = result * 31 + Kotlin.hashCode(this.borderAlign) | 0;
    result = result * 31 + Kotlin.hashCode(this.cutout) | 0;
    result = result * 31 + Kotlin.hashCode(this.animation) | 0;
    result = result * 31 + Kotlin.hashCode(this.drawActiveElementsOnTop) | 0;
    result = result * 31 + Kotlin.hashCode(this.circular) | 0;
    return result;
  };
  DataSets.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.cubicInterpolationMode, other.cubicInterpolationMode) && Kotlin.equals(this.backgroundColor, other.backgroundColor) && Kotlin.equals(this.borderWidth, other.borderWidth) && Kotlin.equals(this.borderColor, other.borderColor) && Kotlin.equals(this.borderCapStyle, other.borderCapStyle) && Kotlin.equals(this.borderDash, other.borderDash) && Kotlin.equals(this.borderDashOffset, other.borderDashOffset) && Kotlin.equals(this.borderJoinStyle, other.borderJoinStyle) && Kotlin.equals(this.borderSkipped, other.borderSkipped) && Kotlin.equals(this.clip, other.clip) && Kotlin.equals(this.data, other.data) && Kotlin.equals(this.fill, other.fill) && Kotlin.equals(this.hoverBackgroundColor, other.hoverBackgroundColor) && Kotlin.equals(this.hoverBorderColor, other.hoverBorderColor) && Kotlin.equals(this.hoverBorderWidth, other.hoverBorderWidth) && Kotlin.equals(this.hoverBorderCapStyle, other.hoverBorderCapStyle) && Kotlin.equals(this.hoverBorderDash, other.hoverBorderDash) && Kotlin.equals(this.hoverBorderDashOffset, other.hoverBorderDashOffset) && Kotlin.equals(this.hoverBorderJoinStyle, other.hoverBorderJoinStyle) && Kotlin.equals(this.indexAxis, other.indexAxis) && Kotlin.equals(this.label, other.label) && Kotlin.equals(this.order, other.order) && Kotlin.equals(this.pointBorderColor, other.pointBorderColor) && Kotlin.equals(this.pointBackgroundColor, other.pointBackgroundColor) && Kotlin.equals(this.pointBorderWidth, other.pointBorderWidth) && Kotlin.equals(this.pointRadius, other.pointRadius) && Kotlin.equals(this.pointHoverRadius, other.pointHoverRadius) && Kotlin.equals(this.pointHitRadius, other.pointHitRadius) && Kotlin.equals(this.pointHoverBackgroundColor, other.pointHoverBackgroundColor) && Kotlin.equals(this.pointHoverBorderColor, other.pointHoverBorderColor) && Kotlin.equals(this.pointHoverBorderWidth, other.pointHoverBorderWidth) && Kotlin.equals(this.pointRotation, other.pointRotation) && Kotlin.equals(this.pointStyle, other.pointStyle) && Kotlin.equals(this.segment, other.segment) && Kotlin.equals(this.showLine, other.showLine) && Kotlin.equals(this.spanGaps, other.spanGaps) && Kotlin.equals(this.stack, other.stack) && Kotlin.equals(this.stepped, other.stepped) && Kotlin.equals(this.tension, other.tension) && Kotlin.equals(this.xAxisID, other.xAxisID) && Kotlin.equals(this.yAxisID, other.yAxisID) && Kotlin.equals(this.base, other.base) && Kotlin.equals(this.barPercentage, other.barPercentage) && Kotlin.equals(this.barThickness, other.barThickness) && Kotlin.equals(this.borderRadius, other.borderRadius) && Kotlin.equals(this.categoryPercentage, other.categoryPercentage) && Kotlin.equals(this.grouped, other.grouped) && Kotlin.equals(this.hoverBorderRadius, other.hoverBorderRadius) && Kotlin.equals(this.inflateAmount, other.inflateAmount) && Kotlin.equals(this.maxBarThickness, other.maxBarThickness) && Kotlin.equals(this.minBarLegth, other.minBarLegth) && Kotlin.equals(this.skipNull, other.skipNull) && Kotlin.equals(this.circumference, other.circumference) && Kotlin.equals(this.offset, other.offset) && Kotlin.equals(this.rotation, other.rotation) && Kotlin.equals(this.spacing, other.spacing) && Kotlin.equals(this.weight, other.weight) && Kotlin.equals(this.hitRadius, other.hitRadius) && Kotlin.equals(this.hoverRadius, other.hoverRadius) && Kotlin.equals(this.radius, other.radius) && Kotlin.equals(this.borderAlign, other.borderAlign) && Kotlin.equals(this.cutout, other.cutout) && Kotlin.equals(this.animation, other.animation) && Kotlin.equals(this.drawActiveElementsOnTop, other.drawActiveElementsOnTop) && Kotlin.equals(this.circular, other.circular)))));
  };
  function toJs_21($receiver, i18nTranslator) {
    var $receiver_0 = new Object_init();
    if ($receiver.cubicInterpolationMode != null)
      $receiver_0.cubicInterpolationMode = $receiver.cubicInterpolationMode.mode_8be2vx$;
    if ($receiver.backgroundColor != null) {
      var $receiver_1 = $receiver.backgroundColor;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$;
      tmp$ = $receiver_1.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.asString());
      }
      $receiver_0.backgroundColor = checkSingleValue(copyToArray(destination));
    }
    if ($receiver.borderWidth != null) {
      $receiver_0.borderWidth = checkSingleValue(copyToArray($receiver.borderWidth));
    }
    if ($receiver.borderColor != null) {
      var $receiver_2 = $receiver.borderColor;
      var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver_2, 10));
      var tmp$_0;
      tmp$_0 = $receiver_2.iterator();
      while (tmp$_0.hasNext()) {
        var item_0 = tmp$_0.next();
        destination_0.add_11rb$(item_0.asString());
      }
      $receiver_0.borderColor = checkSingleValue(copyToArray(destination_0));
    }
    if ($receiver.borderCapStyle != null)
      $receiver_0.borderCapStyle = $receiver.borderCapStyle.mode_8be2vx$;
    if ($receiver.borderDash != null) {
      $receiver_0.borderDash = copyToArray($receiver.borderDash);
    }
    if ($receiver.borderDashOffset != null)
      $receiver_0.borderDashOffset = $receiver.borderDashOffset;
    if ($receiver.borderJoinStyle != null)
      $receiver_0.borderJoinStyle = $receiver.borderJoinStyle.mode_8be2vx$;
    if ($receiver.borderSkipped != null) {
      var $receiver_3 = $receiver.borderSkipped;
      var destination_1 = ArrayList_init(collectionSizeOrDefault($receiver_3, 10));
      var tmp$_1;
      tmp$_1 = $receiver_3.iterator();
      while (tmp$_1.hasNext()) {
        var item_1 = tmp$_1.next();
        destination_1.add_11rb$(item_1.position_8be2vx$);
      }
      $receiver_0.borderSkipped = checkSingleValue(copyToArray(destination_1));
    }
    if ($receiver.clip != null)
      $receiver_0.clip = $receiver.clip;
    if ($receiver.data != null) {
      $receiver_0.data = copyToArray($receiver.data);
    }
    if ($receiver.fill != null)
      $receiver_0.fill = $receiver.fill;
    if ($receiver.hoverBackgroundColor != null) {
      var $receiver_4 = $receiver.hoverBackgroundColor;
      var destination_2 = ArrayList_init(collectionSizeOrDefault($receiver_4, 10));
      var tmp$_2;
      tmp$_2 = $receiver_4.iterator();
      while (tmp$_2.hasNext()) {
        var item_2 = tmp$_2.next();
        destination_2.add_11rb$(item_2.asString());
      }
      $receiver_0.hoverBackgroundColor = checkSingleValue(copyToArray(destination_2));
    }
    if ($receiver.hoverBorderColor != null) {
      var $receiver_5 = $receiver.hoverBorderColor;
      var destination_3 = ArrayList_init(collectionSizeOrDefault($receiver_5, 10));
      var tmp$_3;
      tmp$_3 = $receiver_5.iterator();
      while (tmp$_3.hasNext()) {
        var item_3 = tmp$_3.next();
        destination_3.add_11rb$(item_3.asString());
      }
      $receiver_0.hoverBorderColor = checkSingleValue(copyToArray(destination_3));
    }
    if ($receiver.hoverBorderWidth != null) {
      $receiver_0.hoverBorderWidth = checkSingleValue(copyToArray($receiver.hoverBorderWidth));
    }
    if ($receiver.hoverBorderCapStyle != null)
      $receiver_0.hoverBorderCapStyle = $receiver.hoverBorderCapStyle.mode_8be2vx$;
    if ($receiver.hoverBorderDash != null) {
      $receiver_0.hoverBorderDash = copyToArray($receiver.hoverBorderDash);
    }
    if ($receiver.hoverBorderDashOffset != null)
      $receiver_0.hoverBorderDashOffset = $receiver.hoverBorderDashOffset;
    if ($receiver.hoverBorderJoinStyle != null)
      $receiver_0.hoverBorderJoinStyle = $receiver.hoverBorderJoinStyle.mode_8be2vx$;
    if ($receiver.indexAxis != null)
      $receiver_0.indexAxis = $receiver.indexAxis;
    if ($receiver.label != null)
      $receiver_0.label = i18nTranslator($receiver.label);
    if ($receiver.order != null)
      $receiver_0.order = $receiver.order;
    if ($receiver.pointBorderColor != null) {
      var $receiver_6 = $receiver.pointBorderColor;
      var destination_4 = ArrayList_init(collectionSizeOrDefault($receiver_6, 10));
      var tmp$_4;
      tmp$_4 = $receiver_6.iterator();
      while (tmp$_4.hasNext()) {
        var item_4 = tmp$_4.next();
        destination_4.add_11rb$(item_4.asString());
      }
      $receiver_0.pointBorderColor = checkSingleValue(copyToArray(destination_4));
    }
    if ($receiver.pointBackgroundColor != null) {
      var $receiver_7 = $receiver.pointBackgroundColor;
      var destination_5 = ArrayList_init(collectionSizeOrDefault($receiver_7, 10));
      var tmp$_5;
      tmp$_5 = $receiver_7.iterator();
      while (tmp$_5.hasNext()) {
        var item_5 = tmp$_5.next();
        destination_5.add_11rb$(item_5.asString());
      }
      $receiver_0.pointBackgroundColor = checkSingleValue(copyToArray(destination_5));
    }
    if ($receiver.pointBorderWidth != null) {
      $receiver_0.pointBorderWidth = checkSingleValue(copyToArray($receiver.pointBorderWidth));
    }
    if ($receiver.pointRadius != null) {
      $receiver_0.pointRadius = checkSingleValue(copyToArray($receiver.pointRadius));
    }
    if ($receiver.pointHoverRadius != null) {
      $receiver_0.pointHoverRadius = checkSingleValue(copyToArray($receiver.pointHoverRadius));
    }
    if ($receiver.pointHitRadius != null) {
      $receiver_0.pointHitRadius = checkSingleValue(copyToArray($receiver.pointHitRadius));
    }
    if ($receiver.pointHoverBackgroundColor != null) {
      var $receiver_8 = $receiver.pointHoverBackgroundColor;
      var destination_6 = ArrayList_init(collectionSizeOrDefault($receiver_8, 10));
      var tmp$_6;
      tmp$_6 = $receiver_8.iterator();
      while (tmp$_6.hasNext()) {
        var item_6 = tmp$_6.next();
        destination_6.add_11rb$(item_6.asString());
      }
      $receiver_0.pointHoverBackgroundColor = checkSingleValue(copyToArray(destination_6));
    }
    if ($receiver.pointHoverBorderColor != null) {
      var $receiver_9 = $receiver.pointHoverBorderColor;
      var destination_7 = ArrayList_init(collectionSizeOrDefault($receiver_9, 10));
      var tmp$_7;
      tmp$_7 = $receiver_9.iterator();
      while (tmp$_7.hasNext()) {
        var item_7 = tmp$_7.next();
        destination_7.add_11rb$(item_7.asString());
      }
      $receiver_0.pointHoverBorderColor = checkSingleValue(copyToArray(destination_7));
    }
    if ($receiver.pointHoverBorderWidth != null) {
      $receiver_0.pointHoverBorderWidth = checkSingleValue(copyToArray($receiver.pointHoverBorderWidth));
    }
    if ($receiver.pointRotation != null) {
      $receiver_0.pointRotation = checkSingleValue(copyToArray($receiver.pointRotation));
    }
    if ($receiver.pointStyle != null) {
      var $receiver_10 = $receiver.pointStyle;
      var destination_8 = ArrayList_init(collectionSizeOrDefault($receiver_10, 10));
      var tmp$_8;
      tmp$_8 = $receiver_10.iterator();
      while (tmp$_8.hasNext()) {
        var item_8 = tmp$_8.next();
        destination_8.add_11rb$(item_8.style_8be2vx$);
      }
      $receiver_0.pointStyle = checkSingleValue(copyToArray(destination_8));
    }
    if ($receiver.segment != null)
      $receiver_0.segment = $receiver.segment;
    if ($receiver.showLine != null)
      $receiver_0.showLine = $receiver.showLine;
    if ($receiver.spanGaps != null)
      $receiver_0.spanGaps = $receiver.spanGaps;
    if ($receiver.stack != null)
      $receiver_0.stack = $receiver.stack;
    if ($receiver.stepped != null)
      $receiver_0.stepped = $receiver.stepped;
    if ($receiver.tension != null)
      $receiver_0.tension = $receiver.tension;
    if ($receiver.xAxisID != null)
      $receiver_0.xAxisID = $receiver.xAxisID;
    if ($receiver.yAxisID != null)
      $receiver_0.yAxisID = $receiver.yAxisID;
    if ($receiver.base != null)
      $receiver_0.base = $receiver.base;
    if ($receiver.barPercentage != null)
      $receiver_0.barPercentage = $receiver.barPercentage;
    if ($receiver.barThickness != null)
      $receiver_0.barThickness = $receiver.barThickness;
    if ($receiver.borderRadius != null) {
      $receiver_0.borderRadius = checkSingleValue(copyToArray($receiver.borderRadius));
    }
    if ($receiver.categoryPercentage != null)
      $receiver_0.categoryPercentage = $receiver.categoryPercentage;
    if ($receiver.grouped != null)
      $receiver_0.grouped = $receiver.grouped;
    if ($receiver.hoverBorderRadius != null) {
      $receiver_0.hoverBorderRadius = checkSingleValue(copyToArray($receiver.hoverBorderRadius));
    }
    if ($receiver.inflateAmount != null) {
      $receiver_0.inflateAmount = checkSingleValue(copyToArray($receiver.inflateAmount));
    }
    if ($receiver.maxBarThickness != null)
      $receiver_0.maxBarThickness = $receiver.maxBarThickness;
    if ($receiver.minBarLegth != null)
      $receiver_0.minBarLegth = $receiver.minBarLegth;
    if ($receiver.skipNull != null)
      $receiver_0.skipNull = $receiver.skipNull;
    if ($receiver.circumference != null)
      $receiver_0.circumference = $receiver.circumference;
    if ($receiver.offset != null) {
      $receiver_0.offset = checkSingleValue(copyToArray($receiver.offset));
    }
    if ($receiver.rotation != null)
      $receiver_0.rotation = $receiver.rotation;
    if ($receiver.spacing != null)
      $receiver_0.spacing = $receiver.spacing;
    if ($receiver.weight != null)
      $receiver_0.weight = $receiver.weight;
    if ($receiver.hitRadius != null) {
      $receiver_0.hitRadius = checkSingleValue(copyToArray($receiver.hitRadius));
    }
    if ($receiver.hoverRadius != null)
      $receiver_0.hoverRadius = $receiver.hoverRadius;
    if ($receiver.radius != null) {
      $receiver_0.radius = checkSingleValue(copyToArray($receiver.radius));
    }
    if ($receiver.borderAlign != null)
      $receiver_0.borderAlign = $receiver.borderAlign;
    if ($receiver.cutout != null)
      $receiver_0.cutout = $receiver.cutout;
    if ($receiver.animation != null)
      $receiver_0.animation = $receiver.animation;
    if ($receiver.drawActiveElementsOnTop != null)
      $receiver_0.drawActiveElementsOnTop = $receiver.drawActiveElementsOnTop;
    if ($receiver.circular != null)
      $receiver_0.circular = $receiver.circular;
    return $receiver_0;
  }
  function Configuration(type, dataSets, labels, options, optionsDynamic, plugins) {
    if (labels === void 0)
      labels = null;
    if (options === void 0)
      options = null;
    if (optionsDynamic === void 0)
      optionsDynamic = null;
    if (plugins === void 0)
      plugins = null;
    this.type = type;
    this.dataSets = dataSets;
    this.labels = labels;
    this.options = options;
    this.optionsDynamic = optionsDynamic;
    this.plugins = plugins;
  }
  Configuration.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Configuration',
    interfaces: []
  };
  Configuration.prototype.component1 = function () {
    return this.type;
  };
  Configuration.prototype.component2 = function () {
    return this.dataSets;
  };
  Configuration.prototype.component3 = function () {
    return this.labels;
  };
  Configuration.prototype.component4 = function () {
    return this.options;
  };
  Configuration.prototype.component5 = function () {
    return this.optionsDynamic;
  };
  Configuration.prototype.component6 = function () {
    return this.plugins;
  };
  Configuration.prototype.copy_evgwqy$ = function (type, dataSets, labels, options, optionsDynamic, plugins) {
    return new Configuration(type === void 0 ? this.type : type, dataSets === void 0 ? this.dataSets : dataSets, labels === void 0 ? this.labels : labels, options === void 0 ? this.options : options, optionsDynamic === void 0 ? this.optionsDynamic : optionsDynamic, plugins === void 0 ? this.plugins : plugins);
  };
  Configuration.prototype.toString = function () {
    return 'Configuration(type=' + Kotlin.toString(this.type) + (', dataSets=' + Kotlin.toString(this.dataSets)) + (', labels=' + Kotlin.toString(this.labels)) + (', options=' + Kotlin.toString(this.options)) + (', optionsDynamic=' + Kotlin.toString(this.optionsDynamic)) + (', plugins=' + Kotlin.toString(this.plugins)) + ')';
  };
  Configuration.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.dataSets) | 0;
    result = result * 31 + Kotlin.hashCode(this.labels) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.optionsDynamic) | 0;
    result = result * 31 + Kotlin.hashCode(this.plugins) | 0;
    return result;
  };
  Configuration.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.dataSets, other.dataSets) && Kotlin.equals(this.labels, other.labels) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.optionsDynamic, other.optionsDynamic) && Kotlin.equals(this.plugins, other.plugins)))));
  };
  function toJs_22($receiver, i18nTranslator) {
    var tmp$, tmp$_0, tmp$_1;
    if ($receiver.optionsDynamic != null) {
      if ($receiver.options == null) {
        tmp$_0 = $receiver.optionsDynamic;
      } else {
        tmp$_0 = Object.assign($receiver.optionsDynamic, toJs_20($receiver.options, i18nTranslator));
      }
    } else {
      tmp$_0 = (tmp$ = $receiver.options) != null ? toJs_20(tmp$, i18nTranslator) : null;
    }
    var optionsTmp = tmp$_0;
    var $receiver_0 = new Object_init();
    $receiver_0.type = $receiver.type.type_8be2vx$;
    var $receiver_1 = new Object_init();
    if ($receiver.labels != null) {
      var $receiver_2 = $receiver.labels;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_2, 10));
      var tmp$_2;
      tmp$_2 = $receiver_2.iterator();
      while (tmp$_2.hasNext()) {
        var item = tmp$_2.next();
        destination.add_11rb$(i18nTranslator(item));
      }
      $receiver_1.labels = copyToArray(destination);
    }
    var $receiver_3 = $receiver.dataSets;
    var destination_0 = ArrayList_init(collectionSizeOrDefault($receiver_3, 10));
    var tmp$_3;
    tmp$_3 = $receiver_3.iterator();
    while (tmp$_3.hasNext()) {
      var item_0 = tmp$_3.next();
      destination_0.add_11rb$(toJs_21(item_0, i18nTranslator));
    }
    $receiver_1.datasets = copyToArray(destination_0);
    $receiver_0.data = $receiver_1;
    if (optionsTmp != null)
      $receiver_0.options = optionsTmp;
    if ($receiver.plugins != null) {
      $receiver_0.plugins = copyToArray($receiver.plugins);
    }
    return Kotlin.isType(tmp$_1 = $receiver_0, Object) ? tmp$_1 : throwCCE();
  }
  function checkSingleValue($receiver) {
    var tmp$;
    if ($receiver.length === 1) {
      tmp$ = $receiver[0];
    } else {
      tmp$ = $receiver;
    }
    return tmp$;
  }
  var package$io = _.io || (_.io = {});
  var package$kvision = package$io.kvision || (package$io.kvision = {});
  Object.defineProperty(package$kvision, 'ChartModule', {
    get: ChartModule_getInstance
  });
  Object.defineProperty(UpdateMode, 'ACTIVE', {
    get: UpdateMode$ACTIVE_getInstance
  });
  Object.defineProperty(UpdateMode, 'HIDE', {
    get: UpdateMode$HIDE_getInstance
  });
  Object.defineProperty(UpdateMode, 'RESET', {
    get: UpdateMode$RESET_getInstance
  });
  Object.defineProperty(UpdateMode, 'RESIZE', {
    get: UpdateMode$RESIZE_getInstance
  });
  Object.defineProperty(UpdateMode, 'SHOW', {
    get: UpdateMode$SHOW_getInstance
  });
  Object.defineProperty(UpdateMode, 'NONE', {
    get: UpdateMode$NONE_getInstance
  });
  var package$chart = package$kvision.chart || (package$kvision.chart = {});
  package$chart.UpdateMode = UpdateMode;
  Object.defineProperty(Chart, 'Companion', {
    get: Chart$Companion_getInstance
  });
  package$chart.Chart = Chart;
  package$chart.chart_8mmstp$ = chart;
  Object.defineProperty(ChartCanvas, 'Companion', {
    get: ChartCanvas$Companion_getInstance
  });
  package$chart.ChartCanvas = ChartCanvas;
  Object.defineProperty(ChartType, 'LINE', {
    get: ChartType$LINE_getInstance
  });
  Object.defineProperty(ChartType, 'BAR', {
    get: ChartType$BAR_getInstance
  });
  Object.defineProperty(ChartType, 'RADAR', {
    get: ChartType$RADAR_getInstance
  });
  Object.defineProperty(ChartType, 'DOUGHNUT', {
    get: ChartType$DOUGHNUT_getInstance
  });
  Object.defineProperty(ChartType, 'PIE', {
    get: ChartType$PIE_getInstance
  });
  Object.defineProperty(ChartType, 'POLARAREA', {
    get: ChartType$POLARAREA_getInstance
  });
  Object.defineProperty(ChartType, 'BUBBLE', {
    get: ChartType$BUBBLE_getInstance
  });
  Object.defineProperty(ChartType, 'SCATTER', {
    get: ChartType$SCATTER_getInstance
  });
  package$chart.ChartType = ChartType;
  Object.defineProperty(InteractionMode, 'POINT', {
    get: InteractionMode$POINT_getInstance
  });
  Object.defineProperty(InteractionMode, 'NEAREST', {
    get: InteractionMode$NEAREST_getInstance
  });
  Object.defineProperty(InteractionMode, 'INDEX', {
    get: InteractionMode$INDEX_getInstance
  });
  Object.defineProperty(InteractionMode, 'DATASET', {
    get: InteractionMode$DATASET_getInstance
  });
  Object.defineProperty(InteractionMode, 'X', {
    get: InteractionMode$X_getInstance
  });
  Object.defineProperty(InteractionMode, 'Y', {
    get: InteractionMode$Y_getInstance
  });
  package$chart.InteractionMode = InteractionMode;
  Object.defineProperty(Eeasing, 'LINEAR', {
    get: Eeasing$LINEAR_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINQUAD', {
    get: Eeasing$EASEINQUAD_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTQUAD', {
    get: Eeasing$EASEOUTQUAD_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTQUAD', {
    get: Eeasing$EASEINOUTQUAD_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINCUBIC', {
    get: Eeasing$EASEINCUBIC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTCUBIC', {
    get: Eeasing$EASEOUTCUBIC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTCUBIC', {
    get: Eeasing$EASEINOUTCUBIC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINQUART', {
    get: Eeasing$EASEINQUART_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTQUART', {
    get: Eeasing$EASEOUTQUART_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTQUART', {
    get: Eeasing$EASEINOUTQUART_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINQUINT', {
    get: Eeasing$EASEINQUINT_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTQUINT', {
    get: Eeasing$EASEOUTQUINT_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTQUINT', {
    get: Eeasing$EASEINOUTQUINT_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINSINE', {
    get: Eeasing$EASEINSINE_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTSINE', {
    get: Eeasing$EASEOUTSINE_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTSINE', {
    get: Eeasing$EASEINOUTSINE_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINEXPO', {
    get: Eeasing$EASEINEXPO_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTEXPO', {
    get: Eeasing$EASEOUTEXPO_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTEXPO', {
    get: Eeasing$EASEINOUTEXPO_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINCIRC', {
    get: Eeasing$EASEINCIRC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTCIRC', {
    get: Eeasing$EASEOUTCIRC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTCIRC', {
    get: Eeasing$EASEINOUTCIRC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINELASTIC', {
    get: Eeasing$EASEINELASTIC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTELASTIC', {
    get: Eeasing$EASEOUTELASTIC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTELASTIC', {
    get: Eeasing$EASEINOUTELASTIC_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINBACK', {
    get: Eeasing$EASEINBACK_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTBACK', {
    get: Eeasing$EASEOUTBACK_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTBACK', {
    get: Eeasing$EASEINOUTBACK_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINBOUNCE', {
    get: Eeasing$EASEINBOUNCE_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEOUTBOUNCE', {
    get: Eeasing$EASEOUTBOUNCE_getInstance
  });
  Object.defineProperty(Eeasing, 'EASEINOUTBOUNCE', {
    get: Eeasing$EASEINOUTBOUNCE_getInstance
  });
  package$chart.Eeasing = Eeasing;
  Object.defineProperty(Position, 'TOP', {
    get: Position$TOP_getInstance
  });
  Object.defineProperty(Position, 'LEFT', {
    get: Position$LEFT_getInstance
  });
  Object.defineProperty(Position, 'RIGHT', {
    get: Position$RIGHT_getInstance
  });
  Object.defineProperty(Position, 'BOTTOM', {
    get: Position$BOTTOM_getInstance
  });
  Object.defineProperty(Position, 'CENTER', {
    get: Position$CENTER_getInstance
  });
  Object.defineProperty(Position, 'CHARTAREA', {
    get: Position$CHARTAREA_getInstance
  });
  package$chart.Position = Position;
  Object.defineProperty(TooltipPosition, 'AVERAGE', {
    get: TooltipPosition$AVERAGE_getInstance
  });
  Object.defineProperty(TooltipPosition, 'NEAREST', {
    get: TooltipPosition$NEAREST_getInstance
  });
  package$chart.TooltipPosition = TooltipPosition;
  Object.defineProperty(PointStyle, 'CIRCLE', {
    get: PointStyle$CIRCLE_getInstance
  });
  Object.defineProperty(PointStyle, 'CROSS', {
    get: PointStyle$CROSS_getInstance
  });
  Object.defineProperty(PointStyle, 'CROSSROT', {
    get: PointStyle$CROSSROT_getInstance
  });
  Object.defineProperty(PointStyle, 'DASH', {
    get: PointStyle$DASH_getInstance
  });
  Object.defineProperty(PointStyle, 'LINE', {
    get: PointStyle$LINE_getInstance
  });
  Object.defineProperty(PointStyle, 'RECT', {
    get: PointStyle$RECT_getInstance
  });
  Object.defineProperty(PointStyle, 'RECTROUNDED', {
    get: PointStyle$RECTROUNDED_getInstance
  });
  Object.defineProperty(PointStyle, 'RECTROT', {
    get: PointStyle$RECTROT_getInstance
  });
  Object.defineProperty(PointStyle, 'START', {
    get: PointStyle$START_getInstance
  });
  Object.defineProperty(PointStyle, 'TRIANGLE', {
    get: PointStyle$TRIANGLE_getInstance
  });
  package$chart.PointStyle = PointStyle;
  Object.defineProperty(InterpolationMode, 'DEFAULT', {
    get: InterpolationMode$DEFAULT_getInstance
  });
  Object.defineProperty(InterpolationMode, 'MONOTONE', {
    get: InterpolationMode$MONOTONE_getInstance
  });
  package$chart.InterpolationMode = InterpolationMode;
  Object.defineProperty(ScalesType, 'CATEGORY', {
    get: ScalesType$CATEGORY_getInstance
  });
  Object.defineProperty(ScalesType, 'LINEAR', {
    get: ScalesType$LINEAR_getInstance
  });
  Object.defineProperty(ScalesType, 'LOGARITHMIC', {
    get: ScalesType$LOGARITHMIC_getInstance
  });
  Object.defineProperty(ScalesType, 'TIME', {
    get: ScalesType$TIME_getInstance
  });
  Object.defineProperty(ScalesType, 'TIMESERIES', {
    get: ScalesType$TIMESERIES_getInstance
  });
  Object.defineProperty(ScalesType, 'RADIALLINEAR', {
    get: ScalesType$RADIALLINEAR_getInstance
  });
  package$chart.ScalesType = ScalesType;
  Object.defineProperty(LineCap, 'BUTT', {
    get: LineCap$BUTT_getInstance
  });
  Object.defineProperty(LineCap, 'ROUND', {
    get: LineCap$ROUND_getInstance
  });
  Object.defineProperty(LineCap, 'SQUARE', {
    get: LineCap$SQUARE_getInstance
  });
  package$chart.LineCap = LineCap;
  Object.defineProperty(LineJoin, 'BEVEL', {
    get: LineJoin$BEVEL_getInstance
  });
  Object.defineProperty(LineJoin, 'ROUND', {
    get: LineJoin$ROUND_getInstance
  });
  Object.defineProperty(LineJoin, 'MITER', {
    get: LineJoin$MITER_getInstance
  });
  package$chart.LineJoin = LineJoin;
  Object.defineProperty(LegendAlign, 'CENTER', {
    get: LegendAlign$CENTER_getInstance
  });
  Object.defineProperty(LegendAlign, 'END', {
    get: LegendAlign$END_getInstance
  });
  Object.defineProperty(LegendAlign, 'START', {
    get: LegendAlign$START_getInstance
  });
  package$chart.LegendAlign = LegendAlign;
  Object.defineProperty(TooltipAlign, 'CENTER', {
    get: TooltipAlign$CENTER_getInstance
  });
  Object.defineProperty(TooltipAlign, 'LEFT', {
    get: TooltipAlign$LEFT_getInstance
  });
  Object.defineProperty(TooltipAlign, 'RIGHT', {
    get: TooltipAlign$RIGHT_getInstance
  });
  package$chart.TooltipAlign = TooltipAlign;
  Object.defineProperty(LegendLabelAlign, 'CENTER', {
    get: LegendLabelAlign$CENTER_getInstance
  });
  Object.defineProperty(LegendLabelAlign, 'LEFT', {
    get: LegendLabelAlign$LEFT_getInstance
  });
  Object.defineProperty(LegendLabelAlign, 'RIGHT', {
    get: LegendLabelAlign$RIGHT_getInstance
  });
  package$chart.LegendLabelAlign = LegendLabelAlign;
  Object.defineProperty(TitleAlign, 'CENTER', {
    get: TitleAlign$CENTER_getInstance
  });
  Object.defineProperty(TitleAlign, 'LEFT', {
    get: TitleAlign$LEFT_getInstance
  });
  Object.defineProperty(TitleAlign, 'RIGHT', {
    get: TitleAlign$RIGHT_getInstance
  });
  Object.defineProperty(TitleAlign, 'INNER', {
    get: TitleAlign$INNER_getInstance
  });
  package$chart.TitleAlign = TitleAlign;
  Object.defineProperty(TextDirection, 'LTR', {
    get: TextDirection$LTR_getInstance
  });
  Object.defineProperty(TextDirection, 'RTL', {
    get: TextDirection$RTL_getInstance
  });
  package$chart.TextDirection = TextDirection;
  Object.defineProperty(SkipMode, 'TOP', {
    get: SkipMode$TOP_getInstance
  });
  Object.defineProperty(SkipMode, 'LEFT', {
    get: SkipMode$LEFT_getInstance
  });
  Object.defineProperty(SkipMode, 'RIGHT', {
    get: SkipMode$RIGHT_getInstance
  });
  Object.defineProperty(SkipMode, 'BOTTOM', {
    get: SkipMode$BOTTOM_getInstance
  });
  Object.defineProperty(SkipMode, 'START', {
    get: SkipMode$START_getInstance
  });
  Object.defineProperty(SkipMode, 'END', {
    get: SkipMode$END_getInstance
  });
  Object.defineProperty(SkipMode, 'MIDDLE', {
    get: SkipMode$MIDDLE_getInstance
  });
  package$chart.SkipMode = SkipMode;
  Object.defineProperty(BorderAlign, 'CENTER', {
    get: BorderAlign$CENTER_getInstance
  });
  Object.defineProperty(BorderAlign, 'INNER', {
    get: BorderAlign$INNER_getInstance
  });
  package$chart.BorderAlign = BorderAlign;
  Object.defineProperty(CrossAlign, 'CENTER', {
    get: CrossAlign$CENTER_getInstance
  });
  Object.defineProperty(CrossAlign, 'NEAR', {
    get: CrossAlign$NEAR_getInstance
  });
  Object.defineProperty(CrossAlign, 'FAR', {
    get: CrossAlign$FAR_getInstance
  });
  package$chart.CrossAlign = CrossAlign;
  Object.defineProperty(ScaleBounds, 'DATA', {
    get: ScaleBounds$DATA_getInstance
  });
  Object.defineProperty(ScaleBounds, 'TICKS', {
    get: ScaleBounds$TICKS_getInstance
  });
  package$chart.ScaleBounds = ScaleBounds;
  package$chart.ChartFont = ChartFont;
  $$importsForInline$$['kvision-js-legacy'] = $module$kvision_js_legacy;
  package$chart.toJs_f09jw5$ = toJs;
  package$chart.InteractionOptions = InteractionOptions;
  package$chart.toJs_ohzxps$ = toJs_0;
  package$chart.AnimationOptions = AnimationOptions;
  package$chart.toJs_v11qg2$ = toJs_1;
  package$chart.LayoutPaddingObject = LayoutPaddingObject;
  package$chart.toJs_6d7gu4$ = toJs_2;
  package$chart.LayoutOptions = LayoutOptions;
  package$chart.toJs_vc4xam$ = toJs_3;
  package$chart.LegendLabelOptions = LegendLabelOptions;
  package$chart.toJs_fkcpxh$ = toJs_4;
  package$chart.LegendTitleOptions = LegendTitleOptions;
  package$chart.toJs_kwm653$ = toJs_5;
  package$chart.LegendOptions = LegendOptions;
  package$chart.toJs_vvxb8x$ = toJs_6;
  package$chart.TitleOptions = TitleOptions;
  package$chart.toJs_9wxg46$ = toJs_7;
  package$chart.TooltipCallback = TooltipCallback;
  package$chart.toJs_edkcmy$ = toJs_8;
  package$chart.TooltipOptions = TooltipOptions;
  package$chart.toJs_mmko9t$ = toJs_9;
  package$chart.PointOptions = PointOptions;
  package$chart.toJs_jyqai6$ = toJs_10;
  package$chart.LineOptions = LineOptions;
  package$chart.toJs_x0mqs8$ = toJs_11;
  package$chart.ArcOptions = ArcOptions;
  package$chart.toJs_pu3esw$ = toJs_12;
  package$chart.BarOptions = BarOptions;
  package$chart.toJs_t67xpt$ = toJs_13;
  package$chart.ElementsOptions = ElementsOptions;
  package$chart.toJs_lt0y91$ = toJs_14;
  package$chart.GridLineOptions = GridLineOptions;
  package$chart.toJs_f23kse$ = toJs_15;
  package$chart.ScaleTitleOptions = ScaleTitleOptions;
  package$chart.toJs_p5v20i$ = toJs_16;
  package$chart.TickOptions = TickOptions;
  package$chart.toJs_mh46db$ = toJs_17;
  package$chart.ChartScales = ChartScales;
  package$chart.toJs_70z95x$ = toJs_18;
  package$chart.PluginsOptions = PluginsOptions;
  package$chart.toJs_5dkice$ = toJs_19;
  package$chart.ChartOptions = ChartOptions;
  package$chart.toJs_7y2iho$ = toJs_20;
  package$chart.DataSets = DataSets;
  package$chart.toJs_h0iwrl$ = toJs_21;
  package$chart.Configuration = Configuration;
  package$chart.toJs_k7uxos$ = toJs_22;
  Kotlin.defineModule('kvision-kvision-chart-js-legacy', _);
  return _;
}));
