package io.lambdacube.aspecio.aspect.interceptor;

import io.lambdacube.aspecio.aspect.interceptor.arguments.Arguments;

public final class StackedCompositeAdvice
        implements Advice, Advice.ArgumentHook, Advice.SkipCall, Advice.CallReturn, Advice.Catch, Advice.Finally {

    private final Advice[] advices;
    private final BeforeAction initialAction;
    private final int afterPhase;
    private Arguments currentArgs;
    private int skipLevel;

    private static BeforeAction narrow(BeforeAction b1, BeforeAction b2) {
        return b1.compareTo(b2) < 0 ? b1 : b2;
    }

    public StackedCompositeAdvice(Advice[] advices) {
        super();
        this.advices = advices;
        this.initialAction = determineInitialAction();
        this.afterPhase = determineAfterPhase();
    }

    private BeforeAction determineInitialAction() {
        BeforeAction beforeAction = BeforeAction.PROCEED;
        for (Advice adv : advices) {
            beforeAction = narrow(beforeAction, adv.initialAction());
        }
        return beforeAction;
    }

    private int determineAfterPhase() {
        int phases = 0;
        for (Advice adv : advices) {
            phases |= adv.afterPhases();
        }
        return phases;
    }

    @Override
    public BeforeAction initialAction() {
        return initialAction;
    }

    @Override
    public int afterPhases() {
        return afterPhase;
    }

    @Override
    public BeforeAction visitArguments(Arguments arguments) {
        currentArgs = arguments;
        return visitArguments(0);
    }

    private BeforeAction visitArguments(int stackLevel) {
        switch (advices[stackLevel].initialAction()) {
        case REQUEST_ARGUMENTS:
            ArgumentHook argumentHook = (Advice.ArgumentHook) advices[stackLevel];
            BeforeAction next = argumentHook.visitArguments(currentArgs);
            switch (next) {
            case SKIP_AND_RETURN:
                skipLevel = stackLevel;
                return BeforeAction.SKIP_AND_RETURN;
            case UPDATE_ARGUMENTS_AND_PROCEED:
                updateArguments(stackLevel, argumentHook);
                return BeforeAction.UPDATE_ARGUMENTS_AND_PROCEED;
            default:
                break;
            }
        default:
            int nextAdvice = stackLevel + 1;
            if (nextAdvice < advices.length) {
                return visitArguments(nextAdvice);
            } else {
                return BeforeAction.PROCEED;
            }
        }
    }

    @Override
    public Arguments updateArguments(Arguments arguments) {
        return currentArgs;
    }

    // return true if skipCall
    private void updateArguments(int stackLevel, ArgumentHook argumentHook) {
        currentArgs = argumentHook.updateArguments(currentArgs);
        int nextAdvice = stackLevel + 1;
        if (nextAdvice < advices.length) {
            visitArguments(nextAdvice);
        }
    }

    @Override
    public <T> T skipCallAndReturnObject() {
        Advice nextAdvice = advices[skipLevel-1];

        try {
            T returnVal = ((SkipCall) advices[skipLevel]).skipCallAndReturnObject();
            if (skipLevel == 0) {
                return returnVal;
            }
            if (nextAdvice.hasPhase(CallReturn.PHASE)) {
                returnVal = ((CallReturn)nextAdvice).onObjectReturn(returnVal);
            }
            
            return returnVal;
            
        } catch (Throwable t) {
            t = ((Catch)nextAdvice).reThrow(t);
            throw SneakyThrower.sneakyThrow(t);
        }
    }

    @Override
    public int skipCallAndReturnInt() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void skipCallAndReturnVoid() {
        // TODO Auto-generated method stub

    }

    @Override
    public short skipCallAndReturnShort() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public double skipCallAndReturnDouble() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public float skipCallAndReturnFloat() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public char skipCallAndReturnChar() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public long skipCallAndReturnLong() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public byte skipCallAndReturnByte() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public boolean skipCallAndReturnBoolean() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public <T> T onObjectReturn(T result) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void onVoidReturn() {
        // TODO Auto-generated method stub

    }

    @Override
    public short onShortReturn(short result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public int onIntReturn(int result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public double onDoubleReturn(double result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public float onFloatReturn(float result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public char onCharReturn(char result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public long onLongReturn(long result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public byte onByteReturn(byte result) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public boolean onBooleanReturn(boolean result) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Throwable reThrow(Throwable t) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void runFinally() {
        // TODO Auto-generated method stub

    }
}
