/*
 * Decompiled with CFR 0.152.
 */
package zio.elasticsearch;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.quoted.FromExpr$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.prelude.AssertionError;
import zio.prelude.Validator;

public final class IndexPatternValidator$
extends Validator<String> {
    public static final IndexPatternValidator$ MODULE$ = new IndexPatternValidator$();

    private IndexPatternValidator$() {
        super(IndexPatternValidator$.IndexPatternValidator$$superArg$1(), FromExpr$.MODULE$.StringFromExpr());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IndexPatternValidator$.class);
    }

    private static Function1<String, Either<AssertionError, BoxedUnit>> IndexPatternValidator$$superArg$1() {
        return (Function1 & Serializable)pattern -> {
            if (IndexPatternValidator$.isValid$1(pattern)) {
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return package$.MODULE$.Left().apply((Object)AssertionError.Failure$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |   - Must be lower case only\n               |   - Cannot include \\, /, ?, \", <, >, |, ` `(space character), `,`(comma), #.\n               |   - Cannot include \":\"(since 7.0).\n               |   - Cannot be empty\n               |   - Cannot start with +.\n               |   - Cannot be `.` or `..`.\n               |   - Cannot be longer than 255 bytes (note it is bytes, so multi-byte characters will count towards the 255 limit faster).\n               |   - Patterns starting with . are deprecated, except for hidden indices and internal indices managed by plugins.\n               |"))));
        };
    }

    private static final boolean containsAny$1(String string, Chunk params) {
        return params.exists((Function1 & Serializable)_$1 -> StringUtils.contains((CharSequence)string, (CharSequence)_$1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isValid$1(String pattern) {
        String string = pattern.toLowerCase();
        String string2 = pattern;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (StringUtils.startsWithAny((CharSequence)pattern, (CharSequence[])new CharSequence[]{"+"})) return false;
        if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(pattern))) return false;
        if (IndexPatternValidator$.containsAny$1(pattern, Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"?", "\"", "<", ">", "|", " ", ",", "#", ":"})))) return false;
        if (StringUtils.equalsAny((CharSequence)pattern, (CharSequence[])new CharSequence[]{".", ".."})) return false;
        if (pattern.getBytes().length > 255) return false;
        return true;
    }
}

