/*
 * Decompiled with CFR 0.152.
 */
package zio.elasticsearch.executor;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.NotGiven$;
import sttp.capabilities.zio.ZioStreams;
import sttp.client4.IsOption$;
import sttp.client4.PartialRequest;
import sttp.client4.PartialRequestBuilder;
import sttp.client4.Request;
import sttp.client4.Response;
import sttp.client4.ResponseException;
import sttp.client4.WebSocketStreamBackend;
import sttp.client4.package$;
import sttp.model.MediaType$;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.Zippable$;
import zio.elasticsearch.ElasticConfig;
import zio.elasticsearch.ElasticPrimitive$;
import zio.elasticsearch.ElasticPrimitive$ElasticBool$;
import zio.elasticsearch.ElasticPrimitive$ElasticInt$;
import zio.elasticsearch.ElasticPrimitive$ElasticPrimitiveOps$;
import zio.elasticsearch.ElasticPrimitive$ElasticString$;
import zio.elasticsearch.ElasticRequest;
import zio.elasticsearch.StreamConfig;
import zio.elasticsearch.StreamConfig$;
import zio.elasticsearch.executor.ElasticCredentials;
import zio.elasticsearch.executor.Executor;
import zio.elasticsearch.executor.HttpExecutor$;
import zio.elasticsearch.executor.HttpExecutor$PointInTimeResponse$;
import zio.elasticsearch.executor.response.AggregationResponse;
import zio.elasticsearch.executor.response.AggregationResponse$;
import zio.elasticsearch.executor.response.BulkResponse;
import zio.elasticsearch.executor.response.BulkResponse$;
import zio.elasticsearch.executor.response.CountResponse$;
import zio.elasticsearch.executor.response.CreateResponse$;
import zio.elasticsearch.executor.response.DocumentWithHighlightsAndSort;
import zio.elasticsearch.executor.response.GetResponse$;
import zio.elasticsearch.executor.response.Hit;
import zio.elasticsearch.executor.response.SearchWithAggregationsResponse;
import zio.elasticsearch.executor.response.SearchWithAggregationsResponse$;
import zio.elasticsearch.executor.response.UpdateByQueryResponse;
import zio.elasticsearch.executor.response.UpdateByQueryResponse$;
import zio.elasticsearch.package$DocumentId$;
import zio.elasticsearch.request.CreationOutcome;
import zio.elasticsearch.request.CreationOutcome$AlreadyExists$;
import zio.elasticsearch.request.CreationOutcome$Created$;
import zio.elasticsearch.request.DeletionOutcome;
import zio.elasticsearch.request.DeletionOutcome$Deleted$;
import zio.elasticsearch.request.DeletionOutcome$NotFound$;
import zio.elasticsearch.request.UpdateOutcome;
import zio.elasticsearch.request.UpdateOutcome$Created$;
import zio.elasticsearch.request.UpdateOutcome$Updated$;
import zio.elasticsearch.result.AggregateResult;
import zio.elasticsearch.result.AggregationResult;
import zio.elasticsearch.result.DecodingException$;
import zio.elasticsearch.result.ElasticException;
import zio.elasticsearch.result.GetResult;
import zio.elasticsearch.result.Item;
import zio.elasticsearch.result.Item$;
import zio.elasticsearch.result.KNNSearchResult;
import zio.elasticsearch.result.SearchAndAggregateResult;
import zio.elasticsearch.result.SearchResult;
import zio.elasticsearch.result.UnauthorizedException$;
import zio.elasticsearch.result.UpdateByQueryResult;
import zio.elasticsearch.result.UpdateByQueryResult$;
import zio.elasticsearch.result.VersionConflictException;
import zio.elasticsearch.result.VersionConflictException$;
import zio.json.JsonDecoder;
import zio.json.ast.Json;
import zio.json.ast.Json$;
import zio.schema.Schema;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class HttpExecutor
implements Executor {
    private final ElasticConfig esConfig;
    private final WebSocketStreamBackend<ZIO<Object, Throwable, Object>, ZioStreams> client;
    private final PartialRequest<Either<String, String>> baseRequest;

    public static HttpExecutor apply(ElasticConfig elasticConfig, WebSocketStreamBackend<ZIO<Object, Throwable, Object>, ZioStreams> webSocketStreamBackend) {
        return HttpExecutor$.MODULE$.apply(elasticConfig, webSocketStreamBackend);
    }

    public HttpExecutor(ElasticConfig esConfig, WebSocketStreamBackend<ZIO<Object, Throwable, Object>, ZioStreams> client) {
        PartialRequest partialRequest;
        this.esConfig = esConfig;
        this.client = client;
        Option<ElasticCredentials> option = esConfig.credentials();
        if (option instanceof Some) {
            ElasticCredentials credentials = (ElasticCredentials)((Some)option).value();
            partialRequest = (PartialRequest)package$.MODULE$.basicRequest().auth().basic(credentials.username(), credentials.password());
        } else {
            partialRequest = package$.MODULE$.basicRequest();
        }
        this.baseRequest = partialRequest;
    }

    @Override
    public <A> ZIO<Object, Throwable, A> execute(ElasticRequest<A> request) {
        ElasticRequest<A> elasticRequest = request;
        if (elasticRequest instanceof ElasticRequest.Aggregate) {
            ElasticRequest.Aggregate r = (ElasticRequest.Aggregate)elasticRequest;
            return this.executeAggregate(r);
        }
        if (elasticRequest instanceof ElasticRequest.Bulk) {
            ElasticRequest.Bulk r = (ElasticRequest.Bulk)elasticRequest;
            return this.executeBulk(r);
        }
        if (elasticRequest instanceof ElasticRequest.Count) {
            ElasticRequest.Count r = (ElasticRequest.Count)elasticRequest;
            return this.executeCount(r);
        }
        if (elasticRequest instanceof ElasticRequest.Create) {
            ElasticRequest.Create r = (ElasticRequest.Create)elasticRequest;
            return this.executeCreate(r);
        }
        if (elasticRequest instanceof ElasticRequest.CreateWithId) {
            ElasticRequest.CreateWithId r = (ElasticRequest.CreateWithId)elasticRequest;
            return this.executeCreateWithId(r);
        }
        if (elasticRequest instanceof ElasticRequest.CreateIndex) {
            ElasticRequest.CreateIndex r = (ElasticRequest.CreateIndex)elasticRequest;
            return this.executeCreateIndex(r);
        }
        if (elasticRequest instanceof ElasticRequest.CreateOrUpdate) {
            ElasticRequest.CreateOrUpdate r = (ElasticRequest.CreateOrUpdate)elasticRequest;
            return this.executeCreateOrUpdate(r);
        }
        if (elasticRequest instanceof ElasticRequest.DeleteById) {
            ElasticRequest.DeleteById r = (ElasticRequest.DeleteById)elasticRequest;
            return this.executeDeleteById(r);
        }
        if (elasticRequest instanceof ElasticRequest.DeleteByQuery) {
            ElasticRequest.DeleteByQuery r = (ElasticRequest.DeleteByQuery)elasticRequest;
            return this.executeDeleteByQuery(r);
        }
        if (elasticRequest instanceof ElasticRequest.DeleteIndex) {
            ElasticRequest.DeleteIndex r = (ElasticRequest.DeleteIndex)elasticRequest;
            return this.executeDeleteIndex(r);
        }
        if (elasticRequest instanceof ElasticRequest.Exists) {
            ElasticRequest.Exists r = (ElasticRequest.Exists)elasticRequest;
            return this.executeExists(r);
        }
        if (elasticRequest instanceof ElasticRequest.GetById) {
            ElasticRequest.GetById r = (ElasticRequest.GetById)elasticRequest;
            return this.executeGetById(r);
        }
        if (elasticRequest instanceof ElasticRequest.KNN) {
            ElasticRequest.KNN r = (ElasticRequest.KNN)elasticRequest;
            return this.executeKnn(r);
        }
        if (elasticRequest instanceof ElasticRequest.Refresh) {
            ElasticRequest.Refresh r = (ElasticRequest.Refresh)elasticRequest;
            return this.executeRefresh(r);
        }
        if (elasticRequest instanceof ElasticRequest.Search) {
            ElasticRequest.Search r = (ElasticRequest.Search)elasticRequest;
            return this.executeSearch(r);
        }
        if (elasticRequest instanceof ElasticRequest.SearchAndAggregate) {
            ElasticRequest.SearchAndAggregate r = (ElasticRequest.SearchAndAggregate)elasticRequest;
            return this.executeSearchAndAggregate(r);
        }
        if (elasticRequest instanceof ElasticRequest.Update) {
            ElasticRequest.Update r = (ElasticRequest.Update)elasticRequest;
            return this.executeUpdate(r);
        }
        if (elasticRequest instanceof ElasticRequest.UpdateByQuery) {
            ElasticRequest.UpdateByQuery r = (ElasticRequest.UpdateByQuery)elasticRequest;
            return this.executeUpdateByQuery(r);
        }
        throw new MatchError(elasticRequest);
    }

    @Override
    public ZStream<Object, Throwable, Item> stream(ElasticRequest.SearchRequest r) {
        return this.stream(r, StreamConfig$.MODULE$.Default());
    }

    @Override
    public ZStream<Object, Throwable, Item> stream(ElasticRequest.SearchRequest request, StreamConfig config) {
        ElasticRequest.SearchRequest searchRequest = request;
        if (searchRequest instanceof ElasticRequest.Search) {
            ElasticRequest.Search r = (ElasticRequest.Search)searchRequest;
            if (config.searchAfter()) {
                return ZStream$.MODULE$.paginateChunkZIO(HttpExecutor::stream$$anonfun$1, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        if ("".equals(string)) {
                            return this.executeCreatePointInTime(r.selectors(), config);
                        }
                        String pitId = string;
                        Option searchAfter = (Option)tuple2._2();
                        return this.executeSearchAfterRequest(r, pitId, config, (Option<Json>)searchAfter);
                    }
                    throw new MatchError((Object)tuple2);
                }, (Object)"zio.elasticsearch.executor.HttpExecutor.stream(HttpExecutor.scala:102)");
            }
            return ZStream$.MODULE$.paginateChunkZIO(HttpExecutor::stream$$anonfun$3, (Function1 & Serializable)s -> {
                if (s.isEmpty()) {
                    return this.executeSearchWithScroll(r, config);
                }
                return this.executeGetByScroll((String)s, config);
            }, (Object)"zio.elasticsearch.executor.HttpExecutor.stream(HttpExecutor.scala:106)");
        }
        throw new MatchError((Object)searchRequest);
    }

    @Override
    public <A> ZStream<Object, Throwable, A> streamAs(ElasticRequest.SearchRequest request, Schema<A> evidence$1) {
        return this.stream(request).map((Function1 & Serializable)_$1 -> _$1.documentAs(evidence$1), (Object)"zio.elasticsearch.executor.HttpExecutor.streamAs(HttpExecutor.scala:111)").collectWhileRight((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.elasticsearch.executor.HttpExecutor.streamAs(HttpExecutor.scala:111)");
    }

    @Override
    public <A> ZStream<Object, Throwable, A> streamAs(ElasticRequest.SearchRequest r, StreamConfig config, Schema<A> evidence$1) {
        return this.stream(r, config).map((Function1 & Serializable)_$2 -> _$2.documentAs(evidence$1), (Object)"zio.elasticsearch.executor.HttpExecutor.streamAs(HttpExecutor.scala:114)").collectWhileRight((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.elasticsearch.executor.HttpExecutor.streamAs(HttpExecutor.scala:114)");
    }

    private ZIO<Object, Throwable, AggregateResult> executeAggregate(ElasticRequest.Aggregate r) {
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "?typed_keys"}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.selectors(), "_search"})))).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeAggregate$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeAggregate(HttpExecutor.scala:127)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$1 -> new AggregateResult((Map<String, AggregationResult>)((Map)value.aggs().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        AggregationResponse response = (AggregationResponse)tuple2._2();
                        return Tuple2$.MODULE$.apply((Object)key, (Object)AggregationResponse$.MODULE$.toResult(response));
                    }
                    throw new MatchError((Object)tuple2);
                }))), (Object)"zio.elasticsearch.executor.HttpExecutor.executeAggregate(HttpExecutor.scala:131)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeAggregate$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeAggregate(HttpExecutor.scala:134)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeAggregate(HttpExecutor.scala:136)");
    }

    private ZIO<Object, Throwable, BulkResponse> executeBulk(ElasticRequest.Bulk r) {
        Uri uri;
        Option<Object> option = r.index();
        if (option instanceof Some) {
            Object index = ((Some)option).value();
            uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), index, "_bulk"}));
        } else if (None$.MODULE$.equals(option)) {
            uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), "_bulk"}));
        } else {
            throw new MatchError(option);
        }
        Uri uri2 = uri.withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequestWithCustomResponse(((Request)((PartialRequestBuilder)this.baseRequest.post(uri2)).contentType(MediaType$.MODULE$.ApplicationJson()).body(r.body())).response(sttp.client4.ziojson.package$.MODULE$.asJson(BulkResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeBulk$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeBulk(HttpExecutor.scala:154)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$2 -> value, (Object)"zio.elasticsearch.executor.HttpExecutor.executeBulk(HttpExecutor.scala:155)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeBulk$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeBulk(HttpExecutor.scala:157)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeBulk(HttpExecutor.scala:159)");
    }

    private ZIO<Object, Throwable, Object> executeCount(ElasticRequest.Count r) {
        Request req = ((Request)((PartialRequestBuilder)this.baseRequest.get(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_count"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"routing", r.routing())})))))).contentType(MediaType$.MODULE$.ApplicationJson())).response(sttp.client4.ziojson.package$.MODULE$.asJson(CountResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption()));
        return this.sendRequestWithCustomResponse((Request)r.query().fold(() -> HttpExecutor.executeCount$$anonfun$1(req), (Function1 & Serializable)_$3 -> (Request)req.body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder())))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).map((Function1 & Serializable)_$4 -> _$4.count()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeCount$$anonfun$3$$anonfun$2$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCount(HttpExecutor.scala:174)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$3 -> value, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCount(HttpExecutor.scala:175)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeCount$$anonfun$3$$anonfun$4(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCount(HttpExecutor.scala:178)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCount(HttpExecutor.scala:180)");
    }

    private ZIO<Object, Throwable, Object> executeCreate(ElasticRequest.Create r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_doc"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequestWithCustomResponse(((Request)((PartialRequestBuilder)this.baseRequest.post(uri)).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder()))).response(sttp.client4.ziojson.package$.MODULE$.asJson(CreateResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Created() == n) {
                return (ZIO)((Either)response.body()).map((Function1 & Serializable)res -> {
                    package$DocumentId$ NewtypeCustom_this = package$DocumentId$.MODULE$;
                    return res.id();
                }).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeCreate$$anonfun$1$$anonfun$2$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreate(HttpExecutor.scala:199)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$4 -> value, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreate(HttpExecutor.scala:200)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeCreate$$anonfun$1$$anonfun$4(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreate(HttpExecutor.scala:203)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreate(HttpExecutor.scala:205)");
    }

    private ZIO<Object, Throwable, CreationOutcome> executeCreateWithId(ElasticRequest.CreateWithId r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_create", r.id()})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequest((Request<Either<String, String>>)((Request)((PartialRequestBuilder)this.baseRequest.post(uri)).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder())))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Created() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$5 -> CreationOutcome$Created$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateWithId(HttpExecutor.scala:220)");
            }
            if (StatusCode$.MODULE$.Conflict() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$6 -> CreationOutcome$AlreadyExists$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateWithId(HttpExecutor.scala:221)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeCreateWithId$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateWithId(HttpExecutor.scala:222)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateWithId(HttpExecutor.scala:224)");
    }

    private ZIO<Object, Throwable, CreationOutcome> executeCreateIndex(ElasticRequest.CreateIndex r) {
        return this.sendRequest((Request<Either<String, String>>)((Request)((PartialRequestBuilder)this.baseRequest.put(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index()})))).contentType(MediaType$.MODULE$.ApplicationJson()).body(r.toJson()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$7 -> CreationOutcome$Created$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateIndex(HttpExecutor.scala:235)");
            }
            if (StatusCode$.MODULE$.BadRequest() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$8 -> CreationOutcome$AlreadyExists$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateIndex(HttpExecutor.scala:236)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeCreateIndex$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateIndex(HttpExecutor.scala:237)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateIndex(HttpExecutor.scala:239)");
    }

    private ZIO<Object, Throwable, BoxedUnit> executeCreateOrUpdate(ElasticRequest.CreateOrUpdate r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_doc", r.id()})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequest((Request<Either<String, String>>)((Request)((PartialRequestBuilder)this.baseRequest.put(uri)).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder())))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n || StatusCode$.MODULE$.Created() == n) {
                return ZIO$.MODULE$.unit();
            }
            return ZIO$.MODULE$.fail(() -> this.executeCreateOrUpdate$$anonfun$1$$anonfun$1(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateOrUpdate(HttpExecutor.scala:248)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreateOrUpdate(HttpExecutor.scala:250)");
    }

    private ZIO<Object, Throwable, Tuple2<Chunk<Item>, Option<Tuple2<String, Option<Json>>>>> executeCreatePointInTime(String index, StreamConfig config) {
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), index, "_pit"})).withParams((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"keep_alive", (Object)config.keepAlive())})))).response(sttp.client4.ziojson.package$.MODULE$.asJson(HttpExecutor$PointInTimeResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson())).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeCreatePointInTime$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreatePointInTime(HttpExecutor.scala:266)"), (Function1 & Serializable)pit -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$9 -> Tuple2$.MODULE$.apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Object)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)pit.id(), (Object)None$.MODULE$))), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreatePointInTime(HttpExecutor.scala:267)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeCreatePointInTime$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreatePointInTime(HttpExecutor.scala:270)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeCreatePointInTime(HttpExecutor.scala:272)");
    }

    private ZIO<Object, Throwable, DeletionOutcome> executeDeleteById(ElasticRequest.DeleteById r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_doc", r.id()})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequest((Request<Either<String, String>>)((Request)this.baseRequest.delete(uri))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$10 -> DeletionOutcome$Deleted$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteById(HttpExecutor.scala:280)");
            }
            if (StatusCode$.MODULE$.NotFound() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$11 -> DeletionOutcome$NotFound$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteById(HttpExecutor.scala:281)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeDeleteById$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteById(HttpExecutor.scala:282)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteById(HttpExecutor.scala:284)");
    }

    private ZIO<Object, Throwable, DeletionOutcome> executeDeleteByQuery(ElasticRequest.DeleteByQuery r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_delete_by_query"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequest((Request<Either<String, String>>)((Request)((PartialRequestBuilder)this.baseRequest.post(uri)).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder())))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$12 -> DeletionOutcome$Deleted$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteByQuery(HttpExecutor.scala:300)");
            }
            if (StatusCode$.MODULE$.NotFound() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$13 -> DeletionOutcome$NotFound$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteByQuery(HttpExecutor.scala:301)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeDeleteByQuery$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteByQuery(HttpExecutor.scala:302)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteByQuery(HttpExecutor.scala:304)");
    }

    private ZIO<Object, Throwable, DeletionOutcome> executeDeleteIndex(ElasticRequest.DeleteIndex r) {
        return this.sendRequest((Request<Either<String, String>>)((Request)this.baseRequest.delete(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index()}))))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$14 -> DeletionOutcome$Deleted$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteIndex(HttpExecutor.scala:310)");
            }
            if (StatusCode$.MODULE$.NotFound() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$15 -> DeletionOutcome$NotFound$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteIndex(HttpExecutor.scala:311)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeDeleteIndex$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteIndex(HttpExecutor.scala:312)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeDeleteIndex(HttpExecutor.scala:314)");
    }

    private ZIO<Object, Throwable, Object> executeExists(ElasticRequest.Exists r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_doc", r.id()})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequest((Request<Either<String, String>>)((Request)this.baseRequest.head(uri))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$16 -> true, (Object)"zio.elasticsearch.executor.HttpExecutor.executeExists(HttpExecutor.scala:321)");
            }
            if (StatusCode$.MODULE$.NotFound() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$17 -> false, (Object)"zio.elasticsearch.executor.HttpExecutor.executeExists(HttpExecutor.scala:322)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeExists$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeExists(HttpExecutor.scala:323)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeExists(HttpExecutor.scala:325)");
    }

    private ZIO<Object, Throwable, GetResult> executeGetById(ElasticRequest.GetById r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_doc", r.id()})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequestWithCustomResponse(((Request)this.baseRequest.get(uri)).response(sttp.client4.ziojson.package$.MODULE$.asJson(GetResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.attempt((Function1 & Serializable)contextual$18 -> new GetResult((Option<Item>)((Either)response.body()).toOption().map((Function1 & Serializable)r -> Item$.MODULE$.apply(r.source(), Item$.MODULE$.$lessinit$greater$default$2(), Item$.MODULE$.$lessinit$greater$default$3(), Item$.MODULE$.$lessinit$greater$default$4()))), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetById(HttpExecutor.scala:339)");
            }
            if (StatusCode$.MODULE$.NotFound() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$19 -> new GetResult((Option<Item>)None$.MODULE$), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetById(HttpExecutor.scala:340)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeGetById$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetById(HttpExecutor.scala:341)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetById(HttpExecutor.scala:343)");
    }

    private ZIO<Object, Throwable, Tuple2<Chunk<Item>, Option<String>>> executeGetByScroll(String scrollId, StreamConfig config) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"scroll_id");
        String string2 = (String)ElasticPrimitive$.MODULE$.ElasticPrimitiveOps(scrollId);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ElasticPrimitive$ElasticPrimitiveOps$.MODULE$.toJson$extension(string2, ElasticPrimitive$ElasticString$.MODULE$));
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), "_search", "scroll"})).withParams((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"scroll", (Object)config.keepAlive())})))).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json.Obj$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeGetByScroll$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetByScroll(HttpExecutor.scala:357)"), (Function1 & Serializable)value -> {
                    List list = value.resultsWithHighlightsAndSort().toList();
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    List list2 = list;
                    if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$20 -> Tuple2$.MODULE$.apply((Object)Chunk$.MODULE$.empty(), (Object)None$.MODULE$), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetByScroll(HttpExecutor.scala:361)");
                    }
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$21 -> Tuple2$.MODULE$.apply(this.itemsFromDocumentsWithHighlights(value.resultsWithHighlightsAndSort()), (Object)value.scrollId().orElse(() -> HttpExecutor.executeGetByScroll$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(scrollId))), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetByScroll(HttpExecutor.scala:368)");
                });
            }
            return ZIO$.MODULE$.fail(() -> this.executeGetByScroll$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetByScroll(HttpExecutor.scala:372)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeGetByScroll(HttpExecutor.scala:374)");
    }

    private ZIO<Object, Throwable, KNNSearchResult> executeKnn(ElasticRequest.KNN r) {
        Uri uri = package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.selectors(), "_knn_search"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"routing", r.routing())}))));
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(uri)).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeKnn$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeKnn(HttpExecutor.scala:391)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$22 -> new KNNSearchResult(this.itemsFromDocumentsWithHighlights(value.resultsWithHighlightsAndSort())), (Object)"zio.elasticsearch.executor.HttpExecutor.executeKnn(HttpExecutor.scala:393)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeKnn$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeKnn(HttpExecutor.scala:396)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeKnn(HttpExecutor.scala:398)");
    }

    private ZIO<Object, Throwable, Object> executeRefresh(ElasticRequest.Refresh r) {
        return this.sendRequest((Request<Either<String, String>>)((Request)this.baseRequest.get(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.selectors(), "_refresh"}))))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$23 -> true, (Object)"zio.elasticsearch.executor.HttpExecutor.executeRefresh(HttpExecutor.scala:404)");
            }
            if (StatusCode$.MODULE$.NotFound() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$24 -> false, (Object)"zio.elasticsearch.executor.HttpExecutor.executeRefresh(HttpExecutor.scala:405)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeRefresh$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeRefresh(HttpExecutor.scala:406)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeRefresh(HttpExecutor.scala:408)");
    }

    private ZIO<Object, Throwable, SearchResult> executeSearch(ElasticRequest.Search r) {
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.selectors(), "_search"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"routing", r.routing())})))))).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeSearch$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearch(HttpExecutor.scala:421)"), (Function1 & Serializable)value -> ZIO$.MODULE$.fromEither(() -> HttpExecutor.executeSearch$$anonfun$1$$anonfun$2$$anonfun$1(value), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearch(HttpExecutor.scala:424)").map((Function1 & Serializable)innerHitsResults -> new SearchResult(this.itemsFromDocumentsWithHighlightsSortAndInnerHits(value.resultsWithHighlightsAndSort(), (Chunk<Map<String, Chunk<Hit>>>)innerHitsResults), (SearchWithAggregationsResponse)value), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearch(HttpExecutor.scala:433)").mapError((Function1 & Serializable)error -> DecodingException$.MODULE$.apply(new StringBuilder(28).append("Could not parse inner_hits: ").append((String)error).toString()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearch(HttpExecutor.scala:434)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeSearch$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearch(HttpExecutor.scala:438)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearch(HttpExecutor.scala:440)");
    }

    private ZIO<Object, Throwable, Tuple2<Chunk<Item>, Option<Tuple2<String, Option<Json>>>>> executeSearchAfterRequest(ElasticRequest.Search r, String pitId, StreamConfig config, Option<Json> searchAfter) {
        Json.Obj obj;
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"pit");
        Object[] objectArray2 = new Tuple2[2];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        String string3 = (String)ElasticPrimitive$.MODULE$.ElasticPrimitiveOps(pitId);
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)ElasticPrimitive$ElasticPrimitiveOps$.MODULE$.toJson$extension(string3, ElasticPrimitive$ElasticString$.MODULE$));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"keep_alive");
        String string5 = (String)ElasticPrimitive$.MODULE$.ElasticPrimitiveOps(config.keepAlive());
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)ElasticPrimitive$ElasticPrimitiveOps$.MODULE$.toJson$extension(string5, ElasticPrimitive$ElasticString$.MODULE$));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        Json.Obj pointInTimeJson = Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (r.sortBy().isEmpty()) {
            Object[] objectArray3 = new Tuple2[2];
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"sort");
            Object[] objectArray4 = new Json[1];
            String string7 = (String)ElasticPrimitive$.MODULE$.ElasticPrimitiveOps("_shard_doc");
            objectArray4[0] = ElasticPrimitive$ElasticPrimitiveOps$.MODULE$.toJson$extension(string7, ElasticPrimitive$ElasticString$.MODULE$);
            objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json.Arr$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4)));
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"track_total_hits");
            Boolean bl = (Boolean)ElasticPrimitive$.MODULE$.ElasticPrimitiveOps(BoxesRunTime.boxToBoolean((boolean)false));
            objectArray3[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)ElasticPrimitive$ElasticPrimitiveOps$.MODULE$.toJson$extension(bl, ElasticPrimitive$ElasticBool$.MODULE$));
            obj = Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        } else {
            Object[] objectArray5 = new Tuple2[1];
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"sort");
            objectArray5[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)Json.Arr$.MODULE$.apply(r.sortBy().map((Function1 & Serializable)_$5 -> _$5.toJson())));
            obj = Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
        }
        Json.Obj sortsJson = obj;
        Object[] objectArray6 = new Tuple2[1];
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"query");
        objectArray6[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)r.query().toJson((Option<String>)None$.MODULE$));
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.get(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), "_search"})))).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)pointInTimeJson.merge(sortsJson).merge(Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray6))).merge((Json.Obj)searchAfter.fold(HttpExecutor::executeSearchAfterRequest$$anonfun$1, (Function1 & Serializable)sa -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"search_after");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, sa);
            return Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })).merge((Json.Obj)config.pageSize().fold(HttpExecutor::executeSearchAfterRequest$$anonfun$3, (Function1 & Serializable)ps -> HttpExecutor.executeSearchAfterRequest$$anonfun$4(BoxesRunTime.unboxToInt((Object)ps)))), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json.Obj$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeSearchAfterRequest$$anonfun$5$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:479)"), (Function1 & Serializable)body -> {
                    List list = body.resultsWithHighlightsAndSort().toList();
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    List list2 = list;
                    if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$25 -> Tuple2$.MODULE$.apply((Object)Chunk$.MODULE$.empty(), (Object)None$.MODULE$), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:482)");
                    }
                    Option<String> option = body.pitId();
                    if (option instanceof Some) {
                        String newPitId = (String)((Some)option).value();
                        Option<Json> option2 = body.lastSortField();
                        if (option2 instanceof Some) {
                            Json newSearchAfter = (Json)((Some)option2).value();
                            return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$26 -> Tuple2$.MODULE$.apply(this.itemsFromDocumentsWithHighlights(body.resultsWithHighlightsAndSort()), (Object)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)newPitId, (Object)Some$.MODULE$.apply((Object)newSearchAfter)))), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:493)");
                        }
                        if (None$.MODULE$.equals(option2)) {
                            return ZIO$.MODULE$.fail(HttpExecutor::executeSearchAfterRequest$$anonfun$5$$anonfun$2$$anonfun$3, (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:499)");
                        }
                        throw new MatchError(option2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return ZIO$.MODULE$.fail(HttpExecutor::executeSearchAfterRequest$$anonfun$5$$anonfun$2$$anonfun$4, (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:506)");
                    }
                    throw new MatchError(option);
                });
            }
            return ZIO$.MODULE$.fail(() -> this.executeSearchAfterRequest$$anonfun$5$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:512)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAfterRequest(HttpExecutor.scala:514)");
    }

    private ZIO<Object, Throwable, SearchAndAggregateResult> executeSearchAndAggregate(ElasticRequest.SearchAndAggregate r) {
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "?typed_keys"}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.selectors(), "_search"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"routing", r.routing())})))).addQuerySegment((Uri.QuerySegment)Uri.QuerySegment$.Value$.MODULE$.apply("typed_keys", Uri.QuerySegment$.Value$.MODULE$.$lessinit$greater$default$2())))).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeSearchAndAggregate$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAndAggregate(HttpExecutor.scala:532)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$27 -> new SearchAndAggregateResult(this.itemsFromDocumentsWithHighlights(value.resultsWithHighlightsAndSort()), (Map<String, AggregationResult>)((Map)value.aggs().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        AggregationResponse response = (AggregationResponse)tuple2._2();
                        return Tuple2$.MODULE$.apply((Object)key, (Object)AggregationResponse$.MODULE$.toResult(response));
                    }
                    throw new MatchError((Object)tuple2);
                })), (SearchWithAggregationsResponse)value), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAndAggregate(HttpExecutor.scala:542)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeSearchAndAggregate$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAndAggregate(HttpExecutor.scala:545)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchAndAggregate(HttpExecutor.scala:547)");
    }

    private ZIO<Object, Throwable, Tuple2<Chunk<Item>, Option<String>>> executeSearchWithScroll(ElasticRequest.Search r, StreamConfig config) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"query");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)r.query().toJson((Option<String>)None$.MODULE$));
        Object[] objectArray2 = new Tuple2[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"sort");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json.Arr$.MODULE$.apply(r.sortBy().map((Function1 & Serializable)_$6 -> _$6.toJson())));
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.selectors(), "_search"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"scroll", (Object)Some$.MODULE$.apply((Object)config.keepAlive())), Tuple2$.MODULE$.apply((Object)"routing", r.routing())})))))).response(sttp.client4.ziojson.package$.MODULE$.asJson(SearchWithAggregationsResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).merge(Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json.Obj$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeSearchWithScroll$$anonfun$2$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchWithScroll(HttpExecutor.scala:564)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$28 -> Tuple2$.MODULE$.apply(this.itemsFromDocumentsWithHighlights(value.resultsWithHighlightsAndSort()), value.scrollId()), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchWithScroll(HttpExecutor.scala:568)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeSearchWithScroll$$anonfun$2$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchWithScroll(HttpExecutor.scala:571)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeSearchWithScroll(HttpExecutor.scala:573)");
    }

    private ZIO<Object, Throwable, UpdateOutcome> executeUpdate(ElasticRequest.Update r) {
        return this.sendRequest((Request<Either<String, String>>)((Request)((PartialRequestBuilder)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_update", r.id()})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())})))))).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder())))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$29 -> UpdateOutcome$Updated$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdate(HttpExecutor.scala:587)");
            }
            if (StatusCode$.MODULE$.Created() == n) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$30 -> UpdateOutcome$Created$.MODULE$, (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdate(HttpExecutor.scala:588)");
            }
            return ZIO$.MODULE$.fail(() -> this.executeUpdate$$anonfun$1$$anonfun$3(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdate(HttpExecutor.scala:589)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdate(HttpExecutor.scala:591)");
    }

    private ZIO<Object, Throwable, UpdateByQueryResult> executeUpdateByQuery(ElasticRequest.UpdateByQuery r) {
        return this.sendRequestWithCustomResponse((Request)((Request)this.baseRequest.post(package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.esConfig.uri(), r.index(), "_update_by_query"})).withParams(this.getQueryParams((Chunk<Tuple2<String, Object>>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"conflicts", r.conflicts()), Tuple2$.MODULE$.apply((Object)"refresh", r.refresh()), Tuple2$.MODULE$.apply((Object)"routing", r.routing())})))))).response(sttp.client4.ziojson.package$.MODULE$.asJson(UpdateByQueryResponse$.MODULE$.decoder(), IsOption$.MODULE$.otherIsNotOption())).contentType(MediaType$.MODULE$.ApplicationJson()).body((Object)r.toJson(), sttp.client4.ziojson.package$.MODULE$.zioJsonBodySerializer(Json$.MODULE$.encoder()))).flatMap((Function1 & Serializable)response -> {
            int n = response.code();
            if (StatusCode$.MODULE$.Ok() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeUpdateByQuery$$anonfun$1$$anonfun$1$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdateByQuery(HttpExecutor.scala:608)"), (Function1 & Serializable)value -> ZIO$.MODULE$.succeed((Function1 & Serializable)contextual$31 -> UpdateByQueryResult$.MODULE$.from((UpdateByQueryResponse)value), (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdateByQuery(HttpExecutor.scala:609)"));
            }
            if (StatusCode$.MODULE$.Conflict() == n) {
                return (ZIO)((Either)response.body()).fold((Function1 & Serializable)e -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeUpdateByQuery$$anonfun$1$$anonfun$3$$anonfun$1(e), (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdateByQuery(HttpExecutor.scala:613)"), (Function1 & Serializable)value -> ZIO$.MODULE$.fail(() -> HttpExecutor.executeUpdateByQuery$$anonfun$1$$anonfun$4$$anonfun$1(value), (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdateByQuery(HttpExecutor.scala:614)"));
            }
            return ZIO$.MODULE$.fail(() -> this.executeUpdateByQuery$$anonfun$1$$anonfun$5(response), (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdateByQuery(HttpExecutor.scala:617)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.executeUpdateByQuery(HttpExecutor.scala:619)");
    }

    private Map<String, String> getQueryParams(Chunk<Tuple2<String, Object>> parameters) {
        return parameters.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Object object = tuple2._2();
                    String name = (String)tuple2._1();
                    if (object instanceof Some) {
                        Object value = ((Some)object).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Object object = tuple2._2();
                    String name = (String)tuple2._1();
                    if (object instanceof Some) {
                        Object value = ((Some)object).value();
                        return Tuple2$.MODULE$.apply((Object)name, (Object)value.toString());
                    }
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ElasticException handleFailures(Response<Either<String, String>> response) {
        int n = response.code();
        if (StatusCode$.MODULE$.Unauthorized() == n || StatusCode$.MODULE$.Forbidden() == n) {
            return UnauthorizedException$.MODULE$;
        }
        return new ElasticException(new StringBuilder(55).append("Unexpected response from Elasticsearch. Response body: ").append(((Either)response.body()).fold((Function1 & Serializable)body -> body, (Function1 & Serializable)_$7 -> "")).toString());
    }

    private <A> ElasticException handleFailuresFromCustomResponse(Response<Either<ResponseException<String, String>, A>> response) {
        int n = response.code();
        if (StatusCode$.MODULE$.Unauthorized() == n || StatusCode$.MODULE$.Forbidden() == n) {
            return UnauthorizedException$.MODULE$;
        }
        return new ElasticException(new StringBuilder(55).append("Unexpected response from Elasticsearch. Response body: ").append(((Either)response.body()).fold((Function1 & Serializable)body -> body, (Function1 & Serializable)_$8 -> "")).toString());
    }

    private Chunk<Item> itemsFromDocumentsWithHighlights(Chunk<DocumentWithHighlightsAndSort> results) {
        return results.map((Function1 & Serializable)r -> Item$.MODULE$.apply(r.source(), r.highlight(), Item$.MODULE$.$lessinit$greater$default$3(), r.sort()));
    }

    private Chunk<Item> itemsFromDocumentsWithHighlightsSortAndInnerHits(Chunk<DocumentWithHighlightsAndSort> results, Chunk<Map<String, Chunk<Hit>>> innerHits) {
        return results.zip(innerHits, Zippable$.MODULE$.Zippable2()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DocumentWithHighlightsAndSort r = (DocumentWithHighlightsAndSort)tuple2._1();
                Map innerHits = (Map)tuple2._2();
                return Item$.MODULE$.apply(r.source(), r.highlight(), (Map<String, Chunk<Hit>>)innerHits, r.sort());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private ZIO<Object, Throwable, Response<Either<String, String>>> sendRequest(Request<Either<String, String>> req) {
        return ZIO$.MODULE$.logDebug(() -> HttpExecutor.sendRequest$$anonfun$1(req), (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequest(HttpExecutor.scala:659)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((ZIO)req.send(this.client)).flatMap((Function1 & Serializable)resp -> ZIO$.MODULE$.logDebug(() -> HttpExecutor.sendRequest$$anonfun$2$$anonfun$1$$anonfun$1(resp), (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequest(HttpExecutor.scala:661)").map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return resp;
            }, (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequest(HttpExecutor.scala:662)"), (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequest(HttpExecutor.scala:662)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequest(HttpExecutor.scala:662)");
    }

    private <A> ZIO<Object, Throwable, Response<Either<ResponseException<String, String>, A>>> sendRequestWithCustomResponse(Request<Either<ResponseException<String, String>, A>> req) {
        return ZIO$.MODULE$.logDebug(() -> HttpExecutor.sendRequestWithCustomResponse$$anonfun$1(req), (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequestWithCustomResponse(HttpExecutor.scala:668)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((ZIO)req.send(this.client)).flatMap((Function1 & Serializable)resp -> ZIO$.MODULE$.logDebug(() -> HttpExecutor.sendRequestWithCustomResponse$$anonfun$2$$anonfun$1$$anonfun$1(resp), (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequestWithCustomResponse(HttpExecutor.scala:670)").map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return resp;
            }, (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequestWithCustomResponse(HttpExecutor.scala:671)"), (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequestWithCustomResponse(HttpExecutor.scala:671)");
        }, (Object)"zio.elasticsearch.executor.HttpExecutor.sendRequestWithCustomResponse(HttpExecutor.scala:671)");
    }

    private static final Tuple2 stream$$anonfun$1() {
        return Tuple2$.MODULE$.apply((Object)"", (Object)None$.MODULE$);
    }

    private static final String stream$$anonfun$3() {
        return "";
    }

    private static final ElasticException executeAggregate$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$1) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$1.getMessage()).toString());
    }

    private final ElasticException executeAggregate$$anonfun$1$$anonfun$3(Response response$1) {
        return this.handleFailuresFromCustomResponse(response$1);
    }

    private static final ElasticException executeBulk$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$2) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$2.getMessage()).toString());
    }

    private final ElasticException executeBulk$$anonfun$1$$anonfun$3(Response response$2) {
        return this.handleFailuresFromCustomResponse(response$2);
    }

    private static final Request executeCount$$anonfun$1(Request req$1) {
        return req$1;
    }

    private static final ElasticException executeCount$$anonfun$3$$anonfun$2$$anonfun$1(ResponseException e$3) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$3.getMessage()).toString());
    }

    private final ElasticException executeCount$$anonfun$3$$anonfun$4(Response response$3) {
        return this.handleFailuresFromCustomResponse(response$3);
    }

    private static final ElasticException executeCreate$$anonfun$1$$anonfun$2$$anonfun$1(ResponseException e$4) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$4.getMessage()).toString());
    }

    private final ElasticException executeCreate$$anonfun$1$$anonfun$4(Response response$4) {
        return this.handleFailuresFromCustomResponse(response$4);
    }

    private final ElasticException executeCreateWithId$$anonfun$1$$anonfun$3(Response response$5) {
        return this.handleFailures((Response<Either<String, String>>)response$5);
    }

    private final ElasticException executeCreateIndex$$anonfun$1$$anonfun$3(Response response$6) {
        return this.handleFailures((Response<Either<String, String>>)response$6);
    }

    private final ElasticException executeCreateOrUpdate$$anonfun$1$$anonfun$1(Response response$7) {
        return this.handleFailures((Response<Either<String, String>>)response$7);
    }

    private static final ElasticException executeCreatePointInTime$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$5) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$5.getMessage()).toString());
    }

    private final ElasticException executeCreatePointInTime$$anonfun$1$$anonfun$3(Response response$8) {
        return this.handleFailuresFromCustomResponse(response$8);
    }

    private final ElasticException executeDeleteById$$anonfun$1$$anonfun$3(Response response$9) {
        return this.handleFailures((Response<Either<String, String>>)response$9);
    }

    private final ElasticException executeDeleteByQuery$$anonfun$1$$anonfun$3(Response response$10) {
        return this.handleFailures((Response<Either<String, String>>)response$10);
    }

    private final ElasticException executeDeleteIndex$$anonfun$1$$anonfun$3(Response response$11) {
        return this.handleFailures((Response<Either<String, String>>)response$11);
    }

    private final ElasticException executeExists$$anonfun$1$$anonfun$3(Response response$12) {
        return this.handleFailures((Response<Either<String, String>>)response$12);
    }

    private final ElasticException executeGetById$$anonfun$1$$anonfun$3(Response response$14) {
        return this.handleFailuresFromCustomResponse(response$14);
    }

    private static final ElasticException executeGetByScroll$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$6) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$6.getMessage()).toString());
    }

    private static final Option executeGetByScroll$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(String scrollId$4) {
        return Some$.MODULE$.apply((Object)scrollId$4);
    }

    private final ElasticException executeGetByScroll$$anonfun$1$$anonfun$3(Response response$15) {
        return this.handleFailuresFromCustomResponse(response$15);
    }

    private static final ElasticException executeKnn$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$7) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$7.getMessage()).toString());
    }

    private final ElasticException executeKnn$$anonfun$1$$anonfun$3(Response response$16) {
        return this.handleFailuresFromCustomResponse(response$16);
    }

    private final ElasticException executeRefresh$$anonfun$1$$anonfun$3(Response response$17) {
        return this.handleFailures((Response<Either<String, String>>)response$17);
    }

    private static final ElasticException executeSearch$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$8) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$8.getMessage()).toString());
    }

    private static final Either executeSearch$$anonfun$1$$anonfun$2$$anonfun$1(SearchWithAggregationsResponse value$7) {
        return value$7.innerHitsResults();
    }

    private final ElasticException executeSearch$$anonfun$1$$anonfun$3(Response response$18) {
        return this.handleFailuresFromCustomResponse(response$18);
    }

    private static final Json.Obj executeSearchAfterRequest$$anonfun$1() {
        return Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Json.Obj executeSearchAfterRequest$$anonfun$3() {
        return Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final /* synthetic */ Json.Obj executeSearchAfterRequest$$anonfun$4(int ps) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"size");
        Integer n = (Integer)ElasticPrimitive$.MODULE$.ElasticPrimitiveOps(BoxesRunTime.boxToInteger((int)ps));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ElasticPrimitive$ElasticPrimitiveOps$.MODULE$.toJson$extension(n, ElasticPrimitive$ElasticInt$.MODULE$));
        return Json.Obj$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final ElasticException executeSearchAfterRequest$$anonfun$5$$anonfun$1$$anonfun$1(ResponseException e$9) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$9.getMessage()).toString());
    }

    private static final ElasticException executeSearchAfterRequest$$anonfun$5$$anonfun$2$$anonfun$3() {
        return new ElasticException("Unexpected response from Elasticsearch, search_after field is missing.");
    }

    private static final ElasticException executeSearchAfterRequest$$anonfun$5$$anonfun$2$$anonfun$4() {
        return new ElasticException("Unexpected response from Elasticsearch, pid.id field is missing.");
    }

    private final ElasticException executeSearchAfterRequest$$anonfun$5$$anonfun$3(Response response$19) {
        return this.handleFailuresFromCustomResponse(response$19);
    }

    private static final ElasticException executeSearchAndAggregate$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$10) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$10.getMessage()).toString());
    }

    private final ElasticException executeSearchAndAggregate$$anonfun$1$$anonfun$3(Response response$20) {
        return this.handleFailuresFromCustomResponse(response$20);
    }

    private static final ElasticException executeSearchWithScroll$$anonfun$2$$anonfun$1$$anonfun$1(ResponseException e$11) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$11.getMessage()).toString());
    }

    private final ElasticException executeSearchWithScroll$$anonfun$2$$anonfun$3(Response response$21) {
        return this.handleFailuresFromCustomResponse(response$21);
    }

    private final ElasticException executeUpdate$$anonfun$1$$anonfun$3(Response response$22) {
        return this.handleFailures((Response<Either<String, String>>)response$22);
    }

    private static final ElasticException executeUpdateByQuery$$anonfun$1$$anonfun$1$$anonfun$1(ResponseException e$12) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$12.getMessage()).toString());
    }

    private static final ElasticException executeUpdateByQuery$$anonfun$1$$anonfun$3$$anonfun$1(ResponseException e$13) {
        return new ElasticException(new StringBuilder(20).append("Exception occurred: ").append(e$13.getMessage()).toString());
    }

    private static final VersionConflictException executeUpdateByQuery$$anonfun$1$$anonfun$4$$anonfun$1(UpdateByQueryResponse value$12) {
        return VersionConflictException$.MODULE$.apply(value$12.updated() + value$12.deleted(), value$12.versionConflicts());
    }

    private final ElasticException executeUpdateByQuery$$anonfun$1$$anonfun$5(Response response$23) {
        return this.handleFailuresFromCustomResponse(response$23);
    }

    private static final String sendRequest$$anonfun$1(Request req$3) {
        return new StringBuilder(10).append("[es-req]: ").append(req$3.show(true, true, Predef$.MODULE$.Set().empty())).toString();
    }

    private static final String sendRequest$$anonfun$2$$anonfun$1$$anonfun$1(Response resp$1) {
        return new StringBuilder(10).append("[es-res]: ").append(resp$1.show(true, true, Predef$.MODULE$.Set().empty())).toString();
    }

    private static final String sendRequestWithCustomResponse$$anonfun$1(Request req$5) {
        return new StringBuilder(10).append("[es-req]: ").append(req$5.show(true, true, Predef$.MODULE$.Set().empty())).toString();
    }

    private static final String sendRequestWithCustomResponse$$anonfun$2$$anonfun$1$$anonfun$1(Response resp$3) {
        return new StringBuilder(10).append("[es-res]: ").append(resp$3.show(true, true, Predef$.MODULE$.Set().empty())).toString();
    }

    public static final class PointInTimeResponse
    implements Product,
    Serializable {
        private final String id;

        public static PointInTimeResponse apply(String string) {
            return HttpExecutor$PointInTimeResponse$.MODULE$.apply(string);
        }

        public static JsonDecoder<PointInTimeResponse> decoder() {
            return HttpExecutor$PointInTimeResponse$.MODULE$.decoder();
        }

        public static PointInTimeResponse fromProduct(Product product) {
            return HttpExecutor$PointInTimeResponse$.MODULE$.fromProduct(product);
        }

        public static PointInTimeResponse unapply(PointInTimeResponse pointInTimeResponse) {
            return HttpExecutor$PointInTimeResponse$.MODULE$.unapply(pointInTimeResponse);
        }

        public PointInTimeResponse(String id) {
            this.id = id;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PointInTimeResponse)) return false;
            PointInTimeResponse pointInTimeResponse = (PointInTimeResponse)object;
            String string = this.id();
            String string2 = pointInTimeResponse.id();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PointInTimeResponse;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PointInTimeResponse";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public PointInTimeResponse copy(String id) {
            return new PointInTimeResponse(id);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String _1() {
            return this.id();
        }
    }
}

